/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class XSLFunction
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt = null;
    private String asAtt = null;
    private String overrideAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    List references = new ArrayList(10);

    public void registerReference(UserFunctionCall userFunctionCall) {
        this.references.add(userFunctionCall);
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string = this.getNamePool().getClarkName(n);
            if (string == "name") {
                this.nameAtt = attributeCollection.getValue(i).trim();
                if (this.nameAtt.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix", "XTSE0740");
                }
                try {
                    this.setObjectNameCode(this.makeNameCode(this.nameAtt.trim()));
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage(), "XTSE0280");
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                continue;
            }
            if (string == "as") {
                this.asAtt = attributeCollection.getValue(i);
                continue;
            }
            if (string == "override") {
                this.overrideAtt = attributeCollection.getValue(i).trim();
                if (this.overrideAtt.equals("yes")) {
                    this.override = true;
                    continue;
                }
                if (this.overrideAtt.equals("no")) {
                    this.override = false;
                    continue;
                }
                this.compileError("override must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            if (string == "{http://saxon.sf.net/}memo-function") {
                String string2 = attributeCollection.getValue(i).trim();
                if (string2.equals("yes")) {
                    this.memoFunction = true;
                    continue;
                }
                if (string2.equals("no")) {
                    this.memoFunction = false;
                    continue;
                }
                this.compileError("saxon:memo-function must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        this.functionName = this.nameAtt;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLParam;
    }

    public boolean isOverriding() {
        return this.override;
    }

    public void fixupReferences() throws XPathException {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            ((UserFunctionCall)iterator.next()).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        this.getNumberOfArguments();
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        boolean bl = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof XSLFunction) || e == this || ((XSLFunction)e).getFunctionFingerprint() != this.getFunctionFingerprint() || ((XSLFunction)e).getNumberOfArguments() != this.numberOfArguments) continue;
            if (((XSLFunction)e).getPrecedence() == this.getPrecedence()) {
                bl = true;
            }
            if (((XSLFunction)e).getPrecedence() <= this.getPrecedence()) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.compileError("Duplicate function declaration", "XTSE0770");
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        this.compileAsExpression(executable);
        return null;
    }

    private void compileAsExpression(Executable executable) throws XPathException {
        Serializable serializable;
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), false);
        if (expression == null) {
            expression = EmptySequence.getInstance();
        }
        UserFunction userFunction = new UserFunction();
        userFunction.setBody(expression);
        userFunction.setFunctionNameCode(this.getObjectNameCode());
        this.setParameterDefinitions(userFunction);
        userFunction.setResultType(this.getResultType());
        userFunction.setLineNumber(this.getLineNumber());
        userFunction.setSystemId(this.getSystemId());
        userFunction.setStackFrameMap(this.stackFrameMap);
        userFunction.setMemoFunction(this.memoFunction);
        userFunction.setExecutable(executable);
        Expression expression2 = expression;
        try {
            expression2 = expression.typeCheck(this.staticContext, null);
            expression2 = expression2.optimize(this.getConfiguration().getOptimizer(), this.staticContext, null);
            if (this.resultType != null) {
                serializable = new RoleLocator(5, this.functionName, 0, null);
                ((RoleLocator)serializable).setSourceLocator(new ExpressionLocation(this));
                expression2 = TypeChecker.staticTypeCheck(expression2, this.resultType, false, (RoleLocator)serializable, this.getStaticContext());
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        if (this.getConfiguration().getTraceListener() != null) {
            serializable = new TraceInstruction(expression2, this);
            ((ComputedExpression)serializable).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            expression2 = serializable;
        }
        this.allocateSlots(expression2);
        if (expression2 != expression) {
            userFunction.setBody(expression2);
        }
        boolean bl = ExpressionTool.markTailFunctionCalls(expression2);
        userFunction.setTailRecursive(bl);
        this.fixupInstruction(userFunction, this.getStaticContext());
        this.compiledFunction = userFunction;
        if (this.isExplaining()) {
            System.err.println("Optimized expression tree for function " + this.functionName + " at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
            expression2.display(10, this.getNamePool(), System.err);
        }
    }

    private void fixupInstruction(UserFunction userFunction, StaticContext staticContext) throws XPathException {
        try {
            Iterator iterator = this.references.iterator();
            while (iterator.hasNext()) {
                UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
                userFunctionCall.setFunction(userFunction, staticContext);
                userFunctionCall.checkFunctionCall(userFunction, staticContext);
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public int getFunctionFingerprint() {
        if (this.getObjectFingerprint() == -1) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                return -1;
            }
        }
        return this.getObjectFingerprint();
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Item item;
            this.numberOfArguments = 0;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((item = axisIterator.next()) instanceof XSLParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction userFunction) {
        UserFunctionParameter[] userFunctionParameterArray = new UserFunctionParameter[this.getNumberOfArguments()];
        userFunction.setParameterDefinitions(userFunctionParameterArray);
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLParam)) continue;
            UserFunctionParameter userFunctionParameter = new UserFunctionParameter();
            userFunctionParameterArray[n++] = userFunctionParameter;
            userFunctionParameter.setRequiredType(((XSLParam)nodeInfo).getRequiredType());
            userFunctionParameter.setSlotNumber(((XSLParam)nodeInfo).getSlotNumber());
            ((XSLParam)nodeInfo).fixupBinding(userFunctionParameter);
            List list = ((XSLParam)nodeInfo).getReferences();
            int n2 = RangeVariableDeclaration.getReferenceCount(list, userFunctionParameter, this.getStaticContext(), true);
            userFunctionParameter.setReferenceCount(n2);
        }
        return;
    }

    public UserFunction getCompiledFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 149;
    }
}

