/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class DateValue
extends CalendarValue {
    protected int year;
    protected byte month;
    protected byte day;
    private static byte[] daysPerMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final short[] monthData = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    protected DateValue() {
    }

    protected DateValue(int n, byte by, byte by2) {
        this.year = n;
        this.month = by;
        this.day = by2;
    }

    protected DateValue(int n, byte by, byte by2, int n2) {
        this.year = n;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n2);
    }

    public DateValue(CharSequence charSequence) throws XPathException {
        this.setLexicalValue(charSequence);
    }

    public DateValue(GregorianCalendar gregorianCalendar, int n) {
        int n2 = gregorianCalendar.get(0);
        this.year = gregorianCalendar.get(1);
        if (n2 == 0) {
            this.year = -this.year;
        }
        this.month = (byte)(gregorianCalendar.get(2) + 1);
        this.day = (byte)gregorianCalendar.get(5);
        this.setTimezoneInMinutes(n);
    }

    public void setLexicalValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)DateValue.trimWhitespace(charSequence)).toString(), "-:+Z", true);
        try {
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if ("+".equals(string)) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            if (string.length() < 4) {
                this.badDate("Year is less than four digits", charSequence);
            }
            this.year = Integer.parseInt(string) * n;
            if (this.year == 0) {
                this.badDate("Year zero is not allowed", charSequence);
            }
            if (n < 0) {
                ++this.year;
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after year", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Month must be two digits", charSequence);
            }
            this.month = (byte)Integer.parseInt(string);
            if (this.month < 1 || this.month > 12) {
                this.badDate("Month is out of range", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after month", charSequence);
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                this.badDate("Day must be two digits", charSequence);
            }
            this.day = (byte)Integer.parseInt(string);
            if (this.day < 1 || this.day > 31) {
                this.badDate("Day is out of range", charSequence);
            }
            if (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if ("Z".equals(string2)) {
                    int n2 = 0;
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after 'Z'", charSequence);
                    }
                    this.setTimezoneInMinutes(n2);
                } else if ("+".equals(string2) || "-".equals(string2)) {
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n3 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone hour must be two digits", charSequence);
                    }
                    if (n3 > 14) {
                        this.badDate("Timezone hour is out of range", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    if (!":".equals(stringTokenizer.nextElement())) {
                        this.badDate("Wrong delimiter after timezone hour", charSequence);
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("No minutes in timezone", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n4 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits", charSequence);
                    }
                    if (n4 > 59) {
                        this.badDate("Timezone minute is out of range", charSequence);
                    }
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("Continues after timezone", charSequence);
                    }
                    int n5 = n3 * 60 + n4;
                    if ("-".equals(string2)) {
                        n5 = -n5;
                    }
                    this.setTimezoneInMinutes(n5);
                } else {
                    this.badDate("Timezone format is incorrect", charSequence);
                }
            }
            if (!DateValue.isValidDate(this.year, this.month, this.day)) {
                this.badDate("Non-existent date", charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component", charSequence);
        }
    }

    private void badDate(String string, CharSequence charSequence) throws ValidationException {
        ValidationException validationException = new ValidationException("Invalid date " + Err.wrap(charSequence, 4) + ". " + string);
        validationException.setErrorCode("FORG0001");
        throw validationException;
    }

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 > 0 && n2 <= 12 && n3 > 0 && n3 <= daysPerMonth[n2 - 1]) {
            return true;
        }
        if (n2 == 2 && n3 == 29) {
            return DateValue.isLeapYear(n);
        }
        return false;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static DateValue tomorrow(int n, byte by, byte by2) {
        if (DateValue.isValidDate(n, by, by2 + 1)) {
            return new DateValue(n, by, (byte)(by2 + 1));
        }
        if (by < 12) {
            return new DateValue(n, (byte)(by + 1), 1);
        }
        return new DateValue(n + 1, 1, 1);
    }

    public static DateValue yesterday(int n, byte by, byte by2) {
        if (by2 > 1) {
            return new DateValue(n, by, (byte)(by2 - 1));
        }
        if (by > 1) {
            if (by == 3 && DateValue.isLeapYear(n)) {
                return new DateValue(n, 2, 29);
            }
            return new DateValue(n, (byte)(by - 1), daysPerMonth[by - 2]);
        }
        return new DateValue(n - 1, 12, 31);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 521: 
            case 643: {
                return this;
            }
            case 519: {
                return this.toDateTime();
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 523: {
                return new GYearValue(this.year, this.getTimezoneInMinutes());
            }
            case 522: {
                return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
            }
            case 526: {
                return new GMonthValue(this.month, this.getTimezoneInMinutes());
            }
            case 524: {
                return new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
            }
            case 525: {
                return new GDayValue(this.day, this.getTimezoneInMinutes());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert date to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public DateTimeValue toDateTime() {
        return new DateTimeValue(this.year, this.month, this.day, 0, 0, 0, 0, this.getTimezoneInMinutes());
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n = this.year;
        if (this.year <= 0) {
            fastStringBuffer.append('-');
            n = -n + 1;
        }
        DateValue.appendString(fastStringBuffer, n, n > 9999 ? (n + "").length() : 4);
        fastStringBuffer.append('-');
        DateValue.appendTwoDigits(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        DateValue.appendTwoDigits(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public GregorianCalendar getCalendar() {
        int n = this.hasTimezone() ? this.getTimezoneInMinutes() : 0;
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n * 60000, "LLL");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.clear();
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(Math.abs(this.year), this.month - 1, this.day);
        gregorianCalendar.set(15, n * 60000);
        gregorianCalendar.set(16, 0);
        if (this.year < 0) {
            gregorianCalendar.set(0, 0);
        }
        gregorianCalendar.getTime();
        return gregorianCalendar;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DATE_TYPE;
    }

    public CalendarValue copy() {
        return new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes());
    }

    public CalendarValue adjustTimezone(int n) {
        DateTimeValue dateTimeValue = (DateTimeValue)this.toDateTime().adjustTimezone(n);
        return new DateValue(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay(), dateTimeValue.getTimezoneInMinutes());
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return this.getCalendar().getTime();
        }
        if (clazz.isAssignableFrom(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = DateValue.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar)) {
            return this.getCalendar();
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = DateValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of date to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.year > 0 ? this.year : this.year - 1);
            }
            case 2: {
                return new IntegerValue(this.month);
            }
            case 3: {
                return new IntegerValue(this.day);
            }
            case 7: {
                if (this.hasTimezone()) {
                    return SecondsDurationValue.fromMilliseconds(this.getTimezoneInMinutes() * 60000);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateValue)) {
            throw new ClassCastException("Date values are not comparable to " + object.getClass());
        }
        return this.compareTo((DateValue)object, new IndependentContext().makeEarlyEvaluationContext());
    }

    public int compareTo(CalendarValue calendarValue, XPathContext xPathContext) {
        TypeHierarchy typeHierarchy = xPathContext.getNamePool().getTypeHierarchy();
        if (this.getItemType(typeHierarchy).getPrimitiveType() != calendarValue.getItemType(typeHierarchy).getPrimitiveType()) {
            throw new ClassCastException("Cannot compare values of different types");
        }
        return this.toDateTime().compareTo(calendarValue.toDateTime(), xPathContext);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getCalendar().getTime().hashCode() + this.getTimezoneInMinutes();
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            long l = ((SecondsDurationValue)durationValue).getLengthInMicroseconds();
            boolean bl = l < 0L;
            l = Math.abs(l);
            int n = (int)Math.floor((double)l / 8.64E10);
            boolean bl2 = l % 86400000000L > 0L;
            int n2 = DateValue.getJulianDayNumber(this.year, this.month, this.day);
            DateValue dateValue = DateValue.dateFromJulianDayNumber(n2 + (bl ? -n : n));
            if (bl2 && bl) {
                dateValue = DateValue.yesterday(dateValue.year, dateValue.month, dateValue.day);
            }
            dateValue.setTimezoneInMinutes(this.getTimezoneInMinutes());
            return dateValue;
        }
        if (durationValue instanceof MonthDurationValue) {
            int n = ((MonthDurationValue)durationValue).getLengthInMonths();
            int n3 = this.month - 1 + n;
            int n4 = this.year + n3 / 12;
            if ((n3 %= 12) < 0) {
                n3 += 12;
                --n4;
            }
            ++n3;
            int n5 = this.day;
            while (!DateValue.isValidDate(n4, n3, n5)) {
                --n5;
            }
            return new DateValue(n4, (byte)n3, (byte)n5, this.getTimezoneInMinutes());
        }
        DynamicError dynamicError = new DynamicError("Date arithmetic is not supported on xs:duration, only on its subtypes");
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue, XPathContext xPathContext) throws XPathException {
        if (!(calendarValue instanceof DateValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a date, but the second is not");
            dynamicError.setIsTypeError(true);
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
        return super.subtract(calendarValue, xPathContext);
    }

    public static int getJulianDayNumber(int n, int n2, int n3) {
        int n4 = n - (n2 < 3 ? 1 : 0);
        short s = monthData[n2 - 1];
        if (n4 >= 0) {
            return n3 + s + 365 * n4 + n4 / 4 - n4 / 100 + n4 / 400 + 1721118;
        }
        int n5 = n3 + s + 365 * (n4 += 12000) + n4 / 4 - n4 / 100 + n4 / 400 + 1721118;
        return n5 - 4382910;
    }

    public static DateValue dateFromJulianDayNumber(int n) {
        if (n >= 0) {
            int n2 = n + 68569 + 1;
            int n3 = 4 * n2 / 146097;
            int n4 = 4000 * ((n2 -= (146097 * n3 + 3) / 4) + 1) / 1461001;
            n2 = n2 - 1461 * n4 / 4 + 31;
            int n5 = 80 * n2 / 2447;
            int n6 = n2 - 2447 * n5 / 80;
            n2 = n5 / 11;
            int n7 = n5 + 2 - 12 * n2;
            int n8 = 100 * (n3 - 49) + n4 + n2;
            return new DateValue(n8, (byte)n7, (byte)n6);
        }
        DateValue dateValue = DateValue.dateFromJulianDayNumber(n + 4382910);
        dateValue.year -= 12000;
        return dateValue;
    }

    public static final int getDayWithinYear(int n, int n2, int n3) {
        int n4 = DateValue.getJulianDayNumber(n, n2, n3);
        int n5 = DateValue.getJulianDayNumber(n, 1, 1);
        return n4 - n5 + 1;
    }

    public static final int getDayOfWeek(int n, int n2, int n3) {
        int n4 = DateValue.getJulianDayNumber(n, n2, n3);
        n4 -= 2378500;
        while (n4 <= 0) {
            n4 += 70000000;
        }
        return (n4 - 1) % 7 + 1;
    }

    public static final int getWeekNumber(int n, int n2, int n3) {
        int n4 = DateValue.getDayWithinYear(n, n2, n3);
        int n5 = DateValue.getDayOfWeek(n, 1, 1);
        if (n5 > 4 && n5 + n4 <= 8) {
            return DateValue.getWeekNumber(n - 1, 12, 31);
        }
        int n6 = n5 < 5 ? 1 : 0;
        return (n4 + n5 - 2) / 7 + n6;
    }

    public static final int getWeekNumberWithinMonth(int n, int n2, int n3) {
        int n4 = DateValue.getDayOfWeek(n, n2, 1);
        int n5 = n4 < 5 ? 1 : 0;
        return (n3 + n4 - 2) / 7 + n5;
    }

    public static void main(String[] stringArray) throws Exception {
        DateValue dateValue = new DateValue(stringArray[0]);
        System.out.println(dateValue.getStringValue());
        int n = DateValue.getJulianDayNumber(dateValue.year, dateValue.month, dateValue.day);
        System.out.println(n);
        System.out.println(DateValue.dateFromJulianDayNumber(n).getStringValue());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

