/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.OutputEvent;
import alice.tuprolog.OutputListener;
import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.util.Tools;
import java.io.InputStream;

public class Agent {
    private Prolog core;
    private String theoryText;
    private InputStream theoryInputStream;
    private String goalText;
    private OutputListener defaultOutputListener = new OutputListener(){

        public void onOutput(OutputEvent ev) {
            System.out.print(ev.getMsg());
        }
    };

    public Agent(String theory) {
        this.theoryText = theory;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(String theory, String goal) {
        this.theoryText = theory;
        this.goalText = goal;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(InputStream is) {
        this.theoryInputStream = is;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public Agent(InputStream is, String goal) {
        this.theoryInputStream = is;
        this.goalText = goal;
        this.core = new Prolog();
        this.core.addOutputListener(this.defaultOutputListener);
    }

    public final void spawn() {
        new AgentThread(this).start();
    }

    public synchronized void addOutputListener(OutputListener l) {
        this.core.addOutputListener(l);
    }

    public synchronized void removeOutputListener(OutputListener l) {
        this.core.removeOutputListener(l);
    }

    public void removeAllOutputListener() {
        this.core.removeAllOutputListeners();
    }

    private void body() {
        try {
            if (this.theoryText == null) {
                this.core.setTheory(new Theory(this.theoryInputStream));
            } else {
                this.core.setTheory(new Theory(this.theoryText));
            }
            if (this.goalText != null) {
                this.core.solve(this.goalText);
            }
        }
        catch (Exception ex) {
            System.err.println("invalid theory or goal.");
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block5: {
            if (args.length == 1 || args.length == 2) {
                try {
                    String text = Tools.loadText(args[0]);
                    if (args.length == 1) {
                        new Agent(text).spawn();
                        break block5;
                    }
                    new Agent(text, args[1]).spawn();
                }
                catch (Exception ex) {
                    System.err.println("invalid theory.");
                }
            } else {
                System.err.println("args: <theory file> { goal }");
                System.exit(-1);
            }
        }
    }

    final class AgentThread
    extends Thread {
        Agent agent;

        AgentThread(Agent agent2) {
            this.agent = agent2;
        }

        public final void run() {
            this.agent.body();
        }
    }
}

