/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.lang.reflect.Method;

class BuiltIn {
    static final int LIBRARY_PREDICATE = -100;
    static final int LIBRARY_FUNCTOR = -200;
    private int code;
    private Method method;
    private Library library;
    private Term[] builtin_args;
    private Struct builtin_struct;

    public BuiltIn(int code) {
        this.code = code;
    }

    public BuiltIn(int type, Struct s, Library lib) throws NoSuchMethodException {
        this.code = type;
        this.library = lib;
        this.method = this.library.getLinkedMethod(s);
        if (this.method == null) {
            throw new NoSuchMethodException();
        }
        this.builtin_struct = s;
        this.builtin_args = new Term[s.getArity()];
    }

    public BuiltIn getCopy(Struct ns) {
        BuiltIn bt = new BuiltIn(this.code);
        bt.library = this.library;
        bt.method = this.method;
        bt.builtin_struct = ns;
        bt.builtin_args = new Term[ns.getArity()];
        return bt;
    }

    public boolean evalAsPredicate() {
        try {
            int i = 0;
            while (i < this.builtin_args.length) {
                this.builtin_args[i] = this.builtin_struct.getTerm(i);
                ++i;
            }
            return (Boolean)this.method.invoke((Object)this.library, (Object[])this.builtin_args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Term evalAsFunctor() {
        try {
            int i = 0;
            while (i < this.builtin_args.length) {
                this.builtin_args[i] = this.builtin_struct.getTerm(i);
                ++i;
            }
            return (Term)this.method.invoke((Object)this.library, (Object[])this.builtin_args);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getCode() {
        return this.code;
    }

    public boolean isCorePredicate() {
        return this.code != -100 && this.code != -200;
    }

    public boolean isLibraryPredicate() {
        return this.code == -100;
    }

    public boolean isLibraryFunctor() {
        return this.code == -200;
    }

    public String toString() {
        if (this.isLibraryFunctor() || this.isLibraryPredicate()) {
            return "[ built-in: method " + this.method.getName() + " - " + this.builtin_args + " - N args: " + this.builtin_args.length + " - " + this.library.getClass().getName() + " ]\n";
        }
        return "[ built-in: code " + this.code + " ]";
    }
}

