/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.OperatorManager;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.LinkedList;
import java.io.Serializable;

class ClauseInfo
implements Serializable {
    Struct clause;
    int timestamp;
    boolean stillValid;
    boolean dynamic;
    String libName;

    ClauseInfo(Struct clause_, int t, boolean dyn, String libName) {
        LinkedList l = new LinkedList();
        this.clause = (Struct)clause_.copy(l);
        this.stillValid = true;
        this.timestamp = Var.rename(l, t, true);
        this.dynamic = dyn;
        this.libName = libName;
    }

    ClauseInfo(Struct clause_, Prolog engine, boolean dyn, String libName) {
        LinkedList l = new LinkedList();
        this.clause = (Struct)this.toClause(clause_).copy(l);
        engine.identify(this.clause, false);
        this.stillValid = true;
        this.timestamp = Var.rename(l, Integer.MIN_VALUE, false);
        this.dynamic = dyn;
        this.libName = libName;
    }

    private Struct toClause(Struct t) {
        if (!t.isClause()) {
            t = new Struct(":-", t, new Struct("true"));
        }
        return t;
    }

    public String toString(OperatorManager op) {
        int p = op.opPrio(":-", "xfx");
        if (p >= 1) {
            String st = ClauseInfo.indentPredicatesAsArgX(this.clause.getArg(1), op, p);
            String head = this.clause.getArg(0).toStringAsArgX(op, p);
            if (st.equals("true")) {
                return String.valueOf(head) + ".\n";
            }
            return String.valueOf(head) + " :-\n\t" + st + ".\n";
        }
        p = op.opPrio(":-", "yfx");
        if (p >= 1) {
            String st = ClauseInfo.indentPredicatesAsArgX(this.clause.getArg(1), op, p);
            String head = this.clause.getArg(0).toStringAsArgY(op, p);
            if (st.equals("true")) {
                return String.valueOf(head) + ".\n";
            }
            return String.valueOf(head) + " :-\n\t" + st + ".\n";
        }
        p = op.opPrio(":-", "xfy");
        if (p >= 1) {
            String st = ClauseInfo.indentPredicatesAsArgY(this.clause.getArg(1), op, p);
            String head = this.clause.getArg(0).toStringAsArgX(op, p);
            if (st.equals("true")) {
                return String.valueOf(head) + ".\n";
            }
            return String.valueOf(head) + " :-\n\t" + st + ".\n";
        }
        return this.clause.toString();
    }

    public String toString() {
        String st = ClauseInfo.indentPredicates(this.clause.getArg(1));
        return String.valueOf(this.clause.getArg(0).toString()) + " :-\n\t" + st + ".\n";
    }

    private static String indentPredicates(Term t) {
        if (t.isStruct()) {
            Struct co = (Struct)t;
            if (co.getName().equals(",")) {
                return String.valueOf(co.getArg(0).toString()) + ",\n\t" + ClauseInfo.indentPredicates(co.getArg(1));
            }
            return t.toString();
        }
        return t.toString();
    }

    private static String indentPredicatesAsArgX(Term t, OperatorManager op, int p) {
        if (t.isStruct()) {
            Struct co = (Struct)t;
            if (co.getName().equals(",")) {
                return String.valueOf(co.getArg(0).toStringAsArgX(op, p)) + ",\n\t" + ClauseInfo.indentPredicatesAsArgX(co.getArg(1), op, p);
            }
            return t.toStringAsArgX(op, p);
        }
        return t.toStringAsArgX(op, p);
    }

    private static String indentPredicatesAsArgY(Term t, OperatorManager op, int p) {
        if (t.isStruct()) {
            Struct co = (Struct)t;
            if (co.getName().equals(",")) {
                return String.valueOf(co.getArg(0).toStringAsArgY(op, p)) + ",\n\t" + ClauseInfo.indentPredicatesAsArgY(co.getArg(1), op, p);
            }
            return t.toStringAsArgY(op, p);
        }
        return t.toStringAsArgY(op, p);
    }
}

