/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Number;
import alice.tuprolog.Term;

public class Double
extends Number {
    private double value;

    public Double(double v) {
        this.value = v;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final float floatValue() {
        return (float)this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final long longValue() {
        return (long)this.value;
    }

    public final boolean isInteger() {
        return false;
    }

    public final boolean isReal() {
        return true;
    }

    public final boolean isTypeInt() {
        return false;
    }

    public final boolean isTypeFloat() {
        return false;
    }

    public final boolean isTypeDouble() {
        return true;
    }

    public final boolean isTypeLong() {
        return false;
    }

    public boolean isGreater(Term t) {
        if ((t = t.getTerm()).isNumber()) {
            return this.value > ((Number)t).doubleValue();
        }
        if (t.isStruct()) {
            return false;
        }
        return t.isVar();
    }

    public boolean isEqual(Term t) {
        if ((t = t.getTerm()).isNumber()) {
            return this.value == ((Number)t).doubleValue();
        }
        return false;
    }

    boolean unify(Term t, int m) {
        if ((t = t.getTerm()).isVar()) {
            return t.unify(this, m);
        }
        if (t.isNumber()) {
            return this.value == ((Number)t).doubleValue();
        }
        return false;
    }

    public String toString() {
        return java.lang.Double.toString(this.value);
    }
}

