/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.io.Serializable;
import java.util.Iterator;

class Flag
implements Serializable {
    private String name;
    private Struct valueList;
    private Term value;
    private Term defaultValue;
    private boolean modifiable;
    private String libraryName;

    public Flag(String name, Struct valueSet, Term defValue, boolean modifiable, String library) {
        this.name = name;
        this.valueList = valueSet;
        this.defaultValue = defValue;
        this.modifiable = modifiable;
        this.libraryName = library;
        this.value = defValue;
    }

    protected Flag() {
    }

    public Object clone() {
        Flag f = new Flag();
        f.name = this.name;
        f.valueList = (Struct)this.valueList.copy();
        f.value = this.value.copy();
        f.defaultValue = this.defaultValue.copy();
        f.modifiable = this.modifiable;
        f.libraryName = this.libraryName;
        return f;
    }

    public boolean isValidValue(Term value) {
        Iterator it = this.valueList.listIterator();
        while (it.hasNext()) {
            Term t = (Term)it.next();
            if (!value.match(t)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Struct getValueList() {
        return this.valueList;
    }

    public boolean setValue(Term value) {
        if (this.isValidValue(value) && this.modifiable) {
            this.value = value;
            return true;
        }
        return false;
    }

    public Term getValue() {
        return this.value;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public String getLibraryName() {
        return this.libraryName;
    }
}

