/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.DefaultOperatorManager;
import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Long;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Token;
import alice.tuprolog.Tokenizer;
import alice.tuprolog.Var;
import alice.util.LinkedList;
import alice.util.StringInputStream;
import java.io.Serializable;

public class Parser
implements Serializable {
    public static final int TERM = 0;
    public static final int EOF = 1;
    public static final int ERROR = 2;
    private Tokenizer tokenizer;
    private Term term;
    private int type;
    private static OperatorManager defaultOperatorManager = new DefaultOperatorManager();
    private OperatorManager opManager;

    public Parser(OperatorManager op, String theoryText) {
        this.opManager = op != null ? op : defaultOperatorManager;
        this.tokenizer = new Tokenizer(new StringInputStream(theoryText));
    }

    public Parser(String theoryText) {
        this(null, theoryText);
    }

    public int readTerm(boolean endNeeded) {
        Token tk = this.tokenizer.readToken();
        if (tk.getAttribute() == 4096) {
            this.type = 1;
            return 1;
        }
        this.tokenizer.unreadToken(tk);
        try {
            this.term = this.exprA(1200);
            this.term.resolveVariables(0);
        }
        catch (Exception e) {
            this.term = null;
        }
        if (this.term == null) {
            this.type = 2;
            return this.type;
        }
        this.type = endNeeded ? (this.tokenizer.readToken().getType() == 13 ? 0 : 2) : 0;
        return this.type;
    }

    public static Term toTerm(String st) throws InvalidTermException {
        Parser p = new Parser(st);
        Token tk = p.tokenizer.readToken();
        if (tk.getAttribute() == 4096) {
            throw new InvalidTermException();
        }
        p.tokenizer.unreadToken(tk);
        Term term = null;
        try {
            term = p.exprA(1200);
        }
        catch (Exception e) {
            throw new InvalidTermException();
        }
        if (term == null) {
            throw new InvalidTermException();
        }
        if (p.tokenizer.readToken().getAttribute() == 4096) {
            try {
                term.resolveVariables();
                return term;
            }
            catch (Exception ex) {
                throw new InvalidTermException();
            }
        }
        throw new InvalidTermException();
    }

    public static Term toTerm(String st, OperatorManager op) throws InvalidTermException {
        Parser p = new Parser(op, st);
        Token tk = p.tokenizer.readToken();
        if (tk.getAttribute() == 4096) {
            throw new InvalidTermException();
        }
        p.tokenizer.unreadToken(tk);
        Term term = null;
        try {
            term = p.exprA(1200);
        }
        catch (Exception e) {
            throw new InvalidTermException();
        }
        if (term == null) {
            throw new InvalidTermException();
        }
        if (p.tokenizer.readToken().getAttribute() == 4096) {
            try {
                term.resolveVariables(0);
                return term;
            }
            catch (Exception ex) {
                throw new InvalidTermException();
            }
        }
        throw new InvalidTermException();
    }

    public int getCurrentPos() {
        return this.tokenizer.getCurrentPos();
    }

    public int getCurrentLine() {
        return this.tokenizer.getCurrentLine();
    }

    public Term getCurrentTerm() {
        return this.term;
    }

    public int getCurrentTermType() {
        return this.type;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void skip() {
        while (this.tokenizer.readToken().getAttribute() != 4096) {
        }
    }

    private Term exprA(int prior) throws Exception {
        if (prior == 0) {
            return this.expr0();
        }
        Term tb = this.exprB(prior);
        if (tb != null) {
            Token tk;
            while ((tk = this.tokenizer.readToken()).getAttribute() == 512) {
                Term ta;
                if (this.opManager.opPrio(tk.seq, "yfx") == prior && (ta = this.exprA(this.opManager.opNext(prior))) != null) {
                    tb = new Struct(tk.seq, tb, ta);
                    continue;
                }
                if (this.opManager.opPrio(tk.seq, "yf") != prior) break;
                tb = new Struct(tk.seq, tb);
            }
            this.tokenizer.unreadToken(tk);
        }
        return tb;
    }

    private Term exprB(int prior) throws Exception {
        Token tk = this.tokenizer.readToken();
        if (tk.getAttribute() == 512) {
            Term ta;
            if (this.opManager.opPrio(tk.seq, "fx") == prior && (ta = this.exprA(this.opManager.opNext(prior))) != null) {
                return new Struct(tk.seq, ta);
            }
            if (this.opManager.opPrio(tk.seq, "fy") == prior && (ta = this.exprA(prior)) != null) {
                return new Struct(tk.seq, ta);
            }
        }
        this.tokenizer.unreadToken(tk);
        int pri = this.opManager.opNext(prior);
        Term tb = this.exprA(pri);
        if (tb != null) {
            tk = this.tokenizer.readToken();
            if (tk.getAttribute() == 512) {
                Term ta;
                if (this.opManager.opPrio(tk.seq, "xfx") == prior && (ta = this.exprA(this.opManager.opNext(prior))) != null) {
                    return new Struct(tk.seq, tb, ta);
                }
                if (this.opManager.opPrio(tk.seq, "xfy") == prior && (ta = this.exprA(prior)) != null) {
                    return new Struct(tk.seq, tb, ta);
                }
                if (this.opManager.opPrio(tk.seq, "xf") == prior) {
                    return new Struct(tk.seq, tb);
                }
            }
            this.tokenizer.unreadToken(tk);
        }
        return tb;
    }

    private Term expr0() throws Exception {
        Token tk = this.tokenizer.readToken();
        int type = tk.getType();
        int attr = tk.getAttribute();
        if (type == 1) {
            Term t = this.exprA(1200);
            if (this.tokenizer.readToken().getType() != 2) {
                throw new Exception();
            }
            return t;
        }
        if (type == 3) {
            tk = this.tokenizer.readToken();
            if (tk.getType() == 4) {
                return new Struct();
            }
            this.tokenizer.unreadToken(tk);
            Term t = this.expr0_list();
            if (this.tokenizer.readToken().getType() != 4) {
                throw new Exception();
            }
            return t;
        }
        if (type == 14) {
            Token atok = this.tokenizer.readToken();
            if (atok.getType() == 15) {
                return new Struct("{}");
            }
            this.tokenizer.unreadToken(atok);
            Term arg = this.exprA(1200);
            if (this.tokenizer.readToken().getType() != 15) {
                throw new Exception();
            }
            Struct t = new Struct("{}", arg);
            return t;
        }
        if (type == 6) {
            long num = new java.lang.Long(tk.seq);
            if (num > Integer.MIN_VALUE && num < Integer.MAX_VALUE) {
                return new Int((int)num);
            }
            return new Long(num);
        }
        if (type == 7) {
            return new Double(new java.lang.Double(tk.seq));
        }
        if (type == 9) {
            if (tk.seq.equals("_")) {
                return new Var();
            }
            return new Var(tk.seq);
        }
        if (type == 8 || type == 10) {
            if (attr != 256) {
                return new Struct(tk.seq);
            }
            String f = tk.seq;
            Token tok = this.tokenizer.readToken();
            LinkedList a = this.expr0_arglist();
            if (this.tokenizer.readToken().getType() != 2) {
                throw new Exception();
            }
            Struct newCo = new Struct(f, a);
            return newCo;
        }
        throw new Exception();
    }

    private Term expr0_list() throws Exception {
        Term head = this.exprA_inStruct(1200);
        Token tok = this.tokenizer.readToken();
        if (tok.seq.equals(",")) {
            return new Struct(head, this.expr0_list());
        }
        if (tok.seq.equals("|")) {
            return new Struct(head, this.exprA_inStruct(1200));
        }
        if (tok.seq.equals("]")) {
            this.tokenizer.unreadToken(tok);
            return new Struct(head, (Term)new Struct());
        }
        throw new Exception();
    }

    private Term expr0_list_bracket() throws Exception {
        Term head = this.exprA_inStruct(1200);
        Token tok = this.tokenizer.readToken();
        if (tok.seq.equals(",")) {
            return new Struct("{}", (Term)new Struct(",", head, this.expr0_list_bracket2()));
        }
        if (tok.seq.equals("}")) {
            this.tokenizer.unreadToken(tok);
            return new Struct("{}", head);
        }
        throw new Exception();
    }

    private Term expr0_list_bracket2() throws Exception {
        Term head = this.exprA_inStruct(1200);
        Token tok = this.tokenizer.readToken();
        if (tok.seq.equals(",")) {
            return new Struct(",", head, this.expr0_list_bracket2());
        }
        if (tok.seq.equals("}")) {
            this.tokenizer.unreadToken(tok);
            return head;
        }
        throw new Exception();
    }

    private LinkedList expr0_arglist() throws Exception {
        Term head = this.exprA_inStruct(1200);
        Token tok = this.tokenizer.readToken();
        if (tok.seq.equals(",")) {
            return new LinkedList(head, this.expr0_arglist());
        }
        if (tok.seq.equals(")")) {
            this.tokenizer.unreadToken(tok);
            return new LinkedList(head, new LinkedList());
        }
        throw new Exception();
    }

    private Term exprA_inStruct(int prior) throws Exception {
        if (prior == 0) {
            return this.expr0();
        }
        Term tb = this.exprB_inStruct(prior);
        if (tb != null) {
            Token tk;
            while ((tk = this.tokenizer.readToken()).getAttribute() == 512) {
                Term ta;
                if (tk.seq.equals(",")) break;
                if (this.opManager.opPrio(tk.seq, "yfx") == prior && (ta = this.exprA_inStruct(this.opManager.opNext(prior))) != null) {
                    tb = new Struct(tk.seq, tb, ta);
                    continue;
                }
                if (this.opManager.opPrio(tk.seq, "yf") != prior) break;
                tb = new Struct(tk.seq, tb);
            }
            this.tokenizer.unreadToken(tk);
        }
        return tb;
    }

    private Term exprB_inStruct(int prior) throws Exception {
        Token tk = this.tokenizer.readToken();
        if (tk.getAttribute() == 512 && !tk.seq.equals(",")) {
            Term ta;
            if (this.opManager.opPrio(tk.seq, "fx") == prior && (ta = this.exprA_inStruct(this.opManager.opNext(prior))) != null) {
                return new Struct(tk.seq, ta);
            }
            if (this.opManager.opPrio(tk.seq, "fy") == prior && (ta = this.exprA_inStruct(prior)) != null) {
                return new Struct(tk.seq, ta);
            }
        }
        this.tokenizer.unreadToken(tk);
        int pri = this.opManager.opNext(prior);
        Term tb = this.exprA_inStruct(pri);
        if (tb != null) {
            tk = this.tokenizer.readToken();
            if (tk.getAttribute() == 512 && !tk.seq.equals(",")) {
                Term ta;
                if (this.opManager.opPrio(tk.seq, "xfx") == prior && (ta = this.exprA_inStruct(this.opManager.opNext(prior))) != null) {
                    return new Struct(tk.seq, tb, ta);
                }
                if (this.opManager.opPrio(tk.seq, "xfy") == prior && (ta = this.exprA_inStruct(prior)) != null) {
                    return new Struct(tk.seq, tb, ta);
                }
                if (this.opManager.opPrio(tk.seq, "xf") == prior) {
                    return new Struct(tk.seq, tb);
                }
            }
            this.tokenizer.unreadToken(tk);
        }
        return tb;
    }
}

