/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.BuiltIn;
import alice.tuprolog.ClauseInfo;
import alice.tuprolog.Flag;
import alice.tuprolog.GoalInfo;
import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Number;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.OutputEvent;
import alice.tuprolog.OutputListener;
import alice.tuprolog.RTContext;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.SpyEvent;
import alice.tuprolog.SpyListener;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.tuprolog.TheoryManager;
import alice.tuprolog.Var;
import alice.tuprolog.WarningEvent;
import alice.tuprolog.WarningListener;
import alice.util.LinkedList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Prolog
implements Serializable {
    private static final String VERSION = "1.3.0";
    private static final int INIT = 0;
    private static final int FALSE = 1;
    private static final int CONT = 2;
    private static final int TRUE = 3;
    private static final int TRUE_CP = 4;
    private static final int HALT = 5;
    private RTContext currentContext;
    private boolean mustStop;
    private TheoryManager theoryManager;
    private Term currentGoal;
    private LinkedList currentVars;
    private int evalFlag;
    private int haltCode;
    private Vector currentLibraries = new Vector();
    private HashMap extPredicates = new HashMap();
    private HashMap extFunctors = new HashMap();
    private Vector outputListeners = new Vector();
    private Vector spyListeners = new Vector();
    private Vector warningListeners = new Vector();
    private boolean spy = false;
    private boolean warning = true;
    private OperatorManager opManager = new OperatorManager();
    private Vector flags = new Vector();
    private static final String[][] BUILTIN = new String[][]{{"fail", "true", "halt", "!", "$restore_db"}, {"$asserta", "$assertz", "$retract", "halt", "load_library", "unload_library", "flag_list"}, {",", "is", "=", "\\=", "$tolist", "$fromlist", "$copy", "$append", "$find", "flag"}, {"op"}};

    public Prolog() {
        this.theoryManager = new TheoryManager(this);
        try {
            this.loadLibrary("alice.tuprolog.lib.BasicLibrary");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.ISOLibrary");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.IOLibrary");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.loadLibrary("alice.tuprolog.lib.JavaLibrary");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Prolog(String[] libs) throws InvalidLibraryException {
        this.theoryManager = new TheoryManager(this);
        if (libs != null) {
            int i = 0;
            while (i < libs.length) {
                this.loadLibrary(libs[i]);
                ++i;
            }
        }
    }

    public static String getVersion() {
        return VERSION;
    }

    public synchronized void setTheory(Theory th) throws InvalidTheoryException {
        this.theoryManager.consult(th, true, true, null);
        if (this.theoryManager.getStartGoal() != null) {
            try {
                Term bak_goal = this.currentGoal;
                LinkedList bak_vars = this.currentVars;
                this.solve(this.theoryManager.getStartGoal());
                this.currentGoal = bak_goal;
                this.currentVars = bak_vars;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void addTheory(Theory th) throws InvalidTheoryException {
        this.theoryManager.consult(th, false, true, null);
        if (this.theoryManager.getStartGoal() != null) {
            try {
                Term bak_goal = this.currentGoal;
                LinkedList bak_vars = this.currentVars;
                this.solve(this.theoryManager.getStartGoal());
                this.currentGoal = bak_goal;
                this.currentVars = bak_vars;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized Theory getTheory() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.theoryManager.save(out, true);
        try {
            return new Theory(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void clearTheory() {
        this.theoryManager.clear(true);
    }

    public synchronized Library loadLibrary(String className) throws InvalidLibraryException {
        Library lib = null;
        try {
            lib = (Library)Class.forName(className).newInstance();
            String name = lib.getName();
            boolean found = false;
            Library alib = null;
            int i = 0;
            while (i < this.currentLibraries.size()) {
                alib = (Library)this.currentLibraries.elementAt(i);
                if (alib.getName().equals(name)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                if (this.warning) {
                    this.notifyWarning(new WarningEvent(this, "library " + alib.getName() + " already loaded."));
                }
                return alib;
            }
        }
        catch (Exception ex) {
            throw new InvalidLibraryException(className);
        }
        this.bindLibrary(lib);
        return lib;
    }

    public synchronized void loadLibrary(Library lib) throws InvalidLibraryException {
        boolean found = false;
        String name = lib.getName();
        Library alib = null;
        int i = 0;
        while (i < this.currentLibraries.size()) {
            alib = (Library)this.currentLibraries.elementAt(i);
            if (alib.getName().equals(name)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found && this.warning) {
            this.notifyWarning(new WarningEvent(this, "library " + alib.getName() + " already loaded."));
        }
    }

    public synchronized String[] getCurrentLibraries() {
        String[] libs = new String[this.currentLibraries.size()];
        int i = 0;
        while (i < libs.length) {
            libs[i] = ((Library)this.currentLibraries.get(i)).getName();
            ++i;
        }
        return libs;
    }

    public synchronized void unloadLibrary(String name) throws InvalidLibraryException {
        boolean found = false;
        int j = 0;
        while (j < this.currentLibraries.size()) {
            Library lib = (Library)this.currentLibraries.elementAt(j);
            if (lib.getName().equals(name)) {
                found = true;
                this.currentLibraries.removeElementAt(j);
                lib.dismiss();
                Iterator it = lib.getPredicates().iterator();
                while (it.hasNext()) {
                    this.extPredicates.remove(it.next());
                }
                it = lib.getFunctors().iterator();
                while (it.hasNext()) {
                    this.extFunctors.remove(it.next());
                }
                break;
            }
            ++j;
        }
        if (!found) {
            throw new InvalidLibraryException();
        }
        this.theoryManager.removeLibraryTheory(name);
        this.theoryManager.rebindBuiltins();
    }

    private Library bindLibrary(Library lib) throws InvalidLibraryException {
        try {
            Library alib;
            String name = lib.getName();
            lib.setEngine(this);
            this.currentLibraries.addElement(lib);
            Iterator it = lib.getPredicates().iterator();
            while (it.hasNext()) {
                String pred_name = (String)it.next();
                if (this.warning && (alib = (Library)this.extPredicates.get(pred_name)) != null) {
                    this.notifyWarning(new WarningEvent(this, "predicate " + pred_name + " already defined in library " + alib.getName()));
                }
                this.extPredicates.put(pred_name, lib);
            }
            it = lib.getFunctors().iterator();
            while (it.hasNext()) {
                String fun_name = (String)it.next();
                alib = (Library)this.extFunctors.get(fun_name);
                if (this.warning && alib != null && this.warning) {
                    this.notifyWarning(new WarningEvent(this, "functor " + name + " already defined in library " + alib.getName()));
                }
                this.extFunctors.put(fun_name, lib);
            }
            String th = lib.getTheory();
            if (th != null) {
                this.theoryManager.consult(new Theory(th), false, false, name);
                if (this.theoryManager.getStartGoal() != null) {
                    try {
                        Term bak_goal = this.currentGoal;
                        LinkedList bak_vars = this.currentVars;
                        this.solve(this.theoryManager.getStartGoal());
                        this.currentGoal = bak_goal;
                        this.currentVars = bak_vars;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.theoryManager.rebindBuiltins();
            return lib;
        }
        catch (InvalidTheoryException ex) {
            System.out.println("line " + ex.line + "  " + ex.pos);
            throw new InvalidLibraryException(lib.getName());
        }
        catch (Exception ex) {
            throw new InvalidLibraryException(lib.getName());
        }
    }

    public synchronized Library getLibrary(String name) {
        int i = 0;
        while (i < this.currentLibraries.size()) {
            Library alib = (Library)this.currentLibraries.elementAt(i);
            if (alib.getName().equals(name)) {
                return alib;
            }
            ++i;
        }
        return null;
    }

    protected Library getLibraryPredicate(String name, int nArgs) {
        return (Library)this.extPredicates.get(String.valueOf(name) + "_" + nArgs);
    }

    protected Library getLibraryFunctor(String name, int nArgs) {
        return (Library)this.extFunctors.get(String.valueOf(name) + "_" + nArgs);
    }

    public synchronized List getCurrentOperatorList() {
        return this.opManager.getOperators().toList();
    }

    OperatorManager getOperatorManager() {
        return this.opManager;
    }

    public synchronized SolveInfo solve(Term g) {
        if (g == null) {
            return null;
        }
        try {
            g.resolveVariables(0);
            int i = 0;
            while (i < this.currentLibraries.size()) {
                ((Library)this.currentLibraries.elementAt(i)).onSolveBegin(g);
                ++i;
            }
            this.identify(g, false);
            this.currentContext = new RTContext();
            this.mustStop = false;
            this.currentVars = new LinkedList();
            this.currentGoal = g.copy(this.currentVars);
            this.evalFlag = 0;
            this.theoryManager.transBegin();
            this.init(this.currentContext, this.currentGoal, 0, Var.rename(this.currentVars, 0, false), 0);
            this.haltCode = 0;
            this.evalFlag = this.eval();
            SolveInfo sinfo = null;
            sinfo = this.evalFlag == 3 || this.evalFlag == 4 ? new SolveInfo(this.toVarArray(this.currentVars), this.currentGoal.copy()) : new SolveInfo();
            if (this.evalFlag == 1 || this.evalFlag == 3 || this.evalFlag == 5) {
                this.solveEnd();
            }
            return sinfo;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new SolveInfo();
        }
    }

    public synchronized SolveInfo solve(String st) throws MalformedGoalException {
        try {
            Term t = Term.parseSentence(st, this.opManager);
            return this.solve(t);
        }
        catch (InvalidTermException ex) {
            throw new MalformedGoalException();
        }
    }

    public synchronized boolean hasOpenAlternatives() {
        return this.evalFlag == 4;
    }

    public synchronized boolean isHalted() {
        return this.evalFlag == 5;
    }

    public synchronized SolveInfo solveNext() throws NoMoreSolutionException {
        if (this.evalFlag == 4) {
            SolveInfo sinfo;
            this.evalFlag = this.backTracking();
            if (this.evalFlag == 1) {
                sinfo = new SolveInfo();
            } else {
                this.evalFlag = this.eval();
                sinfo = new SolveInfo(this.toVarArray(this.currentVars), this.currentGoal.copy());
            }
            if (this.evalFlag == 1 || this.evalFlag == 3 || this.evalFlag == 5) {
                this.solveEnd();
            }
            return sinfo;
        }
        throw new NoMoreSolutionException();
    }

    public void solveHalt() {
        this.mustStop = true;
    }

    public synchronized void solveEnd() {
        this.theoryManager.transEnd(this.evalFlag == 3 || this.evalFlag == 4);
        this.theoryManager.optimize();
        int i = 0;
        while (i < this.currentLibraries.size()) {
            ((Library)this.currentLibraries.elementAt(i)).onSolveEnd();
            ++i;
        }
    }

    public synchronized boolean unify(Term t0, Term t1) {
        if (this.currentContext != null) {
            this.currentContext.time = t0.resolveVariables(this.currentContext.time);
            this.currentContext.time = t1.resolveVariables(this.currentContext.time);
            return t0.unify(t1, this.currentContext.mark++);
        }
        return t0.unify(t1);
    }

    public synchronized Term getRenamedCopy(Term t0) {
        if (this.currentContext != null) {
            return this.currentContext.getRenamedTermCopy(t0);
        }
        return t0.copy();
    }

    public synchronized Term toTerm(String st) throws InvalidTermException {
        return Term.parse(st, this.opManager);
    }

    public synchronized String toString(Term term) {
        return term.toStringAsArgY(this.opManager, 1200);
    }

    private void init(RTContext e, Term g, int l, int t, int m) {
        this.spy(l, "Init: ", g);
        e.sDBTS = this.theoryManager.transStatus();
        e.startGoal = g;
        e.startLevel = l;
        e.startTime = t;
        e.startMark = m;
        e.evalState = false;
        e.compatibleGoals = new LinkedList();
        e.goalsToEval = new LinkedList();
        e.termsExecuted = new LinkedList();
        e.nCompatibleGoals = 0;
        e.nGoalsToEval = 0;
        e.nTermsExecuted = 0;
        e.nOpenTermsExecuted = 0;
        e.time = t;
        e.mark = m;
        if (g.isStruct()) {
            Struct goal = (Struct)g;
            if (!goal.isBuiltIn()) {
                e.compatibleGoals = this.theoryManager.find(goal, t, m);
                e.nCompatibleGoals = e.compatibleGoals.length();
                this.spy(l, "Check type: " + e.nCompatibleGoals + " compatible rules found for ", goal);
                if (e.nCompatibleGoals != 0) {
                    e.evalState = true;
                    e.loadChoice();
                }
            } else {
                e.evalState = true;
                e.currentGoal = new GoalInfo(goal);
                this.spy(l, "Check type: built-in ", goal);
                e.saveFGoal();
            }
        }
    }

    private int stepE(RTContext e) {
        while (e.nGoalsToEval > 0) {
            int r;
            if (this.mustStop) {
                return 1;
            }
            e.loadFGoal();
            Term goal_app = e.currentGoal.goal.getTerm();
            if (e.currentGoal.goal != goal_app) {
                this.identify(goal_app, false);
                e.currentGoal.goal = goal_app;
            }
            this.spy(e.startLevel, "Eval: ", e.currentGoal.goal);
            if (!e.currentGoal.goal.isStruct()) {
                e.saveFGoal();
                return 1;
            }
            Struct current_goal = (Struct)e.currentGoal.goal;
            if (!current_goal.isBuiltIn()) {
                if (e.nGoalsToEval == 0 && !e.existChoice()) {
                    this.init(e, current_goal, e.startLevel, e.time, e.mark);
                    if (e.evalState) {
                        return 2;
                    }
                    return 1;
                }
                e.currentGoal.context = new RTContext();
                this.init(e.currentGoal.context, current_goal, e.startLevel + 1, e.time, e.mark);
                if (e.currentGoal.context.evalState) {
                    r = this.eval(e.currentGoal.context);
                    e.loadStatus();
                } else {
                    r = 1;
                }
            } else {
                int code = current_goal.getBuiltIn().getCode();
                if (code == 200) {
                    Term g1 = current_goal.getArg(1);
                    Term g0 = current_goal.getArg(0);
                    e.setGoal(g1);
                    e.saveFGoal();
                    e.setGoal(g0);
                    e.saveFGoal();
                    continue;
                }
                RTContext bak = this.currentContext;
                this.currentContext = e;
                r = this.builtin(e);
                this.currentContext = bak;
            }
            if (this.mustStop) {
                return 1;
            }
            if (r == 5) {
                return 5;
            }
            switch (r) {
                case 1: {
                    e.currentGoal.goal.free(e.currentGoal.mark);
                    e.currentGoal.context = null;
                    e.saveFGoal();
                    return 1;
                }
                case 3: {
                    e.currentGoal.context = null;
                }
                case 4: {
                    e.saveTGoal();
                }
            }
        }
        return e.existChoice() ? 4 : 3;
    }

    private int stepB(RTContext e) {
        while (e.nTermsExecuted > 0) {
            int r;
            if (this.mustStop) {
                return 1;
            }
            e.loadTGoal();
            this.spy(e.startLevel, "Back: ", e.currentGoal.goal);
            if (e.currentGoal.context != null) {
                r = this.backTracking(e.currentGoal.context);
                e.loadStatus();
            } else {
                r = 1;
            }
            if (this.mustStop) {
                return 1;
            }
            switch (r) {
                case 1: {
                    e.currentGoal.goal.free(e.currentGoal.mark);
                    e.currentGoal.context = null;
                    e.saveFGoal();
                    break;
                }
                case 3: {
                    e.currentGoal.context = null;
                }
                case 4: {
                    e.saveTGoal();
                    return 2;
                }
                case 5: {
                    return 5;
                }
            }
        }
        e.startGoal.free(e.startMark);
        return e.loadChoice() ? 2 : 1;
    }

    private int eval() {
        this.evalFlag = this.currentContext.evalState ? this.eval(this.currentContext) : 1;
        return this.evalFlag;
    }

    private int eval(RTContext e) {
        int r;
        while ((r = this.stepE(e)) == 2 || r == 1 && (r = this.stepB(e)) == 2) {
        }
        return r;
    }

    private int backTracking() {
        this.evalFlag = this.currentContext.evalState ? this.backTracking(this.currentContext) : 1;
        return this.evalFlag;
    }

    private int backTracking(RTContext e) {
        int r;
        while ((r = this.stepB(e)) == 2) {
            while ((r = this.stepE(e)) == 2) {
            }
            if (r == 1) continue;
            break;
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int builtin(RTContext e) {
        try {
            Term arg0;
            int gcode;
            if (!e.currentGoal.goal.isStruct()) {
                return 1;
            }
            Struct goal = (Struct)e.currentGoal.goal;
            if (!goal.isBuiltIn()) {
                return 1;
            }
            BuiltIn g = goal.getBuiltIn();
            if (g.isLibraryPredicate()) {
                boolean res = g.evalAsPredicate();
                if (!res) return 1;
                return 3;
            }
            if (g.isLibraryFunctor()) {
                Term term = g.evalAsFunctor();
                if (term == null) return 1;
                e.currentGoal.goal = term;
                if (!term.isStruct()) return 3;
                this.identify(term, true);
                if (!((Struct)term).isBuiltIn()) return 3;
                goal = (Struct)term;
                g = goal.getBuiltIn();
            }
            if ((gcode = g.getCode()) < 100) {
                switch (gcode) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        e.cut();
                        return 3;
                    }
                    case 4: {
                        this.theoryManager.transRestore(e.sDBTS);
                        return 3;
                    }
                }
                return 1;
            }
            if (gcode < 200) {
                arg0 = goal.getArg(0).getTerm();
                switch (gcode) {
                    case 100: {
                        if (!arg0.isStruct()) {
                            return 1;
                        }
                        this.theoryManager.assertA((Struct)arg0, true, null);
                        return 3;
                    }
                    case 101: {
                        if (!arg0.isStruct()) {
                            return 1;
                        }
                        this.theoryManager.assertZ((Struct)arg0, true, null);
                        return 3;
                    }
                    case 102: {
                        if (!arg0.isStruct()) {
                            return 1;
                        }
                        Struct sarg0 = (Struct)arg0;
                        ClauseInfo c = this.theoryManager.retract(sarg0, e.time, e.mark);
                        if (c == null) return 1;
                        Struct clause = null;
                        clause = !sarg0.isClause() ? new Struct(":-", arg0, new Struct("true")) : sarg0;
                        clause.unify(c.clause, e.mark++);
                        e.time = c.timestamp;
                        return 3;
                    }
                    case 103: {
                        if (!arg0.isNumber()) {
                            return 1;
                        }
                        this.haltCode = ((Number)arg0).intValue();
                        return 5;
                    }
                    case 104: {
                        if (!arg0.isAtom()) {
                            return 1;
                        }
                        try {
                            this.loadLibrary(((Struct)arg0).getName());
                            return 3;
                        }
                        catch (Exception ex) {
                            return 1;
                        }
                    }
                    case 105: {
                        if (!arg0.isAtom()) {
                            return 1;
                        }
                        try {
                            this.unloadLibrary(((Struct)arg0).getName());
                            return 3;
                        }
                        catch (Exception ex) {
                            return 1;
                        }
                    }
                    case 106: {
                        Struct flist = new Struct();
                        Iterator it = this.flags.iterator();
                        while (it.hasNext()) {
                            Flag fl = (Flag)it.next();
                            flist = new Struct(new Struct("flag", new Struct(fl.getName()), fl.getValue()), (Term)flist);
                        }
                        boolean res = this.unify(arg0, flist);
                        if (!res) return 1;
                        return 3;
                    }
                }
                return 1;
            }
            if (gcode < 300) {
                arg0 = goal.getArg(0).getTerm();
                Term arg1 = goal.getArg(1).getTerm();
                switch (gcode) {
                    case 201: {
                        Term val1;
                        if (arg1.isStruct()) {
                            BuiltIn bt;
                            Struct t = (Struct)arg1;
                            if (arg1 != goal.getArg(1)) {
                                this.identify(t, true);
                            }
                            val1 = t.isBuiltIn() ? ((bt = t.getBuiltIn()).isLibraryFunctor() ? bt.evalAsFunctor() : arg1) : arg1;
                        } else {
                            val1 = arg1;
                        }
                        if (!arg0.unify(val1, e.mark++)) return 1;
                        return 3;
                    }
                    case 202: {
                        if (!arg0.unify(arg1, e.mark++)) return 1;
                        return 3;
                    }
                    case 203: {
                        if (arg0.unify(arg1, e.mark++)) return 1;
                        return 3;
                    }
                    case 204: {
                        if (!arg0.isStruct()) return 1;
                        Struct val0 = ((Struct)arg0).toList();
                        if (val0 == null) return 1;
                        if (arg1.unify(val0, e.mark++)) return 3;
                        return 1;
                    }
                    case 205: {
                        if (!arg1.isList()) return 1;
                        Struct val1 = ((Struct)arg1).fromList();
                        if (val1 == null) return 1;
                        if (arg0.unify(val1, e.mark++)) return 3;
                        return 1;
                    }
                    case 206: {
                        if (!arg1.unify(e.getRenamedTermCopy(arg0), e.mark++)) return 1;
                        return 3;
                    }
                    case 207: {
                        if (!arg1.isList()) return 1;
                        ((Struct)arg1).append(arg0);
                        return 3;
                    }
                    case 208: {
                        if (!arg1.isList()) return 1;
                        LinkedList l = this.theoryManager.find(arg0, e.time, e.mark);
                        while (!l.isEmptyList()) {
                            ClauseInfo b = (ClauseInfo)l.head;
                            l = l.tail;
                            ((Struct)arg1).append(b.clause);
                            if (b.timestamp <= e.time) continue;
                            e.time = b.timestamp;
                        }
                        return 3;
                    }
                    case 209: {
                        if (!arg0.isStruct()) return 1;
                        if (!arg1.isGround()) return 1;
                        String name = arg0.toString();
                        Iterator it = this.flags.iterator();
                        while (it.hasNext()) {
                            Flag flag = (Flag)it.next();
                            if (!flag.getName().equals(name)) continue;
                            if (!flag.isModifiable()) return 1;
                            if (!flag.isValidValue(arg1)) return 1;
                            flag.setValue(arg1);
                            return 3;
                        }
                        return 1;
                    }
                }
                return 1;
            }
            if (gcode >= 400) return 1;
            arg0 = goal.getArg(0).getTerm();
            Term arg1 = goal.getArg(1).getTerm();
            Term arg2 = goal.getArg(2).getTerm();
            switch (gcode) {
                case 300: {
                    if (!arg0.isNumber()) return 1;
                    if (!arg1.isStruct()) return 1;
                    if (!arg2.isStruct()) return 1;
                    this.opManager.opNew(((Struct)arg2).getName(), ((Struct)arg1).getName(), ((Number)arg0).intValue());
                    return 3;
                }
            }
            return 1;
        }
        catch (NullPointerException ex) {
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
    }

    protected void identify(Term term, boolean forceArgumentIdentification) {
        if (term == null) {
            return;
        }
        if (!(term = term.getTerm()).isStruct()) {
            return;
        }
        Struct t = (Struct)term;
        int arity = t.getArity();
        if (forceArgumentIdentification) {
            int c = 0;
            while (c < arity) {
                this.identify(t.getArg(c), true);
                ++c;
            }
        } else {
            String tname = t.getName();
            if (t.isClause() || tname.equals(",")) {
                int c = 0;
                while (c < arity) {
                    this.identify(t.getArg(c), false);
                    ++c;
                }
            } else if (tname.equals("is")) {
                this.identify(t.getTerm(1), true);
            }
        }
        try {
            Object lib = this.extPredicates.get(String.valueOf(t.getName()) + "_" + arity);
            if (lib != null) {
                t.setBuiltIn(new BuiltIn(-100, t, (Library)lib));
                return;
            }
            lib = this.extFunctors.get(String.valueOf(t.getName()) + "_" + arity);
            if (lib != null) {
                t.setBuiltIn(new BuiltIn(-200, t, (Library)lib));
                return;
            }
        }
        catch (Exception lib) {
            // empty catch block
        }
        int c = 0;
        while (c < BUILTIN.length) {
            int d = 0;
            while (d < BUILTIN[c].length) {
                String st = BUILTIN[c][d];
                if (arity == c && t.getName().equals(st)) {
                    t.setBuiltIn(new BuiltIn(c * 100 + d));
                    return;
                }
                ++d;
            }
            ++c;
        }
    }

    boolean defineFlag(String name, Struct valueList, Term defValue, boolean modifiable, String libName) {
        this.flags.add(new Flag(name, valueList, defValue, modifiable, libName));
        return true;
    }

    private Var[] toVarArray(LinkedList vars) {
        if (vars != null) {
            int size = vars.length();
            Var[] bindings = new Var[size];
            LinkedList l = vars;
            int i = 0;
            while (i < size) {
                bindings[i] = (Var)l.head;
                l = l.tail;
                ++i;
            }
            return bindings;
        }
        return new Var[0];
    }

    public synchronized void setSpy(boolean state) {
        this.spy = state;
    }

    public synchronized boolean isSpy() {
        return this.spy;
    }

    protected void spy(String s) {
        if (this.spy) {
            this.notifySpy(new SpyEvent(this, s));
        }
    }

    protected void spy(int i, String s, Term g) {
        if (this.spy) {
            this.notifySpy(new SpyEvent(this, "spy: " + i + "  " + s + "  " + g));
        }
    }

    public synchronized void setWarning(boolean state) {
        this.warning = state;
    }

    public synchronized boolean isWarning() {
        return this.warning;
    }

    public void warn(String m) {
        if (this.warning) {
            this.notifyWarning(new WarningEvent(this, m));
        }
    }

    public synchronized void stdOutput(String m) {
        this.notifyOutput(new OutputEvent(this, m));
    }

    public synchronized void addOutputListener(OutputListener l) {
        this.outputListeners.addElement(l);
    }

    public synchronized void addSpyListener(SpyListener l) {
        this.spyListeners.addElement(l);
    }

    public synchronized void addWarningListener(WarningListener l) {
        this.warningListeners.addElement(l);
    }

    public synchronized void removeOutputListener(OutputListener l) {
        this.outputListeners.removeElement(l);
    }

    public synchronized void removeAllOutputListeners() {
        this.outputListeners.removeAllElements();
    }

    public synchronized void removeSpyListener(SpyListener l) {
        this.spyListeners.removeElement(l);
    }

    public synchronized void removeAllSpyListeners() {
        this.spyListeners.removeAllElements();
    }

    public synchronized void removeWarningListener(WarningListener l) {
        this.warningListeners.removeElement(l);
    }

    public synchronized void removeAllWarningListeners() {
        this.warningListeners.removeAllElements();
    }

    public synchronized List getOutputListenerList() {
        return (List)this.outputListeners.clone();
    }

    public synchronized List getWarningListenerList() {
        return (List)this.warningListeners.clone();
    }

    public synchronized List getSpyListenerList() {
        return (List)this.outputListeners.clone();
    }

    protected void notifyOutput(OutputEvent e) {
        int i = 0;
        while (i < this.outputListeners.size()) {
            ((OutputListener)this.outputListeners.elementAt(i)).onOutput(e);
            ++i;
        }
    }

    protected void notifySpy(SpyEvent e) {
        int i = 0;
        while (i < this.spyListeners.size()) {
            ((SpyListener)this.spyListeners.elementAt(i)).onSpy(e);
            ++i;
        }
    }

    protected void notifyWarning(WarningEvent e) {
        int i = 0;
        while (i < this.warningListeners.size()) {
            ((WarningListener)this.warningListeners.elementAt(i)).onWarning(e);
            ++i;
        }
    }
}

