/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.GoalInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.util.LinkedList;
import java.io.Serializable;

class RTContext
implements Serializable {
    LinkedList sDBTS;
    public Term startGoal;
    public GoalInfo currentGoal;
    public int startLevel;
    public int startTime;
    public int startMark;
    public int time;
    public int mark;
    public boolean evalState;
    public LinkedList compatibleGoals;
    public int nCompatibleGoals;
    public LinkedList goalsToEval;
    public int nGoalsToEval;
    public LinkedList termsExecuted;
    public int nTermsExecuted;
    public int nOpenTermsExecuted;

    RTContext() {
    }

    public void saveFGoal() {
        this.goalsToEval = new LinkedList(this.currentGoal, this.goalsToEval);
        ++this.nGoalsToEval;
    }

    public void loadFGoal() {
        this.currentGoal = (GoalInfo)this.goalsToEval.head;
        this.goalsToEval = this.goalsToEval.tail;
        --this.nGoalsToEval;
        this.currentGoal.time = this.time;
        this.currentGoal.mark = this.mark;
    }

    public void saveTGoal() {
        this.termsExecuted = new LinkedList(this.currentGoal, this.termsExecuted);
        ++this.nTermsExecuted;
        if (this.currentGoal.context != null) {
            ++this.nOpenTermsExecuted;
        }
    }

    public void loadTGoal() {
        this.currentGoal = (GoalInfo)this.termsExecuted.head;
        this.termsExecuted = this.termsExecuted.tail;
        --this.nTermsExecuted;
        this.time = this.currentGoal.time;
        this.mark = this.currentGoal.mark;
        if (this.currentGoal.context != null) {
            --this.nOpenTermsExecuted;
        }
    }

    public void setGoal(Term g) {
        this.currentGoal = new GoalInfo(g);
    }

    public void cut() {
        LinkedList l = this.termsExecuted;
        while (!l.isEmptyList()) {
            ((GoalInfo)l.head).context = null;
            l = l.tail;
        }
        this.compatibleGoals = new LinkedList();
        this.nCompatibleGoals = 0;
        this.nOpenTermsExecuted = 0;
    }

    public void loadStatus() {
        this.time = this.currentGoal.context.time;
        this.mark = this.currentGoal.context.mark;
    }

    public boolean loadChoice() {
        if (this.nCompatibleGoals == 0) {
            return false;
        }
        ClauseInfo d = (ClauseInfo)this.compatibleGoals.head;
        this.compatibleGoals = this.compatibleGoals.tail;
        --this.nCompatibleGoals;
        this.startGoal.unify(d.clause.getArg(0), this.startMark);
        this.currentGoal = new GoalInfo(d.clause.getArg(1));
        this.goalsToEval = new LinkedList();
        this.nGoalsToEval = 0;
        this.time = d.timestamp;
        this.mark = this.startMark + 1;
        this.saveFGoal();
        return true;
    }

    public boolean existChoice() {
        return this.nCompatibleGoals + this.nOpenTermsExecuted != 0;
    }

    public Term getRenamedTermCopy(Term t) {
        LinkedList l = new LinkedList();
        t = t.copy(l);
        this.time = Var.rename(l, this.time + 1, true);
        return t;
    }

    public String toString() {
        String st = "[ Runtime context -- starting goal: " + this.startGoal + " -- current goal: " + this.currentGoal + " -- start level, time, mark: " + this.startLevel + " " + this.startTime + " " + this.startMark + " -- current time, mark: " + this.time + " " + this.mark + " -- eval state: " + this.evalState + " -- number of terms executed: " + this.nTermsExecuted + " -- number of open choices: " + this.nOpenTermsExecuted + " -- compatible goal list: {";
        LinkedList list = this.compatibleGoals;
        while (!list.isEmptyList()) {
            st = String.valueOf(st) + list.getHead().toString() + ", ";
            list = list.getTail();
        }
        st = String.valueOf(st) + "} -- goals to evaluate list: {";
        list = this.goalsToEval;
        while (!list.isEmptyList()) {
            st = String.valueOf(st) + list.getHead().toString() + ", ";
            list = list.getTail();
        }
        st = String.valueOf(st) + "} -- terms executed list: {";
        list = this.termsExecuted;
        while (!list.isEmptyList()) {
            st = String.valueOf(st) + list.getHead().toString() + ", ";
            list = list.getTail();
        }
        st = String.valueOf(st) + "} ]";
        return st;
    }
}

