/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.NoSolutionException;
import alice.tuprolog.Term;
import alice.tuprolog.UnknownVarException;
import alice.tuprolog.Var;
import java.io.Serializable;

public class SolveInfo
implements Serializable {
    private boolean isSuccess;
    private Var[] bindings;
    private Term goal;

    SolveInfo(Var[] vars, Term g) {
        this.isSuccess = true;
        this.bindings = vars;
        this.goal = g;
    }

    SolveInfo() {
        this.isSuccess = false;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Term getTerm(String varName) throws NoSolutionException, UnknownVarException {
        if (this.isSuccess) {
            int i = 0;
            while (i < this.bindings.length) {
                if (this.bindings[i] != null && this.bindings[i].getName().equals(varName)) {
                    return this.bindings[i].getTerm();
                }
                ++i;
            }
            throw new UnknownVarException();
        }
        throw new NoSolutionException();
    }

    public Term getSolution() throws NoSolutionException {
        if (this.isSuccess) {
            return this.goal;
        }
        throw new NoSolutionException();
    }

    public Var[] toVarArray() throws NoSolutionException {
        if (this.isSuccess) {
            return this.bindings;
        }
        throw new NoSolutionException();
    }

    public Term getVarValue(String name) throws NoSolutionException {
        if (this.isSuccess) {
            String st = "";
            int i = 0;
            while (i < this.bindings.length) {
                if (this.bindings[i] != null && this.bindings[i].getName().equals(name)) {
                    return this.bindings[i].getTerm();
                }
                ++i;
            }
            return null;
        }
        throw new NoSolutionException();
    }

    public String toString() {
        if (this.isSuccess) {
            String st = "";
            int i = 0;
            while (i < this.bindings.length) {
                if (!(this.bindings[i] == null || this.bindings[i].isAnonymous() || !this.bindings[i].isBound() || this.bindings[i].getTerm().isVar() && ((Var)this.bindings[i].getTerm()).getName().startsWith("_"))) {
                    st = String.valueOf(st) + this.bindings[i] + "  ";
                }
                ++i;
            }
            return st;
        }
        return "false";
    }
}

