/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.BuiltIn;
import alice.tuprolog.NullTerm;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.StructIterator;
import alice.tuprolog.StructKey;
import alice.tuprolog.Term;
import alice.tuprolog.Tokenizer;
import alice.tuprolog.Var;
import alice.util.LinkedList;
import java.util.Iterator;

public class Struct
extends Term {
    private String name;
    private Term[] arg;
    private int arity;
    private StructKey hashKey;
    private transient BuiltIn builtIn;
    private boolean resolved = false;
    private static int renameStage = 0;

    public Struct(String f) {
        this(f, 0);
    }

    public Struct(String f, Term at0) {
        this(f, 1);
        this.arg[0] = at0;
    }

    public Struct(String f, Term at0, Term at1) {
        this(f, 2);
        this.arg[0] = at0;
        this.arg[1] = at1;
    }

    public Struct(String f, Term at0, Term at1, Term at2) {
        this(f, 3);
        this.arg[0] = at0;
        this.arg[1] = at1;
        this.arg[2] = at2;
    }

    public Struct(String f, Term at0, Term at1, Term at2, Term at3) {
        this(f, 4);
        this.arg[0] = at0;
        this.arg[1] = at1;
        this.arg[2] = at2;
        this.arg[3] = at3;
    }

    public Struct(String f, Term at0, Term at1, Term at2, Term at3, Term at4) {
        this(f, 5);
        this.arg[0] = at0;
        this.arg[1] = at1;
        this.arg[2] = at2;
        this.arg[3] = at3;
        this.arg[4] = at4;
    }

    public Struct(String f, Term at0, Term at1, Term at2, Term at3, Term at4, Term at5) {
        this(f, 6);
        this.arg[0] = at0;
        this.arg[1] = at1;
        this.arg[2] = at2;
        this.arg[3] = at3;
        this.arg[4] = at4;
        this.arg[5] = at5;
    }

    public Struct(String f, Term at0, Term at1, Term at2, Term at3, Term at4, Term at5, Term at6) {
        this(f, 7);
        this.arg[0] = at0;
        this.arg[1] = at1;
        this.arg[2] = at2;
        this.arg[3] = at3;
        this.arg[4] = at4;
        this.arg[5] = at5;
        this.arg[6] = at6;
    }

    public Struct(String f, Term[] argList) {
        this(f, argList.length);
        int i = 0;
        while (i < argList.length) {
            this.arg[i] = argList[i];
            ++i;
        }
    }

    public Struct() {
        this(".", 2);
        this.arg[0] = this.arg[1] = NullTerm.NULL_TERM;
        this.resolved = true;
    }

    public Struct(Term h, Term t) {
        this(".", 2);
        this.arg[0] = h;
        this.arg[1] = t;
    }

    public Struct(Term[] argList) {
        this(argList, 0);
    }

    private Struct(Term[] argList, int index) {
        this(".", 2);
        if (index < argList.length) {
            this.arg[0] = argList[index];
            this.arg[1] = new Struct(argList, index + 1);
        } else {
            this.arg[0] = this.arg[1] = NullTerm.NULL_TERM;
        }
    }

    Struct(String f, LinkedList al) {
        this.name = f;
        this.arity = al.length();
        if (this.arity > 0) {
            this.arg = new Term[this.arity];
            int c = 0;
            while (c < this.arity) {
                this.arg[c] = (Term)al.head;
                al = al.tail;
                ++c;
            }
        }
        this.hashKey = new StructKey(this.name, this.arity);
        this.resolved = false;
    }

    private Struct(int arity_) {
        this.arity = arity_;
        this.arg = new Term[this.arity];
    }

    private Struct(String name_, int arity_) {
        this.name = name_;
        this.arity = arity_;
        if (this.arity > 0) {
            this.arg = new Term[this.arity];
        }
        this.hashKey = new StructKey(this.name, this.arity);
        this.resolved = false;
    }

    StructKey getHashKey() {
        return this.hashKey;
    }

    public int getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public Term getArg(int index) {
        return this.arg[index];
    }

    public Term getTerm(int index) {
        return this.arg[index].getTerm();
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isStruct() {
        return true;
    }

    public boolean isVar() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isAtomic() {
        return this.arity == 0;
    }

    public boolean isCompound() {
        return this.arity > 0;
    }

    public boolean isAtom() {
        return this.arity == 0 || this.isEmptyList();
    }

    public boolean isList() {
        return this.name.equals(".") && this.arity == 2;
    }

    public boolean isGround() {
        int i = 0;
        while (i < this.arity) {
            if (!this.arg[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isClause() {
        return this.name.equals(":-") && this.arity == 2 && this.arg[0].getTerm().isStruct();
    }

    public Term getTerm() {
        return this;
    }

    public Struct getArg(String name) {
        Struct s;
        if (this.arity == 0) {
            return null;
        }
        int i = 0;
        while (i < this.arg.length) {
            if (this.arg[i].isStruct() && (s = (Struct)this.arg[i]).getName().equals(name)) {
                return s;
            }
            ++i;
        }
        i = 0;
        while (i < this.arg.length) {
            Struct sol;
            if (this.arg[i].isStruct() && (sol = (s = (Struct)this.arg[i]).getArg(name)) != null) {
                return sol;
            }
            ++i;
        }
        return null;
    }

    public boolean isGreater(Term t) {
        if (!(t = t.getTerm()).isStruct()) {
            return true;
        }
        if (t.isStruct()) {
            Struct ts = (Struct)t;
            int tarity = ts.arity;
            if (this.arity > tarity) {
                return true;
            }
            if (this.arity == tarity) {
                if (this.name.compareTo(ts.name) > 0) {
                    return true;
                }
                if (this.name.compareTo(ts.name) == 0) {
                    int c = 0;
                    while (c < this.arity) {
                        if (this.arg[c].isGreater(ts.arg[c])) {
                            return true;
                        }
                        if (!this.arg[c].isEqual(ts.arg[c])) break;
                        ++c;
                    }
                }
            }
        }
        return false;
    }

    public boolean isEqual(Term t) {
        if ((t = t.getTerm()).isStruct()) {
            Struct ts = (Struct)t;
            if (this.arity == ts.arity && this.name.equals(ts.name)) {
                int c = 0;
                while (c < this.arity) {
                    if (!this.arg[c].isEqual(ts.arg[c])) {
                        return false;
                    }
                    ++c;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Term copy() {
        Struct t = new Struct(this.arity);
        t.resolved = this.resolved;
        t.name = this.name;
        t.hashKey = this.hashKey;
        int c = 0;
        while (c < this.arity) {
            t.arg[c] = this.arg[c].copy();
            ++c;
        }
        if (this.builtIn != null) {
            t.builtIn = this.builtIn.getCopy(t);
        }
        return t;
    }

    Term copy(LinkedList vl) {
        Struct t = new Struct(this.arity);
        t.resolved = this.resolved;
        t.name = this.name;
        t.hashKey = this.hashKey;
        int c = 0;
        while (c < this.arity) {
            t.arg[c] = this.arg[c].copy(vl);
            ++c;
        }
        if (this.builtIn != null) {
            t.builtIn = this.builtIn.getCopy(t);
        }
        return t;
    }

    void restoreVariables() {
        int c = 0;
        while (c < this.arity) {
            Term t = this.arg[c];
            if (t.isStruct() || t.isVar()) {
                t.restoreVariables();
            }
            ++c;
        }
    }

    int renameVariables(int count) {
        if (!this.resolved) {
            LinkedList vars = new LinkedList();
            return this.resolveVariables(vars, count);
        }
        return this.renameVariables(++renameStage, count);
    }

    int renameVariables(int stage, int count) {
        int newcount = count;
        int c = 0;
        while (c < this.arity) {
            Term t = this.arg[c];
            if (t.isStruct()) {
                newcount = ((Struct)t).renameVariables(stage, newcount);
            } else if (t.isVar()) {
                newcount = ((Var)t).renameVariables(stage, newcount);
            }
            ++c;
        }
        return newcount;
    }

    int resolveVariables(int count) {
        if (this.resolved) {
            return count;
        }
        LinkedList vars = new LinkedList();
        return this.resolveVariables(vars, count);
    }

    private int resolveVariables(LinkedList vars, int count) {
        int newcount = count;
        int c = 0;
        while (c < this.arity) {
            Term term = this.arg[c];
            if (term != null) {
                if ((term = term.getTerm()).isVar()) {
                    Var t = (Var)term;
                    if (t.isAnonymous()) {
                        t.setTime(newcount++);
                    } else {
                        String name = t.getName();
                        LinkedList vl = vars;
                        Var found = null;
                        while (!vl.isEmptyList()) {
                            Var vn = (Var)vl.head;
                            if (name.equals(vn.getName())) {
                                found = vn;
                                break;
                            }
                            vl = vl.tail;
                        }
                        if (found != null) {
                            this.arg[c] = found;
                        } else {
                            t.setTime(newcount++);
                            vars.append(t);
                        }
                    }
                } else if (term.isStruct()) {
                    newcount = ((Struct)term).resolveVariables(vars, newcount);
                }
            }
            ++c;
        }
        this.resolved = true;
        return newcount;
    }

    public boolean isEmptyList() {
        return this.name.equals(".") && this.arity == 2 && this.arg[0].getTerm().isNull();
    }

    public Term listHead() {
        return this.arg[0].getTerm();
    }

    public Struct listTail() {
        return (Struct)this.arg[1].getTerm();
    }

    public int listSize() {
        Struct t = this;
        int count = 0;
        while (!t.arg[0].isNull()) {
            ++count;
            t = (Struct)t.arg[1].getTerm();
        }
        return count;
    }

    public Iterator listIterator() {
        return new StructIterator(this);
    }

    Struct toList() {
        Struct t = new Struct();
        int c = this.arity - 1;
        while (c >= 0) {
            t = new Struct(this.arg[c].getTerm(), (Term)t);
            --c;
        }
        return new Struct(new Struct(this.name), (Term)t);
    }

    Struct fromList() {
        Term ft = this.arg[0].getTerm();
        if (!ft.isAtom()) {
            return null;
        }
        Struct at = (Struct)this.arg[1].getTerm();
        LinkedList al = new LinkedList();
        while (!at.isEmptyList()) {
            if (!at.isList()) {
                return null;
            }
            al.append(at.getTerm(0));
            at = (Struct)at.getTerm(1);
        }
        return new Struct(((Struct)ft).name, al);
    }

    boolean isEmptyListRaw() {
        return this.arg[0].getTerm().isNull();
    }

    void append(Term t) {
        if (this.isEmptyListRaw()) {
            this.arg[0] = t;
            this.arg[1] = new Struct();
        } else if (this.arg[1].isList()) {
            ((Struct)this.arg[1]).append(t);
        } else {
            this.arg[1] = t;
        }
    }

    void insert(Term t) {
        Struct co = new Struct();
        co.arg[0] = this.arg[0];
        co.arg[1] = this.arg[1];
        this.arg[0] = t;
        this.arg[1] = co;
    }

    boolean unify(Term t, int m) {
        if ((t = t.getTerm()).isStruct()) {
            Struct ts = (Struct)t;
            if (this.arity == ts.arity && this.name.equals(ts.name)) {
                int c = 0;
                while (c < this.arity) {
                    if (!this.arg[c].unify(ts.arg[c], m)) {
                        return false;
                    }
                    ++c;
                }
                return true;
            }
        } else if (t.isVar()) {
            return t.unify(this, m);
        }
        return false;
    }

    void free(int m) {
        int c = 0;
        while (c < this.arity) {
            this.arg[c].free(m);
            ++c;
        }
    }

    void setBuiltIn(BuiltIn b) {
        this.builtIn = b;
    }

    BuiltIn getBuiltIn() {
        return this.builtIn;
    }

    boolean isBuiltIn() {
        return this.builtIn != null;
    }

    public String toString() {
        String s;
        if (this.name.equals(".") && this.arity == 2) {
            if (this.arg[0].isNull()) {
                return "[]";
            }
            return "[" + this.toString0() + "]";
        }
        if (this.name.equals("{}")) {
            return "{" + this.toString0_bracket() + "}";
        }
        String string = s = Tokenizer.isAtom(this.name) ? this.name : "'" + this.name + "'";
        if (this.arity > 0) {
            s = String.valueOf(s) + "(";
            int c = 1;
            while (c < this.arity) {
                s = !this.arg[c - 1].isVar() ? String.valueOf(s) + this.arg[c - 1].toString() + "," : String.valueOf(s) + ((Var)this.arg[c - 1]).toStringFlattened() + ",";
                ++c;
            }
            s = !this.arg[this.arity - 1].isVar() ? String.valueOf(s) + this.arg[this.arity - 1].toString() + ")" : String.valueOf(s) + ((Var)this.arg[this.arity - 1]).toStringFlattened() + ")";
        }
        return s;
    }

    private String toString0() {
        Term h = this.arg[0].getTerm();
        Term t = this.arg[1].getTerm();
        if (t.isList()) {
            Struct tl = (Struct)t;
            if (tl.isEmptyList()) {
                return h.toString();
            }
            if (!h.isVar()) {
                return String.valueOf(h.toString()) + "," + tl.toString0();
            }
            return String.valueOf(((Var)h).toStringFlattened()) + "," + tl.toString0();
        }
        String h0 = h.isVar() ? ((Var)h).toStringFlattened() : h.toString();
        String t0 = t.isVar() ? ((Var)t).toStringFlattened() : t.toString();
        return String.valueOf(h0) + "|" + t0;
    }

    private String toString0_bracket() {
        if (this.arity == 0) {
            return "";
        }
        if (!(this.arity != 1 || this.arg[0].isStruct() && ((Struct)this.arg[0]).getName().equals(","))) {
            return this.arg[0].getTerm().toString();
        }
        Term head = ((Struct)this.arg[0]).getTerm(0);
        Term tail = ((Struct)this.arg[0]).getTerm(1);
        StringBuffer buf = new StringBuffer(head.toString());
        while (tail.isStruct() && ((Struct)tail).getName().equals(",")) {
            head = ((Struct)tail).getTerm(0);
            buf.append("," + head.toString());
            tail = ((Struct)tail).getTerm(1);
        }
        buf.append("," + tail.toString());
        return buf.toString();
    }

    private String toStringAsList(OperatorManager op) {
        Term h = this.arg[0];
        Term t = this.arg[1].getTerm();
        if (t.isList()) {
            Struct tl = (Struct)t;
            if (tl.isEmptyList()) {
                return h.toStringAsArgY(op, 0);
            }
            return String.valueOf(h.toStringAsArgY(op, 0)) + "," + tl.toStringAsList(op);
        }
        return String.valueOf(h.toStringAsArgY(op, 0)) + "|" + t.toStringAsArgY(op, 0);
    }

    String toStringAsArg(OperatorManager op, int prio, boolean x) {
        int p = 0;
        String v = "";
        if (this.name.equals(".") && this.arity == 2) {
            if (this.arg[0].isNull()) {
                return "[]";
            }
            return "[" + this.toStringAsList(op) + "]";
        }
        if (this.name.equals("{}")) {
            return "{" + this.toString0_bracket() + "}";
        }
        if (this.arity == 2) {
            p = op.opPrio(this.name, "xfx");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgX(op, p) + " " + this.name + " " + this.arg[1].toStringAsArgX(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
            }
            p = op.opPrio(this.name, "yfx");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgY(op, p) + " " + this.name + " " + this.arg[1].toStringAsArgX(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
            }
            p = op.opPrio(this.name, "xfy");
            if (p >= 1) {
                if (!this.name.equals(",")) {
                    return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgX(op, p) + " " + this.name + " " + this.arg[1].toStringAsArgY(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
                }
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgX(op, p) + "," + this.arg[1].toStringAsArgY(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
            }
        } else if (this.arity == 1) {
            p = op.opPrio(this.name, "fx");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.name + " " + this.arg[0].toStringAsArgX(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
            }
            p = op.opPrio(this.name, "fy");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.name + " " + this.arg[0].toStringAsArgY(op, p) + (x && p >= prio || !x && p > prio ? ")" : "");
            }
            p = op.opPrio(this.name, "xf");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgX(op, p) + " " + this.name + " " + (x && p >= prio || !x && p > prio ? ")" : "");
            }
            p = op.opPrio(this.name, "yf");
            if (p >= 1) {
                return String.valueOf(x && p >= prio || !x && p > prio ? "(" : "") + this.arg[0].toStringAsArgY(op, p) + " " + this.name + " " + (x && p >= prio || !x && p > prio ? ")" : "");
            }
        }
        String string = v = Tokenizer.isAtom(this.name) ? this.name : "'" + this.name + "'";
        if (this.arity == 0) {
            return v;
        }
        v = String.valueOf(v) + "(";
        p = 1;
        while (p < this.arity) {
            v = String.valueOf(v) + this.arg[p - 1].toStringAsArgY(op, 0) + ",";
            ++p;
        }
        v = String.valueOf(v) + this.arg[this.arity - 1].toStringAsArgY(op, 0);
        v = String.valueOf(v) + ")";
        return v;
    }
}

