/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTermException;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Parser;
import alice.tuprolog.Struct;
import alice.tuprolog.TermIterator;
import alice.tuprolog.Var;
import alice.util.LinkedList;
import java.io.Serializable;
import java.util.Iterator;

public abstract class Term
implements Serializable {
    public static final Term TRUE = new Struct("true");
    public static final Term FALSE = new Struct("false");

    public abstract boolean isNumber();

    public abstract boolean isStruct();

    public abstract boolean isVar();

    public abstract boolean isNull();

    public abstract boolean isAtomic();

    public abstract boolean isCompound();

    public abstract boolean isAtom();

    public abstract boolean isList();

    public abstract boolean isGround();

    public boolean equals(Object t) {
        return this.isEqual((Term)t);
    }

    public abstract boolean isGreater(Term var1);

    public abstract boolean isEqual(Term var1);

    public abstract Term copy();

    public Term getRenamedCopy() {
        LinkedList l = new LinkedList();
        Term newterm = this.copy(l);
        Var.rename(l, 0, true);
        return newterm;
    }

    public abstract Term getTerm();

    abstract void free(int var1);

    abstract int renameVariables(int var1);

    abstract int resolveVariables(int var1);

    public void resolveVariables() {
        this.resolveVariables(0);
    }

    abstract void restoreVariables();

    abstract Term copy(LinkedList var1);

    public boolean match(Term t) {
        int c0 = this.renameVariables(0);
        t.renameVariables(c0);
        boolean ok = this.unify(t, 0);
        this.restoreVariables();
        t.restoreVariables();
        return ok;
    }

    public boolean unify(Term t) {
        int count = this.renameVariables(0);
        t.renameVariables(count);
        boolean ok = this.unify(t, 0);
        if (!ok) {
            this.restoreVariables();
            t.restoreVariables();
        }
        return ok;
    }

    abstract boolean unify(Term var1, int var2);

    public static Term parse(String st) throws InvalidTermException {
        return Parser.toTerm(st);
    }

    public static Term parse(String st, OperatorManager op) throws InvalidTermException {
        return Parser.toTerm(st, op);
    }

    static Term parseSentence(String st, OperatorManager op) throws InvalidTermException {
        try {
            Parser p = new Parser(op, st);
            if (p.readTerm(true) == 0) {
                return p.getCurrentTerm();
            }
            throw new InvalidTermException();
        }
        catch (Exception ex) {
            throw new InvalidTermException();
        }
    }

    public static Iterator getIterator(String text) {
        return new TermIterator(text);
    }

    String toStringAsArgX(OperatorManager op, int prio) {
        return this.toStringAsArg(op, prio, true);
    }

    String toStringAsArgY(OperatorManager op, int prio) {
        return this.toStringAsArg(op, prio, false);
    }

    String toStringAsArg(OperatorManager op, int prio, boolean x) {
        return this.toString();
    }
}

