/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Struct;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class Theory
implements Serializable {
    private String theory;
    private Struct clauseList;

    public Theory(InputStream is) throws IOException, InvalidTheoryException {
        byte[] info = new byte[is.available()];
        is.read(info);
        this.theory = new String(info);
    }

    public Theory(String theory) throws InvalidTheoryException {
        if (theory == null) {
            throw new InvalidTheoryException();
        }
        this.theory = theory;
    }

    public Theory(Struct clauseList) throws InvalidTheoryException {
        if (clauseList == null || !clauseList.isList()) {
            throw new InvalidTheoryException();
        }
        this.clauseList = clauseList;
    }

    public void append(Theory th) throws InvalidTheoryException {
        if (th.isTextual() && this.isTextual()) {
            this.theory = String.valueOf(this.theory) + th.theory;
        } else if (!th.isTextual() && !this.isTextual()) {
            this.clauseList.append(th.getClauseListRepresentation());
        } else {
            throw new InvalidTheoryException();
        }
    }

    boolean isTextual() {
        return this.theory != null;
    }

    Struct getClauseListRepresentation() {
        return this.clauseList;
    }

    public String toString() {
        if (this.theory != null) {
            return this.theory;
        }
        return this.clauseList.toString();
    }
}

