/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.ClauseInfo;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.Number;
import alice.tuprolog.Parser;
import alice.tuprolog.Prolog;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import alice.util.LinkedList;
import alice.util.LinkedQueue;
import alice.util.Tools;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class TheoryManager
implements Serializable {
    private LinkedList transientClauseList = new LinkedList();
    private boolean updateTransientClauseList = false;
    protected HashMap clauseDBase = new HashMap();
    protected int clauseNumber = 0;
    protected Prolog engine;
    private Struct startGoal;

    public TheoryManager(Prolog vm) {
        this.engine = vm;
    }

    private LinkedQueue getQueue(Object k) {
        LinkedQueue q = (LinkedQueue)this.clauseDBase.get(k);
        if (q == null) {
            q = new LinkedQueue();
            this.clauseDBase.put(k, q);
        }
        return q;
    }

    private void checkExistance(Struct clause, String libName, LinkedList list) {
        Struct head = (Struct)clause.getArg(0);
        Library lib = this.engine.getLibraryPredicate(head.getName(), head.getArity());
        if (lib != null) {
            if (libName != null) {
                this.engine.warn("a builtin predicate with signature equals to the head of clause " + clause + " in library " + libName + "  has been defined in library " + lib.getClass().getName());
            } else {
                this.engine.warn("a builtin predicate with signature equals to the head of clause " + clause + " has been defined in library " + lib.getClass().getName());
            }
        } else {
            String libn;
            lib = this.engine.getLibraryFunctor(head.getName(), head.getArity());
            if (lib != null) {
                if (libName != null) {
                    this.engine.warn("a builtin functor with signature equals to the head of clause " + clause + " in library " + libName + "  has been defined in library " + lib.getClass().getName());
                } else {
                    this.engine.warn("a builtin functor with signature equals to the head of clause " + clause + " has been defined in library " + lib.getClass().getName());
                }
            } else if (list.head != null && (libn = ((ClauseInfo)list.head).libName) != null && !libn.equals(libName)) {
                if (libName != null) {
                    this.engine.warn("a clause with the same head of " + clause + " in library " + libName + "  has been defined in library " + ((ClauseInfo)list.head).libName + " as " + ((ClauseInfo)list.head).clause);
                } else {
                    this.engine.warn("a clause with the same head of " + clause + "  has been defined in library " + ((ClauseInfo)list.head).libName + " as " + ((ClauseInfo)list.head).clause);
                }
            }
        }
    }

    public void assertA(Struct clause, boolean dyn, String libName) {
        ClauseInfo d = new ClauseInfo(clause, this.engine, dyn, libName);
        LinkedQueue q = this.getQueue(((Struct)d.clause.getArg(0)).getHashKey());
        if (this.engine.isWarning()) {
            this.checkExistance(d.clause, libName, q.head);
        }
        q.insFirst(d);
        this.transOp(d, true, true);
    }

    public void assertZ(Struct clause, boolean dyn, String libName) {
        ClauseInfo d = new ClauseInfo(clause, this.engine, dyn, libName);
        LinkedQueue q = this.getQueue(((Struct)d.clause.getArg(0)).getHashKey());
        this.checkExistance(d.clause, libName, q.head);
        q.insLast(d);
        this.transOp(d, true, false);
    }

    public ClauseInfo retract(Struct cl, int t, int m) {
        Struct clause = new ClauseInfo((Struct)cl, (Prolog)this.engine, (boolean)true, null).clause;
        ClauseInfo r = null;
        LinkedQueue q = this.getQueue(((Struct)clause.getArg(0)).getHashKey());
        LinkedList l = q.head;
        while (!l.isEmptyList()) {
            ClauseInfo d = (ClauseInfo)l.head;
            l = l.tail;
            if (!d.stillValid) continue;
            boolean f = clause.unify(d.clause, m);
            clause.free(m);
            d.clause.free(m);
            if (!f) continue;
            r = d;
            break;
        }
        if (r == null) {
            return null;
        }
        this.transOp(r, false, false);
        return new ClauseInfo(r.clause, t, true, null);
    }

    public LinkedList find(Term headt, int t, int m) {
        LinkedQueue r;
        block4: {
            block3: {
                r = new LinkedQueue();
                if (!headt.isStruct()) break block3;
                Struct head = (Struct)headt;
                LinkedQueue q = this.getQueue(head.getHashKey());
                LinkedList l = q.head;
                while (!l.isEmptyList()) {
                    ClauseInfo d = (ClauseInfo)l.head;
                    l = l.tail;
                    if (!d.stillValid) continue;
                    boolean f = head.unify(d.clause.getArg(0), m);
                    head.free(m);
                    d.clause.free(m);
                    if (!f) continue;
                    r.insLast(new ClauseInfo(d.clause, t, d.dynamic, null));
                }
                break block4;
            }
            if (!headt.isVar()) break block4;
            Iterator it = this.clauseDBase.values().iterator();
            while (it.hasNext()) {
                LinkedList l = ((LinkedQueue)it.next()).head;
                while (!l.isEmptyList()) {
                    ClauseInfo d = (ClauseInfo)l.head;
                    l = l.tail;
                    if (!d.stillValid || !d.dynamic) continue;
                    r.insLast(new ClauseInfo(d.clause, t, d.dynamic, null));
                }
            }
        }
        return r.head;
    }

    public void rebindBuiltins() {
        Iterator it = this.clauseDBase.values().iterator();
        while (it.hasNext()) {
            LinkedQueue q = (LinkedQueue)it.next();
            LinkedList l = q.head;
            while (!l.isEmptyList()) {
                ClauseInfo d = (ClauseInfo)l.head;
                l = l.tail;
                if (!d.stillValid || !d.dynamic) continue;
                Term body = d.clause.getArg(1);
                while (body.isStruct() && ((Struct)body).getName().equals(",")) {
                    Term t = ((Struct)body).getArg(0);
                    this.engine.identify(t, false);
                    body = ((Struct)body).getArg(1);
                }
                this.engine.identify(body, false);
            }
        }
    }

    public LinkedList elements() {
        LinkedQueue r = new LinkedQueue();
        Iterator it = this.clauseDBase.values().iterator();
        while (it.hasNext()) {
            LinkedQueue q = (LinkedQueue)it.next();
            LinkedList l = q.head;
            while (!l.isEmptyList()) {
                ClauseInfo d = (ClauseInfo)l.head;
                l = l.tail;
                if (!d.stillValid) continue;
                r.insLast(new ClauseInfo(d.clause, this.engine, d.dynamic, null));
            }
        }
        return r.head;
    }

    public ArrayList getDynamicClauseList() {
        ArrayList<Struct> list = new ArrayList<Struct>();
        Iterator it = this.clauseDBase.values().iterator();
        while (it.hasNext()) {
            LinkedQueue q = (LinkedQueue)it.next();
            LinkedList l = q.head;
            while (!l.isEmptyList()) {
                ClauseInfo d = (ClauseInfo)l.head;
                l = l.tail;
                if (!d.stillValid || !d.dynamic) continue;
                list.add(d.clause);
            }
        }
        return list;
    }

    public void elements(LinkedList elements, boolean dynamicClauses, String libName) {
        this.clear(true);
        this.addElements(elements, dynamicClauses, libName);
    }

    public void addElements(LinkedList elements, boolean dynamicClauses, String libName) {
        while (!elements.isEmptyList()) {
            ClauseInfo d = (ClauseInfo)elements.head;
            elements = elements.tail;
            this.assertZ(d.clause, dynamicClauses, libName);
        }
    }

    public void clear(boolean onlyDynamic) {
        if (!onlyDynamic) {
            this.clauseDBase = new HashMap();
            this.clauseNumber = 0;
        } else {
            Iterator it = this.clauseDBase.values().iterator();
            while (it.hasNext()) {
                LinkedQueue q = (LinkedQueue)it.next();
                LinkedList l = q.head;
                while (!l.isEmptyList()) {
                    ClauseInfo d = (ClauseInfo)l.head;
                    l = l.tail;
                    if (!d.stillValid || !d.dynamic) continue;
                    d.stillValid = false;
                    --this.clauseNumber;
                }
            }
            this.optimize();
        }
    }

    public void removeLibraryTheory(String libName) {
        Iterator it = this.clauseDBase.values().iterator();
        while (it.hasNext()) {
            LinkedQueue q = (LinkedQueue)it.next();
            LinkedList l = q.head;
            while (!l.isEmptyList()) {
                ClauseInfo d = (ClauseInfo)l.head;
                l = l.tail;
                if (!d.stillValid || d.libName == null || !libName.equals(d.libName)) continue;
                d.stillValid = false;
                --this.clauseNumber;
            }
        }
        this.optimize();
    }

    public void transBegin() {
        this.transientClauseList = new LinkedList();
        this.updateTransientClauseList = true;
    }

    public void transOp(ClauseInfo d, boolean f, boolean p) {
        if (f) {
            ++this.clauseNumber;
            this.engine.spy("INSERT" + (p ? "A" : "Z") + ": " + d.clause + "\n");
        } else {
            --this.clauseNumber;
            this.engine.spy("DELETE: " + d.clause + "\n");
        }
        d.stillValid = f;
        if (this.updateTransientClauseList) {
            this.transientClauseList = new LinkedList(d, this.transientClauseList);
        }
    }

    public LinkedList transStatus() {
        return this.transientClauseList;
    }

    public void transRestore(LinkedList ol) {
        while (this.transientClauseList != ol) {
            ClauseInfo d = (ClauseInfo)this.transientClauseList.head;
            this.transientClauseList = this.transientClauseList.tail;
            if (d.stillValid) {
                --this.clauseNumber;
                this.engine.spy("RESTORE-: " + d.clause + "\n");
            } else {
                ++this.clauseNumber;
                this.engine.spy("RESTORE+: " + d.clause + "\n");
            }
            boolean bl = d.stillValid = !d.stillValid;
        }
    }

    public boolean transEnd(boolean f) {
        if (!f) {
            while (!this.transientClauseList.isEmptyList()) {
                ClauseInfo d = (ClauseInfo)this.transientClauseList.head;
                this.transientClauseList = this.transientClauseList.tail;
                if (d.stillValid) {
                    --this.clauseNumber;
                    this.engine.spy("RESTORE-: " + d.clause + "\n");
                } else {
                    ++this.clauseNumber;
                    this.engine.spy("RESTORE+: " + d.clause + "\n");
                }
                boolean bl = d.stillValid = !d.stillValid;
            }
        }
        this.updateTransientClauseList = false;
        return !this.transientClauseList.isEmptyList();
    }

    public void optimize() {
        int n = 0;
        Iterator it = this.clauseDBase.values().iterator();
        while (it.hasNext()) {
            LinkedQueue q = (LinkedQueue)it.next();
            int b = q.length();
            while (b-- > 0) {
                ClauseInfo d = (ClauseInfo)q.remFirst();
                if (d.stillValid) {
                    q.insLast(d);
                    continue;
                }
                ++n;
            }
        }
        if (n > 0) {
            this.engine.spy("OPTIMIZE: " + n + "\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void consult(Theory theory, boolean m, boolean dynamicTheory, String libName) throws InvalidTheoryException {
        if (theory == null) {
            throw new InvalidTheoryException();
        }
        this.transBegin();
        this.startGoal = null;
        LinkedQueue q = new LinkedQueue();
        Object lastTerm = null;
        boolean r = true;
        if (theory.isTextual()) {
            Parser p = new Parser(this.engine.getOperatorManager(), theory.toString());
            int nc = 0;
            while (p.readTerm(true) != 1) {
                if (p.getCurrentTerm() != null && p.getCurrentTermType() == 0 && p.getCurrentTerm().isStruct()) {
                    boolean result = this.parseClause((Struct)p.getCurrentTerm(), q, dynamicTheory, libName);
                    if (!result) {
                        r = false;
                        break;
                    }
                    this.engine.spy("READ #" + ++nc + ": " + p.getCurrentTerm());
                    continue;
                }
                r = false;
                break;
            }
            if (r) {
                if (m) {
                    this.elements(q.head, dynamicTheory, libName);
                } else {
                    this.addElements(q.head, dynamicTheory, libName);
                }
                this.transEnd(true);
                return;
            }
            this.transEnd(false);
            throw new InvalidTheoryException(p.getCurrentLine(), p.getCurrentPos());
        }
        try {
            Struct list = theory.getClauseListRepresentation();
            while (!list.isEmptyList()) {
                boolean result = this.parseClause((Struct)list.listHead(), q, dynamicTheory, libName);
                if (!result) {
                    this.transEnd(false);
                    throw new InvalidTheoryException();
                }
                list = list.listTail();
            }
            if (m) {
                this.elements(q.head, dynamicTheory, libName);
            } else {
                this.addElements(q.head, dynamicTheory, libName);
            }
            this.transEnd(true);
            return;
        }
        catch (Exception ex) {
            this.transEnd(false);
            throw new InvalidTheoryException();
        }
    }

    private boolean parseClause(Struct co, LinkedQueue clauses, boolean dynamicTheory, String libName) {
        try {
            ClauseInfo info = new ClauseInfo(co, this.engine, dynamicTheory, libName);
            String name = co.getName();
            if ((name.equals("':-'") || name.equals(":-")) && co.getArity() == 1 && co.getTerm(0).isStruct()) {
                Struct dir = (Struct)co.getTerm(0);
                if (dir.getName().equals("op") && dir.getArity() == 3) {
                    String st;
                    Term t0 = dir.getTerm(0);
                    Term t1 = dir.getTerm(1);
                    Term t2 = dir.getTerm(2);
                    if (t0.isNumber() && t2.isAtom() && t1.isAtom() && (st = ((Struct)t1).getName()).equals("fx") | st.equals("fy") | st.equals("xf") | st.equals("yf") | st.equals("xfx") | st.equals("yfx") | st.equals("xfy")) {
                        this.engine.getOperatorManager().opNew(((Struct)dir.getArg(2)).getName(), ((Struct)dir.getArg(1)).getName(), ((Number)t0).intValue());
                    }
                } else if (dir.getName().equals("flag") && dir.getArity() == 4) {
                    Term flagName = dir.getTerm(0);
                    Term flagSet = dir.getTerm(1);
                    Term flagDefault = dir.getTerm(2);
                    Term flagModifiable = dir.getTerm(3);
                    if (flagSet.isList() && (flagModifiable.equals(Term.TRUE) || flagModifiable.equals(Term.FALSE))) {
                        this.engine.defineFlag(flagName.toString(), (Struct)flagSet, flagDefault, flagModifiable.equals(Term.TRUE), libName);
                    }
                } else if ((dir.getName().equals("solve") || dir.getName().equals("initialization")) && dir.getArity() == 1) {
                    if (dir.getTerm(0).isStruct()) {
                        this.startGoal = (Struct)dir.getTerm(0);
                    }
                } else if (dir.getName().equals("load_library") && dir.getArity() == 1) {
                    try {
                        this.engine.loadLibrary(Tools.removeApices(dir.getTerm(0).toString()));
                    }
                    catch (Exception ex) {
                        return false;
                    }
                } else if (dir.getName().equals("consult") && dir.getArity() == 1) {
                    try {
                        this.engine.addTheory(new Theory(new FileInputStream(Tools.removeApices(dir.getTerm(0).toString()))));
                    }
                    catch (Exception ex) {
                        return false;
                    }
                } else {
                    clauses.insLast(info);
                }
            } else {
                clauses.insLast(info);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Struct getStartGoal() {
        return this.startGoal;
    }

    public synchronized boolean save(OutputStream os, boolean onlyDynamic) {
        this.optimize();
        boolean r = true;
        DataOutputStream ds = new DataOutputStream(os);
        LinkedList l = this.elements();
        while (!l.isEmptyList()) {
            ClauseInfo d = (ClauseInfo)l.head;
            l = l.tail;
            if (!d.stillValid || onlyDynamic && !d.dynamic) continue;
            try {
                ds.writeBytes(d.toString(this.engine.getOperatorManager()));
            }
            catch (Exception e) {
                r = false;
                break;
            }
        }
        return r;
    }
}

