/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.Token;
import alice.util.LinkedList;
import alice.util.StringInputStream;
import java.io.Serializable;

class Tokenizer
implements Serializable {
    public static final int TYPEMASK = 255;
    public static final int ATTRMASK = 65280;
    public static final int LPAR = 1;
    public static final int RPAR = 2;
    public static final int LBRA = 3;
    public static final int RBRA = 4;
    public static final int BAR = 5;
    public static final int INTEGER = 6;
    public static final int FLOAT = 7;
    public static final int ATOM = 8;
    public static final int VARIABLE = 9;
    public static final int SQ_SEQUENCE = 10;
    public static final int DQ_SEQUENCE = 11;
    public static final int COMMA = 12;
    public static final int END = 13;
    public static final int LBRA2 = 14;
    public static final int RBRA2 = 15;
    public static final int FUNCTOR = 256;
    public static final int OPERATOR = 512;
    public static final int EOF = 4096;
    public static final int ERROR = 8192;
    public static final String SYMCHAR = "\\\u00a3$&?^@#.,:;=<>+-*/";
    private StringInputStream inputStream;
    private LinkedList charList;
    private LinkedList tokenList;
    private int type;
    private String seq;
    int lastTokenType;

    public Tokenizer(StringInputStream is) {
        this.inputStream = is;
        this.charList = new LinkedList();
        this.tokenList = new LinkedList();
    }

    public Token readToken() {
        if (this.tokenList.isEmptyList()) {
            this.nextToken();
            this.lastTokenType = this.type;
            return new Token(this.seq, this.type);
        }
        Token token = (Token)this.tokenList.head;
        this.tokenList = this.tokenList.tail;
        this.lastTokenType = token.getType();
        return token;
    }

    public void unreadToken(Token token) {
        this.tokenList = new LinkedList(token, this.tokenList);
    }

    public int getCurrentPos() {
        return this.inputStream.getCurrentPos();
    }

    public int getCurrentLine() {
        return this.inputStream.getCurrentLine();
    }

    public void reset() throws Exception {
        this.charList = new LinkedList();
        this.tokenList = new LinkedList();
        this.inputStream.reset();
    }

    public static boolean isAtom(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Tokenizer.isLLt(s.charAt(0))) {
            return false;
        }
        int c = 1;
        while (c < s.length()) {
            if (!Tokenizer.isLtr(s.charAt(c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private static boolean isTer(int c) {
        return c == -1 || c == 10 || c == 13;
    }

    private static boolean isWht(int c) {
        return c == 32 || c == 9 || Tokenizer.isTer(c);
    }

    private static boolean isCmt(int c) {
        return c == 37;
    }

    private static boolean isDgt(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isLLt(int c) {
        return c == 33 || c >= 97 && c <= 122;
    }

    private static boolean isULt(int c) {
        return c == 95 || c >= 65 && c <= 90;
    }

    private static boolean isLtr(int c) {
        return Tokenizer.isLLt(c) || Tokenizer.isULt(c) || Tokenizer.isDgt(c);
    }

    private static boolean isExp(int c) {
        return c == 101 || c == 69;
    }

    private static boolean isSym(int c) {
        return SYMCHAR.indexOf(String.valueOf((char)c)) != -1;
    }

    private boolean isNum(int c) {
        if (Tokenizer.isDgt(c)) {
            this.seq = String.valueOf(this.seq) + String.valueOf((char)c);
            while (Tokenizer.isDgt(c = this.readChar())) {
                this.seq = String.valueOf(this.seq) + String.valueOf((char)c);
            }
            this.unreadChar(c);
            return true;
        }
        return false;
    }

    private int readChar() {
        if (this.charList.isEmptyList()) {
            try {
                int value = this.inputStream.read();
                return value;
            }
            catch (Exception e) {
                return -1;
            }
        }
        int ch = (Integer)this.charList.head;
        this.charList = this.charList.tail;
        return ch;
    }

    private void unreadChar(int ch) {
        this.charList = new LinkedList(new Integer(ch), this.charList);
    }

    private int skip() {
        int ch;
        block5: {
            int next_ch;
            ch = 0;
            while (true) {
                if (Tokenizer.isWht(ch = this.readChar())) {
                    if (ch != -1) continue;
                    return ch;
                }
                if (Tokenizer.isCmt(ch)) {
                    while (!Tokenizer.isTer(ch = this.readChar())) {
                    }
                    continue;
                }
                if (ch != 47) break block5;
                next_ch = this.readChar();
                if (next_ch != 42) break;
                while (((next_ch = this.readChar()) != 42 || (next_ch = this.readChar()) != 47) && next_ch != -1) {
                }
            }
            this.unreadChar(next_ch);
        }
        return ch;
    }

    /*
     * Unable to fully structure code
     */
    private int nextToken() {
        block68: {
            block67: {
                ch = this.skip();
                this.type = 8192;
                this.seq = "";
                if (ch == -1) {
                    this.type = 4096;
                    return 4096;
                }
                if (ch == 40) {
                    this.seq = "(";
                    this.type = 1;
                    return 1;
                }
                if (ch == 41) {
                    this.seq = ")";
                    this.type = 2;
                    return 2;
                }
                if (ch == 123) {
                    this.seq = "{";
                    this.type = 14;
                    return 14;
                }
                if (ch == 125) {
                    this.seq = "}";
                    this.type = 15;
                    return 15;
                }
                if (ch == 91) {
                    this.seq = "[";
                    this.type = 3;
                    return 3;
                }
                if (ch == 93) {
                    this.seq = "]";
                    this.type = 4;
                    return 4;
                }
                if (ch == 124) {
                    this.seq = "|";
                    this.type = 5;
                    return 5;
                }
                if (ch == 44) {
                    this.seq = ",";
                    this.type = 512;
                    return 512;
                }
                if (ch == 45) {
                    ch = this.readChar();
                    if (Tokenizer.isDgt(ch)) {
                        if (this.lastTokenType == 7 || this.lastTokenType == 6 || this.lastTokenType == 9 || Tokenizer.isSym(ch) || this.lastTokenType == 2 || this.lastTokenType == 4 || this.lastTokenType == 15) {
                            this.unreadChar(ch);
                            ch = 45;
                        } else {
                            this.seq = "-";
                        }
                    } else {
                        this.unreadChar(ch);
                        ch = 45;
                    }
                } else if (ch == 43) {
                    ch = this.readChar();
                    if (Tokenizer.isDgt(ch)) {
                        if (this.lastTokenType == 7 || this.lastTokenType == 6 || this.lastTokenType == 9 || Tokenizer.isSym(ch) || this.lastTokenType == 2 || this.lastTokenType == 4 || this.lastTokenType == 15) {
                            this.unreadChar(ch);
                            ch = 43;
                        }
                    } else {
                        this.unreadChar(ch);
                        ch = 43;
                    }
                }
                if (this.isNum(ch)) {
                    ch = this.readChar();
                    if (ch != 46) {
                        this.unreadChar(ch);
                        this.type = 6;
                        return 6;
                    }
                    ch = this.readChar();
                    if (!Tokenizer.isDgt(ch)) {
                        this.unreadChar(ch);
                        this.unreadChar(46);
                        this.type = 6;
                        return 6;
                    }
                    this.seq = String.valueOf(this.seq) + ".";
                    this.isNum(ch);
                    ch = this.readChar();
                    if (!Tokenizer.isExp(ch)) {
                        this.unreadChar(ch);
                        this.type = 7;
                        return 7;
                    }
                    this.seq = String.valueOf(this.seq) + "E";
                    ch = this.readChar();
                    if (ch == 45) {
                        this.seq = String.valueOf(this.seq) + "-";
                        ch = this.readChar();
                    }
                    if (!this.isNum(ch)) {
                        this.type = 8192;
                        return 8192;
                    }
                    this.type = 7;
                    return 7;
                }
                if (ch != 39) break block67;
                ch = this.readChar();
                while (!Tokenizer.isTer(ch)) {
                    if (ch != 39) ** GOTO lbl100
                    ch = this.readChar();
                    if (ch == 39) {
                        this.seq = String.valueOf(this.seq) + "'";
                    } else {
                        this.unreadChar(ch);
                        break;
lbl100:
                        // 1 sources

                        if (ch == 92) {
                            ch = this.readChar();
                            if (ch == -1) {
                                this.unreadChar(-1);
                                break;
                            }
                            if (ch == 116) {
                                this.seq = String.valueOf(this.seq) + "\t";
                            } else if (ch == 114) {
                                this.seq = String.valueOf(this.seq) + "\r";
                            } else if (ch == 110) {
                                this.seq = String.valueOf(this.seq) + "\n";
                            } else if (!Tokenizer.isTer(ch)) {
                                this.seq = String.valueOf(this.seq) + "\\";
                                this.unreadChar(ch);
                            } else {
                                ch = this.skip();
                                this.unreadChar(ch);
                            }
                        } else {
                            this.seq = String.valueOf(this.seq) + String.valueOf((char)ch);
                        }
                    }
                    ch = this.readChar();
                }
                ch = this.readChar();
                this.unreadChar(ch);
                this.type = 10;
                if (ch == 40) {
                    this.type |= 256;
                }
                return this.type;
            }
            if (ch != 34) break block68;
            ch = this.readChar();
            while (!Tokenizer.isTer(ch)) {
                if (ch != 34) ** GOTO lbl141
                ch = this.readChar();
                if (ch == 34) {
                    this.seq = String.valueOf(this.seq) + "\"";
                } else {
                    this.unreadChar(ch);
                    break;
lbl141:
                    // 1 sources

                    if (ch == 92) {
                        ch = this.readChar();
                        if (ch == -1) {
                            this.unreadChar(-1);
                            break;
                        }
                        if (ch == 116) {
                            this.seq = String.valueOf(this.seq) + "\t";
                        } else if (ch == 114) {
                            this.seq = String.valueOf(this.seq) + "\r";
                        } else if (ch == 110) {
                            this.seq = String.valueOf(this.seq) + "\n";
                        } else if (!Tokenizer.isTer(ch)) {
                            this.seq = String.valueOf(this.seq) + "\\";
                            this.unreadChar(ch);
                        } else {
                            ch = this.skip();
                            this.unreadChar(ch);
                        }
                    } else {
                        this.seq = String.valueOf(this.seq) + String.valueOf((char)ch);
                    }
                }
                ch = this.readChar();
            }
            ch = this.readChar();
            this.unreadChar(ch);
            this.type = 10;
            if (ch == 40) {
                this.type |= 256;
            }
            return this.type;
        }
        if (Tokenizer.isLLt(ch)) {
            this.seq = String.valueOf((char)ch);
            while (Tokenizer.isLtr(ch = this.readChar())) {
                this.seq = String.valueOf(this.seq) + String.valueOf((char)ch);
            }
            this.unreadChar(ch);
            this.type = 8;
            if (ch == 40) {
                this.type |= 256;
            } else if (ch == 32) {
                this.type |= 512;
            }
            return this.type;
        }
        if (Tokenizer.isULt(ch)) {
            this.seq = String.valueOf((char)ch);
            while (Tokenizer.isLtr(ch = this.readChar())) {
                this.seq = String.valueOf(this.seq) + String.valueOf((char)ch);
            }
            this.unreadChar(ch);
            this.type = 9;
            return 9;
        }
        if (Tokenizer.isSym(ch)) {
            this.seq = String.valueOf((char)ch);
            while (Tokenizer.isSym(ch = this.readChar())) {
                this.seq = String.valueOf(this.seq) + String.valueOf((char)ch);
            }
            this.unreadChar(ch);
            if (this.seq.equals(".")) {
                while (Tokenizer.isWht(ch = this.readChar())) {
                    if (!Tokenizer.isTer(ch)) continue;
                    this.type = 13;
                    return 13;
                }
                this.unreadChar(ch);
                if (Tokenizer.isCmt(ch)) {
                    this.type = 13;
                    return 13;
                }
            }
            this.type = 512;
            return 512;
        }
        this.seq = String.valueOf((char)ch);
        return this.type;
    }
}

