/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.InvalidVarNameException;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.util.LinkedList;

public class Var
extends Term {
    static final String ANY = "_";
    private String name;
    private int time;
    private int timeBackup;
    private Term link;
    private Term linkBackup;
    private int mark;
    private int renameStage = -1;

    public Var(String n) throws InvalidVarNameException {
        this.time = -1;
        this.link = null;
        if (n.equals(ANY)) {
            this.name = null;
        } else if (Character.isUpperCase(n.charAt(0)) || n.startsWith(ANY)) {
            this.name = n;
        } else {
            throw new InvalidVarNameException();
        }
    }

    public Var() {
        this.name = null;
        this.time = -1;
        this.link = null;
    }

    Var(String n, int t) {
        this.name = n;
        this.time = t;
        this.link = null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return ANY;
    }

    public Term getTerm() {
        Term tt = this;
        Term t = this.link;
        while (t != null) {
            tt = t;
            if (!t.isVar()) break;
            t = ((Var)t).link;
        }
        return tt;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isStruct() {
        return false;
    }

    public boolean isVar() {
        return true;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isAtomic() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isGround() {
        Term t = this.getTerm();
        if (t == this) {
            return false;
        }
        return t.isGround();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public boolean isBound() {
        return this.link != null;
    }

    public boolean isResolved() {
        return this.time != -1;
    }

    void unlink() {
        this.link = null;
    }

    void setTime(int t) {
        this.time = t;
    }

    private Var findIn(LinkedList vl) {
        while (!vl.isEmptyList()) {
            if (this.time == ((Var)vl.head).time) {
                return (Var)vl.head;
            }
            vl = vl.tail;
        }
        return null;
    }

    private boolean findIn(Struct t) {
        int arity = t.getArity();
        int c = 0;
        while (c < arity) {
            Term at = t.getTerm(c);
            if (at.isStruct() ? this.findIn((Struct)at) : at.isVar() && this.time == ((Var)at).time) {
                return true;
            }
            ++c;
        }
        return false;
    }

    int resolveVariables(int count) {
        Term tt = this.getTerm();
        if (tt != this) {
            return tt.resolveVariables(count);
        }
        return count;
    }

    int renameVariables(int count) {
        Term tt = this.getTerm();
        if (tt == this) {
            this.timeBackup = this.time;
            this.time = count++;
            this.linkBackup = this.link;
            return count;
        }
        return tt.renameVariables(count);
    }

    int renameVariables(int currentStage, int count) {
        if (this.renameStage != currentStage) {
            this.timeBackup = this.time;
            this.time = count++;
            this.renameStage = currentStage;
            this.linkBackup = this.link;
        }
        return count;
    }

    void restoreVariables() {
        this.link = this.linkBackup;
    }

    static int rename(LinkedList vl, int c, boolean f) {
        while (!vl.isEmptyList()) {
            Var v = (Var)vl.head;
            v.time = c++;
            if (f && v.name != null) {
                v.name = ANY + v.time;
            }
            vl = vl.tail;
        }
        return c;
    }

    boolean unify(Term t, int m) {
        Term tt = this.getTerm();
        if (tt == this) {
            if ((t = t.getTerm()).isVar()) {
                if (this.time == ((Var)t).time) {
                    return true;
                }
            } else if (t.isStruct() ? this.findIn((Struct)t) : !t.isNumber()) {
                return false;
            }
            this.link = t;
            this.mark = m;
            return true;
        }
        return tt.unify(t, m);
    }

    void free(int m) {
        if (this.link != null) {
            this.link.free(m);
            if (this.mark >= m) {
                this.link = null;
            }
        }
    }

    public Term copy() {
        Term tt = this.getTerm();
        if (tt == this) {
            return new Var(this.name, this.time);
        }
        return tt.copy();
    }

    Term copy(LinkedList vl) {
        Term tt = this.getTerm();
        if (tt == this) {
            Var v = this.findIn(vl);
            if (v == null) {
                v = new Var(this.name, this.time);
                vl.insert(v);
            }
            return v;
        }
        return tt.copy(vl);
    }

    public boolean isGreater(Term t) {
        Term tt = this.getTerm();
        if (tt == this) {
            return (t = t.getTerm()).isVar() && this.time > ((Var)t).time;
        }
        return tt.isGreater(t);
    }

    public boolean isEqual(Term t) {
        Term tt = this.getTerm();
        if (tt == this) {
            return (t = t.getTerm()).isVar() && this.time == ((Var)t).time;
        }
        return tt.isEqual(t);
    }

    public String toString() {
        Term tt = this.getTerm();
        if (this.name != null) {
            if (tt == this) {
                return this.name;
            }
            return String.valueOf(this.name) + " / " + tt.toString();
        }
        return ANY;
    }

    public String toStringFlattened() {
        Term tt = this.getTerm();
        if (this.name != null) {
            if (tt == this) {
                return this.name;
            }
            return tt.toString();
        }
        if (tt == this) {
            return ANY;
        }
        return tt.toString();
    }
}

