/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.util.Tools;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;

public class IOLibrary
extends Library {
    protected String inputStreamName = "stdin";
    protected InputStream inputStream = System.in;
    protected String outputStreamName = "stdout";
    protected OutputStream outputStream = System.out;
    private Random gen = new Random();

    public IOLibrary() {
        this.gen.setSeed(System.currentTimeMillis());
    }

    public boolean see_1(Struct arg0) throws Exception {
        if (!arg0.isAtom()) {
            return false;
        }
        this.inputStream = arg0.getName().equals("stdin") ? System.in : new FileInputStream(arg0.getName());
        this.inputStreamName = arg0.getName();
        return true;
    }

    public boolean seen_0() throws Exception {
        this.inputStream.close();
        return true;
    }

    public boolean seeing_1(Term t) {
        return this.unify(t, new Struct(this.inputStreamName));
    }

    public boolean tell_1(Struct arg0) throws Exception {
        if (!arg0.isAtom()) {
            return false;
        }
        this.outputStream = arg0.getName().equals("stdout") ? System.out : new FileOutputStream(arg0.getName());
        this.outputStreamName = arg0.getName();
        return true;
    }

    public boolean told_0() throws Exception {
        this.outputStream.close();
        return true;
    }

    public boolean telling_1(Term arg0) {
        return this.unify(arg0, new Struct(this.outputStreamName));
    }

    public boolean put_1(Struct arg0) throws Exception {
        if (!arg0.isAtom()) {
            return false;
        }
        String ch = arg0.getName();
        if (ch.length() > 1) {
            return false;
        }
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput(ch);
        } else {
            this.outputStream.write((byte)ch.charAt(0));
        }
        return true;
    }

    public boolean get0_1(Term arg0) throws Exception {
        int ch = this.inputStream.read();
        if (ch == -1) {
            return this.unify(arg0, new Int(-1));
        }
        return this.unify(arg0, new Struct(new Character((char)ch).toString()));
    }

    public boolean get_1(Term arg0) throws Exception {
        int ch = 0;
        while ((ch = this.inputStream.read()) < 32 && ch >= 0) {
        }
        if (ch == -1) {
            return this.unify(arg0, new Int(-1));
        }
        return this.unify(arg0, new Struct(new Character((char)ch).toString()));
    }

    public boolean tab_1(Number arg) throws Exception {
        int n = arg.intValue();
        if (this.outputStreamName.equals("stdout")) {
            int i = 0;
            while (i < n) {
                this.getEngine().stdOutput("\t");
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                this.outputStream.write(32);
                ++i;
            }
        }
        return true;
    }

    public boolean read_1(Term arg0) throws Exception {
        try {
            int ch = 0;
            boolean open_apices = false;
            boolean just_open_apices = false;
            boolean open_apices2 = false;
            boolean just_open_apices2 = false;
            String st = "";
            while ((ch = this.inputStream.read()) != -1) {
                boolean can_add = true;
                if (ch == 39) {
                    open_apices = !open_apices;
                } else if (ch == 34) {
                    open_apices2 = !open_apices2;
                } else if (ch == 46 && !open_apices && !open_apices2) break;
                if (!can_add) continue;
                st = String.valueOf(st) + new Character((char)ch).toString();
            }
            return this.unify(arg0, this.getEngine().toTerm(st));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean write_1(Term arg0) throws Exception {
        try {
            if (this.outputStreamName.equals("stdout")) {
                this.getEngine().stdOutput(arg0.toString());
            } else {
                this.outputStream.write(arg0.toString().getBytes());
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean print_1(Term arg0) throws Exception {
        try {
            if (this.outputStreamName.equals("stdout")) {
                this.getEngine().stdOutput(Tools.removeApices(arg0.toString()));
            } else {
                this.outputStream.write(Tools.removeApices(arg0.toString()).getBytes());
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean nl_0() throws Exception {
        if (this.outputStreamName.equals("stdout")) {
            this.getEngine().stdOutput("\n");
        } else {
            this.outputStream.write(10);
        }
        return true;
    }

    public boolean text_from_file_2(Struct fileName, Term text) {
        try {
            Struct goal = new Struct(Tools.loadText(Tools.removeApices(fileName.toString())));
            return this.unify(text, goal);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean rand_float_1(Term t) {
        return this.unify(t, new Double(this.gen.nextFloat()));
    }

    public boolean rand_int_2(Number arg, Term num) {
        return this.unify(num, new Int(this.gen.nextInt(arg.intValue())));
    }

    public String getTheory() {
        return "consult(File) :- text_from_file(File,Text), add_theory(Text).\nreconsult(File) :- text_from_file(File,Text), set_theory(Text).\nsolve_file(File,Goal) :- text_from_file(File,Text),text_term(Text,Goal),call(Goal).\nagent_file(X)  :- text_from_file(X,Y),agent(Y).\n";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        InputStream inputStreamBak = this.inputStream;
        OutputStream outputStreamBak = this.outputStream;
        this.inputStream = null;
        this.outputStream = null;
        try {
            out.defaultWriteObject();
        }
        catch (IOException ex) {
            this.inputStream = inputStreamBak;
            this.outputStream = outputStreamBak;
            throw new IOException();
        }
        this.inputStream = inputStreamBak;
        this.outputStream = outputStreamBak;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.outputStreamName.equals("user")) {
            this.outputStream = System.out;
        }
        if (this.inputStreamName.equals("user")) {
            this.inputStream = System.in;
        }
    }
}

