/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;

public class ISOLibrary
extends Library {
    public boolean atom_length_2(Struct arg0, Term arg1) {
        if (!arg0.isAtom()) {
            return false;
        }
        return this.unify(arg1, new Int(arg0.getName().length()));
    }

    public boolean atom_chars_2(Term arg0, Term arg1) {
        if (arg0.isVar()) {
            if (!arg1.isList()) {
                return false;
            }
            Struct list = (Struct)arg1;
            if (list.isEmptyList()) {
                return this.unify(arg0, new Struct(""));
            }
            String st = "";
            while (!list.isEmptyList()) {
                String st1 = list.getTerm(0).toString();
                try {
                    if (st1.startsWith("'") && st1.endsWith("'")) {
                        st1 = st1.substring(1, st1.length() - 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                st = st.concat(st1);
                list = (Struct)list.getTerm(1);
            }
            return this.unify(arg0, new Struct(st));
        }
        if (!arg0.isAtom()) {
            return false;
        }
        String st = ((Struct)arg0).getName();
        Term[] tlist = new Term[st.length()];
        int i = 0;
        while (i < st.length()) {
            tlist[i] = new Struct(new String(new char[]{st.charAt(i)}));
            ++i;
        }
        Struct list = new Struct(tlist);
        return this.unify(arg1, list);
    }

    public boolean char_code_2(Term arg0, Term arg1) {
        if (arg1.isVar()) {
            if (!arg0.isAtom()) {
                return false;
            }
            String st = ((Struct)arg0).getName();
            if (st.length() > 1) {
                return false;
            }
            return this.unify(arg1, new Int(st.charAt(0)));
        }
        if (!arg1.isNumber() && ((Number)arg1).isInteger()) {
            return false;
        }
        String st = new String(new char[]{(char)((Number)arg1).intValue()});
        return this.unify(arg0, new Struct(st));
    }

    public Term sin_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.sin(((Number)val0).doubleValue()));
    }

    public Term cos_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.cos(((Number)val0).doubleValue()));
    }

    public Term exp_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.exp(((Number)val0).doubleValue()));
    }

    public Term atan_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.atan(((Number)val0).doubleValue()));
    }

    public Term log_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.log(((Number)val0).doubleValue()));
    }

    public Term sqrt_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.sqrt(((Number)val0).doubleValue()));
    }

    public Term abs_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        if (((Number)val0).isInteger()) {
            return new Int(Math.abs(((Number)val0).intValue()));
        }
        return new Double(Math.abs(((Number)val0).doubleValue()));
    }

    public Term sign_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        if (((Number)val0).isInteger()) {
            return new Double(((Number)val0).intValue() > 0 ? 1.0 : -1.0);
        }
        return new Double(((Number)val0).doubleValue() > 0.0 ? 1.0 : -1.0);
    }

    public Term float_integer_part_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double((long)Math.rint(((Number)val0).doubleValue()));
    }

    public Term float_fractional_part_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        double fl = ((Number)val0).doubleValue();
        return new Double(Math.abs(fl - Math.rint(fl)));
    }

    public Term floor_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.floor(((Number)val0).doubleValue()));
    }

    public Term round_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Long(Math.round(((Number)val0).doubleValue()));
    }

    public Term truncate_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.rint(((Number)val0).doubleValue()));
    }

    public Term ceiling_1(Term val) {
        Term val0 = this.evalExpression(val);
        if (!val0.isNumber()) {
            return null;
        }
        return new Double(Math.ceil(((Number)val0).doubleValue()));
    }

    public Term div_2(Term v0, Term v1) {
        Term val0 = this.evalExpression(v0);
        Term val1 = this.evalExpression(v1);
        if (!val0.isNumber()) {
            return null;
        }
        if (!val1.isNumber()) {
            return null;
        }
        return new Int(((Number)val0).intValue() / ((Number)val1).intValue());
    }

    public Term mod_2(Term v0, Term v1) {
        Term val0 = this.evalExpression(v0);
        Term val1 = this.evalExpression(v1);
        if (!val0.isNumber()) {
            return null;
        }
        if (!val1.isNumber()) {
            return null;
        }
        return new Int(((Number)val0).intValue() % ((Number)val1).intValue());
    }

    public Term rem_2(Term v0, Term v1) {
        Term val0 = this.evalExpression(v0);
        Term val1 = this.evalExpression(v1);
        if (!val0.isNumber()) {
            return null;
        }
        if (!val1.isNumber()) {
            return null;
        }
        return new Double(Math.IEEEremainder(((Number)val0).doubleValue(), ((Number)val1).doubleValue()));
    }

    public String getTheory() {
        return ":- op( 1200, xfx,  '-->'). \n:- op(  300, yfx,  'div'). \n:- op(  400, yfx,  'mod'). \n:- op(  400, yfx,  'rem'). \n:- op(  200, fx,   'sin'). \n:- op(  200, fx,   'cos'). \n:- op(  200, fx,   'sqrt'). \n:- op(  200, fx,   'atan'). \n:- op(  200, fx,   'exp'). \n:- op(  200, fx,   'log'). \n:- op(  200, xfx,   '\\'). \n:- flag(bounded, [true,false], true, false).\n:- flag(max_integer, [" + new Integer(Integer.MAX_VALUE).toString() + "], " + new Integer(Integer.MAX_VALUE).toString() + ",false).\n" + ":- flag(min_integer, [" + new Integer(Integer.MIN_VALUE).toString() + "], " + new Integer(Integer.MIN_VALUE).toString() + ",false).\n" + ":- flag(integer_rounding_function, [up,down], down, false).\n" + ":- flag(char_conversion,[on,off],off,false).\n" + ":- flag(debug,[on,off],off,false).\n" + ":- flag(max_arity, [" + new Integer(Integer.MAX_VALUE).toString() + "], " + new Integer(Integer.MAX_VALUE).toString() + ",false).\n" + ":- flag(undefined_predicate, [error,fail,warning], fail, false).\n" + ":- flag(double_quotes, [atom,chars,codes], atom, false).\n" + "bound(X):-ground(X).\n                                                                                  " + "unbound(X):-not(ground(X)).\n                                                                          " + "atom_concat(F,S,R) :- atom_chars(F,FL),atom_chars(S,SL),!,append(FL,SL,RS),atom_chars(R,RS).\n          " + "atom_concat(F,S,R) :- atom_chars(R,RS),append(FL,SL,RS),atom_chars(F,FL),atom_chars(S,SL).\n            " + "atom_codes(A,L):-atom_chars(A,L1),!,chars_codes(L1,L).\n" + "atom_codes(A,L):-chars_codes(L1,L),atom_chars(A,L1).\n" + "chars_codes([],[]).\n" + "chars_codes([X|L1],[Y|L2]):-char_code(X,Y),chars_codes(L1,L2).\n" + "sub_atom(Atom,B,L,A,Sub):-atom_chars(Atom,L1),atom_chars(Sub,L2),!,(L2,L1,B),length(L2,L), length(L1,Len), A is Len-(B+L).\n" + "sub_atom(Atom,B,L,A,Sub):-atom_chars(Atom,L1),sub_list(L2,L1,B),atom_chars(Sub,L2),length(L2,L), length(L1,Len), A is Len-(B+L).\n" + "sub_list([],_,0).\n" + "sub_list([X|L1],[X|L2],0):- sub_list_seq(L1,L2).\n" + "sub_list(L1,[_|L2],N):- sub_list(L1,L2,M), N is M + 1.\n" + "sub_list_seq([],L).\n" + "sub_list_seq([X|L1],[X|L2]):-sub_list_seq(L1,L2).\n" + "number_chars(Number,List):-num_atom(Number,Struct),atom_chars(Struct,List),!.\n" + "number_chars(Number,List):-atom_chars(Struct,List),num_atom(Number,Struct).\n" + "number_codes(Number,List):-num_atom(Number,Struct),atom_codes(Struct,List),!.\n" + "number_codes(Number,List):-atom_codes(Struct,List),num_atom(Number,Struct).\n" + "dcg_nonterminal(X) :- list(X),!,fail.  \n" + "dcg_nonterminal(_).                    \n" + "dcg_terminals(Xs) :- list(Xs).         \n" + "phrase(Category,String,Left) :- dcg_parse(Category,String\\Left).      \n" + "phrase(Category,[H|T]) :- dcg_parse(Category,[H|T]\\[]).      \n" + "dcg_parse(A,Tokens) :- dcg_nonterminal(A), (A --> B), dcg_parse(B,Tokens).            \n" + "dcg_parse((A,B),(Tokens \\ Xs)) :- dcg_parse(A,(Tokens \\ Tokens1)), dcg_parse(B,(Tokens1 \\ Xs)).    \n" + "dcg_parse(A,Tokens) :- dcg_terminals(A), dcg_connect(A,Tokens).    \n" + "dcg_parse({A},(Xs \\ Xs)) :- A. \n" + "dcg_connect([],(Xs \\ Xs)). \n" + "dcg_connect([W|Ws],([W|Xs] \\ Ys)) :- dcg_connect(Ws,(Xs \\ Ys)). \n";
    }
}

