/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog.lib;

import alice.tuprolog.Double;
import alice.tuprolog.Float;
import alice.tuprolog.Int;
import alice.tuprolog.Library;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.Var;
import alice.tuprolog.lib.ClassLoader;
import alice.tuprolog.lib.InvalidObjectIdException;
import alice.tuprolog.lib.Signature;
import alice.util.Tools;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class JavaLibrary
extends Library {
    private HashMap currentObjects = new HashMap();
    private HashMap currentObjects_inverse = new HashMap();
    private HashMap staticObjects = new HashMap();
    private HashMap staticObjects_inverse = new HashMap();
    private int id = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public String getTheory() {
        return ":- op(800,xfx,'<-').\n:- op(850,xfx,'returns').\n:- op(200,xfx,'as').\n:- op(600,xfx,'.'). \njava_object_bt(ClassName,Args,Id):- java_object(ClassName,Args,Id).\njava_object_bt(ClassName,Args,Id):- destroy_object(Id).\nObj <- What :- java_call(Obj,What,Res), Res \\== false.\nObj <- What returns Res :- java_call(Obj,What,Res).\njava_array_set(Array,Index,Object):-           class('java.lang.reflect.Array') <- set(Array as 'java.lang.Object',Index,Object as 'java.lang.Object'),!.\njava_array_set(Array,Index,Object):-\t\t\tjava_array_set_primitive(Array,Index,Object).\njava_array_get(Array,Index,Object):-           class('java.lang.reflect.Array') <- get(Array as 'java.lang.Object',Index) returns Object,!.\njava_array_get(Array,Index,Object):-       java_array_get_primitive(Array,Index,Object).\njava_array_length(Array,Length):-              class('java.lang.reflect.Array') <- getLength(Array as 'java.lang.Object') returns Length.\njava_object_string(Object,String):-    Object <- toString returns String.    \n";
    }

    public void dismiss() {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
    }

    public void dismissAll() {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
        this.staticObjects.clear();
        this.staticObjects_inverse.clear();
    }

    public void onSolveBegin(Term goal) {
        this.currentObjects.clear();
        this.currentObjects_inverse.clear();
        Iterator it = this.staticObjects_inverse.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            this.bindDynamicObject((Struct)en.getValue(), en.getKey());
        }
        this.preregisterObjects();
    }

    public void onSolveEnd() {
    }

    protected void preregisterObjects() {
        try {
            this.bindDynamicObject(new Struct("stdout"), System.out);
            this.bindDynamicObject(new Struct("stderr"), System.err);
            this.bindDynamicObject(new Struct("runtime"), Runtime.getRuntime());
            this.bindDynamicObject(new Struct("current_thread"), Thread.currentThread());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean java_object_3(Term className, Struct arg, Term id) {
        try {
            if (!className.isAtom()) {
                return false;
            }
            String clName = ((Struct)className).getName();
            if (clName.endsWith("[]")) {
                Object[] list = this.getArrayFromList(arg);
                int nargs = ((Number)list[0]).intValue();
                return this.java_array(clName, nargs, id);
            }
            Signature args = this.parseArg(this.getArrayFromList(arg));
            if (args == null) {
                return false;
            }
            try {
                Class<?> cl = Class.forName(clName);
                Object[] args_value = args.getValues();
                Constructor co = JavaLibrary.lookupConstructor(cl, args.getTypes(), args_value);
                if (co == null) {
                    this.getEngine().warn("Constructor not found: class " + clName);
                    return false;
                }
                Object obj = co.newInstance(args_value);
                return this.bindDynamicObject(id, obj);
            }
            catch (ClassNotFoundException ex) {
                this.getEngine().warn("Java class not found: " + clName);
                return false;
            }
            catch (InvocationTargetException ex) {
                this.getEngine().warn("Invalid constructor arguments.");
                return false;
            }
            catch (NoSuchMethodException ex) {
                this.getEngine().warn("Constructor not found: " + args.getTypes());
                return false;
            }
            catch (InstantiationException ex) {
                this.getEngine().warn("Objects of class " + clName + " cannot be instantiated");
                return false;
            }
            catch (IllegalArgumentException ex) {
                this.getEngine().warn("Illegal constructor arguments  " + args);
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean destroy_object_1(Term id) {
        try {
            if (id.isGround()) {
                this.unregisterDynamic((Struct)id);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean java_class_4(Struct classSource, Struct className, Struct classPathes, Term id) {
        try {
            String fullClassName = Tools.removeApices(className.toString());
            String fullClassPath = fullClassName.replace('.', '/');
            Iterator it = classPathes.listIterator();
            String cp = "";
            while (it.hasNext()) {
                if (cp.length() > 0) {
                    cp = String.valueOf(cp) + ";";
                }
                cp = String.valueOf(cp) + Tools.removeApices(((Struct)it.next()).toString());
            }
            if (cp.length() > 0) {
                cp = " -classpath " + cp;
            }
            String text = Tools.removeApices(classSource.toString());
            try {
                FileWriter file = new FileWriter(String.valueOf(fullClassPath) + ".java");
                file.write(text);
                file.close();
            }
            catch (IOException ex) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(creation of " + fullClassPath + ".java fail failed)");
                return false;
            }
            String cmd = "javac " + cp + " " + fullClassPath + ".java";
            try {
                Process jc = Runtime.getRuntime().exec(cmd);
                int res = jc.waitFor();
                if (res != 0) {
                    this.getEngine().warn("Compilation of java sources failed");
                    this.getEngine().warn("(java compiler (javac) has stopped with errors)");
                    return false;
                }
            }
            catch (IOException ex) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(java compiler (javac) invocation failed)");
                return false;
            }
            try {
                Class<?> the_class = Class.forName(fullClassName, true, new ClassLoader());
                return this.bindDynamicObject(id, the_class);
            }
            catch (ClassNotFoundException ex) {
                this.getEngine().warn("Compilation of java sources failed");
                this.getEngine().warn("(Java Class compiled, but not created: " + fullClassName + " )");
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean java_call_3(Term objId, Struct method, Term idResult) {
        Object obj = null;
        Signature args = null;
        String methodName = null;
        try {
            methodName = method.getName();
            if (!objId.isAtom()) {
                if (objId.isVar()) {
                    return false;
                }
                Struct sel = (Struct)objId;
                if (sel.getName().equals(".") && sel.getArity() == 2 && method.getArity() == 1) {
                    if (methodName.equals("set")) {
                        return this.java_set(sel.getTerm(0), sel.getTerm(1), method.getTerm(0));
                    }
                    if (methodName.equals("get")) {
                        return this.java_get(sel.getTerm(0), sel.getTerm(1), method.getTerm(0));
                    }
                }
            }
            args = this.parseArg(method);
            if (objId.isVar() || args == null) {
                return false;
            }
            String objName = Tools.removeApices(objId.toString());
            obj = this.currentObjects.get(objName);
            Object tres = null;
            Object res = null;
            if (obj != null) {
                Class<?> cl = obj.getClass();
                Object[] args_values = args.getValues();
                Method m = JavaLibrary.lookupMethod(cl, methodName, args.getTypes(), args_values);
                if (m != null) {
                    try {
                        res = m.invoke(obj, args_values);
                    }
                    catch (IllegalAccessException ex) {
                        this.getEngine().warn("Method invocation failed: " + methodName + "( signature: " + args + " )");
                        ex.printStackTrace();
                        return false;
                    }
                }
                this.getEngine().warn("Method not found: " + methodName + "( signature: " + args + " )");
                return false;
            }
            if (objId.isCompound()) {
                Struct id = (Struct)objId;
                if (id.getArity() == 1 && id.getName().equals("class")) {
                    try {
                        Class<?> cl = Class.forName(Tools.removeApices(id.getArg(0).toString()));
                        Method m = cl.getMethod(methodName, args.getTypes());
                        m.setAccessible(true);
                        res = m.invoke(null, args.getValues());
                    }
                    catch (ClassNotFoundException ex) {
                        this.getEngine().warn("Unknown class.");
                        ex.printStackTrace();
                        return false;
                    }
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method m = clazz.getMethod(methodName, args.getTypes());
                m.setAccessible(true);
                res = m.invoke((Object)objName, args.getValues());
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method m = clazz.getMethod(methodName, args.getTypes());
                m.setAccessible(true);
                res = m.invoke((Object)objName, args.getValues());
            }
            return this.parseResult(idResult, res);
        }
        catch (InvocationTargetException ex) {
            this.getEngine().warn("Method failed: " + methodName + " - ( signature: " + args + " ) - Original Exception: " + ex.getTargetException());
            ex.printStackTrace();
            return false;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            this.getEngine().warn("Method not found: " + methodName + " - ( signature: " + args + " )");
            return false;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            this.getEngine().warn("Invalid arguments " + args + " - ( method: " + methodName + " )");
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.getEngine().warn("Generic error in method invocation " + methodName);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean java_set(Term objId, Term fieldTerm, Term what) {
        what = what.getTerm();
        if (!fieldTerm.isAtom() || what.isVar()) {
            return false;
        }
        String fieldName = ((Struct)fieldTerm).getName();
        Object obj = null;
        try {
            Class<?> cl = null;
            if (objId.isCompound() && ((Struct)objId).getArity() == 1 && ((Struct)objId).getName().equals("class")) {
                String clName = Tools.removeApices(((Struct)objId).getArg(0).toString());
                try {
                    cl = Class.forName(clName);
                }
                catch (ClassNotFoundException ex) {
                    this.getEngine().warn("Java class not found: " + clName);
                    return false;
                }
                catch (Exception ex) {
                    this.getEngine().warn("Static field " + fieldName + " not found in class " + Tools.removeApices(((Struct)objId).getArg(0).toString()));
                    return false;
                }
            } else {
                String objName = Tools.removeApices(objId.toString());
                obj = this.currentObjects.get(objName);
                if (obj == null) return false;
                cl = obj.getClass();
            }
            Field field = cl.getField(fieldName);
            if (what.isNumber()) {
                Number wn = (Number)what;
                if (wn.isTypeInt()) {
                    field.setInt(obj, wn.intValue());
                    return true;
                } else if (wn.isTypeDouble()) {
                    field.setDouble(obj, wn.doubleValue());
                    return true;
                } else if (wn.isTypeLong()) {
                    field.setLong(obj, wn.longValue());
                    return true;
                } else {
                    if (!wn.isTypeFloat()) return false;
                    field.setFloat(obj, wn.floatValue());
                }
                return true;
            } else {
                String what_name = Tools.removeApices(what.toString());
                Object obj2 = this.currentObjects.get(what_name);
                if (obj2 != null) {
                    field.set(obj, obj2);
                    return true;
                } else {
                    field.set(obj, what_name);
                }
            }
            return true;
        }
        catch (NoSuchFieldException ex) {
            this.getEngine().warn("Field " + fieldName + " not found in class " + objId);
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean java_get(Term objId, Term fieldTerm, Term what) {
        if (!fieldTerm.isAtom()) {
            return false;
        }
        String fieldName = ((Struct)fieldTerm).getName();
        Object obj = null;
        try {
            Class<?> cl = null;
            if (objId.isCompound() && ((Struct)objId).getArity() == 1 && ((Struct)objId).getName().equals("class")) {
                String clName = Tools.removeApices(((Struct)objId).getArg(0).toString());
                try {
                    cl = Class.forName(clName);
                }
                catch (ClassNotFoundException ex) {
                    this.getEngine().warn("Java class not found: " + clName);
                    return false;
                }
                catch (Exception ex) {
                    this.getEngine().warn("Static field " + fieldName + " not found in class " + Tools.removeApices(((Struct)objId).getArg(0).toString()));
                    return false;
                }
            } else {
                String objName = Tools.removeApices(objId.toString());
                obj = this.currentObjects.get(objName);
                if (obj == null) {
                    return false;
                }
                cl = obj.getClass();
            }
            Field field = cl.getField(fieldName);
            Class<?> fc = field.getType();
            field.setAccessible(true);
            if (fc.equals(Integer.TYPE) || fc.equals(Byte.TYPE)) {
                int value = field.getInt(obj);
                return this.unify(what, new Int(value));
            }
            if (fc.equals(java.lang.Long.TYPE)) {
                long value = field.getLong(obj);
                return this.unify(what, new Long(value));
            }
            if (fc.equals(java.lang.Float.TYPE)) {
                float value = field.getFloat(obj);
                return this.unify(what, new Float(value));
            }
            if (fc.equals(java.lang.Double.TYPE)) {
                double value = field.getDouble(obj);
                return this.unify(what, new Double(value));
            }
            Object res = field.get(obj);
            return this.bindDynamicObject(what, res);
        }
        catch (NoSuchFieldException ex) {
            this.getEngine().warn("Field " + fieldName + " not found in class " + objId);
            return false;
        }
        catch (Exception ex) {
            this.getEngine().warn("Generic error in accessing the field");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean java_array_set_primitive_3(Struct objId, Number index, Term what) {
        what = what.getTerm();
        Object obj = null;
        if (!index.isInteger()) {
            return false;
        }
        try {
            Class<?> cl = null;
            String objName = Tools.removeApices(objId.toString());
            obj = this.currentObjects.get(objName);
            if (obj == null) {
                return false;
            }
            cl = obj.getClass();
            if (!cl.isArray()) {
                return false;
            }
            String name = cl.toString();
            if (name.equals("class [I")) {
                if (!what.isNumber()) {
                    return false;
                }
                byte v = (byte)((Number)what).intValue();
                Array.setInt(obj, index.intValue(), v);
                return true;
            } else if (name.equals("class [D")) {
                if (!what.isNumber()) {
                    return false;
                }
                double v = ((Number)what).doubleValue();
                Array.setDouble(obj, index.intValue(), v);
                return true;
            } else if (name.equals("class [F")) {
                if (!what.isNumber()) {
                    return false;
                }
                float v = ((Number)what).floatValue();
                Array.setFloat(obj, index.intValue(), v);
                return true;
            } else if (name.equals("class [L")) {
                if (!what.isNumber()) {
                    return false;
                }
                long v = ((Number)what).longValue();
                Array.setFloat(obj, index.intValue(), v);
                return true;
            } else if (name.equals("class [C")) {
                String s = what.toString();
                Array.setChar(obj, index.intValue(), s.charAt(0));
                return true;
            } else if (name.equals("class [Z")) {
                String s = what.toString();
                if (s.equals("true")) {
                    Array.setBoolean(obj, index.intValue(), true);
                    return true;
                } else {
                    if (!s.equals("false")) return false;
                    Array.setBoolean(obj, index.intValue(), false);
                }
                return true;
            } else if (name.equals("class [B")) {
                if (!what.isNumber()) {
                    return false;
                }
                int v = ((Number)what).intValue();
                Array.setByte(obj, index.intValue(), (byte)v);
                return true;
            } else {
                if (!name.equals("class [S")) return false;
                if (!what.isNumber()) {
                    return false;
                }
                short v = (short)((Number)what).intValue();
                Array.setShort(obj, index.intValue(), v);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean java_array_get_primitive_3(Struct objId, Number index, Term what) {
        Object obj = null;
        if (!index.isInteger()) {
            return false;
        }
        try {
            Class<?> cl = null;
            String objName = Tools.removeApices(objId.toString());
            obj = this.currentObjects.get(objName);
            if (obj == null) {
                return false;
            }
            cl = obj.getClass();
            if (!cl.isArray()) {
                return false;
            }
            String name = cl.toString();
            if (name.equals("class [I")) {
                Int value = new Int(Array.getInt(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [D")) {
                Double value = new Double(Array.getDouble(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [F")) {
                Float value = new Float(Array.getFloat(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [L")) {
                Long value = new Long(Array.getLong(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [C")) {
                Struct value = new Struct("" + Array.getChar(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [Z")) {
                boolean b = Array.getBoolean(obj, index.intValue());
                if (b) {
                    return this.unify(what, Term.TRUE);
                }
                return this.unify(what, Term.FALSE);
            }
            if (name.equals("class [B")) {
                Int value = new Int(Array.getByte(obj, index.intValue()));
                return this.unify(what, value);
            }
            if (name.equals("class [S")) {
                Int value = new Int(Array.getInt(obj, index.intValue()));
                return this.unify(what, value);
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean java_array(String type, int nargs, Term id) {
        try {
            Object array = null;
            String obtype = type.substring(0, type.length() - 2);
            if (obtype.equals("boolean")) {
                array = new boolean[nargs];
            } else if (obtype.equals("byte")) {
                array = new byte[nargs];
            } else if (obtype.equals("char")) {
                array = new char[nargs];
            } else if (obtype.equals("short")) {
                array = new short[nargs];
            } else if (obtype.equals("int")) {
                array = new int[nargs];
            } else if (obtype.equals("long")) {
                array = new long[nargs];
            } else if (obtype.equals("float")) {
                array = new float[nargs];
            } else if (obtype.equals("double")) {
                array = new double[nargs];
            } else {
                Class<?> cl = Class.forName(obtype);
                array = Array.newInstance(cl, nargs);
            }
            return this.bindDynamicObject(id, array);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Signature parseArg(Struct method) {
        Object[] values = new Object[method.getArity()];
        Class[] types = new Class[method.getArity()];
        int i = 0;
        while (i < method.getArity()) {
            if (!this.parse_arg(values, types, i, method.getTerm(i))) {
                return null;
            }
            ++i;
        }
        return new Signature(values, types);
    }

    private Signature parseArg(Object[] objs) {
        Object[] values = new Object[objs.length];
        Class[] types = new Class[objs.length];
        int i = 0;
        while (i < objs.length) {
            if (!this.parse_arg(values, types, i, (Term)objs[i])) {
                return null;
            }
            ++i;
        }
        return new Signature(values, types);
    }

    private boolean parse_arg(Object[] values, Class[] types, int i, Term term) {
        block22: {
            try {
                if (term == null) {
                    values[i] = null;
                    types[i] = null;
                    break block22;
                }
                if (term.isAtom()) {
                    String name = Tools.removeApices(term.toString());
                    if (name.equals("true")) {
                        values[i] = Boolean.TRUE;
                        types[i] = Boolean.TYPE;
                    } else if (name.equals("false")) {
                        values[i] = Boolean.FALSE;
                        types[i] = Boolean.TYPE;
                    } else {
                        Object obj = this.currentObjects.get(name);
                        values[i] = obj == null ? name : obj;
                        types[i] = values[i].getClass();
                    }
                    break block22;
                }
                if (term.isNumber()) {
                    Number t = (Number)term;
                    if (t.isTypeInt()) {
                        values[i] = new Integer(t.intValue());
                        types[i] = Integer.TYPE;
                    } else if (t.isTypeDouble()) {
                        values[i] = new java.lang.Double(t.doubleValue());
                        types[i] = java.lang.Double.TYPE;
                    } else if (t.isTypeLong()) {
                        values[i] = new java.lang.Long(t.longValue());
                        types[i] = java.lang.Long.TYPE;
                    } else if (t.isTypeFloat()) {
                        values[i] = new java.lang.Float(t.floatValue());
                        types[i] = java.lang.Float.TYPE;
                    }
                    break block22;
                }
                if (term.isStruct()) {
                    Struct tc = (Struct)term;
                    if (tc.getName().equals("as")) {
                        return this.parse_as(values, types, i, tc.getTerm(0), tc.getTerm(1));
                    }
                    Object obj = this.currentObjects.get(Tools.removeApices(tc.toString()));
                    values[i] = obj == null ? Tools.removeApices(tc.toString()) : obj;
                    types[i] = values[i].getClass();
                    break block22;
                }
                if (term.isVar() && !((Var)term).isBound()) {
                    values[i] = null;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    types[i] = clazz;
                    break block22;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private boolean parse_as(Object[] values, Class[] types, int i, Term castWhat, Term castTo) {
        block39: {
            try {
                if (!castWhat.isNumber()) {
                    String castTo_name = Tools.removeApices(((Struct)castTo).getName());
                    String castWhat_name = Tools.removeApices(castWhat.getTerm().toString());
                    if (castTo_name.equals("java.lang.String") && castWhat_name.equals("true")) {
                        values[i] = "true";
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        types[i] = clazz;
                        return true;
                    }
                    if (castTo_name.equals("java.lang.String") && castWhat_name.equals("false")) {
                        values[i] = "false";
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        types[i] = clazz;
                        return true;
                    }
                    if (castTo_name.endsWith("[]")) {
                        castTo_name = castTo_name.equals("boolean[]") ? "[Z" : (castTo_name.equals("byte[]") ? "[B" : (castTo_name.equals("short[]") ? "[S" : (castTo_name.equals("char[]") ? "[C" : (castTo_name.equals("int[]") ? "[I" : (castTo_name.equals("long[]") ? "[L" : (castTo_name.equals("float[]") ? "[F" : (castTo_name.equals("double[]") ? "[D" : "[L" + castTo_name.substring(0, castTo_name.length() - 2) + ";")))))));
                    }
                    if (!castWhat_name.equals("null")) {
                        Object obj_to_cast = this.currentObjects.get(castWhat_name);
                        if (obj_to_cast == null) {
                            if (castTo_name.equals("boolean")) {
                                if (castWhat_name.equals("true")) {
                                    values[i] = new Boolean(true);
                                } else if (castWhat_name.equals("false")) {
                                    values[i] = new Boolean(false);
                                } else {
                                    return false;
                                }
                                types[i] = Boolean.TYPE;
                                break block39;
                            }
                            return false;
                        }
                        values[i] = obj_to_cast;
                        try {
                            types[i] = Class.forName(castTo_name);
                            break block39;
                        }
                        catch (ClassNotFoundException ex) {
                            this.getEngine().warn("Java class not found: " + castTo_name);
                            return false;
                        }
                    }
                    values[i] = null;
                    if (castTo_name.equals("byte")) {
                        types[i] = Byte.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("short")) {
                        types[i] = Short.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("char")) {
                        types[i] = Character.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("int")) {
                        types[i] = Integer.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("long")) {
                        types[i] = java.lang.Long.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("float")) {
                        types[i] = java.lang.Float.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("double")) {
                        types[i] = java.lang.Double.TYPE;
                        break block39;
                    }
                    if (castTo_name.equals("boolean")) {
                        types[i] = Boolean.TYPE;
                        break block39;
                    }
                    try {
                        types[i] = Class.forName(castTo_name);
                        break block39;
                    }
                    catch (ClassNotFoundException ex) {
                        this.getEngine().warn("Java class not found: " + castTo_name);
                        return false;
                    }
                }
                Number num = (Number)castWhat;
                String castTo_name = ((Struct)castTo).getName();
                if (castTo_name.equals("byte")) {
                    values[i] = new Byte((byte)num.intValue());
                    types[i] = Byte.TYPE;
                    break block39;
                }
                if (castTo_name.equals("short")) {
                    values[i] = new Short((short)num.intValue());
                    types[i] = Short.TYPE;
                    break block39;
                }
                if (castTo_name.equals("int")) {
                    values[i] = new Integer(num.intValue());
                    types[i] = Integer.TYPE;
                    break block39;
                }
                if (castTo_name.equals("long")) {
                    values[i] = new java.lang.Long(num.longValue());
                    types[i] = java.lang.Long.TYPE;
                    break block39;
                }
                if (castTo_name.equals("float")) {
                    values[i] = new java.lang.Float(num.floatValue());
                    types[i] = java.lang.Float.TYPE;
                    break block39;
                }
                if (castTo_name.equals("double")) {
                    values[i] = new java.lang.Double(num.doubleValue());
                    types[i] = java.lang.Double.TYPE;
                    break block39;
                }
                return false;
            }
            catch (Exception ex) {
                this.getEngine().warn("Casting " + castWhat + " to " + castTo + " failed");
                return false;
            }
        }
        return true;
    }

    private boolean parseResult(Term id, Object obj) {
        if (obj == null) {
            return this.unify(id, new Var());
        }
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(obj)) {
                if (((Boolean)obj).booleanValue()) {
                    return this.unify(id, Term.TRUE);
                }
                return this.unify(id, Term.FALSE);
            }
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isInstance(obj)) {
                return this.unify(id, new Int(((Byte)obj).intValue()));
            }
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.isInstance(obj)) {
                return this.unify(id, new Int(((Short)obj).intValue()));
            }
            Class<?> clazz4 = class$5;
            if (clazz4 == null) {
                try {
                    clazz4 = class$5 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.isInstance(obj)) {
                return this.unify(id, new Int((Integer)obj));
            }
            Class<?> clazz5 = class$6;
            if (clazz5 == null) {
                try {
                    clazz5 = class$6 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.isInstance(obj)) {
                return this.unify(id, new Long((java.lang.Long)obj));
            }
            Class<?> clazz6 = class$7;
            if (clazz6 == null) {
                try {
                    clazz6 = class$7 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz6.isInstance(obj)) {
                return this.unify(id, new Float(((java.lang.Float)obj).floatValue()));
            }
            Class<?> clazz7 = class$8;
            if (clazz7 == null) {
                try {
                    clazz7 = class$8 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz7.isInstance(obj)) {
                return this.unify(id, new Double((java.lang.Double)obj));
            }
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz8.isInstance(obj)) {
                return this.unify(id, new Struct((String)obj));
            }
            Class<?> clazz9 = class$9;
            if (clazz9 == null) {
                try {
                    clazz9 = class$9 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz9.isInstance(obj)) {
                return this.unify(id, new Struct(((Character)obj).toString()));
            }
            return this.bindDynamicObject(id, obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private Object[] getArrayFromList(Struct list) {
        Object[] args = new Object[list.listSize()];
        Iterator it = list.listIterator();
        int count = 0;
        while (it.hasNext()) {
            args[count++] = it.next();
        }
        return args;
    }

    public boolean register(Struct id, Object obj) throws InvalidObjectIdException {
        if (!id.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap hashMap = this.staticObjects;
        synchronized (hashMap) {
            block5: {
                Object aKey = this.staticObjects_inverse.get(obj);
                if (aKey == null) break block5;
                return false;
            }
            String raw_name = Tools.removeApices(id.getTerm().toString());
            this.staticObjects.put(raw_name, obj);
            this.staticObjects_inverse.put(obj, id);
            return true;
        }
    }

    public Struct register(Object obj) {
        HashMap hashMap = this.staticObjects;
        synchronized (hashMap) {
            Object aKey = this.staticObjects_inverse.get(obj);
            if (aKey != null) {
                return (Struct)aKey;
            }
            Struct id = this.generateFreshId();
            this.staticObjects.put(id.getName(), obj);
            this.staticObjects_inverse.put(obj, id);
            return id;
        }
    }

    public Object getRegisteredObject(Struct id) throws InvalidObjectIdException {
        if (!id.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap hashMap = this.staticObjects;
        synchronized (hashMap) {
            return this.staticObjects.get(Tools.removeApices(id.toString()));
        }
    }

    public boolean unregister(Struct id) throws InvalidObjectIdException {
        if (!id.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap hashMap = this.staticObjects;
        synchronized (hashMap) {
            block5: {
                String raw_name = Tools.removeApices(id.toString());
                Object obj = this.staticObjects.remove(raw_name);
                if (obj == null) break block5;
                this.staticObjects_inverse.remove(obj);
                return true;
            }
            return false;
        }
    }

    public void registerDynamic(Struct id, Object obj) {
        HashMap hashMap = this.currentObjects;
        synchronized (hashMap) {
            String raw_name = Tools.removeApices(id.toString());
            this.currentObjects.put(raw_name, obj);
            this.currentObjects_inverse.put(obj, id);
        }
    }

    public Struct registerDynamic(Object obj) {
        HashMap hashMap = this.currentObjects;
        synchronized (hashMap) {
            Object aKey = this.currentObjects_inverse.get(obj);
            if (aKey != null) {
                return (Struct)aKey;
            }
            Struct id = this.generateFreshId();
            this.currentObjects.put(id.getName(), obj);
            this.currentObjects_inverse.put(obj, id);
            return id;
        }
    }

    public Object getRegisteredDynamicObject(Struct id) throws InvalidObjectIdException {
        if (!id.isGround()) {
            throw new InvalidObjectIdException();
        }
        HashMap hashMap = this.currentObjects;
        synchronized (hashMap) {
            return this.currentObjects.get(Tools.removeApices(id.toString()));
        }
    }

    public boolean unregisterDynamic(Struct id) {
        HashMap hashMap = this.currentObjects;
        synchronized (hashMap) {
            block4: {
                String raw_name = Tools.removeApices(id.toString());
                Object obj = this.currentObjects.remove(raw_name);
                if (obj == null) break block4;
                this.currentObjects_inverse.remove(obj);
                return true;
            }
            return false;
        }
    }

    protected boolean bindDynamicObject(Term id, Object obj) {
        if (obj == null) {
            return this.unify(id, new Var());
        }
        HashMap hashMap = this.currentObjects;
        synchronized (hashMap) {
            Object linkedobj;
            block8: {
                block7: {
                    Object aKey = this.currentObjects_inverse.get(obj);
                    if (aKey != null) {
                        return this.unify(id, (Term)aKey);
                    }
                    if (!id.isVar()) break block7;
                    Struct idTerm = this.generateFreshId();
                    this.unify(id, idTerm);
                    this.registerDynamic(idTerm, obj);
                    return true;
                }
                String raw_name = Tools.removeApices(id.getTerm().toString());
                linkedobj = this.currentObjects.get(raw_name);
                if (linkedobj != null) break block8;
                this.registerDynamic((Struct)id.getTerm(), obj);
                return true;
            }
            return obj == linkedobj;
        }
    }

    protected Struct generateFreshId() {
        return new Struct("$obj_" + this.id++);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap bak00 = this.currentObjects;
        HashMap bak01 = this.currentObjects_inverse;
        try {
            this.currentObjects = null;
            this.currentObjects_inverse = null;
            out.defaultWriteObject();
        }
        catch (IOException ex) {
            this.currentObjects = bak00;
            this.currentObjects_inverse = bak01;
            throw new IOException();
        }
        this.currentObjects = bak00;
        this.currentObjects_inverse = bak01;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.currentObjects = new HashMap();
        this.currentObjects_inverse = new HashMap();
        this.preregisterObjects();
    }

    private void log(String m) {
        System.out.println("JavaLibrary: " + m);
    }

    /*
     * Unable to fully structure code
     */
    private static Method lookupMethod(Class target, String name, Class[] argClasses, Object[] argValues) throws NoSuchMethodException {
        try {
            m = target.getMethod(name, argClasses);
            return m;
        }
        catch (NoSuchMethodException e) {
            if (argClasses.length == 0) {
                return null;
            }
            methods = target.getMethods();
            goodMethods = new Vector<Method>();
            i = 0;
            ** while (i != methods.length)
        }
lbl-1000:
        // 1 sources

        {
            if (name.equals(methods[i].getName()) && JavaLibrary.matchClasses(methods[i].getParameterTypes(), argClasses)) {
                goodMethods.addElement(methods[i]);
            }
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        switch (goodMethods.size()) {
            case 0: {
                i = 0;
                while (i != methods.length) {
                    if (name.equals(methods[i].getName()) && (val = JavaLibrary.matchClasses(types = methods[i].getParameterTypes(), argClasses, argValues)) != null) {
                        j = 0;
                        while (j < types.length) {
                            argClasses[j] = types[j];
                            argValues[j] = val[j];
                            ++j;
                        }
                        return methods[i];
                    }
                    ++i;
                }
                return null;
            }
            case 1: {
                return (Method)goodMethods.firstElement();
            }
        }
        return JavaLibrary.mostSpecificMethod(goodMethods);
    }

    /*
     * Unable to fully structure code
     */
    private static Constructor lookupConstructor(Class target, Class[] argClasses, Object[] argValues) throws NoSuchMethodException {
        try {
            return target.getConstructor(argClasses);
        }
        catch (NoSuchMethodException e) {
            if (argClasses.length == 0) {
                return null;
            }
            constructors = target.getConstructors();
            goodConstructors = new Vector<Constructor<?>>();
            i = 0;
            ** while (i != constructors.length)
        }
lbl-1000:
        // 1 sources

        {
            if (JavaLibrary.matchClasses(constructors[i].getParameterTypes(), argClasses)) {
                goodConstructors.addElement(constructors[i]);
            }
            ++i;
            continue;
        }
lbl14:
        // 1 sources

        switch (goodConstructors.size()) {
            case 0: {
                i = 0;
                while (i != constructors.length) {
                    types = constructors[i].getParameterTypes();
                    val = JavaLibrary.matchClasses(types, argClasses, argValues);
                    if (val != null) {
                        j = 0;
                        while (j < types.length) {
                            argClasses[j] = types[j];
                            argValues[j] = val[j];
                            ++j;
                        }
                        return constructors[i];
                    }
                    ++i;
                }
                return null;
            }
            case 1: {
                return (Constructor)goodConstructors.firstElement();
            }
        }
        return JavaLibrary.mostSpecificConstructor(goodConstructors);
    }

    private static boolean matchClasses(Class[] mclasses, Class[] pclasses) {
        if (mclasses.length == pclasses.length) {
            int i = 0;
            while (i != mclasses.length) {
                if (!JavaLibrary.matchClass(mclasses[i], pclasses[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean matchClass(Class mclass, Class pclass) {
        boolean assignable = mclass.isAssignableFrom(pclass);
        if (assignable) {
            return true;
        }
        return mclass.equals(java.lang.Long.TYPE) && pclass.equals(Integer.TYPE);
    }

    private static Method mostSpecificMethod(Vector methods) throws NoSuchMethodException {
        int i = 0;
        while (i != methods.size()) {
            int j = 0;
            while (j != methods.size()) {
                if (i != j && JavaLibrary.moreSpecific((Method)methods.elementAt(i), (Method)methods.elementAt(j))) {
                    methods.removeElementAt(j);
                    if (i > j) {
                        --i;
                    }
                    --j;
                }
                ++j;
            }
            ++i;
        }
        if (methods.size() == 1) {
            return (Method)methods.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific method");
    }

    private static boolean moreSpecific(Method c1, Method c2) {
        Class<?>[] p1 = c1.getParameterTypes();
        Class<?>[] p2 = c2.getParameterTypes();
        int n = p1.length;
        int i = 0;
        while (i != n) {
            if (!JavaLibrary.matchClass(p2[i], p1[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Constructor mostSpecificConstructor(Vector constructors) throws NoSuchMethodException {
        int i = 0;
        while (i != constructors.size()) {
            int j = 0;
            while (j != constructors.size()) {
                if (i != j && JavaLibrary.moreSpecific((Constructor)constructors.elementAt(i), (Constructor)constructors.elementAt(j))) {
                    constructors.removeElementAt(j);
                    if (i > j) {
                        --i;
                    }
                    --j;
                }
                ++j;
            }
            ++i;
        }
        if (constructors.size() == 1) {
            return (Constructor)constructors.elementAt(0);
        }
        throw new NoSuchMethodException(">1 most specific constructor");
    }

    private static boolean moreSpecific(Constructor c1, Constructor c2) {
        Class<?>[] p1 = c1.getParameterTypes();
        Class<?>[] p2 = c2.getParameterTypes();
        int n = p1.length;
        int i = 0;
        while (i != n) {
            if (!JavaLibrary.matchClass(p2[i], p1[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Object[] matchClasses(Class[] mclasses, Class[] pclasses, Object[] values) {
        if (mclasses.length == pclasses.length) {
            Object[] newvalues = new Object[mclasses.length];
            int i = 0;
            while (i != mclasses.length) {
                boolean assignable = mclasses[i].isAssignableFrom(pclasses[i]);
                if (assignable || mclasses[i].equals(java.lang.Long.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = values[i];
                } else if (mclasses[i].equals(java.lang.Float.TYPE) && pclasses[i].equals(java.lang.Double.TYPE)) {
                    newvalues[i] = new java.lang.Float(((java.lang.Double)values[i]).floatValue());
                } else if (mclasses[i].equals(java.lang.Float.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = new java.lang.Float(((Integer)values[i]).intValue());
                } else if (mclasses[i].equals(java.lang.Double.TYPE) && pclasses[i].equals(Integer.TYPE)) {
                    newvalues[i] = new java.lang.Double(((Integer)values[i]).doubleValue());
                } else if (values[i] == null && !mclasses[i].isPrimitive()) {
                    newvalues[i] = null;
                } else {
                    return null;
                }
                ++i;
            }
            return newvalues;
        }
        return null;
    }
}

