/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.FrameLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AWTFrameLauncher
implements FrameLauncher {
    private String iconPathName = "";

    public void launchFrame(Component content) {
        this.launchFrame(content, "Frame", 0, 0);
    }

    public void launchFrame(Component content, String title, int width, int height) {
        new AWTFrame(content, title, width, height);
    }

    public void setFrameIcon(String imagePathName) {
        this.iconPathName = imagePathName;
    }

    public String getFrameIcon() {
        return this.iconPathName;
    }

    private class AWTFrame
    extends Frame {
        private transient Image doubleBuffer;

        public AWTFrame(Component content, String title, int width, int height) {
            super(title);
            this.initComponents(content, width, height);
        }

        private void initComponents(Component content, int width, int height) {
            this.setLayout(new BorderLayout());
            this.add(content, "Center");
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ AWTFrame this$1;
                {
                    this.this$1 = aWTFrame;
                }

                public void windowClosing(WindowEvent event) {
                    this.this$1.dispose();
                }
            });
            if (AWTFrameLauncher.this.iconPathName != "") {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(AWTFrameLauncher.this.getFrameIcon())));
            }
            this.pack();
            if (width > 0 && height > 0) {
                Insets insets = this.getInsets();
                width += insets.left + insets.right;
                height += insets.top + insets.bottom;
                Dimension screenSize = this.getToolkit().getScreenSize();
                width = Math.min(width, screenSize.width);
                height = Math.min(height, screenSize.height);
                this.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
            }
            this.show();
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            if (this.doubleBuffer == null) {
                Dimension d = this.getSize();
                this.doubleBuffer = this.createImage(d.width, d.height);
            }
            Graphics dg = this.doubleBuffer.getGraphics();
            dg.setClip(g.getClipBounds());
            super.paint(dg);
            dg.dispose();
            g.drawImage(this.doubleBuffer, 0, 0, this);
        }

        public void doLayout() {
            if (this.doubleBuffer != null) {
                this.doubleBuffer.flush();
                this.doubleBuffer = null;
            }
            super.doLayout();
        }
    }
}

