/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.OutputEvent;
import alice.tuprolog.OutputListener;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.SpyEvent;
import alice.tuprolog.SpyListener;
import alice.tuprolog.Theory;
import alice.tuprolog.WarningEvent;
import alice.tuprolog.WarningListener;
import alice.util.Automaton;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;

public class CUIConsole
extends Automaton
implements Serializable,
OutputListener,
SpyListener,
WarningListener {
    BufferedReader stdin;
    Prolog engine;
    SolveInfo info;
    static final String incipit = "\ntuProlog " + Prolog.getVersion() + " - DEIS,  Universita' di Bologna a Cesena \n" + new Date() + "\n";

    public CUIConsole(String[] args) {
        if (args.length > 1) {
            System.err.println("args: { theory file }");
            System.exit(-1);
        }
        this.engine = new Prolog();
        this.stdin = new BufferedReader(new InputStreamReader(System.in));
        this.engine.addWarningListener(this);
        this.engine.addOutputListener(this);
        this.engine.addSpyListener(this);
        if (args.length > 0) {
            try {
                this.engine.setTheory(new Theory(new FileInputStream(args[0])));
            }
            catch (InvalidTheoryException ex) {
                System.err.println("invalid theory - line: " + ex.line);
                System.exit(-1);
            }
            catch (Exception ex) {
                System.err.println("invalid theory.");
                System.exit(-1);
            }
        }
    }

    public void boot() {
        System.out.println(incipit);
        this.become("goalRequest");
    }

    public void goalRequest() {
        String goal = "";
        try {
            while (goal.equals("")) {
                System.out.print("\n?- ");
                goal = this.stdin.readLine();
            }
            this.solveGoal(goal);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void solveGoal(String goal) {
        try {
            this.info = this.engine.solve(goal);
            if (this.engine.isHalted()) {
                System.exit(0);
            } else if (!this.info.isSuccess()) {
                System.out.println("no.");
                this.become("goalRequest");
            } else if (!this.engine.hasOpenAlternatives()) {
                String binds = this.info.toString();
                if (binds.equals("")) {
                    System.out.println("yes.");
                } else {
                    System.out.println("yes ( " + binds + " ).");
                }
                System.out.println("solution: " + this.engine.toString(this.info.getSolution()));
                this.become("goalRequest");
            } else {
                System.out.print("substitution: " + this.info + "  ?  ");
                this.become("getChoice");
            }
        }
        catch (MalformedGoalException ex) {
            System.out.println("syntax error in " + goal);
            this.become("goalRequest");
        }
        catch (NoSolutionException ex) {
            System.out.println("syntax error in " + goal);
            this.become("goalRequest");
        }
    }

    public void getChoice() {
        block11: {
            String choice = "";
            try {
                while (!(choice = this.stdin.readLine()).equals(";") && !choice.equals("")) {
                    System.out.println("\nAction ( ';' for more choices, otherwise <return> ) ");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (!choice.equals(";")) {
                    String binds = this.info.toString();
                    if (binds.equals("")) {
                        System.out.println("yes.");
                    } else {
                        System.out.println("yes ( " + binds + " ).");
                    }
                    System.out.print("solution: " + this.engine.toString(this.info.getSolution()));
                    this.engine.solveEnd();
                    this.become("goalRequest");
                    break block11;
                }
                try {
                    this.info = this.engine.solveNext();
                    if (!this.info.isSuccess()) {
                        System.out.println("no.");
                        this.become("goalRequest");
                        break block11;
                    }
                    System.out.print("substitution: " + this.info + "  ?  ");
                    this.become("getChoice");
                }
                catch (Exception ex) {
                    System.out.println("no.");
                    this.become("goalRequest");
                }
            }
            catch (NoSolutionException ex) {
                System.out.println("no.");
                this.become("goalRequest");
            }
        }
    }

    public void onOutput(OutputEvent e) {
        System.out.print(e.getMsg());
    }

    public void onSpy(SpyEvent e) {
        System.out.println(e.getMsg());
    }

    public void onWarning(WarningEvent e) {
        System.out.println(e.getMsg());
    }

    public static void main(String[] args) {
        new Thread(new CUIConsole(args)).start();
    }
}

