/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.TheoryEditArea;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;

public class DotNetEditArea
extends Panel
implements TheoryEditArea {
    private TextArea textArea = new TextArea(25, 80);
    private Vector table;
    private int caretLine;
    private boolean dirty;
    private PropertyChangeSupport propertyChangeSupport;

    public DotNetEditArea() {
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.dirty = false;
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!DotNetEditArea.this.dirty) {
                    DotNetEditArea.this.setDirty(true);
                }
                DotNetEditArea.this.inputKeyReleased(e);
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DotNetEditArea.this.doSetCaretLine();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.textArea, constraints);
        this.table = this.buildLengthTable(this.textArea.getText());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public String getTheory() {
        return this.textArea.getText();
    }

    public void setTheory(String theory) {
        this.textArea.setText(theory);
    }

    public void setCaretLine(int caretLine) {
        int oldCaretLine = this.getCaretLine();
        this.caretLine = caretLine;
        this.propertyChangeSupport.firePropertyChange("caretLine", oldCaretLine, caretLine);
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void undoAction() {
    }

    public void redoAction() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void inputKeyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (!this.isCursorMovement(keyCode)) {
            this.table = this.buildLengthTable(this.textArea.getText());
        }
        this.doSetCaretLine();
    }

    private void doSetCaretLine() {
        int caretLine = this.getCurrentLine(this.textArea.getCaretPosition());
        this.setCaretLine(caretLine);
    }

    private boolean isCursorMovement(int keyCode) {
        switch (keyCode) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private int getCurrentLine(int caretPosition) {
        int textLength = (Integer)this.table.get(this.table.size() - 1);
        int index = 0;
        while (index < this.table.size()) {
            int highBound = (Integer)this.table.get(index);
            if (caretPosition < highBound) {
                return index + 1;
            }
            ++index;
        }
        return this.table.size();
    }

    private Vector buildLengthTable(String text) {
        Vector<Integer> table = new Vector<Integer>();
        int lines = 0;
        int textLength = 0;
        String remaining = text;
        while (remaining.indexOf("\n") != -1) {
            int lineLength = remaining.substring(0, remaining.indexOf("\n")).length();
            textLength = lineLength == 0 ? ++textLength : (textLength += lineLength + 1);
            table.add(lines++, new Integer(textLength));
            remaining = remaining.substring(remaining.indexOf("\n") + 1);
        }
        table.add(lines, new Integer(textLength += remaining.length()));
        return table;
    }
}

