/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Prolog;
import alice.tuprologx.ide.AWTFrameLauncher;
import alice.tuprologx.ide.DotNetEditArea;
import alice.tuprologx.ide.DotNetIOManager;
import alice.tuprologx.ide.DotNetInputField;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.LibraryDialog;
import alice.tuprologx.ide.ThinletConsole;
import alice.tuprologx.ide.ThinletDebugArea;
import alice.tuprologx.ide.ThinletStatusBar;
import alice.tuprologx.ide.ThinletTheoryEditor;
import alice.tuprologx.ide.ThinletToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class DotNetIDE
extends Frame
implements IDE {
    private ThinletTheoryEditor editor;
    private DotNetEditArea editArea;
    private ThinletToolBar toolBar;

    public DotNetIDE() {
        super("tuProlog IDE");
        this.initComponents();
    }

    private void initComponents() {
        Panel corePanel = new Panel();
        corePanel.setLayout(new BorderLayout());
        Prolog engine = new Prolog();
        System.out.println("tuProlog system - release " + Prolog.getVersion());
        ThinletDebugArea debugArea = new ThinletDebugArea();
        engine.addSpyListener(debugArea);
        ThinletStatusBar statusBar = new ThinletStatusBar();
        this.editor = new ThinletTheoryEditor();
        this.editor.addPropertyChangeListener(statusBar);
        corePanel.add((Component)this.editor, "North");
        this.editArea = new DotNetEditArea();
        this.editor.setEditArea(this.editArea);
        this.editArea.addPropertyChangeListener(this.editor);
        this.editArea.setBackground(new Color(230, 230, 230));
        corePanel.add((Component)this.editArea, "Center");
        ThinletConsole console = new ThinletConsole(this);
        console.addPropertyChangeListener(statusBar);
        console.setStatusMessage("Ready.");
        DotNetInputField inputField = new DotNetInputField();
        console.setInputField(inputField);
        inputField.setBackground(new Color(230, 230, 230));
        Panel queryPanel = new Panel();
        queryPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        queryPanel.add((Component)inputField, constraints);
        Panel consolePanel = new Panel();
        consolePanel.setLayout(new BorderLayout());
        consolePanel.add((Component)queryPanel, "North");
        consolePanel.add((Component)console, "Center");
        corePanel.add((Component)consolePanel, "South");
        Panel IDEPanel = new Panel();
        IDEPanel.setLayout(new BorderLayout());
        this.toolBar = new ThinletToolBar();
        IDEPanel.add((Component)this.toolBar, "North");
        IDEPanel.add((Component)corePanel, "Center");
        this.toolBar.addPropertyChangeListener(statusBar);
        this.toolBar.setDebugArea(debugArea);
        this.toolBar.setFileManager(new DotNetIOManager(this));
        AWTFrameLauncher frameLauncher = new AWTFrameLauncher();
        frameLauncher.setFrameIcon("tuProlog.gif");
        this.toolBar.setFrameLauncher(frameLauncher);
        IDEPanel.add((Component)statusBar, "South");
        LibraryDialog libraryDialog = new LibraryDialog();
        this.toolBar.setLibraryDialog(libraryDialog);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        this.add(IDEPanel);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("tuProlog.gif")));
    }

    public void enableTheoryCommands(boolean flag) {
        this.editor.enableTheoryCommands(flag);
        this.toolBar.enableTheoryCommands(flag);
    }

    public boolean isFeededTheory() {
        return !this.editArea.isDirty();
    }

    public String getEditorContent() {
        return this.editArea.getTheory();
    }
}

