/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Library;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.EngineRunningException;
import alice.tuprologx.ide.EngineStatus;
import java.util.Observable;

public class EngineThread
extends Observable
implements Runnable {
    private Prolog _engine = null;
    private String _goal = null;
    private SolveInfo info = null;
    private boolean _halted = false;
    private boolean _running = false;

    public EngineThread(Prolog engine, String goal) {
        this._engine = engine;
        this._goal = goal;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        Object var3_9;
        EngineStatus status = null;
        try {
            try {
                this._running = true;
                this.info = this._engine.solve(this._goal);
                status = new EngineStatus();
                status.setInfo(this.info);
                status.hasAlternatives(this._engine.hasOpenAlternatives());
                status.setFirstSolution(true);
            }
            catch (MalformedGoalException e) {
                status = new EngineStatus();
                status.setError("syntax error");
                this._running = false;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.setChanged();
            this.notifyObservers(status);
            throw throwable;
        }
        {
            var3_9 = null;
            this.setChanged();
            this.notifyObservers(status);
        }
        while (!this._halted) {
            try {
                try {
                    this._running = false;
                    this.wait();
                    this._running = true;
                    this.info = this._engine.solveNext();
                    status = new EngineStatus();
                    status.setInfo(this.info);
                    status.hasAlternatives(this._engine.hasOpenAlternatives());
                }
                catch (NoMoreSolutionException e2) {
                    status.setError("No more solution founded.");
                    this._running = false;
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                var3_9 = null;
                this.setChanged();
                this.notifyObservers(status);
                throw throwable;
            }
            {
                var3_9 = null;
            }
            this.setChanged();
            this.notifyObservers(status);
        }
        return;
    }

    public synchronized void nextSolution() {
        this.notify();
    }

    public synchronized void acceptSolution() {
        this._engine.solveEnd();
        this._halted = true;
        EngineStatus status = new EngineStatus();
        status.setInfo(this.info);
        status.hasAlternatives(false);
        status.setAccepted(true);
        this.setChanged();
        this.notifyObservers(status);
    }

    public void stopExcution() {
        this._engine.solveHalt();
        this._running = false;
        this._halted = true;
    }

    public boolean isRunning() {
        return this._running;
    }

    public void setTheory(Theory t) throws InvalidTheoryException, EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        this._engine.setTheory(t);
    }

    public Theory getTheory() throws EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        return this._engine.getTheory();
    }

    public Library getLibrary(String libraryClassname) throws EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        return this._engine.getLibrary(libraryClassname);
    }

    public void loadLibrary(String library) throws InvalidLibraryException, EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        this._engine.loadLibrary(library);
    }

    public void unloadLibrary(String library) throws InvalidLibraryException, EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        this._engine.unloadLibrary(library);
    }

    public void clearTheory() throws EngineRunningException {
        if (this.isRunning()) {
            throw new EngineRunningException();
        }
        this._engine.clearTheory();
    }

    public void setGoal(String goal) {
        this._goal = goal;
    }
}

