/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.PrologTextArea;
import alice.tuprologx.ide.PrologTokenMarker;
import alice.tuprologx.ide.TheoryEditArea;
import alice.util.jedit.JEditTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JavaEditArea
extends JPanel
implements TheoryEditArea {
    private JEditTextArea inputTheory;
    private int caretLine;
    private boolean dirty;
    private PropertyChangeSupport propertyChangeSupport;
    private UndoManager undoManager;

    public JavaEditArea() {
        PrologTextArea textArea = new PrologTextArea();
        this.setKeyBindings(textArea);
        this.inputTheory = new JEditTextArea(textArea);
        this.inputTheory.setTokenMarker(new PrologTokenMarker());
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 10, 0);
        this.inputTheory.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                JavaEditArea.this.setCaretLine(JavaEditArea.this.inputTheory.getCaretLine() + 1);
            }
        });
        this.dirty = false;
        this.inputTheory.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent event) {
                this.changedUpdate(event);
            }

            public void removeUpdate(DocumentEvent event) {
                this.changedUpdate(event);
            }

            public void changedUpdate(DocumentEvent event) {
                if (!JavaEditArea.this.dirty) {
                    JavaEditArea.this.setDirty(true);
                }
            }
        });
        this.undoManager = new UndoManager();
        this.inputTheory.getDocument().addUndoableEditListener(this.undoManager);
        this.add((Component)this.inputTheory, constraints);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    private void setKeyBindings(PrologTextArea textArea) {
        textArea.inputHandler.addKeyBinding("C+Z", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                JavaEditArea.this.undoAction();
            }
        });
        textArea.inputHandler.addKeyBinding("CS+Z", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                JavaEditArea.this.redoAction();
            }
        });
    }

    public void setCaretLine(int caretLine) {
        int oldCaretLine = this.getCaretLine();
        this.caretLine = caretLine;
        this.propertyChangeSupport.firePropertyChange("caretLine", oldCaretLine, caretLine);
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setTheory(String theory) {
        this.inputTheory.setText(theory);
    }

    public String getTheory() {
        return this.inputTheory.getText();
    }

    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void undoAction() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redoAction() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }
}

