/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.OutputEvent;
import alice.tuprolog.Prolog;
import alice.tuprolog.SpyEvent;
import alice.tuprolog.WarningEvent;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.JavaEditArea;
import alice.tuprologx.ide.JavaIOManager;
import alice.tuprologx.ide.JavaInputField;
import alice.tuprologx.ide.LibraryDialog;
import alice.tuprologx.ide.LibraryManager;
import alice.tuprologx.ide.SwingFrameLauncher;
import alice.tuprologx.ide.ThinletConsole;
import alice.tuprologx.ide.ThinletDebugArea;
import alice.tuprologx.ide.ThinletStatusBar;
import alice.tuprologx.ide.ThinletTheoryEditor;
import alice.tuprologx.ide.ThinletToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JavaIDE
extends JFrame
implements IDE {
    private ThinletTheoryEditor editor;
    private JavaEditArea editArea;
    private ThinletToolBar toolBar;
    private Prolog engine;

    public JavaIDE() {
        super("tuProlog IDE");
        this.initComponents();
    }

    private void initComponents() {
        JPanel corePanel = new JPanel();
        corePanel.setLayout(new BorderLayout());
        this.engine = new Prolog();
        EngineThread et = new EngineThread(this.engine, null);
        System.out.println("tuProlog system - release " + Prolog.getVersion());
        ThinletDebugArea debugArea = new ThinletDebugArea();
        this.engine.addSpyListener(debugArea);
        ThinletStatusBar statusBar = new ThinletStatusBar();
        this.editor = new ThinletTheoryEditor();
        this.editor.setEngine(et);
        this.editor.addPropertyChangeListener(statusBar);
        corePanel.add((Component)this.editor, "North");
        this.editArea = new JavaEditArea();
        this.editor.setEditArea(this.editArea);
        this.editArea.addPropertyChangeListener(this.editor);
        corePanel.add((Component)this.editArea, "Center");
        this.editArea.setBackground(new Color(230, 230, 230));
        ThinletConsole console = new ThinletConsole(this);
        console.setEngine(et);
        console.addPropertyChangeListener(statusBar);
        console.setStatusMessage("Ready.");
        JavaInputField inputField = new JavaInputField();
        inputField.setBackground(new Color(230, 230, 230));
        console.setInputField(inputField);
        JPanel queryPanel = new JPanel();
        queryPanel.setLayout(new GridBagLayout());
        GridBagConstraints inputConstraints = new GridBagConstraints();
        inputConstraints.gridx = 0;
        inputConstraints.gridy = 0;
        inputConstraints.weightx = 1.0;
        inputConstraints.fill = 2;
        queryPanel.add((Component)inputField, inputConstraints);
        JPanel consolePanel = new JPanel();
        consolePanel.setLayout(new BorderLayout());
        consolePanel.add((Component)queryPanel, "North");
        consolePanel.add((Component)console, "Center");
        corePanel.add((Component)consolePanel, "South");
        JPanel IDEPanel = new JPanel();
        IDEPanel.setLayout(new BorderLayout());
        this.toolBar = new ThinletToolBar();
        this.toolBar.setEngine(et);
        IDEPanel.add((Component)this.toolBar, "North");
        IDEPanel.add((Component)corePanel, "Center");
        this.toolBar.addPropertyChangeListener(statusBar);
        this.toolBar.setDebugArea(debugArea);
        this.toolBar.setFileManager(new JavaIOManager(this.toolBar));
        SwingFrameLauncher frameLauncher = new SwingFrameLauncher();
        frameLauncher.setFrameIcon("img/tuProlog.gif");
        this.toolBar.setFrameLauncher(frameLauncher);
        IDEPanel.add((Component)statusBar, "South");
        LibraryManager.getInstance().setEngine(et);
        LibraryDialog libraryDialog = new LibraryDialog();
        this.toolBar.setLibraryDialog(libraryDialog);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        this.getContentPane().add(IDEPanel);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("img/tuProlog.gif"));
        this.setIconImage(icon.getImage());
        this.engine.addWarningListener(debugArea);
        this.engine.addOutputListener(console);
        this.engine.addSpyListener(debugArea);
    }

    public void onOutput(OutputEvent e) {
        System.out.print(e.getMsg());
    }

    public void onSpy(SpyEvent e) {
        System.out.println(e.getMsg());
    }

    public void onWarning(WarningEvent e) {
        System.out.println(e.getMsg());
    }

    public void enableTheoryCommands(boolean flag) {
        this.editor.enableTheoryCommands(flag);
        this.toolBar.enableTheoryCommands(flag);
    }

    public boolean isFeededTheory() {
        return !this.editArea.isDirty();
    }

    public String getEditorContent() {
        return this.editArea.getTheory();
    }
}

