/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Theory;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.IOFileOperations;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class JavaIOManager
extends IOFileOperations {
    private Component parent;

    public JavaIOManager(Component parent) {
        this.parent = parent;
    }

    public Theory loadTheory() throws Exception {
        JFileChooser chooser = new JFileChooser(this.currentLoadDirectory);
        chooser.setFileFilter(new PrologFileFilter());
        int returnVal = chooser.showOpenDialog(this.parent);
        if (returnVal == 0) {
            this.currentLoadDirectory = chooser.getCurrentDirectory().toString();
            this.currentTheoryFileName = chooser.getCurrentDirectory() + File.separator + chooser.getSelectedFile().getName();
            return new Theory(new FileInputStream(this.currentTheoryFileName));
        }
        return null;
    }

    public String saveTheoryAs(EngineThread engine) throws Exception {
        JFileChooser chooser = new JFileChooser(this.currentSaveDirectory);
        chooser.setDialogType(1);
        chooser.setFileFilter(new PrologFileFilter());
        int returnVal = chooser.showSaveDialog(this.parent);
        if (returnVal == 0) {
            this.currentSaveDirectory = chooser.getCurrentDirectory().toString();
            this.currentTheoryFileName = chooser.getCurrentDirectory() + File.separator + chooser.getSelectedFile().getName();
            return this.save(engine);
        }
        return "";
    }

    private class PrologFileFilter
    extends FileFilter {
        PrologFileFilter() {
        }

        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null && (extension.equals("pl") || extension.equals("pro"))) {
                    return true;
                }
            }
            return false;
        }

        private String getExtension(File f) {
            String filename;
            int i;
            if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                return filename.substring(i + 1).toLowerCase();
            }
            return null;
        }

        public String getDescription() {
            return "Prolog files (*.pro, *.pl)";
        }
    }
}

