/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprologx.ide.EngineRunningException;
import alice.tuprologx.ide.LibraryManager;
import alice.util.thinlet.Thinlet;
import java.awt.Container;
import java.awt.Window;

public class LibraryDialog
extends Thinlet {
    private LibraryManager libraryManager;

    public LibraryDialog() {
        try {
            this.add(this.parse("xml/LibraryDialog.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.libraryManager = LibraryManager.getInstance();
        this.displayLibraryManagerStatus();
    }

    private void displayLibraryManagerStatus() {
        Object[] libraries = this.libraryManager.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            this.createTextField(libraries[i]);
            this.createComboBox(libraries[i]);
            ++i;
        }
    }

    private void createTextField(Object library) {
        Object textfield = this.create("textfield");
        this.add(this.find("librariesDisplay"), textfield, 0);
        String libraryClassname = library.toString();
        String libraryName = libraryClassname.substring(libraryClassname.lastIndexOf(46) + 1, libraryClassname.length());
        this.setString(textfield, "text", libraryName);
        this.setInteger(textfield, "weightx", 90);
    }

    private void createComboBox(Object library) {
        Object combobox = this.create("combobox");
        this.add(this.find("librariesDisplay"), combobox, 1);
        this.setBoolean(combobox, "editable", false);
        Object choiceLoaded = this.create("choice");
        this.add(combobox, choiceLoaded, 0);
        this.setString(choiceLoaded, "text", "Loaded");
        Object choiceUnloaded = this.create("choice");
        this.add(combobox, choiceUnloaded, 1);
        this.setString(choiceUnloaded, "text", "Unloaded");
        try {
            boolean selected = this.libraryManager.isLibraryLoaded(library.toString());
            this.setInteger(combobox, "selected", selected ? 0 : 1);
            this.setInteger(combobox, "weightx", 10);
        }
        catch (EngineRunningException e) {
            this.setStatusMessage("Error loading library: " + e.getMessage());
        }
    }

    private void setStatusMessage(String message) {
        this.setString(this.find("statusTextField"), "text", message);
    }

    public void addLibrary(String libraryClassname) {
        try {
            this.libraryManager.addLibrary(libraryClassname);
            this.removeAll(this.find("librariesDisplay"));
            this.displayLibraryManagerStatus();
            this.setStatusMessage("Ready.");
        }
        catch (ClassNotFoundException e) {
            this.setStatusMessage(String.valueOf(libraryClassname) + ": Class Not Found");
        }
        catch (InvalidLibraryException e) {
            this.setStatusMessage(String.valueOf(libraryClassname) + ": Not a Library");
        }
    }

    public void setLibraryManagerStatus() {
        Object[] items = this.getItems(this.find("librariesDisplay"));
        Object[] libraries = this.libraryManager.getLibraries();
        int i = 0;
        while (i < items.length) {
            String libraryClassname = libraries[i / 2].toString();
            String library = this.getString(items[items.length - i - 2], "text");
            String status = this.getString(items[items.length - i - 1], "text");
            try {
                if (status.equals("Loaded")) {
                    this.libraryManager.loadLibrary(libraryClassname);
                }
                if (status.equals("Unloaded")) {
                    this.libraryManager.unloadLibrary(libraryClassname);
                }
                this.closeLibraryDialog();
            }
            catch (InvalidLibraryException e) {
                this.setStatusMessage(e.getMessage());
            }
            catch (EngineRunningException e) {
                this.setStatusMessage("Failed: " + e.getMessage());
            }
            i += 2;
        }
    }

    public void closeLibraryDialog() {
        Container c = this.getParent();
        while (!(c instanceof Window)) {
            c = c.getParent();
        }
        ((Window)c).dispose();
    }
}

