/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.util.jedit.KeywordMap;
import alice.util.jedit.TokenMarker;
import javax.swing.text.Segment;

public class PrologTokenMarker
extends TokenMarker {
    private static KeywordMap libraryKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public PrologTokenMarker() {
        this(true, PrologTokenMarker.getKeywords());
    }

    public PrologTokenMarker(boolean cpp, KeywordMap keywords) {
        this.cpp = cpp;
        this.keywords = keywords;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block20: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        block6 : switch (c) {
                            case '%': {
                                if (backslash) {
                                    backslash = false;
                                }
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token);
                                this.addToken(length - i, (byte)1);
                                this.lastOffset = this.lastKeyword = length;
                                break block20;
                            }
                            case '\"': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)3;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '\'': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)3;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '[': {
                                this.doKeyword(line, i, c);
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '/': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (length - i <= 1) break block0;
                                switch (array[i1]) {
                                    case '*': {
                                        this.addToken(i - this.lastOffset, token);
                                        this.lastOffset = this.lastKeyword = i;
                                        if (length - i > 2 && array[i + 2] == '*') {
                                            token = (byte)2;
                                            break block6;
                                        }
                                        token = 1;
                                    }
                                }
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_' || c == '!') break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        backslash = false;
                        if (c != '*' || length - i <= 1 || array[i1] != '/') break;
                        this.addToken(++i + 1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i + 1;
                        break;
                    }
                    case 3: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c == '\"') {
                            this.addToken(i1 - this.lastOffset, token);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != ']') break;
                        this.addToken(i1 - this.lastOffset, (byte)4);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (libraryKeywords == null) {
            libraryKeywords = new KeywordMap(false);
            libraryKeywords.add("abolish", (byte)7);
            libraryKeywords.add("add_theory", (byte)7);
            libraryKeywords.add("agent", (byte)7);
            libraryKeywords.add("arg", (byte)7);
            libraryKeywords.add("append", (byte)7);
            libraryKeywords.add("assert", (byte)7);
            libraryKeywords.add("asserta", (byte)7);
            libraryKeywords.add("assertz", (byte)7);
            libraryKeywords.add("atom", (byte)7);
            libraryKeywords.add("atomic", (byte)7);
            libraryKeywords.add("bagof", (byte)7);
            libraryKeywords.add("call", (byte)7);
            libraryKeywords.add("clause", (byte)7);
            libraryKeywords.add("compound", (byte)7);
            libraryKeywords.add("constant", (byte)7);
            libraryKeywords.add("copy_term", (byte)7);
            libraryKeywords.add("current_op", (byte)7);
            libraryKeywords.add("current_prolog_flag", (byte)7);
            libraryKeywords.add("delete", (byte)7);
            libraryKeywords.add("element", (byte)7);
            libraryKeywords.add("findall", (byte)7);
            libraryKeywords.add("float", (byte)7);
            libraryKeywords.add("functor", (byte)7);
            libraryKeywords.add("get_theory", (byte)7);
            libraryKeywords.add("ground", (byte)7);
            libraryKeywords.add("integer", (byte)7);
            libraryKeywords.add("length", (byte)7);
            libraryKeywords.add("list", (byte)7);
            libraryKeywords.add("member", (byte)7);
            libraryKeywords.add("nonvar", (byte)7);
            libraryKeywords.add("nospy", (byte)6);
            libraryKeywords.add("not", (byte)7);
            libraryKeywords.add("num_atom", (byte)7);
            libraryKeywords.add("number", (byte)7);
            libraryKeywords.add("once", (byte)7);
            libraryKeywords.add("quicksort", (byte)7);
            libraryKeywords.add("repeat", (byte)6);
            libraryKeywords.add("retract", (byte)7);
            libraryKeywords.add("retract_bt", (byte)7);
            libraryKeywords.add("retract_nb", (byte)7);
            libraryKeywords.add("reverse", (byte)7);
            libraryKeywords.add("set_prolog_flag", (byte)7);
            libraryKeywords.add("set_theory", (byte)7);
            libraryKeywords.add("setof", (byte)7);
            libraryKeywords.add("spy", (byte)7);
            libraryKeywords.add("text_concat", (byte)7);
            libraryKeywords.add("text_term", (byte)7);
            libraryKeywords.add("unify_with_occurs_check", (byte)7);
            libraryKeywords.add("var", (byte)7);
            libraryKeywords.add("atom_length", (byte)7);
            libraryKeywords.add("atom_chars", (byte)7);
            libraryKeywords.add("atom_codes", (byte)7);
            libraryKeywords.add("atom_concat", (byte)7);
            libraryKeywords.add("bound", (byte)7);
            libraryKeywords.add("char_code", (byte)7);
            libraryKeywords.add("number_chars", (byte)7);
            libraryKeywords.add("number_codes", (byte)7);
            libraryKeywords.add("sub_atom", (byte)7);
            libraryKeywords.add("abs", (byte)7);
            libraryKeywords.add("atan", (byte)7);
            libraryKeywords.add("ceiling", (byte)7);
            libraryKeywords.add("cos", (byte)7);
            libraryKeywords.add("div", (byte)7);
            libraryKeywords.add("exp", (byte)7);
            libraryKeywords.add("float_fractional_part", (byte)7);
            libraryKeywords.add("float_integer_part", (byte)7);
            libraryKeywords.add("floor", (byte)7);
            libraryKeywords.add("log", (byte)7);
            libraryKeywords.add("mod", (byte)7);
            libraryKeywords.add("rem", (byte)7);
            libraryKeywords.add("round", (byte)7);
            libraryKeywords.add("sign", (byte)7);
            libraryKeywords.add("sin", (byte)7);
            libraryKeywords.add("sqrt", (byte)7);
            libraryKeywords.add("truncate", (byte)7);
            libraryKeywords.add("agent_file", (byte)7);
            libraryKeywords.add("consult", (byte)7);
            libraryKeywords.add("get", (byte)7);
            libraryKeywords.add("get0", (byte)7);
            libraryKeywords.add("nl", (byte)6);
            libraryKeywords.add("put", (byte)7);
            libraryKeywords.add("rand_float", (byte)7);
            libraryKeywords.add("rand_int", (byte)7);
            libraryKeywords.add("read", (byte)7);
            libraryKeywords.add("see", (byte)7);
            libraryKeywords.add("seeing", (byte)7);
            libraryKeywords.add("seen", (byte)6);
            libraryKeywords.add("solve_file", (byte)7);
            libraryKeywords.add("tab", (byte)7);
            libraryKeywords.add("tell", (byte)7);
            libraryKeywords.add("telling", (byte)7);
            libraryKeywords.add("text_from_file", (byte)7);
            libraryKeywords.add("told", (byte)6);
            libraryKeywords.add("write", (byte)7);
            libraryKeywords.add("as", (byte)7);
            libraryKeywords.add("destroy_object", (byte)7);
            libraryKeywords.add("java_array_get", (byte)7);
            libraryKeywords.add("java_array_get_boolean", (byte)7);
            libraryKeywords.add("java_array_get_byte", (byte)7);
            libraryKeywords.add("java_array_get_char", (byte)7);
            libraryKeywords.add("java_array_get_double", (byte)7);
            libraryKeywords.add("java_array_get_float", (byte)7);
            libraryKeywords.add("java_array_get_int", (byte)7);
            libraryKeywords.add("java_array_get_long", (byte)7);
            libraryKeywords.add("java_array_get_short", (byte)7);
            libraryKeywords.add("java_array_length", (byte)7);
            libraryKeywords.add("java_array_set", (byte)7);
            libraryKeywords.add("java_array_set_boolean", (byte)7);
            libraryKeywords.add("java_array_set_byte", (byte)7);
            libraryKeywords.add("java_array_set_char", (byte)7);
            libraryKeywords.add("java_array_set_double", (byte)7);
            libraryKeywords.add("java_array_set_float", (byte)7);
            libraryKeywords.add("java_array_set_int", (byte)7);
            libraryKeywords.add("java_array_set_long", (byte)7);
            libraryKeywords.add("java_array_set_short", (byte)7);
            libraryKeywords.add("java_call", (byte)7);
            libraryKeywords.add("java_class", (byte)7);
            libraryKeywords.add("java_object", (byte)7);
            libraryKeywords.add("java_object_bt", (byte)7);
            libraryKeywords.add("java_object_nb", (byte)7);
            libraryKeywords.add("java_object_string", (byte)7);
            libraryKeywords.add("returns", (byte)7);
            libraryKeywords.add("!", (byte)6);
            libraryKeywords.add("at_the_end_of_stream", (byte)6);
            libraryKeywords.add("fail", (byte)6);
            libraryKeywords.add("halt", (byte)6);
            libraryKeywords.add("is", (byte)6);
            libraryKeywords.add("true", (byte)6);
            libraryKeywords.add("_", (byte)8);
        }
        return libraryKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

