/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprologx.ide.FrameLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SwingFrameLauncher
implements FrameLauncher {
    private String iconPathName = "";

    public void launchFrame(Component content) {
        this.launchFrame(content, "Frame", 0, 0);
    }

    public void launchFrame(Component content, String title, int width, int height) {
        final JFrame f = new JFrame(title);
        Container c = f.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(content, "Center");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                f.dispose();
            }
        });
        if (this.iconPathName != "") {
            ImageIcon icon = new ImageIcon(this.getClass().getResource(this.getFrameIcon()));
            f.setIconImage(icon.getImage());
        }
        f.pack();
        if (width > 0 && height > 0) {
            Insets insets = f.getInsets();
            width += insets.left + insets.right;
            height += insets.top + insets.bottom;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            width = Math.min(width, screenSize.width);
            height = Math.min(height, screenSize.height);
            f.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        }
        f.setVisible(true);
    }

    public void setFrameIcon(String imagePathName) {
        this.iconPathName = imagePathName;
    }

    public String getFrameIcon() {
        return this.iconPathName;
    }
}

