/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.NoSolutionException;
import alice.tuprolog.OutputEvent;
import alice.tuprolog.OutputListener;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.EngineRunningException;
import alice.tuprologx.ide.EngineStatus;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.InputField;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Observable;
import java.util.Observer;

public class ThinletConsole
extends Thinlet
implements OutputListener,
Observer {
    private EngineThread engine;
    private IDE ide;
    private InputField inputField;
    private String statusMessage;
    private PropertyChangeSupport propertyChangeSupport;

    public ThinletConsole(IDE ide) {
        try {
            this.add(this.parse("xml/ThinletConsole.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ide = ide;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void solve() {
        if (!this.ide.isFeededTheory()) {
            try {
                this.getEngine().setTheory(new Theory(this.ide.getEditorContent()));
            }
            catch (InvalidTheoryException e) {
                this.showSolution("error reading theory.");
                this.setStatusMessage("Error setting theory: Syntax Error at/before line " + e.line);
            }
            catch (EngineRunningException e) {
                this.setStatusMessage("Error setting theory: " + e.getMessage());
            }
        }
        this.enableStopButton(true);
        this.getEngine().addObserver(this);
        this.getEngine().setGoal(this.getGoal());
        new Thread(this.getEngine()).start();
        this.setStatusMessage("Solving...");
    }

    public EngineThread getEngine() {
        return this.engine;
    }

    public void setEngine(EngineThread engine) {
        this.engine = engine;
    }

    public void setInputField(InputField inputField) {
        this.inputField = inputField;
        this.inputField.setConsole(this);
    }

    public void setStatusMessage(String message) {
        String oldStatusMessage = this.getStatusMessage();
        this.statusMessage = message;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", oldStatusMessage, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected String getGoal() {
        return this.inputField.getGoal();
    }

    protected void showSolution(String solution) {
        Object solutionArea = this.find("solutionArea");
        this.setString(solutionArea, "text", solution);
    }

    protected void enableSolutionCommands(boolean flag) {
        Object nextButton = this.find("nextButton");
        this.setBoolean(nextButton, "enabled", flag);
        Object acceptButton = this.find("acceptButton");
        this.setBoolean(acceptButton, "enabled", flag);
    }

    protected void enableStopButton(boolean flag) {
        Object stopButton = this.find("stopButton");
        this.setBoolean(stopButton, "enabled", flag);
    }

    protected void enableSolveCommands(boolean flag) {
        this.inputField.enableSolveCommands(flag);
    }

    public void getNextSolution() {
        this.enableStopButton(true);
        this.enableSolutionCommands(false);
        this.showSolution("");
        this.setStatusMessage("Solving...");
        this.engine.nextSolution();
    }

    public void acceptSolution() {
        this.enableStopButton(false);
        this.enableSolutionCommands(false);
        this.enableSolveCommands(true);
        this.ide.enableTheoryCommands(true);
        this.engine.acceptSolution();
    }

    public void stopEngine() {
        this.engine.stopExcution();
        this.enableSolutionCommands(false);
        this.enableStopButton(false);
    }

    public void onOutput(OutputEvent event) {
        System.out.println(event.getMsg());
        Object outputArea = this.find("outputArea");
        String output = this.getString(outputArea, "text");
        this.setString(outputArea, "text", String.valueOf(output) + event.getMsg());
    }

    public void update(Observable arg0, Object arg1) {
        this.enableStopButton(false);
        this.enableSolutionCommands(true);
        try {
            EngineStatus status = (EngineStatus)arg1;
            if (status.getError() != null) {
                this.showSolution("Error: " + status.getError());
                this.setStatusMessage("Ready.");
                this.enableSolutionCommands(false);
            } else if (status.getInfo() != null) {
                if (status.getInfo().isSuccess()) {
                    String binds = status.getInfo().toString();
                    String append = "";
                    if (!status.hasAlternatives()) {
                        this.enableSolutionCommands(false);
                        if (status.isAccepted()) {
                            this.setStatusMessage("Ready.");
                        } else {
                            this.setStatusMessage("No more solutions found.");
                        }
                    } else {
                        this.enableSolutionCommands(true);
                        if (status.isFirstSolution()) {
                            this.setStatusMessage("Found a solution (open alternatives can be explored).");
                        } else {
                            this.setStatusMessage("Found another solution (open alternatives can be explored).");
                        }
                        append = "?";
                    }
                    if (binds.equals("")) {
                        this.showSolution("yes.\nSolution: " + status.getInfo().getSolution() + append);
                    } else {
                        this.showSolution("yes.\nSolution: " + binds + "\n" + status.getInfo().getSolution() + append);
                    }
                } else {
                    this.showSolution("no.");
                    this.enableSolutionCommands(false);
                    this.setStatusMessage("Ready.");
                }
            }
        }
        catch (NoSolutionException e) {
            this.showSolution("generic error. " + e.getMessage());
            this.setStatusMessage("Ready.");
        }
    }
}

