/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.EngineRunningException;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.TheoryEditArea;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ThinletTheoryEditor
extends Thinlet
implements PropertyChangeListener {
    private EngineThread engine;
    private TheoryEditArea editArea;
    private String statusMessage;
    private PropertyChangeSupport propertyChangeSupport;

    public ThinletTheoryEditor() {
        try {
            this.add(this.parse("xml/ThinletTheoryEditor.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public EngineThread getEngine() {
        return this.engine;
    }

    public void setEngine(EngineThread engine) {
        this.engine = engine;
    }

    public void setStatusMessage(String message) {
        String oldStatusMessage = this.getStatusMessage();
        this.statusMessage = message;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", oldStatusMessage, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setEditArea(TheoryEditArea editArea) {
        this.editArea = editArea;
    }

    public void setEngineTheory() {
        String theory = this.editArea.getTheory();
        try {
            this.getEngine().setTheory(new Theory(theory));
            this.editArea.setDirty(false);
            this.setStatusMessage("New theory accepted.");
        }
        catch (InvalidTheoryException ite) {
            this.setStatusMessage("Error setting theory: Syntax Error at/before line " + ite.line);
        }
        catch (EngineRunningException e) {
            this.setStatusMessage("Error setting theory: " + e.getMessage());
        }
    }

    public void getEngineTheory() {
        try {
            this.editArea.setTheory(this.engine.getTheory().toString());
        }
        catch (EngineRunningException e) {
            this.setStatusMessage(e.getMessage());
        }
        this.setStatusMessage("Engine theory displayed.");
    }

    public void undo() {
        this.editArea.undoAction();
    }

    public void redo() {
        this.editArea.redoAction();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("caretLine")) {
            this.setCaretLine(event.getNewValue().toString());
        }
    }

    private void setCaretLine(String caretLine) {
        Object lineField = this.find("lineField");
        this.setString(lineField, "text", caretLine);
    }

    protected void enableTheoryCommands(boolean flag) {
        Object setTheoryButton = this.find("setTheoryButton");
        this.setBoolean(setTheoryButton, "enabled", flag);
        Object getTheoryButton = this.find("getTheoryButton");
        this.setBoolean(getTheoryButton, "enabled", flag);
    }
}

