/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.EngineRunningException;
import alice.tuprologx.ide.EngineThread;
import alice.tuprologx.ide.FrameLauncher;
import alice.tuprologx.ide.IOFileOperations;
import alice.tuprologx.ide.LibraryDialog;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ThinletToolBar
extends Thinlet {
    private EngineThread engine;
    private Thinlet debugArea;
    private LibraryDialog libraryDialog;
    private IOFileOperations fileManager;
    private FrameLauncher frameLauncher;
    private String statusMessage;
    private PropertyChangeSupport propertyChangeSupport;

    public ThinletToolBar() {
        try {
            this.add(this.parse("xml/ThinletToolBar.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public EngineThread getEngine() {
        return this.engine;
    }

    public void setEngine(EngineThread engine) {
        this.engine = engine;
    }

    public void setStatusMessage(String message) {
        String oldStatusMessage = this.getStatusMessage();
        this.statusMessage = message;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", oldStatusMessage, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setFileManager(IOFileOperations fileManager) {
        this.fileManager = fileManager;
    }

    public IOFileOperations getFileManager() {
        return this.fileManager;
    }

    public void setFrameLauncher(FrameLauncher frameLauncher) {
        this.frameLauncher = frameLauncher;
    }

    public FrameLauncher getFrameLauncher() {
        return this.frameLauncher;
    }

    protected void enableTheoryCommands(boolean flag) {
        Object newTheoryButton = this.find("newTheoryButton");
        this.setBoolean(newTheoryButton, "enabled", flag);
        Object loadTheoryButton = this.find("loadTheoryButton");
        this.setBoolean(loadTheoryButton, "enabled", flag);
        Object saveTheoryButton = this.find("saveTheoryButton");
        this.setBoolean(saveTheoryButton, "enabled", flag);
        Object saveTheoryAsButton = this.find("saveTheoryAsButton");
        this.setBoolean(saveTheoryAsButton, "enabled", flag);
        Object openLibraryManagerButton = this.find("openLibraryManagerButton");
        this.setBoolean(openLibraryManagerButton, "enabled", flag);
    }

    public void newTheory() {
        try {
            this.engine.clearTheory();
        }
        catch (EngineRunningException e) {
            this.setStatusMessage("Error clearing Theory: " + e.getMessage());
        }
        this.fileManager.resetDefaultTheoryFileName();
        this.setStatusMessage("Ready (new theory accepted).");
    }

    public void loadTheory() {
        this.setStatusMessage("Load Theory...");
        try {
            Theory theory = this.fileManager.loadTheory();
            if (theory != null) {
                this.engine.setTheory(theory);
                this.setStatusMessage("Ready (theory consulted).");
            } else {
                this.setStatusMessage("Ready.");
            }
        }
        catch (Exception e) {
            this.setStatusMessage("Error consulting theory.");
        }
    }

    public void saveTheory() {
        try {
            String theoryFileName = this.fileManager.saveTheory(this.engine);
            this.setStatusMessage("Theory saved to " + theoryFileName + ".");
        }
        catch (Exception exception) {
            this.setStatusMessage("Error saving theory.");
        }
    }

    public void saveTheoryAs() {
        this.setStatusMessage("Save Theory As...");
        try {
            String theoryFileName = this.fileManager.saveTheoryAs(this.engine);
            if (theoryFileName != "") {
                this.setStatusMessage("Theory saved to " + theoryFileName + ".");
            } else {
                this.setStatusMessage("Ready.");
            }
        }
        catch (Exception e) {
            this.setStatusMessage("Error saving theory.");
        }
    }

    public void openLibraryManager() {
        this.frameLauncher.launchFrame(this.libraryDialog, "Library Manager", 275, 250);
    }

    public void viewDebugInformation() {
        this.frameLauncher.launchFrame(this.debugArea, "Debug Information", 200, 300);
    }

    public void viewAboutInformation() {
        Thinlet aboutThinlet = new Thinlet();
        try {
            aboutThinlet.add(this.parse("xml/AboutDialog.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object tuPrologSystemLabel = aboutThinlet.find("tuPrologSystem");
        aboutThinlet.setString(tuPrologSystemLabel, "text", "tuProlog System version " + Prolog.getVersion());
        this.frameLauncher.launchFrame(aboutThinlet, "About tuProlog IDE", 270, 125);
    }

    public void setDebugArea(Thinlet debugArea) {
        this.debugArea = debugArea;
    }

    public Thinlet getDebugArea() {
        return this.debugArea;
    }

    public void setLibraryDialog(LibraryDialog libraryDialog) {
        this.libraryDialog = libraryDialog;
    }
}

