/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.corba;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.tuprologx.runtime.corba.SolveInfo;
import alice.tuprologx.runtime.corba._PrologImplBase;
import java.io.ByteArrayInputStream;

public class PrologImpl
extends _PrologImplBase {
    Prolog imp;

    public PrologImpl() {
        try {
            this.imp = new Prolog(new String[]{"alice.tuprolog.lib.MetaLibrary", "alice.tuprolog.lib.ISOLibrary"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrologImpl(String[] libs) throws InvalidLibraryException {
        this.imp = new Prolog(libs);
    }

    public void clearTheory() {
        this.imp.clearTheory();
    }

    public String getTheory() {
        Theory th = this.imp.getTheory();
        return th.toString();
    }

    public void setTheory(String st) {
        try {
            this.imp.setTheory(new Theory(new ByteArrayInputStream(st.getBytes())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SolveInfo solve(String g) {
        try {
            return PrologImpl.toSolveInfo(this.imp.solve(g));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasOpenAlternatives() {
        return this.imp.hasOpenAlternatives();
    }

    public SolveInfo solveNext() {
        try {
            return PrologImpl.toSolveInfo(this.imp.solveNext());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void solveHalt() {
        this.imp.solveHalt();
    }

    public void solveEnd() {
        this.imp.solveEnd();
    }

    public void loadLibrary(String className) {
        try {
            this.imp.loadLibrary(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unloadLibrary(String className) {
        try {
            this.imp.unloadLibrary(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static SolveInfo toSolveInfo(alice.tuprolog.SolveInfo info) {
        try {
            SolveInfo cinfo = new SolveInfo();
            cinfo.success = info.isSuccess();
            cinfo.solution = info.isSuccess() ? info.getSolution().toString() : "";
            return cinfo;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

