/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.tcp;

import alice.tuprolog.Prolog;
import alice.tuprologx.runtime.tcp.Acceptor;
import alice.tuprologx.runtime.tcp.PrologImpl;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class Daemon
implements Runnable {
    public static int DEFAULT_PORT = 3203;
    ServerSocket s;
    Prolog core;
    PrologImpl coreTCP;

    public Daemon(Prolog core_) throws IOException {
        this.core = core_;
        this.coreTCP = new PrologImpl(this.core);
        this.initCore(DEFAULT_PORT);
    }

    public Daemon(Prolog core_, int port) throws IOException {
        this.core = core_;
        this.coreTCP = new PrologImpl(this.core);
        this.initCore(port);
    }

    private void initCore(int port) throws IOException {
        this.s = new ServerSocket(port);
    }

    public void run() {
        System.out.println("prolog TCP daemon start.");
        while (true) {
            try {
                Socket socket = this.s.accept();
                System.out.println("[ UserAcceptor ] accept new user.");
                Thread th = new Thread(new Acceptor(socket, this.coreTCP));
                th.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[ UserAcceptor ] end.");
                return;
            }
        }
    }

    public static void main(String[] args) {
        block6: {
            try {
                if (args.length != 0 && args.length != 1) {
                    System.err.println("args: { port }.");
                    System.exit(-1);
                }
                Prolog core = new Prolog();
                if (args.length > 0) {
                    int port = -1;
                    try {
                        port = Integer.parseInt(args[0]);
                    }
                    catch (Exception ex) {
                        System.err.println("args: { port }.");
                        System.exit(-1);
                    }
                    new Thread(new Daemon(core, port)).start();
                    break block6;
                }
                new Thread(new Daemon(core)).start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

