/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.runtime.tcp;

import alice.tuprolog.InvalidLibraryException;
import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.NoMoreSolutionException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import alice.tuprolog.Term;
import alice.tuprolog.Theory;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PrologImpl
implements Serializable {
    Prolog core;

    public PrologImpl(Prolog core_) {
        this.core = core_;
    }

    public void clearTheory(ObjectInputStream in, ObjectOutputStream out) {
        this.core.clearTheory();
    }

    public void getTheory(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        Theory th = this.core.getTheory();
        out.writeObject(new Boolean(false));
        out.writeObject(th);
    }

    public void setTheory(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            Theory th = (Theory)in.readObject();
            this.core.setTheory(th);
            out.writeObject(new Boolean(true));
        }
        catch (InvalidTheoryException ex) {
            out.writeObject(new Boolean(false));
        }
    }

    public void addTheory(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            Theory th = (Theory)in.readObject();
            this.core.addTheory(th);
            out.writeObject(new Boolean(true));
        }
        catch (InvalidTheoryException ex) {
            out.writeObject(new Boolean(false));
        }
    }

    public void solveString(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            String st = (String)in.readObject();
            SolveInfo info = this.core.solve(st);
            out.writeObject(new Boolean(true));
            out.writeObject(info);
        }
        catch (MalformedGoalException ex) {
            out.writeObject(new Boolean(false));
        }
    }

    public void hasOpenAlternatives(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        out.writeObject(new Boolean(this.core.hasOpenAlternatives()));
    }

    public void solveTerm(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        Term th = (Term)in.readObject();
        SolveInfo info = this.core.solve(th);
        out.writeObject(new Boolean(true));
        out.writeObject(info);
    }

    public void solveNext(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            SolveInfo info = this.core.solveNext();
            out.writeObject(new Boolean(true));
            out.writeObject(info);
        }
        catch (NoMoreSolutionException ex) {
            out.writeObject(new Boolean(false));
        }
    }

    public void solveHalt(ObjectInputStream in, ObjectOutputStream out) {
        this.core.solveHalt();
    }

    public void solveEnd(ObjectInputStream in, ObjectOutputStream out) {
        this.core.solveEnd();
    }

    public void loadLibrary(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            String st = (String)in.readObject();
            this.core.loadLibrary(st);
            out.writeObject(new Boolean(true));
        }
        catch (InvalidLibraryException ex) {
            out.writeObject(new Boolean(false));
        }
    }

    public void unloadLibrary(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        try {
            String st = (String)in.readObject();
            this.core.unloadLibrary(st);
            out.writeObject(new Boolean(true));
        }
        catch (InvalidLibraryException ex) {
            out.writeObject(new Boolean(false));
        }
    }
}

