/*
 * Decompiled with CFR 0.152.
 */
package alice.util;

import java.io.IOException;
import java.io.InputStream;

public class StringInputStream
extends InputStream {
    private String source;
    private int pos;
    private int line;

    public StringInputStream(String s) {
        this.source = s;
        this.pos = 0;
        this.line = 1;
    }

    public int read() throws IOException {
        if (this.pos < this.source.length()) {
            char c = this.source.charAt(this.pos);
            ++this.pos;
            if ((char)c == '\n') {
                ++this.line;
            }
            return c;
        }
        return -1;
    }

    public void reset() throws IOException {
        this.pos = 0;
        this.line = 1;
    }

    public void seek(int n) {
        this.pos = n;
        if (this.pos > this.source.length()) {
            this.pos = this.source.length();
        }
    }

    public int getCurrentPos() {
        return this.pos;
    }

    public int getCurrentLine() {
        return this.line;
    }
}

