/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

we_require('YERNA_LINDALE','prolog/pal').
%we_require('ASPICERE','weaving/joinpoints').
%next one is generated out of included modules and aspects
we_require('ASPICERE','layers/hyperprimitive').
we_require('ASPICERE','layers/primitive').
we_require('ASPICERE','layers/__modules_rules__').

:- load_library('be.ugent.ftw.intec.sel.lillambi.agents.TUPrologDOMXMLLibrary').

%act([XMLDocument,AdviceMap],[Advice,Jp,Bindings]):-
act([XMLDocument,AdviceMap],MatchList):-
	require_all,
	nospy,
	print('[joinpoints] Judging...'),
	nl,
	pal_first_element(XMLDocument, AspectCApp),
	%print('VOOR assert'),nl,	
	assert(xmldoc(AspectCApp)),
	assert(advicemap(AdviceMap)),
	%print('NA assert'),nl,
	findall(
		[Jp,Advice,Bindings],
		(match(Advice,Jp,Bindings),print('Found one: '),write(Advice),print(','),write(Jp),print(','),write(Bindings),nl),
		MatchList
	),
	print('Length: '),ourlength(MatchList,N),write(N),nl,
	print('Matches:'),nl,write(MatchList),nl
	.
