<?xml version="1.0"?> 
<!--
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Aspicere.
#
# The Initial Developer of the Original Code is
# the Software Engineering Lab, INTEC, University Ghent.
# Portions created by the Initial Developer are Copyright (C) 2004
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Bram Adams <bram.adams@ugent.be>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="text" indent="no"/>
  
<xsl:template match="/">
	<xsl:apply-templates select=".//NAdviceDef"/>
</xsl:template>
  
<xsl:template match="NAdviceDef">
match(<xsl:value-of select="normalize-space(NIdentifier[string(preceding-sibling::string)='around'])"/>,['<xsl:value-of select="normalize-space(NVariable)"/>',<xsl:value-of select="normalize-space(NVariable)"/>],[<xsl:apply-templates select="NVariableList"/>])<xsl:text> :- </xsl:text><xsl:apply-templates select="NPointcut"/><xsl:text>.</xsl:text>
</xsl:template>

<xsl:template match="NVariableList">
	<xsl:apply-templates select="NVariable"/>
</xsl:template>

<xsl:template match="NVariable">
	['<xsl:value-of select="normalize-space(.)"/>',<xsl:value-of select="normalize-space(.)"/>]<xsl:choose>
	  <xsl:when test="following-sibling::NVariable">
		<xsl:text>, </xsl:text>
	  </xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="NPointcut">
	(<xsl:apply-templates select="NOrPPC/NAndPPC"/><xsl:choose>
	  <xsl:when test="NOrPPC/NAndPPC/following-sibling::NRighthandOrPPC">
		<xsl:text>;
		</xsl:text>
	  </xsl:when>
	</xsl:choose>
	<xsl:apply-templates select="NOrPPC/NRighthandOrPPC"/>)
</xsl:template>

<xsl:template match="NRighthandOrPPC">
	<xsl:apply-templates select="NAndPPC"/><xsl:choose>
	  <xsl:when test="following-sibling::NRighthandOrPPC">
		<xsl:text>;
		</xsl:text>
	  </xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="NAndPPC">
	<xsl:apply-templates select="NUnaryPPC"/><xsl:choose>
	  <xsl:when test="NUnaryPPC/following-sibling::NRighthandAndPPC">
		<xsl:text>,
		</xsl:text>
	  </xsl:when>
	</xsl:choose>
	<xsl:apply-templates select="NRighthandAndPPC"/>
</xsl:template>

<xsl:template match="NRighthandAndPPC">	
	<xsl:apply-templates select="NUnaryPPC"/><xsl:choose>
	  <xsl:when test="following-sibling::NRighthandAndPPC">
		<xsl:text>,
		</xsl:text>
	  </xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="NUnaryPPC">
	<xsl:choose>
	  <xsl:when test="string/text()='!'">
		<xsl:text>\+</xsl:text>
	  </xsl:when>
	</xsl:choose>
	<xsl:choose>
	  <xsl:when test="NPrimitivePPC/NPointcut">
	  	<xsl:apply-templates select="NPrimitivePPC/NPointcut"/>
	  </xsl:when>
	  <xsl:otherwise>
	  	<xsl:apply-templates select="NPrimitivePPC/NGenericPPC"/>	  
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="NGenericPPC">	
	<xsl:value-of select="translate(normalize-space(string(.)),' ','')"/>
</xsl:template>

<!-- SOME TEMPLATE CODE
<xsl:template match="Family">
	Family is:  <xsl:value-of select="@Name"/>
	<xsl:apply-templates select="Species | SubFamily | text()"/>
</xsl:template>

<xsl:template match="SubFamily">
		SubFamily is <xsl:value-of select="@Name"/>
    <xsl:apply-templates select="Species | text()"/>
</xsl:template>

<xsl:template match="Species">
	<xsl:choose>
	  <xsl:when test="name(..)='SubFamily'">
		<xsl:text>	</xsl:text><xsl:value-of select="."/><xsl:text> </xsl:text><xsl:value-of select="@Scientific_Name"/>
	  </xsl:when>
	  <xsl:otherwise>
		<xsl:value-of select="."/><xsl:text> </xsl:text><xsl:value-of select="@Scientific_Name"/>
	  </xsl:otherwise>
	</xsl:choose>
</xsl:template>
-->
</xsl:stylesheet>
