/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

import java.io.*;

import antlr.*;


public class AspectCGram {
    public static void main (String[] args) {
        for (int i = 0; i < args.length; i++) {
            try {
                String programName = args[i];
                DataInputStream dis = null;
                if (programName.equals ("-")) {
                    dis = new DataInputStream (System.in);
                } else {
                    dis = new DataInputStream (
                            new FileInputStream (programName));
                }

                AspectCLexer lexer = new AspectCLexer (dis);
                lexer.setTokenObjectClass ("CToken");
                lexer.initialize ();

                // Parse the input expression.
                AspectCParser parser = new AspectCParser (lexer);
                parser.setAspectCLexer(lexer);

                // set AST node type to TNode or get nasty cast class errors
                parser.setASTNodeType (TNode.class.getName ());
                TNode.setTokenVocabulary ("AspectCTokenTypes");

                // QUICK FIX
                TNode node = new TNode ();
                node.setType (GNUCTokenTypes.LITERAL_typedef);
		TNode parentNode=new TNode();
		parentNode.addChild(node);
                parser.symbolTable.add ("__builtin_va_list", parentNode);

                // QUICK FIX
                node = new TNode ();
                node.setType (GNUCTokenTypes.LITERAL_typedef);
		parentNode=new TNode();
		parentNode.addChild(node);
                parser.symbolTable.add ("_Bool", parentNode);

                // invoke parser
                try {
                    parser.translationUnit ();
                } catch (RecognitionException e) {
                    System.err.println ("Fatal IO error:\n" + e);
                    System.exit (1);
                } catch (TokenStreamException e) {
                    System.err.println ("Fatal IO error:\n" + e);
                    System.exit (1);
                }

                // Garbage collection hint
                System.gc ();

                //      System.out.println(lexer.getPreprocessorInfoChannel());
                //    TNode.printTree(parser.getAST()); System.out.flush();

                // Garbage collection hint
                System.gc ();

                // GnuCEmitter e = new
                // GnuCEmitter(lexer.getPreprocessorInfoChannel());

                // set AST node type to TNode or get nasty cast class errors
                // e.setASTNodeType(TNode.class.getName());

                TNode ast = (TNode) parser.getAST ();

                //ASTFrame frame = new ASTFrame ("AST", ast);
                //frame.setVisible (true);

                // walk that tree
                // e.translationUnit( ast );
                Writer out = new OutputStreamWriter (System.out);
                ast.xmlSerialize (out);
                out.flush ();
                //System.err.println ("AST:" + ast.toStringList ());

                // Garbage collection hint
                System.gc ();

            } catch (Exception e) {
                System.err.println ("exception: " + e);
                e.printStackTrace ();
            }
        }
    }
}

