// ***** BEGIN LICENSE BLOCK *****
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is Aspicere.
//
// The Initial Developer of the Original Code is
// the Software Engineering Lab, INTEC, University Ghent.
// Portions created by the Initial Developer are Copyright (C) 2004
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//   Kris De Schutter <kris.deschutter@ugent.be>
//   Bram Adams <bram.adams@ugent.be>
//
// Alternatively, the contents of this file may be used under the terms of
// either the GNU General Public License Version 2 or later (the "GPL"), or
// the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// ***** END LICENSE BLOCK *****
  
{
import java.io.*;

import antlr.CommonAST;
import antlr.DumpASTVisitor;
}

           
class AspectCParser extends GnuCParser;

options
        {
        k = 2;
        exportVocab = AspectC;
        //importVocab = GNUC;
        buildAST = true;
        ASTLabelType = "TNode";

        // Copied following options from java grammar.
        codeGenMakeSwitchThreshold = 2;
        codeGenBitsetTestThreshold = 3;
        }

tokens {
  NGarbage;
  NNonHeaderFile;
  NHeaderFile;
  NLineDirective;
  NAdviceDef;
  NPointcut;
  NVariableList;
  NVariable;
  NPrimitivePPC;
  NGenericPPC;
  NRIList;
  NList;
  NRegexp;
  NUnaryPPC;
  NAndPPC;
  NOrPPC;
  NRighthandOrPPC;
  NRighthandAndPPC;
}

{
    // Support C++-style single-line comments?
    public static boolean CPPComments = true;

    // access to symbol table
    public CSymbolTable symbolTable = new CSymbolTable();

    // source for names to unnamed scopes
    protected int unnamedScopeCounter = 0;

    public boolean isTypedefName(String name) {
      boolean returnValue = false;
      TNode node = symbolTable.lookupNameInCurrentScope(name);
      if (node == null) return returnValue;
      node = (TNode) node.getFirstChild ();
      for (; node != null; node = (TNode) node.getNextSibling() ) {
        if(node.getType() == LITERAL_typedef) {
            returnValue = true;
            break;
        }
      }
      return returnValue;
    }


    public String getAScopeName() {
      return "" + (unnamedScopeCounter++);
    }

    public void pushScope(String scopeName) {
      symbolTable.pushScope(scopeName);
    }

    public void popScope() {
      symbolTable.popScope();
    }

        int traceDepth = 0;
        public void reportError(RecognitionException ex) {
          try {
            System.err.println("ANTLR Parsing Error: "+ex + " token name:" + tokenNames[LA(1)]);
            ex.printStackTrace(System.err);
          }
	  catch (TokenStreamException e) {
            System.err.println("ANTLR Parsing Error: "+ex);
            ex.printStackTrace(System.err);              
          }
        }
        public void reportError(String s) {
            System.err.println("ANTLR Parsing Error from String: " + s);
        }
        public void reportWarning(String s) {
            System.err.println("ANTLR Parsing Warning from String: " + s);
        }
        public void match(int t) throws MismatchedTokenException {
          boolean debugging = false;
          
          if ( debugging ) {
           for (int x=0; x<traceDepth; x++) System.out.print(" ");
           try {
            System.out.println("Match("+tokenNames[t]+") with LA(1)="+
                tokenNames[LA(1)] + ((inputState.guessing>0)?" [inputState.guessing "+ inputState.guessing + "]":""));
           }
           catch (TokenStreamException e) {
            System.out.println("Match("+tokenNames[t]+") " + ((inputState.guessing>0)?" [inputState.guessing "+ inputState.guessing + "]":""));

           }
    
          }
          try {
            if ( LA(1)!=t ) {
                if ( debugging ){
                    for (int x=0; x<traceDepth; x++) System.out.print(" ");
                    System.out.println("token mismatch: "+tokenNames[LA(1)]
                                + "!="+tokenNames[t]);
                }
	        throw new MismatchedTokenException(tokenNames, LT(1), t, false, getFilename());

            } else {
                // mark token as consumed -- fetch next token deferred until LA/LT
                consume();
            }
          }
          catch (TokenStreamException e) {
          }
    
        }
        public void traceIn(String rname) {
          traceDepth += 1;
          for (int x=0; x<traceDepth; x++) System.out.print(" ");
          try {
            System.out.println("> "+rname+"; LA(1)==("+ tokenNames[LT(1).getType()] 
                + ") " + LT(1).getText() + " [inputState.guessing "+ inputState.guessing + "]");
          }
          catch (TokenStreamException e) {
          }
        }
        public void traceOut(String rname) {
          for (int x=0; x<traceDepth; x++) System.out.print(" ");
          try {
            System.out.println("< "+rname+"; LA(1)==("+ tokenNames[LT(1).getType()] 
                + ") "+LT(1).getText() + " [inputState.guessing "+ inputState.guessing + "]");
          }
          catch (TokenStreamException e) {
          }
          traceDepth -= 1;
        }

  AspectCLexer lexer = null;
  java.util.List headers=new java.util.ArrayList();/*system headers have <>, others have ""*/
  boolean alreadyEncounteredLineDirectives=false;
  String currentHeader=null;
  int teller=0;


  public void setAspectCLexer (AspectCLexer lexer) {
    this.lexer = lexer;
  }

  int lastTokenNumberSeen = -1;

  private boolean hasPreprocessorInfo () {
    if (lexer == null) return false;
    int current = lexer.getCurrentTokenNumber ();
    if (current > lastTokenNumberSeen) {
      PreprocessorInfoChannel channel = lexer.getPreprocessorInfoChannel ();
      int lastTokenNumber = channel.getMaxTokenNumber ();
      if (lastTokenNumber <= lastTokenNumberSeen) {
//         System.out.println ("NO_1");
         return false;
      }
      lastTokenNumberSeen = lastTokenNumber;

      java.util.Vector vec=channel.extractLinesPrecedingTokenNumber(new Integer(current));

      if(vec.size()==0) { 
//        System.out.println ("NO_4");
        return false;
      }
      java.util.Iterator it=vec.iterator();

      boolean foundOne=false;
      while(it.hasNext()){
                Object obj=it.next();
                if(obj instanceof LineObject){
                    LineObject lineObj=(LineObject)obj;
                    if(!alreadyEncounteredLineDirectives){
//                        System.err.println("INIT:\t"+"\""+lineObj.getSource()+"\"");
                        alreadyEncounteredLineDirectives=true;
                        headers.add("\""+lineObj.getSource()+"\"");/*look for case where there are NO #include's*/
                        headers.add("\""+lineObj.getSource()+"\"");/*TWICE: the 1-case eats up the second; if there are no #include's, then the second one is harmless*/
                        foundOne=true;
                    }else if(lineObj.getEnteringFile()){
//                        System.err.println("INCR: "+(teller+1));
                        if(teller==0){
                            currentHeader=(lineObj.getSystemHeader())?"<"+lineObj.getSource()+">":"\""+lineObj.getSource()+"\"";
//                            System.err.println("\tNEW:\t"+currentHeader);
                            int size=headers.size();
                            if(size>0) headers.remove(size-1);/*"main.c" between #include's is unnecessary! */
                            headers.add(currentHeader);
                            foundOne=true;
                        }
                        teller++;                     
                    }else if(lineObj.getReturningToFile()){
                        teller--;
//                        System.err.println("DECR: "+teller);
                        if(teller==0){
//                            System.err.println("\tNEW:\t"+"\""+lineObj.getSource()+"\"");
                            headers.add("\""+lineObj.getSource()+"\"");
                            foundOne=true;
                        }
                    }
/*                    if((!lineObj.getEnteringFile())&&(!lineObj.getReturningToFile())&&(!lineObj.getSystemHeader())&&(!lineObj.getTreatAsC())){ //main file itself
                        headers.add("\""+lineObj.getSource()+"\"");
                        foundOne=true;
                    }

                    if(lineObj.getSystemHeader()) {
                        headers.add("<"+lineObj.getSource()+">");
                        foundOne=true;
                    }else{
                        headers.add("\""+lineObj.getSource()+"\"");
                        foundOne=true;                       
                    }*/
                }
      }
//      System.err.println("STOP");
//      if (foundOne) System.out.println ("Yes");
//      else System.out.println ("NO_3");
      return foundOne;
      

    } else {
//      System.out.println ("NO_2");
      return false;
    }
  }
}

externalDef
{ TNode directives = null; }
        :       { hasPreprocessorInfo()  }? { 
//                    System.out.println("> PREV:");
                    //TNode.printTree(##);
                    if(##!=null){
                        System.err.println("BAD");
                        ##.doubleLink();
                        TNode res=##;
                        java.util.Iterator it=headers.iterator();
                        while(it.hasNext()){
                            String header=(String)it.next();
                            //System.out.println(header);
                            TNode tmp=#(#[NGarbage],#[NGarbage,"/*"]);
                            tmp.addSibling(#(#[NGarbage],#[NGarbage,"*/"]));/*OMGEKEERDE volgorde toevoegen!!!*/
                            if(header.lastIndexOf(".h")!=-1){
                                tmp.addSibling(#(#[NHeaderFile],#[NHeaderFile,header]));
                            }else{
                                tmp.addSibling(#(#[NNonHeaderFile],#[NNonHeaderFile,header]));
                            }
                            
                            res=(TNode)res.addSibling(#(#[NLineDirective],tmp));
                        }
                    }else{
                        TNode res=null;
                        java.util.Iterator it=headers.iterator();
                        while(it.hasNext()){
                            String header=(String)it.next();
//                            System.out.println(header);
//                            TNode tmp=#[NGarbage,"/*"];
  //                          tmp.addSibling(#[NHeaderFile,header]);
    //                        tmp.addSibling(#[NGarbage,"*/"]);
                            TNode tmp=#(#[NGarbage],#[NGarbage,"/*"]);
                            tmp.addSibling(#(#[NGarbage],#[NGarbage,"*/"]));/*OMGEKEERDE volgorde toevoegen!!!*/
                            if(header.lastIndexOf(".h")!=-1){
                                tmp.addSibling(#(#[NHeaderFile],#[NHeaderFile,header]));
                            }else{
                                tmp.addSibling(#(#[NNonHeaderFile],#[NNonHeaderFile,header]));
                            }

                            if(res!=null){
                                res=(TNode)res.addSibling(#(#[NLineDirective],tmp));
//                                System.out.println("TMP:");
  //                              TNode.printTree(tmp);
                            }else{
                                res = directives=#(#[NLineDirective],tmp);
                            }
                        }
                        //##=res;
                    }
                    //##.doubleLink();
                    headers.clear(); 
  //                  System.out.println("<");
                } externalDefSub 
                { 
 //                 ##.doubleLink();
 //                 ##.addSibling(directives);
//                  System.out.println("AFTER:"); TNode.printTree(##);
  //                System.out.println("DIR:"); TNode.printTree(directives);
                  directives.getLastSibling().addSibling (##);
                  ## = directives;

                }
        |       externalDefSub
        ;

externalDefSub
        :       ( "typedef" | declaration )=> declaration
        |       ( advicePrefix )=> adviceDef
        |       ( functionPrefix )=> functionDef
        |       typelessDeclaration
        |       asm_expr
        |       SEMI
        ;

advicePrefix
  : ( (functionDeclSpecifiers) => ds:functionDeclSpecifiers
    | identifier
    |  //epsilon
    )
    ( pointerGroup )?               
    "around"
  ;
        
adviceDef
{ String declName = null; String tmp = null; }
  : ( (functionDeclSpecifiers) => ds:functionDeclSpecifiers
    |  tmp=rt:identifier { //declName = id.getText();
            AST d2, ds2;
            d2 = astFactory.dupList(#rt);
            ds2 = astFactory.dupList(
              #( #[NDeclarationSpecifiers], #[LITERAL_typedef,"typedef"])
            );
            symbolTable.add(tmp, #(null, ds2, d2));
            pushScope(tmp);
    }
    |  //epsilon
    )
    ( pointerGroup )?               

    "around"
    declName=id:identifier { //declName = id.getText();
            AST d2, ds2;
            d2 = astFactory.dupList(#id);
            ds2 = astFactory.dupList(#ds);
            symbolTable.add(declName, #(null, ds2, d2));
            pushScope(declName);
    }

    LPAREN ( variableList )? RPAREN
    "on" LPAREN variable RPAREN
    COLON pointcut
    { popScope();
      if (tmp != null)
        popScope ();
    }
    compoundStatement[declName]
      { ## = #( #[NAdviceDef], ##); }
  ;        

variable
  : identifier
      { ## = #( #[NVariable], ##); }
  ;
  
variableList
  : variable(COMMA variable)*
      { ## = #( #[NVariableList], ##); }
  ;
  
primitive_ppc
  : LPAREN pointcut RPAREN
      { ## = #( #[NPrimitivePPC], ##); }
  | generic_ppc
      { ## = #( #[NPrimitivePPC], ##); }
  ;
  
generic_ppc
  : identifier LPAREN (regexp_or_identifier_list)? RPAREN
      { ## = #( #[NGenericPPC], ##); }
  ;
  
regexp_or_identifier_list
  : regexp_or_identifier_or_list (COMMA regexp_or_identifier_or_list)*
      { ## = #( #[NRIList], ##); }
  ;
  
regexp_or_identifier_or_list  
  : list
  | regexp_or_identifier
  ;
  
list
  : LBRACKET (regexp_or_identifier_list)? ( BOR ( "_" | list) )? RBRACKET
      { ## = #( #[NList], ##); }
  ;
  
regexp_or_identifier
  : regular_expression
  | identifier
  | Number
  | "_"
  ;
  
regular_expression
  : StringLiteral
      { ## = #( #[NRegexp], ##); }
  ;
  
unary_ppc
  : LNOT primitive_ppc
      { ## = #( #[NUnaryPPC], ##); }
  | primitive_ppc
      { ## = #( #[NUnaryPPC], ##); }
  ;

and_ppc
  : unary_ppc (righthand_and_ppc)*
      { ## = #( #[NAndPPC], ##); }
  ;

righthand_and_ppc 
  : LAND unary_ppc 
      { ## = #( #[NRighthandAndPPC], ##); }
  ;
  
or_ppc
  : and_ppc (righthand_or_ppc)*
      { ## = #( #[NOrPPC], ##); }
  ;

righthand_or_ppc 
  : LOR and_ppc 
      { ## = #( #[NRighthandOrPPC], ##); }
  ;
   
pointcut
  : or_ppc
      { ## = #( #[NPointcut], ##); }
  ;


postfixExpr
  : proceed_call
  | primaryExpr ( 
      postfixSuffix {## = #( #[NPostfixExpr], ## );} 
    )?
  ;

proceed_call
  : "proceed" LPAREN RPAREN
  ;
  
  
/* ================================================================ */

{
        // import CToken;
        import java.io.*;
        // import LineObject;
        import antlr.*;
}

class AspectCLexer extends GnuCLexer;
options 
        {
        k = 3;
        importVocab = AspectC;
        testLiterals = false;
        }    

tokens {
        LITERAL___extension__ = "__extension__";
}

{
  public void initialize(String src)
  {
    setOriginalSource(src);
    initialize();
  }

  public void initialize() 
  {
    literals.put(new ANTLRHashString("__alignof__", this), new Integer(LITERAL___alignof));
    literals.put(new ANTLRHashString("__asm", this), new Integer(LITERAL_asm));
    literals.put(new ANTLRHashString("__asm__", this), new Integer(LITERAL_asm));
    literals.put(new ANTLRHashString("__attribute__", this), new Integer(LITERAL___attribute));
    literals.put(new ANTLRHashString("__complex__", this), new Integer(LITERAL___complex));
    literals.put(new ANTLRHashString("__const", this), new Integer(LITERAL_const));
    literals.put(new ANTLRHashString("__const__", this), new Integer(LITERAL_const));
    literals.put(new ANTLRHashString("__imag__", this), new Integer(LITERAL___imag));
    literals.put(new ANTLRHashString("__inline", this), new Integer(LITERAL_inline));
    literals.put(new ANTLRHashString("__inline__", this), new Integer(LITERAL_inline));
    literals.put(new ANTLRHashString("__real__", this), new Integer(LITERAL___real));
    literals.put(new ANTLRHashString("__signed", this), new Integer(LITERAL_signed));
    literals.put(new ANTLRHashString("__signed__", this), new Integer(LITERAL_signed));
    literals.put(new ANTLRHashString("__typeof", this), new Integer(LITERAL_typeof));
    literals.put(new ANTLRHashString("__typeof__", this), new Integer(LITERAL_typeof));
    literals.put(new ANTLRHashString("__volatile", this), new Integer(LITERAL_volatile));
    literals.put(new ANTLRHashString("__volatile__", this), new Integer(LITERAL_volatile));
  }

  LineObject lineObject = new LineObject();
  String originalSource = "";
  PreprocessorInfoChannel preprocessorInfoChannel = new PreprocessorInfoChannel();
  int tokenNumber = 0;
  boolean countingTokens = true;
  int deferredLineCount = 0;

  public void setCountingTokens(boolean ct) 
  {
    countingTokens = ct;
    if ( countingTokens ) {
      tokenNumber = 0;
    }
    else {
      tokenNumber = 1;
    }
  }

  public void setOriginalSource(String src) 
  {
    originalSource = src;
    lineObject.setSource(src);
  }
  public void setSource(String src) 
  {
    lineObject.setSource(src);
  }
  
  public PreprocessorInfoChannel getPreprocessorInfoChannel() 
  {
    return preprocessorInfoChannel;
  }

  public void setPreprocessingDirective(String pre)
  {
    preprocessorInfoChannel.addLineForTokenNumber( pre, new Integer(tokenNumber) );
  }
  
  protected Token makeToken(int t)
  {
    if ( t != Token.SKIP && countingTokens) {
        tokenNumber++;
    }
    CToken tok = (CToken) super.makeToken(t);
    tok.setLine(lineObject.line);
    tok.setSource(lineObject.source);
    tok.setTokenNumber(tokenNumber);

    lineObject.line += deferredLineCount;
    deferredLineCount = 0;
    return tok;
  }

    public void deferredNewline() { 
        deferredLineCount++;
    }

    public void newline() { 
        lineObject.newline();
    }



 public int getCurrentTokenNumber () { return tokenNumber; }


}



protected ID
        options 
                {
                testLiterals = true; 
                }
        :       ( 'a'..'z' | 'A'..'Z' | '_' | '$')
                ( 'a'..'z' | 'A'..'Z' | '_' | '$' | '0'..'9' )*
        ;
