{
import java.io.*;

import antlr.CommonAST;
import antlr.DumpASTVisitor;
}class AspectCParser extends Parser;

options {
	k= 2;
	exportVocab= AspectC;
	buildAST= true;
	ASTLabelType= "TNode";
	codeGenMakeSwitchThreshold= 2;
	codeGenBitsetTestThreshold= 3;
	importVocab=GNUC;
}

tokens {
  NGarbage;
  NNonHeaderFile;
  NHeaderFile;
  NLineDirective;
  NAdviceDef;
  NPointcut;
  NVariableList;
  NVariable;
  NPrimitivePPC;
  NGenericPPC;
  NRIList;
  NList;
  NRegexp;
  NUnaryPPC;
  NAndPPC;
  NOrPPC;
  NRighthandOrPPC;
  NRighthandAndPPC;
}
{
    // Support C++-style single-line comments?
    public static boolean CPPComments = true;

    // access to symbol table
    public CSymbolTable symbolTable = new CSymbolTable();

    // source for names to unnamed scopes
    protected int unnamedScopeCounter = 0;

    public boolean isTypedefName(String name) {
      boolean returnValue = false;
      TNode node = symbolTable.lookupNameInCurrentScope(name);
      if (node == null) return returnValue;
      node = (TNode) node.getFirstChild ();
      for (; node != null; node = (TNode) node.getNextSibling() ) {
        if(node.getType() == LITERAL_typedef) {
            returnValue = true;
            break;
        }
      }
      return returnValue;
    }


    public String getAScopeName() {
      return "" + (unnamedScopeCounter++);
    }

    public void pushScope(String scopeName) {
      symbolTable.pushScope(scopeName);
    }

    public void popScope() {
      symbolTable.popScope();
    }

        int traceDepth = 0;
        public void reportError(RecognitionException ex) {
          try {
            System.err.println("ANTLR Parsing Error: "+ex + " token name:" + tokenNames[LA(1)]);
            ex.printStackTrace(System.err);
          }
	  catch (TokenStreamException e) {
            System.err.println("ANTLR Parsing Error: "+ex);
            ex.printStackTrace(System.err);              
          }
        }
        public void reportError(String s) {
            System.err.println("ANTLR Parsing Error from String: " + s);
        }
        public void reportWarning(String s) {
            System.err.println("ANTLR Parsing Warning from String: " + s);
        }
        public void match(int t) throws MismatchedTokenException {
          boolean debugging = false;
          
          if ( debugging ) {
           for (int x=0; x<traceDepth; x++) System.out.print(" ");
           try {
            System.out.println("Match("+tokenNames[t]+") with LA(1)="+
                tokenNames[LA(1)] + ((inputState.guessing>0)?" [inputState.guessing "+ inputState.guessing + "]":""));
           }
           catch (TokenStreamException e) {
            System.out.println("Match("+tokenNames[t]+") " + ((inputState.guessing>0)?" [inputState.guessing "+ inputState.guessing + "]":""));

           }
    
          }
          try {
            if ( LA(1)!=t ) {
                if ( debugging ){
                    for (int x=0; x<traceDepth; x++) System.out.print(" ");
                    System.out.println("token mismatch: "+tokenNames[LA(1)]
                                + "!="+tokenNames[t]);
                }
	        throw new MismatchedTokenException(tokenNames, LT(1), t, false, getFilename());

            } else {
                // mark token as consumed -- fetch next token deferred until LA/LT
                consume();
            }
          }
          catch (TokenStreamException e) {
          }
    
        }
        public void traceIn(String rname) {
          traceDepth += 1;
          for (int x=0; x<traceDepth; x++) System.out.print(" ");
          try {
            System.out.println("> "+rname+"; LA(1)==("+ tokenNames[LT(1).getType()] 
                + ") " + LT(1).getText() + " [inputState.guessing "+ inputState.guessing + "]");
          }
          catch (TokenStreamException e) {
          }
        }
        public void traceOut(String rname) {
          for (int x=0; x<traceDepth; x++) System.out.print(" ");
          try {
            System.out.println("< "+rname+"; LA(1)==("+ tokenNames[LT(1).getType()] 
                + ") "+LT(1).getText() + " [inputState.guessing "+ inputState.guessing + "]");
          }
          catch (TokenStreamException e) {
          }
          traceDepth -= 1;
        }

  AspectCLexer lexer = null;
  java.util.List headers=new java.util.ArrayList();/*system headers have <>, others have ""*/
  boolean alreadyEncounteredLineDirectives=false;
  String currentHeader=null;
  int teller=0;


  public void setAspectCLexer (AspectCLexer lexer) {
    this.lexer = lexer;
  }

  int lastTokenNumberSeen = -1;

  private boolean hasPreprocessorInfo () {
    if (lexer == null) return false;
    int current = lexer.getCurrentTokenNumber ();
    if (current > lastTokenNumberSeen) {
      PreprocessorInfoChannel channel = lexer.getPreprocessorInfoChannel ();
      int lastTokenNumber = channel.getMaxTokenNumber ();
      if (lastTokenNumber <= lastTokenNumberSeen) {
//         System.out.println ("NO_1");
         return false;
      }
      lastTokenNumberSeen = lastTokenNumber;

      java.util.Vector vec=channel.extractLinesPrecedingTokenNumber(new Integer(current));

      if(vec.size()==0) { 
//        System.out.println ("NO_4");
        return false;
      }
      java.util.Iterator it=vec.iterator();

      boolean foundOne=false;
      while(it.hasNext()){
                Object obj=it.next();
                if(obj instanceof LineObject){
                    LineObject lineObj=(LineObject)obj;
                    if(!alreadyEncounteredLineDirectives){
//                        System.err.println("INIT:\t"+"\""+lineObj.getSource()+"\"");
                        alreadyEncounteredLineDirectives=true;
                        headers.add("\""+lineObj.getSource()+"\"");/*look for case where there are NO #include's*/
                        headers.add("\""+lineObj.getSource()+"\"");/*TWICE: the 1-case eats up the second; if there are no #include's, then the second one is harmless*/
                        foundOne=true;
                    }else if(lineObj.getEnteringFile()){
//                        System.err.println("INCR: "+(teller+1));
                        if(teller==0){
                            currentHeader=(lineObj.getSystemHeader())?"<"+lineObj.getSource()+">":"\""+lineObj.getSource()+"\"";
//                            System.err.println("\tNEW:\t"+currentHeader);
                            int size=headers.size();
                            if(size>0) headers.remove(size-1);/*"main.c" between #include's is unnecessary! */
                            headers.add(currentHeader);
                            foundOne=true;
                        }
                        teller++;                     
                    }else if(lineObj.getReturningToFile()){
                        teller--;
//                        System.err.println("DECR: "+teller);
                        if(teller==0){
//                            System.err.println("\tNEW:\t"+"\""+lineObj.getSource()+"\"");
                            headers.add("\""+lineObj.getSource()+"\"");
                            foundOne=true;
                        }
                    }
/*                    if((!lineObj.getEnteringFile())&&(!lineObj.getReturningToFile())&&(!lineObj.getSystemHeader())&&(!lineObj.getTreatAsC())){ //main file itself
                        headers.add("\""+lineObj.getSource()+"\"");
                        foundOne=true;
                    }

                    if(lineObj.getSystemHeader()) {
                        headers.add("<"+lineObj.getSource()+">");
                        foundOne=true;
                    }else{
                        headers.add("\""+lineObj.getSource()+"\"");
                        foundOne=true;                       
                    }*/
                }
      }
//      System.err.println("STOP");
//      if (foundOne) System.out.println ("Yes");
//      else System.out.println ("NO_3");
      return foundOne;
      

    } else {
//      System.out.println ("NO_2");
      return false;
    }
  }
}
externalDef { TNode directives = null; }
:{ hasPreprocessorInfo()  }? { 
//                    System.out.println("> PREV:");
                    //TNode.printTree(##);
                    if(##!=null){
                        System.err.println("BAD");
                        ##.doubleLink();
                        TNode res=##;
                        java.util.Iterator it=headers.iterator();
                        while(it.hasNext()){
                            String header=(String)it.next();
                            //System.out.println(header);
                            TNode tmp=#(#[NGarbage],#[NGarbage,"/*"]);
                            tmp.addSibling(#(#[NGarbage],#[NGarbage,"*/"]));/*OMGEKEERDE volgorde toevoegen!!!*/
                            if(header.lastIndexOf(".h")!=-1){
                                tmp.addSibling(#(#[NHeaderFile],#[NHeaderFile,header]));
                            }else{
                                tmp.addSibling(#(#[NNonHeaderFile],#[NNonHeaderFile,header]));
                            }
                            
                            res=(TNode)res.addSibling(#(#[NLineDirective],tmp));
                        }
                    }else{
                        TNode res=null;
                        java.util.Iterator it=headers.iterator();
                        while(it.hasNext()){
                            String header=(String)it.next();
//                            System.out.println(header);
//                            TNode tmp=#[NGarbage,"/*"];
  //                          tmp.addSibling(#[NHeaderFile,header]);
    //                        tmp.addSibling(#[NGarbage,"*/"]);
                            TNode tmp=#(#[NGarbage],#[NGarbage,"/*"]);
                            tmp.addSibling(#(#[NGarbage],#[NGarbage,"*/"]));/*OMGEKEERDE volgorde toevoegen!!!*/
                            if(header.lastIndexOf(".h")!=-1){
                                tmp.addSibling(#(#[NHeaderFile],#[NHeaderFile,header]));
                            }else{
                                tmp.addSibling(#(#[NNonHeaderFile],#[NNonHeaderFile,header]));
                            }

                            if(res!=null){
                                res=(TNode)res.addSibling(#(#[NLineDirective],tmp));
//                                System.out.println("TMP:");
  //                              TNode.printTree(tmp);
                            }else{
                                res = directives=#(#[NLineDirective],tmp);
                            }
                        }
                        //##=res;
                    }
                    //##.doubleLink();
                    headers.clear(); 
  //                  System.out.println("<");
                } externalDefSub 
                { 
 //                 ##.doubleLink();
 //                 ##.addSibling(directives);
//                  System.out.println("AFTER:"); TNode.printTree(##);
  //                System.out.println("DIR:"); TNode.printTree(directives);
                  directives.getLastSibling().addSibling (##);
                  ## = directives;

                }
        |       externalDefSub
        ;

externalDefSub :( "typedef" | declaration )=> declaration
        |       ( advicePrefix )=> adviceDef
        |       ( functionPrefix )=> functionDef
        |       typelessDeclaration
        |       asm_expr
        |       SEMI
        ;

advicePrefix :( (functionDeclSpecifiers) => ds:functionDeclSpecifiers
    | identifier
    |  //epsilon
    )
    ( pointerGroup )?               
    "around"
  ;

adviceDef { String declName = null; String tmp = null; }
:( (functionDeclSpecifiers) => ds:functionDeclSpecifiers
    |  tmp=rt:identifier { //declName = id.getText();
            AST d2, ds2;
            d2 = astFactory.dupList(#rt);
            ds2 = astFactory.dupList(
              #( #[NDeclarationSpecifiers], #[LITERAL_typedef,"typedef"])
            );
            symbolTable.add(tmp, #(null, ds2, d2));
            pushScope(tmp);
    }
    |  //epsilon
    )
    ( pointerGroup )?               

    "around"
    declName=id:identifier { //declName = id.getText();
            AST d2, ds2;
            d2 = astFactory.dupList(#id);
            ds2 = astFactory.dupList(#ds);
            symbolTable.add(declName, #(null, ds2, d2));
            pushScope(declName);
    }

    LPAREN ( variableList )? RPAREN
    "on" LPAREN variable RPAREN
    COLON pointcut
    { popScope();
      if (tmp != null)
        popScope ();
    }
    compoundStatement[declName]
      { ## = #( #[NAdviceDef], ##); }
  ;

variable :identifier
      { ## = #( #[NVariable], ##); }
  ;

variableList :variable(COMMA variable)*
      { ## = #( #[NVariableList], ##); }
  ;

primitive_ppc :LPAREN pointcut RPAREN
      { ## = #( #[NPrimitivePPC], ##); }
  | generic_ppc
      { ## = #( #[NPrimitivePPC], ##); }
  ;

generic_ppc :identifier LPAREN (regexp_or_identifier_list)? RPAREN
      { ## = #( #[NGenericPPC], ##); }
  ;

regexp_or_identifier_list :regexp_or_identifier_or_list (COMMA regexp_or_identifier_or_list)*
      { ## = #( #[NRIList], ##); }
  ;

regexp_or_identifier_or_list :list
  | regexp_or_identifier
  ;

list :LBRACKET (regexp_or_identifier_list)? ( BOR ( "_" | list) )? RBRACKET
      { ## = #( #[NList], ##); }
  ;

regexp_or_identifier :regular_expression
  | identifier
  | Number
  | "_"
  ;

regular_expression :StringLiteral
      { ## = #( #[NRegexp], ##); }
  ;

unary_ppc :LNOT primitive_ppc
      { ## = #( #[NUnaryPPC], ##); }
  | primitive_ppc
      { ## = #( #[NUnaryPPC], ##); }
  ;

and_ppc :unary_ppc (righthand_and_ppc)*
      { ## = #( #[NAndPPC], ##); }
  ;

righthand_and_ppc :LAND unary_ppc 
      { ## = #( #[NRighthandAndPPC], ##); }
  ;

or_ppc :and_ppc (righthand_or_ppc)*
      { ## = #( #[NOrPPC], ##); }
  ;

righthand_or_ppc :LOR and_ppc 
      { ## = #( #[NRighthandOrPPC], ##); }
  ;

pointcut :or_ppc
      { ## = #( #[NPointcut], ##); }
  ;

postfixExpr :proceed_call
  | primaryExpr ( 
      postfixSuffix {## = #( #[NPostfixExpr], ## );} 
    )?
  ;

proceed_call :"proceed" LPAREN RPAREN
  ;

// inherited from grammar GnuCParser
functionDef { String declName; boolean preansi=false; int nrIncompleteArgs=0; int nrCompletedArgs=0;}
:( (functionDeclSpecifiers)=> ds:functionDeclSpecifiers
                |  //epsilon
                )
                declName = d:declarator[true]
                            {
                            AST d2, ds2;
                            d2 = astFactory.dupList(#d);
                            ds2 = astFactory.dupList(#ds);
                            symbolTable.add(declName, #(null, ds2, d2));
                            pushScope(declName);
			    
			    nrIncompleteArgs=#d.numberOfChildrenOfType(AspectCTokenTypes.NIdentifier)-1;
                            }
                ( decl:declaration 
                    {
		    //VOLGORDE checken!!!
		    
		    //detecteer dat er argumenten zijn zonder type : in BEGIN->OK
		    //hou bij hoeveel er door declaratie opgelost worden
		    //rest herstellen met int
                                preansi=true;
                                ##.doubleLink();//NECESSARY <--> compoundStatement must be appended MANUALLY now

                                TNode defNode = #d.firstChildOfType(AspectCTokenTypes.NIdentifier).firstSiblingOfType(AspectCTokenTypes.NIdentifier);
                                TNode declSpecNode = (TNode) #decl.getFirstChild();//NDeclarationsSpecifier
                                TNode declaratorParentNode = (TNode) declSpecNode.getNextSibling();
//                                int teller=0;
                                do{
  //                              	System.out.println("INDEX:\t"+(++teller));
   	                                TNode declaratorNode = (TNode) declaratorParentNode.getFirstChild();//declarator

    	                            TNode tmpNode=defNode.firstSiblingOfType(AspectCTokenTypes.NIdentifier);
								    defNode.replaceSelf(#(#[NParameterDeclaration],astFactory.dupTree(declSpecNode),astFactory.dupTree(declaratorNode)));
        	                        defNode=tmpNode;

        	                        declaratorParentNode = (TNode) declaratorParentNode.firstSiblingOfType(AspectCTokenTypes.NInitDecl);
			       				    nrCompletedArgs++;
                                }while(declaratorParentNode!=null);

                                #decl.removeSelf();                       
                    })* (VARARGS)? ( SEMI )*
                            { popScope(); }
                com:compoundStatement[declName]
                            { 
				##.doubleLink();//NECESSARY <--> compoundStatement must be appended MANUALLY now
				int nrTodo=nrIncompleteArgs-nrCompletedArgs;
				for(int i=0;i<nrTodo;i++){
					/*System.out.println("TODO/nrTODO "+i+"/"+nrTodo);*/
					TNode defNode = #d.firstChildOfType(AspectCTokenTypes.NIdentifier).firstSiblingOfType(AspectCTokenTypes.NIdentifier);

					TNode type=#(#[NTypeSpecifier],#[LITERAL_int,"int"]);
					TNode declSpec=#(#[NDeclarationSpecifiers],type);
					TNode declarator=#(#[NDeclarator],astFactory.dupTree(defNode));
					TNode initDecl=#(#[NInitDecl],declarator);

					TNode tmpNode=defNode.firstSiblingOfType(AspectCTokenTypes.NIdentifier);
					defNode.replaceSelf(#(#[NParameterDeclaration],declSpec,initDecl));
					defNode=tmpNode;
				}
				
                                if(preansi){ //append MANUALLY because of the doubleLink()
                                    ## = #( #[NFunctionDef], ## , #com);
                                }else{
                                    ## = #( #[NFunctionDef], ## );
                                }
                                }
        ;

// inherited from grammar GnuCParser
translationUnit :( externalList )?       /* Empty source files are allowed.  */
        { ## = #( #[NTranslationUnit], ##); }
        ;

// inherited from grammar GnuCParser
asm_expr :"asm" 
                ("volatile")? LCURLY expr RCURLY ( SEMI )+
        ;

// inherited from grammar GnuCParser
idList :identifier ( options{warnWhenFollowAmbig=false;}: COMMA identifier )*
        ;

// inherited from grammar GnuCParser
functionPrefix { String declName; }
:( (functionDeclSpecifiers)=> ds:functionDeclSpecifiers
                |  //epsilon
                )
                declName = d:declarator[true]
                ( declaration )* (VARARGS)? ( SEMI )*
                LCURLY
        ;

// inherited from grammar GnuCParser
typelessDeclaration { AST typeMissing = #[NTypeMissing]; }
:initDeclList[typeMissing] SEMI          { ## = #( #[NTypeMissing], ##); }
        ;

// inherited from grammar GnuCParser
initializer :( ( ( (initializerElementLabel)=> initializerElementLabel )?
                ( assignExpr | lcurlyInitializer )  { ## = #( #[NInitializer], ## ); }
              )
              | lcurlyInitializer
              )
        ;

// inherited from grammar GnuCParser
initializerElementLabel :(   ( LBRACKET ((constExpr VARARGS)=> rangeExpr | constExpr) RBRACKET (ASSIGN)? )
                | identifier COLON
                | DOT identifier ASSIGN
            )
                                    { ## = #( #[NInitializerElementLabel], ##) ; }
        ;

// inherited from grammar GnuCParser
lcurlyInitializer :LCURLY (initializerList ( COMMA )? )? RCURLY
                            { /*##.setType( NLcurlyInitializer );*/ }
        ;

// inherited from grammar GnuCParser
initializerList :initializer ( options{warnWhenFollowAmbig=false;}:COMMA initializer )*
        ;

// inherited from grammar GnuCParser
declarator[boolean isFunctionDefinition] returns [String declName]{ declName = ""; }
:( pointerGroup )?               

                ( attributeDecl )?

                ( declName=identifier                         { /*declName = id.getText();*/ }
                | LPAREN declName = declarator[false] RPAREN
                )

                ( declaratorParamaterList[isFunctionDefinition, declName]
                | LBRACKET ( expr )? RBRACKET
                )*
                                                { ## = #( #[NDeclarator], ## ); }
        ;

// inherited from grammar GnuCParser
declaratorParamaterList[boolean isFunctionDefinition, String declName] :LPAREN
                                                { 
                                                    if (isFunctionDefinition) {
                                                        pushScope(declName);
                                                    }
                                                    else {
                                                        pushScope("!"+declName); 
                                                    }
                                                }
                (                           
                        (declSpecifiers)=> parameterTypeList
                        | (idList)?
                )
                                                {
                                                popScope();
                                                }    
                ( COMMA )?
                RPAREN       
                                                { ##.setType(NParameterTypeList); }      
        ;

// inherited from grammar GnuCParser
parameterTypeList :parameterDeclaration
                (   options {
                            warnWhenFollowAmbig = false;
                        } : 
                  ( COMMA | SEMI )  
                  parameterDeclaration
                )*
                ( ( COMMA | SEMI ) 
                  VARARGS
                )?
        ;

// inherited from grammar GnuCParser
declarationList :(               options {   // this loop properly aborts when
                                            // it finds a non-typedefName ID MBZ
                                            warnWhenFollowAmbig = false;
                                        } :
    
                localLabelDeclaration
                |  ( declarationPredictor )=> declaration
                )+
        ;

// inherited from grammar GnuCParser
localLabelDeclaration :( //GNU note:  any __label__ declarations must come before regular declarations.
                "__label__" identifier (options{warnWhenFollowAmbig=false;}: COMMA identifier)* ( COMMA )? ( SEMI )+
                )
        ;

// inherited from grammar GnuCParser
declaration { AST ds1 = null; }
:ds:declSpecifiers       { ds1 = astFactory.dupList(#ds); }
                (                       
                    initDeclList[ds1]
                )?
                ( SEMI )+
                                        { ## = #( #[NDeclaration], ##); }
                
        ;

// inherited from grammar GnuCParser
functionStorageClassSpecifier :"extern"
          { ## = #( #[NFunctionStorageClassSpecifier], ##); }
        |       "static"
          { ## = #( #[NFunctionStorageClassSpecifier], ##); }
        |       "inline"
          { ## = #( #[NFunctionStorageClassSpecifier], ##); }
        ;

// inherited from grammar GnuCParser
typeSpecifier[int specCount] returns [int retSpecCount]{ retSpecCount = specCount + 1; }
:(       "void"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "char"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "short"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "int"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "long"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "float"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "double"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "signed"
          { ## = #( #[NTypeSpecifier], ##); }
        |       "unsigned"
          { ## = #( #[NTypeSpecifier], ##); }
        |       structOrUnionSpecifier  ( options{warnWhenFollowAmbig=false;}: attributeDecl )*
          { ## = #( #[NTypeSpecifier], ##); }
        |       enumSpecifier
          { ## = #( #[NTypeSpecifier], ##); }
        |       { specCount==0 }? typedefName
          { ## = #( #[NTypeSpecifier], ##); }
        |       "typeof" LPAREN
                ( ( typeName )=> typeName
                | expr
                )
                RPAREN
          { ## = #( #[NTypeSpecifier], ##); }
        |       "__complex"
          { ## = #( #[NTypeSpecifier], ##); }
        )
        ;

// inherited from grammar GnuCParser
structOrUnionSpecifier { String scopeName; }
:sou:structOrUnion
                ( ( identifier LCURLY )=> scopeName=identifier l:LCURLY
                                            {
                                            scopeName = #sou.getText() + " " + scopeName; // #i.getText();
                                            //#l.setText(scopeName);
                                            pushScope(scopeName);
                                            }
                        ( structDeclarationList )?
                                            { popScope();}
                        RCURLY
                |   l1:LCURLY
                                            {
                                            scopeName = getAScopeName();
                                            //#l1.setText(scopeName);
                                            pushScope(scopeName);
                                            }
                    ( structDeclarationList )?
                                            { popScope(); }
                    RCURLY
                | identifier
                )
                                            {
                                             // ## = #( #sou, ## );
                                            }
        ;

// inherited from grammar GnuCParser
structDeclaration :specifierQualifierList structDeclaratorList ( COMMA )? ( SEMI )+
        ;

// inherited from grammar GnuCParser
structDeclaratorList :structDeclarator ( options{warnWhenFollowAmbig=false;}: COMMA structDeclarator )*
        ;

// inherited from grammar GnuCParser
structDeclarator :( declarator[false] )?
                ( COLON constExpr )?
                ( attributeDecl )*
                                    { ## = #( #[NStructDeclarator], ##); }
        ;

// inherited from grammar GnuCParser
enumSpecifier { String txt = null; }
:"enum"
                ( ( identifier LCURLY )=> txt=identifier LCURLY enumList[txt] RCURLY
                | LCURLY enumList["anonymous"] RCURLY
                | identifier
                )
        ;

// inherited from grammar GnuCParser
enumList[String enumName] :enumerator[enumName] ( options{warnWhenFollowAmbig=false;}: COMMA enumerator[enumName] )* ( COMMA )?
        ;

// inherited from grammar GnuCParser
initDeclList[AST declarationSpecifiers] :initDecl[declarationSpecifiers] 
                ( options{warnWhenFollowAmbig=false;}: COMMA initDecl[declarationSpecifiers] )*
                ( COMMA )?
        ;

// inherited from grammar GnuCParser
initDecl[AST declarationSpecifiers] { String declName = ""; }
:declName = d:declarator[false]
                                        {   AST ds1, d1;
                                            ds1 = astFactory.dupList(declarationSpecifiers);
                                            d1 = astFactory.dupList(#d);
                                            symbolTable.add(declName, #(null, ds1, d1) );
                                        }
                ( attributeDecl )*
                ( ASSIGN initializer
                | COLON expr
                )?
                                        { ## = #( #[NInitDecl], ## ); }
        ;

// inherited from grammar GnuCParser
attributeDecl :"__attribute" LPAREN LPAREN attributeList RPAREN RPAREN
                | "asm" LPAREN stringConst RPAREN { ##.setType( NAsmAttribute ); }
        ;

// inherited from grammar GnuCParser
attributeList :attribute ( options{warnWhenFollowAmbig=false;}: COMMA attribute)*  ( COMMA )?
        ;

// inherited from grammar GnuCParser
attribute :( ~(LPAREN | RPAREN | COMMA)
                |  LPAREN attributeList RPAREN
                )*
        ;

// inherited from grammar GnuCParser
compoundStatement[String scopeName] :LCURLY

                            {
                                pushScope(scopeName);
                            }
                (       //this ambiguity is ok, declarationList and nestedFunctionDef end properly
                        options {
                            warnWhenFollowAmbig = false;
                        } :
                    ( "typedef" | "__label__" | declaration )=> declarationList
                    | (nestedFunctionDef)=> nestedFunctionDef
                )*
                ( statementList )?
                            { popScope(); }
                RCURLY
                            { /*##.setType( NCompoundStatement ); ##.setAttribute( "scopeName", scopeName );*/ }
                            { ## = #( #[NCompoundStatement, scopeName], ##); }
        ;

// inherited from grammar GnuCParser
nestedFunctionDef { String declName; }
:( "auto" )? //only for nested functions
                ( (functionDeclSpecifiers)=> ds:functionDeclSpecifiers
                )?
                declName = d:declarator[false]
                            {
                            AST d2, ds2;
                            d2 = astFactory.dupList(#d);
                            ds2 = astFactory.dupList(#ds);
                            symbolTable.add(declName, #(null, ds2, d2));
                            pushScope(declName);
                            }
                ( declaration )*
                            { popScope(); }
                compoundStatement[declName]
                            { ## = #( #[NFunctionDef], ## );}
        ;

// inherited from grammar GnuCParser
realStatement :SEMI                    // Empty statements
        
        |       compoundStatement[getAScopeName()]       // Group of statements

        |       expr SEMI               { ## = #( #[NStatementExpr], ## );} // Expressions

// Iteration statements:

        |       "while" LPAREN expr RPAREN statement
                  { ## = #( #[NWhile], ## ); }
        |       "do" statement "while" LPAREN expr RPAREN SEMI
                  { ## = #( #[NDo], ## ); }
        |       "for"
                LPAREN ( e1:expr )? SEMI ( e2:expr )? SEMI ( e3:expr )? RPAREN
                s:statement
                                    {
                                        //if ( #e1 == null) { #e1 = #[ NEmptyExpression ]; }
                                        //if ( #e2 == null) { #e2 = #[ NEmptyExpression ]; }
                                        //if ( #e3 == null) { #e3 = #[ NEmptyExpression ]; }
                                        //## = #( #[LITERAL_for, "for"], #e1, #e2, #e3, #s );
                                    }
                  { ## = #( #[NFor], ## ); }


// Jump statements:

        |       "goto" expr SEMI
        |       "continue" SEMI
        |       "break" SEMI
        |       "return" ( expr )? SEMI
                  { ## = #( #[NReturn], ## ); }


        |       identifier COLON (options {warnWhenFollowAmbig=false;}: statement)?  { ## = #( #[NLabel], ## ); }
// GNU allows range expressions in case statements
        |       "case" ((constExpr VARARGS)=> rangeExpr | constExpr) COLON ( options{warnWhenFollowAmbig=false;}:statement )?
                  { ## = #( #[NCase], ## ); }
        |       "default" COLON ( options{warnWhenFollowAmbig=false;}: statement )?
                  { ## = #( #[NDefault], ## ); }

// Selection statements:

        |       "if"
                 LPAREN expr RPAREN thenStatement
                ( //standard if-else ambiguity
                        options {
                            warnWhenFollowAmbig = false;
                        } :
                "else" elseStatement )?
                  { ## = #( #[NIf], ## ); }
        |       "switch" LPAREN expr RPAREN statement
                  { ## = #( #[NSwitch], ## ); }
        ;

// inherited from grammar GnuCParser
protected thenStatement :statement { ## = #( #[NThen], ## ); }
        ;

// inherited from grammar GnuCParser
protected elseStatement :statement { ## = #( #[NElse], ## ); }
        ;

// inherited from grammar GnuCParser
conditionalExpr :logicalOrExpr
                ( QUESTION (expr)? COLON conditionalExpr )?
        ;

// inherited from grammar GnuCParser
rangeExpr :constExpr VARARGS constExpr
                                { ## = #(#[NRangeExpr], ##); }
        ;

// inherited from grammar GnuCParser
castExpr :( LPAREN typeName RPAREN )=>
                LPAREN typeName RPAREN ( castExpr | lcurlyInitializer )
                            { ##.setType(NCast); }

        |       unaryExpr
        ;

// inherited from grammar GnuCParser
nonemptyAbstractDeclarator :(
                pointerGroup
                (   (LPAREN  
                    (   nonemptyAbstractDeclarator
                        | parameterTypeList
                    )?
                    ( COMMA )?
                    RPAREN)
                | (LBRACKET (expr)? RBRACKET)
                )*

            |   (   (LPAREN  
                    (   nonemptyAbstractDeclarator
                        | parameterTypeList
                    )?
                    ( COMMA )?
                    RPAREN)
                | (LBRACKET (expr)? RBRACKET)
                )+
            )
                            {   ## = #( #[NNonemptyAbstractDeclarator], ## ); }
                                
        ;

// inherited from grammar GnuCParser
unaryExpr :postfixExpr
        |       INC castExpr
        |       DEC castExpr
        |       u:unaryOperator castExpr { ## = #( #[NUnaryExpr], ## ); }

        |       "sizeof"
                ( ( LPAREN typeName )=> LPAREN typeName RPAREN
                | unaryExpr
                )
        |       "__alignof"
                ( ( LPAREN typeName )=> LPAREN typeName RPAREN
                | unaryExpr
                )       
        |       gnuAsmExpr
        ;

// inherited from grammar GnuCParser
unaryOperator :BAND
        |       STAR
        |       PLUS
        |       MINUS
        |       BNOT    //also stands for complex conjugation
        |       LNOT
        |       LAND    //for label dereference (&&label)
        |       "__real"
        |       "__imag"
        ;

// inherited from grammar GnuCParser
gnuAsmExpr :"asm" ("volatile")? 
                LPAREN stringConst
                ( options { warnWhenFollowAmbig = false; }:
                  COLON (strOptExprPair ( COMMA strOptExprPair)* )?
                  ( options { warnWhenFollowAmbig = false; }:
                    COLON (strOptExprPair ( COMMA strOptExprPair)* )?
                  )?
                )?
                ( COLON stringConst ( COMMA stringConst)* )?
                RPAREN
                                { ##.setType(NGnuAsmExpr); }
        ;

// inherited from grammar GnuCParser
strOptExprPair :stringConst ( LPAREN expr RPAREN )?
        ;

// inherited from grammar GnuCParser
primaryExpr :identifier
        |       Number
        |       charConst
        |       stringConst
// JTC:
// ID should catch the enumerator
// leaving it in gives ambiguous err
//      | enumerator
        |       (LPAREN LCURLY) => LPAREN compoundStatement[getAScopeName()] RPAREN
        |       LPAREN expr RPAREN        { ##.setType(NExpressionGroup); }
        ;

// inherited from grammar GnuCParser
typeQualifier :"const"
        |       "volatile"
	|	"__restrict"
        ;

// inherited from grammar StdCParser
externalList :( externalDef )+
        ;

// inherited from grammar StdCParser
declSpecifiers { int specCount=0; }
:(               options { // this loop properly aborts when
                                          //  it finds a non-typedefName ID MBZ
                                          warnWhenFollowAmbig = false;
                                        } :
                  s:storageClassSpecifier
                | typeQualifier
                | ( "struct" | "union" | "enum" | typeSpecifier[specCount] )=>
                        specCount = typeSpecifier[specCount]
                )+
                                        { ## = #( #[NDeclarationSpecifiers], ##); }
        ;

// inherited from grammar StdCParser
storageClassSpecifier :"auto"                  
        |       "register"              
        |       "typedef"               
        |       functionStorageClassSpecifier
        ;

// inherited from grammar StdCParser
identifier returns [String txt = null;]:id:ID
      {  txt = id.getText();
      	 ## = #( #[NIdentifier], ##);
      }
  ;

// inherited from grammar StdCParser
typedefName :{ isTypedefName ( LT(1).getText() ) }?
                i:identifier                    { ## = #(#[NTypedefName], #i); }
        ;

// inherited from grammar StdCParser
structOrUnion :"struct"
        |       "union"
        ;

// inherited from grammar StdCParser
structDeclarationList :( structDeclaration )+
        ;

// inherited from grammar StdCParser
specifierQualifierList { int specCount = 0; }
:(               options {   // this loop properly aborts when
                                            // it finds a non-typedefName ID MBZ
                                            warnWhenFollowAmbig = false;
                                        } :
                ( "struct" | "union" | "enum" | typeSpecifier[specCount] )=>
                        specCount = typeSpecifier[specCount]
                | typeQualifier
                )+
        ;

// inherited from grammar StdCParser
enumerator[String enumName] { String txt = null; }
:txt=i:identifier                { symbolTable.add(  txt, //i.getText(),
                                                        #(   null,
                                                            #[LITERAL_enum, "enum"],
                                                            #[ ID, enumName]
                                                         )
                                                     );
                                    }
                (ASSIGN constExpr)?
        ;

// inherited from grammar StdCParser
pointerGroup :( STAR ( typeQualifier )* )+    { ## = #( #[NPointerGroup], ##); }
        ;

// inherited from grammar StdCParser
parameterDeclaration { String declName; }
:ds:declSpecifiers
                ( ( declarator[false] )=> declName = d:declarator[false]
                            {
                            AST d2, ds2;
                            d2 = astFactory.dupList(#d);
                            ds2 = astFactory.dupList(#ds);
                            symbolTable.add(declName, #(null, ds2, d2));
                            }
                | nonemptyAbstractDeclarator
                )?
                            {
                            ## = #( #[NParameterDeclaration], ## );
                            }
        ;

// inherited from grammar StdCParser
functionDeclSpecifiers { int specCount = 0; }
:(               options {   // this loop properly aborts when
                                            // it finds a non-typedefName ID MBZ
                                            warnWhenFollowAmbig = false;
                                        } :
                  functionStorageClassSpecifier
                | typeQualifier
                | ( "struct" | "union" | "enum" | typeSpecifier[specCount] )=>
                        specCount = typeSpecifier[specCount]
                )+
                                        { ## = #( #[NFunctionDeclarationSpecifiers], ##); }
        ;

// inherited from grammar StdCParser
declarationPredictor :(options {      //only want to look at declaration if I don't see typedef
                    warnWhenFollowAmbig = false;
                }:
                "typedef"
                | declaration
                )
        ;

// inherited from grammar StdCParser
statementList :( statement )+
        ;

// inherited from grammar StdCParser
statement :realStatement
        { ## = #( #[NStatement], ## ); }
        ;

// inherited from grammar StdCParser
expr :assignExpr (options {
                                /* MBZ:
                                    COMMA is ambiguous between comma expressions and
                                    argument lists.  argExprList should get priority,
                                    and it does by being deeper in the expr rule tree
                                    and using (COMMA assignExpr)*
                                */
                                warnWhenFollowAmbig = false;
                            } :
                            c:COMMA { /*#c.setType(NCommaExpr);*/ } assignExpr         
                            )*
                  { ## = #( #[NExpression], ## ); }
        ;

// inherited from grammar StdCParser
assignExpr :conditionalExpr ( a:assignOperator assignExpr )?
        { ## = #( #[NAssignExpr], ## ); }
        ;

// inherited from grammar StdCParser
assignOperator :ASSIGN
        |       DIV_ASSIGN
        |       PLUS_ASSIGN
        |       MINUS_ASSIGN
        |       STAR_ASSIGN
        |       MOD_ASSIGN
        |       RSHIFT_ASSIGN
        |       LSHIFT_ASSIGN
        |       BAND_ASSIGN
        |       BOR_ASSIGN
        |       BXOR_ASSIGN
        ;

// inherited from grammar StdCParser
constExpr :conditionalExpr
        ;

// inherited from grammar StdCParser
logicalOrExpr :logicalAndExpr ( LOR logicalAndExpr )*
        ;

// inherited from grammar StdCParser
logicalAndExpr :inclusiveOrExpr ( LAND inclusiveOrExpr )*
        ;

// inherited from grammar StdCParser
inclusiveOrExpr :exclusiveOrExpr ( BOR exclusiveOrExpr )*
        ;

// inherited from grammar StdCParser
exclusiveOrExpr :bitAndExpr ( BXOR bitAndExpr )*
        ;

// inherited from grammar StdCParser
bitAndExpr :equalityExpr ( BAND equalityExpr )*
        ;

// inherited from grammar StdCParser
equalityExpr :relationalExpr
                ( ( EQUAL | NOT_EQUAL ) relationalExpr )*
        ;

// inherited from grammar StdCParser
relationalExpr :shiftExpr
                ( ( LT | LTE | GT | GTE ) shiftExpr )*
        ;

// inherited from grammar StdCParser
shiftExpr :additiveExpr
                ( ( LSHIFT | RSHIFT ) additiveExpr )*
        ;

// inherited from grammar StdCParser
additiveExpr :multExpr
                ( ( PLUS | MINUS ) multExpr )*
        ;

// inherited from grammar StdCParser
multExpr :castExpr
                ( ( STAR | DIV | MOD ) castExpr )*
        ;

// inherited from grammar StdCParser
typeName :specifierQualifierList (nonemptyAbstractDeclarator)?
        ;

// inherited from grammar StdCParser
postfixSuffix :( PTR identifier
                | DOT identifier
                | functionCall
                | LBRACKET expr RBRACKET
                | INC
                | DEC
                )+
        ;

// inherited from grammar StdCParser
functionCall :LPAREN (a:argExprList)? RPAREN
                        {
                        //##.setType( NFunctionCallArgs );
                        ## = #( #[NFunctionCall], ## );
                        }
        ;

// inherited from grammar StdCParser
argExprList :argExpr ( COMMA argExpr )*
        ;

// inherited from grammar StdCParser
argExpr :assignExpr
          { ## = #(#[NArgExpr], ##); }
        ;

// inherited from grammar StdCParser
protected charConst :CharLiteral
        ;

// inherited from grammar StdCParser
protected stringConst :(StringLiteral)+                { ## = #(#[NStringSeq], ##); }
        ;

// inherited from grammar StdCParser
protected intConst :IntOctalConst
        |       LongOctalConst
        |       UnsignedOctalConst
        |       IntIntConst
        |       LongIntConst
        |       UnsignedIntConst
        |       IntHexConst
        |       LongHexConst
        |       UnsignedHexConst
        ;

// inherited from grammar StdCParser
protected floatConst :FloatDoubleConst
        |       DoubleDoubleConst
        |       LongDoubleConst
        ;

// inherited from grammar StdCParser
dummy :NTypedefName
        |       NInitDecl
        |       NDeclarator
        |       NStructDeclarator
        |       NDeclaration
        |       NCast
        |       NPointerGroup
        |       NExpressionGroup
        |       NFunctionCallArgs
        |       NArgExpr
        |       NNonemptyAbstractDeclarator
        |       NInitializer
        |       NStatementExpr
        |       NEmptyExpression
        |       NParameterTypeList
        |       NFunctionDef
        |       NFunctionCall
        |       NCompoundStatement
        |       NParameterDeclaration
        |       NCommaExpr
        |       NUnaryExpr
        |       NLabel
        |       NPostfixExpr
        |       NRangeExpr
        |       NStringSeq
        |       NInitializerElementLabel
        |       NLcurlyInitializer
        |       NAsmAttribute
        |       NGnuAsmExpr
        |       NTypeMissing
        |       NReturn
        |       NExpression
        |       NStatement
        |       NIdentifier
        |       NAssignExpr
        |       NDeclarationSpecifiers
        |       NFunctionDeclarationSpecifiers
        ;

{
        // import CToken;
        import java.io.*;
        // import LineObject;
        import antlr.*;
}class AspectCLexer extends Lexer;

options {
	k= 3;
	importVocab= AspectC;
	testLiterals= false;
}

tokens {
        LITERAL___extension__ = "__extension__";
}
{
  public void initialize(String src)
  {
    setOriginalSource(src);
    initialize();
  }

  public void initialize() 
  {
    literals.put(new ANTLRHashString("__alignof__", this), new Integer(LITERAL___alignof));
    literals.put(new ANTLRHashString("__asm", this), new Integer(LITERAL_asm));
    literals.put(new ANTLRHashString("__asm__", this), new Integer(LITERAL_asm));
    literals.put(new ANTLRHashString("__attribute__", this), new Integer(LITERAL___attribute));
    literals.put(new ANTLRHashString("__complex__", this), new Integer(LITERAL___complex));
    literals.put(new ANTLRHashString("__const", this), new Integer(LITERAL_const));
    literals.put(new ANTLRHashString("__const__", this), new Integer(LITERAL_const));
    literals.put(new ANTLRHashString("__imag__", this), new Integer(LITERAL___imag));
    literals.put(new ANTLRHashString("__inline", this), new Integer(LITERAL_inline));
    literals.put(new ANTLRHashString("__inline__", this), new Integer(LITERAL_inline));
    literals.put(new ANTLRHashString("__real__", this), new Integer(LITERAL___real));
    literals.put(new ANTLRHashString("__signed", this), new Integer(LITERAL_signed));
    literals.put(new ANTLRHashString("__signed__", this), new Integer(LITERAL_signed));
    literals.put(new ANTLRHashString("__typeof", this), new Integer(LITERAL_typeof));
    literals.put(new ANTLRHashString("__typeof__", this), new Integer(LITERAL_typeof));
    literals.put(new ANTLRHashString("__volatile", this), new Integer(LITERAL_volatile));
    literals.put(new ANTLRHashString("__volatile__", this), new Integer(LITERAL_volatile));
  }

  LineObject lineObject = new LineObject();
  String originalSource = "";
  PreprocessorInfoChannel preprocessorInfoChannel = new PreprocessorInfoChannel();
  int tokenNumber = 0;
  boolean countingTokens = true;
  int deferredLineCount = 0;

  public void setCountingTokens(boolean ct) 
  {
    countingTokens = ct;
    if ( countingTokens ) {
      tokenNumber = 0;
    }
    else {
      tokenNumber = 1;
    }
  }

  public void setOriginalSource(String src) 
  {
    originalSource = src;
    lineObject.setSource(src);
  }
  public void setSource(String src) 
  {
    lineObject.setSource(src);
  }
  
  public PreprocessorInfoChannel getPreprocessorInfoChannel() 
  {
    return preprocessorInfoChannel;
  }

  public void setPreprocessingDirective(String pre)
  {
    preprocessorInfoChannel.addLineForTokenNumber( pre, new Integer(tokenNumber) );
  }
  
  protected Token makeToken(int t)
  {
    if ( t != Token.SKIP && countingTokens) {
        tokenNumber++;
    }
    CToken tok = (CToken) super.makeToken(t);
    tok.setLine(lineObject.line);
    tok.setSource(lineObject.source);
    tok.setTokenNumber(tokenNumber);

    lineObject.line += deferredLineCount;
    deferredLineCount = 0;
    return tok;
  }

    public void deferredNewline() { 
        deferredLineCount++;
    }

    public void newline() { 
        lineObject.newline();
    }



 public int getCurrentTokenNumber () { return tokenNumber; }


}
protected ID 
options {
	testLiterals= true;
}
:( 'a'..'z' | 'A'..'Z' | '_' | '$')
                ( 'a'..'z' | 'A'..'Z' | '_' | '$' | '0'..'9' )*
        ;

// inherited from grammar GnuCLexer
Whitespace :( ( ' ' | '\t' | '\014')
                | "\r\n"                { newline(); }
                | ( '\n' | '\r' )       { newline();    }
                )                       { _ttype = Token.SKIP;  }
        ;

// inherited from grammar GnuCLexer
protected Escape :'\\'
                ( options{warnWhenFollowAmbig=false;}: 
                  ~('0'..'7' | 'x')
                | ('0'..'3') ( options{warnWhenFollowAmbig=false;}: Digit )*
                | ('4'..'7') ( options{warnWhenFollowAmbig=false;}: Digit )*
                | 'x' ( options{warnWhenFollowAmbig=false;}: Digit | 'a'..'f' | 'A'..'F' )+
                )
        ;

// inherited from grammar GnuCLexer
protected IntSuffix :'L'
            | 'l'
            | 'U'
            | 'u'
            | 'I'
            | 'i'
            | 'J'
            | 'j'
        ;

// inherited from grammar GnuCLexer
protected NumberSuffix :IntSuffix
            | 'F'
            | 'f'
        ;

// inherited from grammar GnuCLexer
Number :( ( Digit )+ ( '.' | 'e' | 'E' ) )=> ( Digit )+
                ( '.' ( Digit )* ( Exponent )?
                | Exponent
                ) 
                ( NumberSuffix
                )*

        |       ( "..." )=> "..."       { _ttype = VARARGS;     }

        |       '.'                     { _ttype = DOT; }
                ( ( Digit )+ ( Exponent )?
                                        { _ttype = Number;   }
                    ( NumberSuffix
                    )*
                )?

        |       '0' ( '0'..'7' )*       
                ( NumberSuffix
                )*

        |       '1'..'9' ( Digit )*     
                ( NumberSuffix
                )*

        |       '0' ( 'x' | 'X' ) ( 'a'..'f' | 'A'..'F' | Digit )+
                ( IntSuffix
                )*
        ;

// inherited from grammar GnuCLexer
IDMEAT :i:ID                {
                                        
                                        if ( i.getType() == LITERAL___extension__ ) {
                                                $setType(Token.SKIP);
                                        }
                                        else {
                                                $setType(i.getType());
                                        }
                                        
                                    }
        ;

// inherited from grammar GnuCLexer
WideCharLiteral :'L' CharLiteral
                                { $setType(CharLiteral); }
        ;

// inherited from grammar GnuCLexer
WideStringLiteral :'L' StringLiteral
                                { $setType(StringLiteral); }
        ;

// inherited from grammar GnuCLexer
StringLiteral :'"'
                ( ('\\' ~('\n'))=> Escape
                | ( '\r'        { newline(); }
                  | '\n'        {
                                newline();
                                }
                  | '\\' '\n'   {
                                newline();
                                }
                  )
                | ~( '"' | '\r' | '\n' | '\\' )
                )*
                '"'
        ;

// inherited from grammar StdCLexer
protected Vocabulary :'\3'..'\377'
        ;

// inherited from grammar StdCLexer
ASSIGN :'=' ;

// inherited from grammar StdCLexer
COLON :':' ;

// inherited from grammar StdCLexer
COMMA :',' ;

// inherited from grammar StdCLexer
QUESTION :'?' ;

// inherited from grammar StdCLexer
SEMI :';' ;

// inherited from grammar StdCLexer
PTR :"->" ;

// inherited from grammar StdCLexer
protected DOT :;

// inherited from grammar StdCLexer
protected VARARGS :;

// inherited from grammar StdCLexer
LPAREN :'(' ;

// inherited from grammar StdCLexer
RPAREN :')' ;

// inherited from grammar StdCLexer
LBRACKET :'[' ;

// inherited from grammar StdCLexer
RBRACKET :']' ;

// inherited from grammar StdCLexer
LCURLY :'{' ;

// inherited from grammar StdCLexer
RCURLY :'}' ;

// inherited from grammar StdCLexer
EQUAL :"==" ;

// inherited from grammar StdCLexer
NOT_EQUAL :"!=" ;

// inherited from grammar StdCLexer
LTE :"<=" ;

// inherited from grammar StdCLexer
LT :"<" ;

// inherited from grammar StdCLexer
GTE :">=" ;

// inherited from grammar StdCLexer
GT :">" ;

// inherited from grammar StdCLexer
DIV :'/' ;

// inherited from grammar StdCLexer
DIV_ASSIGN :"/=" ;

// inherited from grammar StdCLexer
PLUS :'+' ;

// inherited from grammar StdCLexer
PLUS_ASSIGN :"+=" ;

// inherited from grammar StdCLexer
INC :"++" ;

// inherited from grammar StdCLexer
MINUS :'-' ;

// inherited from grammar StdCLexer
MINUS_ASSIGN :"-=" ;

// inherited from grammar StdCLexer
DEC :"--" ;

// inherited from grammar StdCLexer
STAR :'*' ;

// inherited from grammar StdCLexer
STAR_ASSIGN :"*=" ;

// inherited from grammar StdCLexer
MOD :'%' ;

// inherited from grammar StdCLexer
MOD_ASSIGN :"%=" ;

// inherited from grammar StdCLexer
RSHIFT :">>" ;

// inherited from grammar StdCLexer
RSHIFT_ASSIGN :">>=" ;

// inherited from grammar StdCLexer
LSHIFT :"<<" ;

// inherited from grammar StdCLexer
LSHIFT_ASSIGN :"<<=" ;

// inherited from grammar StdCLexer
LAND :"&&" ;

// inherited from grammar StdCLexer
LNOT :'!' ;

// inherited from grammar StdCLexer
LOR :"||" ;

// inherited from grammar StdCLexer
BAND :'&' ;

// inherited from grammar StdCLexer
BAND_ASSIGN :"&=" ;

// inherited from grammar StdCLexer
BNOT :'~' ;

// inherited from grammar StdCLexer
BOR :'|' ;

// inherited from grammar StdCLexer
BOR_ASSIGN :"|=" ;

// inherited from grammar StdCLexer
BXOR :'^' ;

// inherited from grammar StdCLexer
BXOR_ASSIGN :"^=" ;

// inherited from grammar StdCLexer
Comment :"/*"
                ( { LA(2) != '/' }? '*'
                | "\r\n"                { deferredNewline(); }
                | ( '\r' | '\n' )       { deferredNewline();    }
                | ~( '*'| '\r' | '\n' )
                )*
                "*/"                    { _ttype = Token.SKIP;  
                                        }
        ;

// inherited from grammar StdCLexer
CPPComment :"//" ( ~('\n') )* 
                        {
                        _ttype = Token.SKIP;
                        }
        ;

// inherited from grammar StdCLexer
PREPROC_DIRECTIVE 
options {
	paraphrase= "a line directive";
}
:'#'
        ( ( "line" || (( ' ' | '\t' | '\014')+ '0'..'9')) => LineDirective      
            | (~'\n')*                                  { setPreprocessingDirective(getText()); }
        )
                {  
                    _ttype = Token.SKIP;
                }
        ;

// inherited from grammar StdCLexer
protected Space :( ' ' | '\t' | '\014')
        ;

// inherited from grammar StdCLexer
protected LineDirective {
        boolean oldCountingTokens = countingTokens;
        countingTokens = false;
}
:{
                        lineObject = new LineObject();
                        deferredLineCount = 0;
                }
        ("line")?  //this would be for if the directive started "#line", but not there for GNU directives
        (Space)+
        n:Number { lineObject.setLine(Integer.parseInt(n.getText())); } 
        (Space)+
        (       fn:StringLiteral {  try { 
                                          lineObject.setSource(fn.getText().substring(1,fn.getText().length()-1)); 
                                    } 
                                    catch (StringIndexOutOfBoundsException e) { /*not possible*/ } 
                                 }
                | fi:ID { lineObject.setSource(fi.getText()); }
        )?
        (Space)*
        ("1"            { lineObject.setEnteringFile(true); } )?
        (Space)*
        ("2"            { lineObject.setReturningToFile(true); } )?
        (Space)*
        ("3"            { lineObject.setSystemHeader(true); } )?
        (Space)*
        ("4"            { lineObject.setTreatAsC(true); } )?
        (~('\r' | '\n'))*
        ("\r\n" | "\r" | "\n")
                {
                        preprocessorInfoChannel.addLineForTokenNumber(new LineObject(lineObject), new Integer(tokenNumber));
                        countingTokens = oldCountingTokens;
                }
        ;

// inherited from grammar StdCLexer
CharLiteral :'\'' ( Escape | ~( '\'' ) ) '\''
        ;

// inherited from grammar StdCLexer
protected BadStringLiteral :// Imaginary token.
        ;

// inherited from grammar StdCLexer
protected Digit :'0'..'9'
        ;

// inherited from grammar StdCLexer
protected LongSuffix :'l'
        |       'L'
        ;

// inherited from grammar StdCLexer
protected UnsignedSuffix :'u'
        |       'U'
        ;

// inherited from grammar StdCLexer
protected FloatSuffix :'f'
        |       'F'
        ;

// inherited from grammar StdCLexer
protected Exponent :( 'e' | 'E' ) ( '+' | '-' )? ( Digit )+
        ;

// inherited from grammar StdCLexer
protected DoubleDoubleConst :;

// inherited from grammar StdCLexer
protected FloatDoubleConst :;

// inherited from grammar StdCLexer
protected LongDoubleConst :;

// inherited from grammar StdCLexer
protected IntOctalConst :;

// inherited from grammar StdCLexer
protected LongOctalConst :;

// inherited from grammar StdCLexer
protected UnsignedOctalConst :;

// inherited from grammar StdCLexer
protected IntIntConst :;

// inherited from grammar StdCLexer
protected LongIntConst :;

// inherited from grammar StdCLexer
protected UnsignedIntConst :;

// inherited from grammar StdCLexer
protected IntHexConst :;

// inherited from grammar StdCLexer
protected LongHexConst :;

// inherited from grammar StdCLexer
protected UnsignedHexConst :;


