/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Cobble.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.aspicere;

import org.w3c.dom.Node;

public class Advice {
   private static long timeStamp=System.currentTimeMillis();
    private String adviceName = null;

    public static int UNDEFINED = 0;
    public static int BEFORE = 1;
    public static int AROUND = 2;
    public static int AFTER = 3;
    
    private int when = UNDEFINED;
    
    private static String [] asString = new String [] {
        "undefined",
        "before",
        "around",
        "after"
    };

    private Node body = null;
    
    private String aspectName = null;

    private Node node = null;
    
    private Node pointcut = null;

    // Unique number for a Aspicere Advice.
    private int id;

    // Counter.
    private static int count = 0;


    public Advice(Node node, String adviceName, int when, Node pointcut, Node body, String aspectName) {
        synchronized (getClass()) {
            this.id = count++;
        }
        
        this.node = node;
        this.adviceName = adviceName;
        this.when = when;
        this.pointcut = pointcut;
        this.body = body;
        this.aspectName=aspectName;
    }


    public int getID() {
        return id;
    }

    public Node getNode() {
        return node;
    }

    public Node getBody() {
        return body;
    }

    public Node getPointcut() {
        return pointcut;
    }

    public int getWhen() {
        return when;
    }


    public String getName() {
        return adviceName+"_"+timeStamp+"_";
    }

    public String getUntimedName() {
        return adviceName;
    }
    
    public String getAspectName() {
        return aspectName;
    }


    public String toString() {
        return "ADV#" + id
             + " [" + (adviceName == null ? "" : adviceName) + "]:"
             + " (" + asString[when] + ")";
    }
    
    public boolean comesBefore() {
        return when == BEFORE;
    }

    public boolean comesAround() {
        return when == AROUND;
    }

    public boolean comesAfter() {
        return when == AFTER;
    }
}

