/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.aspicere;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * Created on 12-apr-2005
 *
 */

/**
 * @author bram
 *
 * 12-apr-2005
 */
public class Binding implements Serializable{    
    private Map bindings;
    /*private long id;*/
    private String adviceName;
    //private String shadowName;//name of function which will be the instantiation of advice with the current bindings
    private boolean valid;
    
    public Binding(){
        this.valid=true;
    }
    
	/**
	 * @return Returns the adviceName.
	 */
	public String getAdviceName() {
		return adviceName;
	}
	/**
	 * @param adviceName The adviceName to set.
	 */
	public void setAdviceName(String adviceName) {
		this.adviceName = adviceName;
	}
	/**
	 * @param bindings The bindings to set.
	 */
	public void setBindings(Map bindings) {
		this.bindings = bindings;
	}
	
    public Binding(Object[] listOfBindings,String adviceName){
        bindings=new HashMap();
        for(int i=0;i<listOfBindings.length;i++){
            Object[] tmp=(Object[])listOfBindings[i];
            String name=(String)tmp[0];
            bindings.put(name,tmp[1]);
        }
        this.adviceName=adviceName;
        this.valid=true;
        //this.shadowName=null;
        /*this.id=System.currentTimeMillis();*/
    }
    
    public String getName(){
        /*return advice.getName()+id;*/
    		int hash = hashCode();
		String neg = "";
		if (hash < 0) {
			neg += "NEG";
			hash = -hash;
		}
		return adviceName + neg + hash;/*
									    * POTENTIALLY UNSAFE <--> only after
									    * running through all jps, the Bindings
									    * can be filtered. BUT name of Bindings
									    * is used BEFORE that, so using time, we
									    * get wrong calls to advice!
									    */
    }
    
    /*public long getId(){
        return id;
    }*/
    
    /*public String getShadowName(){
        return shadowName;
    }
    
    public void setShadowName(String shadowName){
        this.shadowName=shadowName;
    }*/
    
    public Map getBindings() {
        return bindings;
    }    
        
    public boolean isValid() {
        return valid;
    }
    
    public void setValid(boolean valid) {
        this.valid = valid;
    }
    
    public boolean equals(Object obj) {
        return bindings.equals(((Binding)obj).bindings);
    }
    
    public int hashCode() {
        return bindings.hashCode()+(valid?100:0);
    }
    
    
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return getName()+"["+valid+"]";
	}
}
