/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Aspicere.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 5-mei-2005
 *
 */
package be.ugent.ftw.intec.sel.aspicere;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * @author bram
 *
 * 5-mei-2005
 */
public class CGramXMLFactory {
	static Map cache=new HashMap();//HACK (context -> token -> tokenized_argtype)
	
	public List getHeaderFileNames(Node node){
		List tmp=XPathUtilities.selectNodes (node, "/NTranslationUnit/NLineDirective/NHeaderFile");
		java.util.Iterator it=tmp.iterator();
		List res=new java.util.ArrayList();
		while(it.hasNext()){
		    res.add(getStringValueOf((Node)it.next()));
		}
		return res;
	}
	
	public Node getTopNode(Document doc){
		/*first real child node of program*/
		return (Node)XPathUtilities.selectSingleNode(doc,"/NTranslationUnit/*[node()][1]");
	}
	public Node getGlobalDeclarationNode(Document doc,String varName){
		return (Node)XPathUtilities.selectSingleNode(doc, "/NTranslationUnit/NDeclaration[string(NInitDecl/NDeclarator/NIdentifier/string)='"+varName+"']");
	}
	
	public List getIdentifierNodes(Node node){
		return XPathUtilities.selectNodes (node, ".//NIdentifier");
	}
	
	public List getAdviceNodes(Document doc){
		return XPathUtilities.selectNodes (doc, "//NAdviceDef");
	}
	
	public String getAdviceName(Node adviceNode){
		return XPathUtilities.stringValueOf (adviceNode, "string(NIdentifier[string(preceding-sibling::string)='around'])").trim();
	}
	
	public Node getAdvicePcdNode(Node adviceNode){
		return (Node)XPathUtilities.selectSingleNode (adviceNode, "NPointcut");
	}
	
	public Node getAdviceBodyNode(Node adviceNode){
		return (Node)XPathUtilities.selectSingleNode (adviceNode, "NCompoundStatement");
	}
	
	public List getProceedCallNodes(Node node){
		return (List)XPathUtilities.selectNodes(node,".//NAssignExpr[string(string)='proceed']");
	}
	
	public List getReturnNodes(Node node){
		return (List)XPathUtilities.selectNodes(node,".//NReturn");
	}
	
	public Node getReturnNodeExpression(Node returnNode){
		return (Node)XPathUtilities.selectSingleNode(returnNode,"NExpression");
	}
	
	public Node getEnclosingFunctionDefinitionNode(Node node){
		return (Node)XPathUtilities.selectSingleNode(node,"ancestor::NFunctionDef");
	}
	
	public Node getEnclosingParameterDeclarationNode(Node node,String varName){
		return (Node)XPathUtilities.selectSingleNode(node, "ancestor::NFunctionDef/NDeclarator/NParameterDeclaration[string(NDeclarator/NIdentifier/string)='"+varName+"']");
	}
	
	public String getFunctionNameFromCallNode(Node callNode){
		return XPathUtilities.stringValueOf(callNode,"string(./preceding-sibling::NIdentifier/string)").trim();
	}
	
	public String getFunctionNameFromDefinitionNode(Node defNode){
		return XPathUtilities.stringValueOf(defNode,"string(./NDeclarator/NIdentifier/string)").trim();
	}
	
	public Node getFunctionNameNodeFromCallNode(Node callNode){
		return (Node)XPathUtilities.selectSingleNode(callNode,"./preceding-sibling::NIdentifier");
	}
	
	public Node getFunctionNameStringNodeFromCallNode(Node callNode){
		return (Node)XPathUtilities.selectSingleNode(callNode,"./preceding-sibling::NIdentifier/string");
	}
	
	public Node getFunctionNameStringNodeFromDeclarationNode(Node declNode){
		return (Node)XPathUtilities.selectSingleNode(declNode,"NInitDecl/NDeclarator/NIdentifier[1]/string");
	}
	
	public String getFunctionNameFromDeclarationNode(Node declNode){
		return XPathUtilities.stringValueOf(declNode,"string(NInitDecl/NDeclarator/NIdentifier[1]/string)");
	}
	
	public Node getFunctionDeclarationNode(Document doc,String functionName){
	    return (Node)XPathUtilities.selectSingleNode(doc, "//NInitDecl/NDeclarator[NIdentifier/string='"+functionName+"' and not (following-sibling::*[last()]/self::NCompoundStatement)]");// and following-sibling::string[1][string(.)='(']
	}
	
	public Node getFunctionDefinitionNode(Document doc,String functionName){
		return (Node)XPathUtilities.selectSingleNode(doc,"//NFunctionDef[NDeclarator[1]/NIdentifier[1]/string='"+functionName+"']");
	}
	
	public Node getFunctionDeclaratorsDeclarationSpecifiersNode(Node functionDeclarationNode){
		return (Node)XPathUtilities.selectSingleNode(functionDeclarationNode,"../../NDeclarationSpecifiers[1]");
	}

	public Node getFunctionPrototypesDeclarationSpecifiersNode(Node functionPrototypeNode){
		return (Node)XPathUtilities.selectSingleNode(functionPrototypeNode,"NDeclarationSpecifiers[1]");
	}
	
	public Node getFunctionDefinitionsDeclarationSpecifiersNode(Node functionDefinitionNode){
		return (Node)XPathUtilities.selectSingleNode(functionDefinitionNode,"NFunctionDeclarationSpecifiers");
	}
	
	public List getFunctionArgumentsDeclarationSpecifiersNodes(Node functionDefinitionOrPrototypeNode){
		return (List)XPathUtilities.selectNodes(functionDefinitionOrPrototypeNode,".//NDeclarator/NParameterDeclaration/NDeclarationSpecifiers");
	}
	
	public List getFunctionArgumentsParameterDeclarationNodes(Node functionDefinitionOrPrototypeNode){
		return (List)XPathUtilities.selectNodes(functionDefinitionOrPrototypeNode,".//NDeclarator/NParameterDeclaration[not(ancestor::NParameterDeclaration)]");
	}
	
	public Node getFunctionDefinitionsDeclaratorNode(Node functionDefinitionNode){
		return (Node)XPathUtilities.selectSingleNode(functionDefinitionNode,"NDeclarator");
	}

	public Node getFunctionPrototypesDeclaratorNode(Node functionPrototypeNode){
		return (Node)XPathUtilities.selectSingleNode(functionPrototypeNode,"NInitDecl/NDeclarator");
	}
	
	public int getIndexOfParameterDeclarationNode(Node parameterDeclarationNode){
		return Integer.parseInt(XPathUtilities.stringValueOf(parameterDeclarationNode,"count(./preceding-sibling::NParameterDeclaration)"));
	}

	public int getIndexOfArgumentExpressionNode(Node functionCallNode){
		return Integer.parseInt(XPathUtilities.stringValueOf(functionCallNode,"count(./preceding-sibling::NArgExpr)"));
	}

	public void removeExternStorageClassSpecifierNode(Node declarationSpecifiersNode){
		Node storage_class_specifierNode=(Node)XPathUtilities.selectSingleNode(declarationSpecifiersNode, "NFunctionStorageClassSpecifier[string(string)='extern']");
		if(storage_class_specifierNode!=null){
			storage_class_specifierNode.getParentNode().removeChild(storage_class_specifierNode);
		}
	}
	
	/**
	 * No support for non-typedeffed function pointers.
	 * @param declarationSpecifiersNode
	 * @param declaratorNode
	 * @return
	 */
	public String getFunctionReturnType(Node declarationSpecifiersNode,Node declaratorNode){
		String res=null;
		if(declarationSpecifiersNode==null){
			//System.out.println("AAAAARRRRRRRGGGGGGGGHHHHHHHH1");
			res="int";
		}else{  
            res=XPathUtilities.stringValueOf(declarationSpecifiersNode,"normalize-space(string(.))").trim();
        }
		
		int nrStars=0;
		Node pointerGroupNode = (Node)XPathUtilities.selectSingleNode(declaratorNode,"NIdentifier/preceding-sibling::NPointerGroup[last()]");
        if (pointerGroupNode!=null)
            nrStars = Integer.parseInt((String)XPathUtilities.stringValueOf(pointerGroupNode,"round(count(./string[string(.)='*']))"));
        nrStars+=Integer.parseInt((String)XPathUtilities.stringValueOf(declaratorNode,"round(count(NIdentifier/following-sibling::string[string(.)='[']))"));
        for(int i=0;i<nrStars;i++) res+="*";
        /*XPathUtilities.walk(declarationSpecifiersNode);
        System.out.println("SPECIAL:\t"+res);*/
		
        //res=res.replaceAll("(\\s+|^)static\\s+"," ").replaceAll("(\\s+|^)extern\\s+"," ").replaceAll("(\\s+|^)register\\s+"," ").replaceAll("(\\s+|^)auto\\s+"," ").trim();
        res=(" "+res+" ").replaceAll("\\s+static\\s+"," ").replaceAll("\\s+__inline__\\s+"," ").replaceAll("\\s+extern\\s+"," ").replaceAll("\\s+register\\s+"," ").replaceAll("\\s+auto\\s+"," ").trim();
	if(res.equals("")){
		//System.out.println("AAAAARRRRRRRGGGGGGGGHHHHHHHH1");
		res="int";
	}
	//System.out.println("OUT:\t"+res);
	return res;
	}
	
	public String getFunctionArgumentType(Node declarationSpecifiersNode,Node parameterDeclarationNode){
		return getFunctionArgumentType(declarationSpecifiersNode,parameterDeclarationNode," ");
	}
	
	public String getFunctionArgumentType(Node declarationSpecifiersNode,Node parameterDeclarationNode,String tempToken){
		String res=null;
		/*CACHE*/
		Map queryToResult=(Map)cache.get(parameterDeclarationNode);
		if(queryToResult!=null){
			Object tmp=queryToResult.get(tempToken);
			if((tmp!=null)&&(tmp instanceof String)) return (String)tmp;
		}
		/*CACHE*/
		
		/*DEBUG*/
		//System.out.println("IN");
		//XPathUtilities.walk(parameterDeclarationNode);
		/*DEBUG*/
		
		String tmp=XPathUtilities.stringify(parameterDeclarationNode).trim()+" ";//" " needed for the replacement of e.g. 'int x'
		String varName=((String)XPathUtilities.stringValueOf(parameterDeclarationNode,"string(.//NDeclarator[1]/NIdentifier/string)")).trim();
		//System.err.println("VAR:\t<"+varName+">");
		if(!varName.equals("")){
		    int pos=tmp.lastIndexOf(" "+varName+" ");
		    //tmp=tmp.replaceAll(" "+varName+" "," ");
		    String sub1=tmp.substring(0,pos);
		    String sub2=tmp.substring(pos,tmp.length());
		    //System.err.println("SUB1: <"+sub1+">");
		    //System.err.println("SUB2: <"+sub2+">");
		    tmp=sub1+sub2.replaceFirst(varName+" ",tempToken);
		}else{ //e.g. int f(char[]);
            int bracketPos=tmp.indexOf("[");
//          int nextBracketPos=tmp.indexOf("[",bracketPos);
            if((bracketPos!=-1))
              {
                 String sub1=tmp.substring(0,bracketPos);
                 String sub2=tmp.substring(bracketPos,tmp.length());
                 //System.err.println("SUB1: <"+sub1+">");
                 //System.err.println("SUB2: <"+sub2+">");
                 tmp=sub1+sub2.replaceFirst("\\[",tempToken+"[");
              }
         
         }
		//int bracketPos=tmp.indexOf('[');
		/*if(bracketPos!=-1){
		    res=tmp.substring(0,bracketPos);
		    tmp=tmp.substring(bracketPos).trim();
		    int len=tmp.length();
		    while((len>0)&&tmp.matches("\\[.*\\]")){
		        res+="*";
		        tmp=tmp.substring(1,len-1).trim();
		        len=tmp.length();
		    }		    
		}else*/ res=tmp;
		//System.err.println("ARG:\t<"+res+">");
		/*if(tmp.lastIndexOf(" ")!=-1){
			if((tmp.lastIndexOf("(")!=-1) && (tmp.charAt(0)!='(')){ //function pointer
				int startOfArgs=tmp.indexOf("(",tmp.indexOf("("));
				String sub1=tmp.substring(startOfArgs);
				String sub2=tmp.substring(startOfArgs,tmp.length());
			}else{ //possible identifier included
				
			} 
		}else{ //easy case: only int e.g.
			res=tmp;
		}*/
		/*if(declarationSpecifiersNode==null){
			res="int";
		}else{*/  
/*
		//(Node)XPathUtilities.selectSingleNode(parameterDeclarationNode,)
		//recursief doorlopen, ook bij returntype!
		//kijk naar voorbeeld in workspce/ctest + naar stickies

            res=XPathUtilities.stringValueOf(declarationSpecifiersNode,"normalize-space(string(.))").trim();
        //}
		
		int nrStars=0;
	   int nrBrackets=0;
		Node pointerGroupNode = (Node)XPathUtilities.selectSingleNode(parameterDeclarationNode,".//NPointerGroup");
        if (pointerGroupNode!=null)
            nrStars = Integer.parseInt((String)XPathUtilities.stringValueOf(pointerGroupNode,"round(count(./string[string(.)='*']))"));
        for(int i=0;i<nrStars;i++) res+="*";
	   nrBrackets = Integer.parseInt((String)XPathUtilities.stringValueOf(parameterDeclarationNode,"round(count(.//string[string(.)='[']))"));
        for(int i=0;i<nrBrackets;i++) res+="*";
	   
        //System.out.println("SPECIAL:\t"+res);*/
		/*CACHE*/
		if(queryToResult==null) queryToResult=new HashMap();
    		queryToResult.put(tempToken,res);
    		cache.put(parameterDeclarationNode,queryToResult);
        	/*CACHE*/
        	
        return res;
	}

	public List getActualArgumentNodes(Node callNode){
		return XPathUtilities.selectNodes(callNode, "NArgExpr");
	}
	
	public int getNumberOfArgs(Node declaratorNode){
		return Integer.parseInt(XPathUtilities.stringValueOf(declaratorNode, "count(NParameterDeclaration)"));
	}
	
	public Node getLocalVariableDeclarationNode(Node node,String varName){
		return (Node)XPathUtilities.selectSingleNode(node, "./ancestor::NCompoundStatement/NDeclaration[NInitDecl/NDeclarator/NIdentifier[string(string)='"+varName+"']][1]");
	}
	
	public Node getLocalVariableDeclarationSpecifiersNode(Node declarationNode){
		return (Node)XPathUtilities.selectSingleNode(declarationNode,"NDeclarationSpecifiers[1]");
	}
	
	public Node getLocalVariableDeclaratorNode(Node declarationNode,String varName){
		return (Node)XPathUtilities.selectSingleNode(declarationNode,"NInitDecl/NDeclarator[string(NIdentifier/string)='"+varName+"']");
	}


	
	public String getStringValueOf(Node node){
		return XPathUtilities.stringValueOf(node,"string(.)").trim();
	}
	
	/**
	 * Currently supported:
	 * <ul>
	 * <li>constants</li>
	 * <li>variables</li>
	 * <li>&variable</li>
	 * <li>function call</li>
	 * </ul>
	 * @param actualArgumentNode
	 * @return
	 */
	public Node getSupportedEllipsisArgumentNode(Node actualArgumentNode){
//	    XPathUtilities.walk(actualArgumentNode);
	    Node tmpNode=(Node)XPathUtilities.selectSingleNode(actualArgumentNode,"NAssignExpr/NExpression[preceding-sibling::string[string(.)='(']]");
	    while(tmpNode!=null){ //remove parentheses
		actualArgumentNode=tmpNode;
		tmpNode=(Node)XPathUtilities.selectSingleNode(actualArgumentNode,"NAssignExpr/NExpression[preceding-sibling::string[string(.)='(']]");
	    }

	    /*System.out.println("!!! IN ELLIPSIS !!!");
   	    XPathUtilities.walk(actualArgumentNode);
   	    System.out.println("----------");*/
	    // | NAssignExpr/NUnaryExpr/string[not(string(.)='-') and not(string(.)='+')]
	    Node res= (Node)XPathUtilities.selectSingleNode(actualArgumentNode,"NAssignExpr/string | NAssignExpr/NStringSeq | NAssignExpr/NUnaryExpr/NIdentifier[not(following-sibling::string[string(.)='->'])] | NAssignExpr/NIdentifier[not(following-sibling::string[string(.)='->'])] | NAssignExpr/NPostfixExpr/NFunctionCall[not(following-sibling::string[string(.)='->'])]");
	    /*if(res!=null) XPathUtilities.walk(res);
	    System.out.println("++++++++++");*/
	    return res;
	}
	
	public boolean hasEllipsis(Node declaratorNode){
		return (XPathUtilities.selectSingleNode(declaratorNode, "string[string(.)='...']")!=null);
	}
	
	public Node removeEllipsisNodes(Node declaratorNode){
	    /*XPathUtilities.walk(declaratorNode);
	    System.out.println("");*/
		List nodesToRemove=XPathUtilities.selectNodes(declaratorNode, "string[string(.)=','][last()] | string[string(.)='...'] | string[string(.)=')']");
		/*Iterator it=nodesToRemove.iterator();
		while(it.hasNext()){
		    System.out.println("Another element:");
		    XPathUtilities.walk((Node)it.next());
		}
		if(nodesToRemove.size()==0) System.out.println("NO elements!!!");*/
		if(nodesToRemove.size()>1){ /*ellipsis found*/
		    declaratorNode.removeChild((Node)nodesToRemove.get(0));/*","*/
		    declaratorNode.removeChild((Node)nodesToRemove.get(1));/*"..."*/
		    return (Node)nodesToRemove.get(2);/*")"*/
		}else return (Node)nodesToRemove.get(0);/*")"*/
	}
	
	/**
	 * Discover type of variable named varName from context.
	 * @param node Start recursively from NArgExpr or Expression
	 * @param varName
	 * @return NTypeSpecifier-node with NPointerGroup (if applicable)
	 */
	public ArrayList getTypeOfVar(Node node,String varName){
	    return null;
	}
	
	public ArrayList getTypeOfBaseComponent(Node node){
	    
	    /*1) Strip parentheses, *'s, &'s and []'s*/
	    int dereferences=0;
	    Node tmpNode=(Node)XPathUtilities.selectSingleNode(node,"NAssignExpr/NUnaryExpr/NExpression[preceding-sibling::string[string(.)='(']] | NAssignExpr/NPostfixExpr/NExpression[preceding-sibling::string[string(.)='(']]");
	    while(tmpNode!=null){ //remove parentheses
	        node=tmpNode;
	        dereferences+=Integer.parseInt(XPathUtilities.stringValueOf(node, "round(count(preceding-sibling::string[string(.)='*'])-count(preceding-sibling::string[string(.)='&']))+count(following-sibling::string[string(.)='['])"));
	        /*-> en . detecteren*/
	        tmpNode=(Node)XPathUtilities.selectSingleNode(node,"NAssignExpr/NUnaryExpr/NExpression[preceding-sibling::string[string(.)='(']] | NAssignExpr/NPostfixExpr/NExpression[preceding-sibling::string[string(.)='(']]");
	    }
	    
	    
	    

	    //Node res= (Node)XPathUtilities.selectSingleNode(actualArgumentNode,"NAssignExpr/string | NAssignExpr/NStringSeq | NAssignExpr/NUnaryExpr/NIdentifier[not(following-sibling::string[string(.)='->'])] | NAssignExpr/NIdentifier[not(following-sibling::string[string(.)='->'])] | NAssignExpr/NPostfixExpr/NFunctionCall[not(following-sibling::string[string(.)='->'])]");
	    return null;
	}
	
	public boolean isFunctionDefinitionNode(Node node){
		return (XPathUtilities.selectSingleNode(node, "self::NFunctionDef")!=null);
	}
	
	public boolean isNonStringConstantNode(Node node){
		return (XPathUtilities.selectSingleNode(node, "self::string")!=null);
	}
	
	public boolean isStringConstantNode(Node node){
		return (XPathUtilities.selectSingleNode(node, "self::NStringSeq")!=null);
	}
	
	public boolean isIdentifierNode(Node node){
		return (XPathUtilities.selectSingleNode(node, "self::NIdentifier")!=null);
	}
	
	public int isReferencedIdentifierNode(Node node){
		String tmp=XPathUtilities.stringValueOf(node, "normalize-space(string(self::NIdentifier/preceding-sibling::string))");
		char[] tmp2=tmp.toCharArray();
		int res=0;
		for(int i=0;i<tmp2.length;i++){
			if(tmp2[i]=='&') res++;
		}
		//System.out.println("REF:\t"+res);
		return res;
	}
	
	public int isDeReferencedIdentifierNode(Node node){
		int res=Integer.parseInt((String)XPathUtilities.stringValueOf(node, "round(count(self::NIdentifier/ancestor::NArgExpr[1]//NUnaryExpr/string[string(.)='*']))"));
		//System.out.println("DEREF:\t"+res);
		return res;
	}
	
	public boolean isFunctionCallNode(Node node){
		return (XPathUtilities.selectSingleNode(node, "self::NFunctionCall")!=null);
	}
	
	public boolean isActualFunctionArgumentNode(Node node){
	    return (XPathUtilities.selectSingleNode(node, "self::NArgExpr")!=null);
	}

	public void removeAllPreprocessingOutput(Node node){
		/*DANGER:
		 * * do NOT select ordinary code between two #include-s (the [1][NHeaderFile])
		 * * let advised #include-code disappear (node() instead of * => proxy bodies disappear)
		 */
	    List list=XPathUtilities.selectNodes(node,"/NTranslationUnit/node()[preceding-sibling::NLineDirective[1][NHeaderFile] and following-sibling::NLineDirective]");
	    Node parent=(list.size()>0)?((Node)list.get(0)).getParentNode():null;
	    Iterator it=list.iterator();
	    while(it.hasNext()){
	        parent.removeChild((Node)it.next());
	    }
	}
}
