/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Cobble.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Kris De Schutter <kris.deschutter@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.aspicere;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import org.w3c.dom.Node;

public class JoinPoint {
    static Map allJoinPoints=new HashMap();//hashcode -> JoinPoint
    // Name for JoinPoint.
    private String name = "";

    // Node in DOM tree where the joinpoint was found.
    private ArrayList nodes = null;

    // JP type.
    public static int UNDEFINED = 0;
    public static int STATEMENT = 1;
    public static int PARAGRAPH = 2;
    public static int SECTION = 3;
    public static int PROGRAM = 4;
    public static int READ = 5;
    public static int WRITE = 6;
    public static int MOVE = 7;
    public static int CALL = 8;

    private int type = UNDEFINED;

    private static String[] asString = new String[]{
            "undefined",
            "statement",
            "paragraph",
            "section",
            "program",
            "read",
            "write",
            "move",
            "call"
            };

    // Unique number for a Cobol JP.
    private int id;

    // Counter.
    private static int count = 0;
    
    public static JoinPoint createNewJoinPoint(Node node){
        JoinPoint tmp=new JoinPoint(node);
        return checkUniqueness(tmp);
    }
    
    public static JoinPoint createNewJoinPoint(ArrayList nodes){
        JoinPoint tmp=new JoinPoint(nodes);
        return checkUniqueness(tmp);
    }
    
    public static JoinPoint createNewJoinPoint(Node node, int type, String name){
        JoinPoint tmp=new JoinPoint(node, type, name);
        return checkUniqueness(tmp);
    }
    
    public static JoinPoint createNewJoinPoint(ArrayList nodes, int type, String name){
        JoinPoint tmp=new JoinPoint(nodes, type, name);
        return checkUniqueness(tmp);
    }
    
    private static JoinPoint checkUniqueness(JoinPoint tmp){
        int tmpCode=tmp.hashCode();
        JoinPoint existing=(JoinPoint)allJoinPoints.get(new Integer(tmpCode));
        if(existing==null){
            allJoinPoints.put(new Integer(tmpCode),tmp);
        }else{
            tmp=existing;
        }
        return tmp;        
    }

    protected JoinPoint(Node node) {
        synchronized (getClass()) {
            this.id = count++;
        }

        this.nodes = new ArrayList();
        this.nodes.add(node);
    }
    
    protected JoinPoint(ArrayList nodes) {
        synchronized (getClass()) {
            this.id = count++;
        }

        this.nodes = nodes;
    }

    protected JoinPoint(Node node, int type, String name) {
        synchronized (getClass()) {
            this.id = count++;
        }

        this.nodes = new ArrayList();
        this.nodes.add(node);
        this.type = type;
        this.name = (name == null ? "" : name);
    }
    
    protected JoinPoint(ArrayList nodes, int type, String name) {
        synchronized (getClass()) {
            this.id = count++;
        }

        this.nodes = nodes;
        this.type = type;
        this.name = (name == null ? "" : name);
    }


    public int getID() {
        return id;
    }


    public ArrayList getNodes() {
        return nodes;
    }


    public int getType() {
        return type;
    }


    public String getName() {
        return name;
    }
    
    public void setType(int type) {
        this.type=type;
    }


    public void setName(String name) {
        this.name=name;
    }


    public String toString() {
        return "JP#" + id + " [" + name + "] (" + asString[type] + ")" + getNodes().get(0).toString();
    }
    
    public boolean isStatement() {
        return type == STATEMENT
            || type == READ
            || type == WRITE
            || type == MOVE
            || type == CALL;
    }
    
    public boolean equals(Object obj){
        if(!(obj instanceof JoinPoint)) return false;
        JoinPoint other=(JoinPoint)obj;
        List otherNodes=other.getNodes();
        if(nodes.size()!=otherNodes.size()) return false;
        
        Iterator otherNodesIterator=otherNodes.iterator();
        Iterator nodesIterator=nodes.iterator();
        while(nodesIterator.hasNext()){
            Node otherNode=(Node)otherNodesIterator.next();
            Node node=(Node)nodesIterator.next();
            if(otherNode!=node) return false;
        }
        
        return true;
    }
    
    public int hashCode(){
        return getNodes().hashCode();
    }
}

