/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Cobble.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams	<bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package be.ugent.ftw.intec.sel.aspicere;

import be.ugent.ftw.intec.sel.lillambi.*;
import be.ugent.ftw.intec.sel.aspicere.*;

import org.w3c.dom.*;
import org.jaxen.*;
import org.jaxen.dom.*;

import java.util.*;
import java.io.*;
import java.beans.XMLEncoder;
import java.beans.XMLDecoder;

import be.ugent.ftw.intec.sel.lillambi.Agent;
import be.ugent.ftw.intec.sel.lillambi.AgentException;
import be.ugent.ftw.intec.sel.lillambi.Lillambi;

public class SpiderMan implements Agent{

    final String PROCEEDTOKEN="PROCEEDDEECORP";
    final String RETURNTOKEN="RETURNNRUTER";
    /* support for keeping track of needed include-files in transformed aspects */
    final String ASPECTFILEINCLUDESTOKEN="ASPECTFILEINCLUDESSEDULCNIELIFTCEPSA";
    /*final String FILENAMETOKEN="FileNameee";*/

    static CGramXMLFactory cGramXMLFactory=new CGramXMLFactory();
    static String globalToken="TOKEN"+System.currentTimeMillis();


public Object[] act (Object [] args) throws AgentException{
    Map joinPointToAdviceAndBinding=(Map)args[0];/*JP -> List van Lists with advice name and binding*/
    Map newAdviceToBindings=(Map)args[1];/*name advice -> List van Binding*/
    Map allAdvice=(Map)args[2];/*name advice -> Advice*/
    Map aspectNamesToBody=(Map)args[3];/*name aspect -> XML Document*/
    List aspectNamesOrderedList=(List)args[4];/*currently unused, see sortAdvice() at the bottom of the page*/
    Map aspectNamesToOrderedListOfAdviceNames=(Map)args[5];/*currently unused, see sortAdvice() at the bottom of the page*/
    String fileName=(String)args[6];
    boolean nolegacy=((Boolean)args[7]).booleanValue();
    Map adviceToJpName=(Map)args[8];
    /*Map fileNameToHeaderFiles=(Map)args[7];*/
    
    Document baseDocument=null;
        
    int jpIndex=0;
    int jpTotal=joinPointToAdviceAndBinding.size();
    Iterator jpIterator=joinPointToAdviceAndBinding.keySet().iterator();
    int nrSkipped=0;
    while(jpIterator.hasNext()){
    		System.out.println("*** joinpoint "+(++jpIndex)+"/"+jpTotal+" ***");
        JoinPoint jp=(JoinPoint)jpIterator.next();
        Node jpNode=(Node)jp.getNodes().get(0);
        List adviceAndBindings=(List)joinPointToAdviceAndBinding.get(jp);
        /*Hoe weaven?
         * 1 adviceprototypes bovenaan basefile (generieke signatuur)
         * 2 rond enclosing definition (voor elk joinpoint erin):
         * 	a) erboven resp. het prototype van de caller proxy, prototype van callee en definities van caller en callee
         * 3 appendChild aan //aspectc_application de advice-definities*/
        Node enclosingFunctionDefinitionNode=cGramXMLFactory.getEnclosingFunctionDefinitionNode(jpNode);
        Node enclosingFunctionDefinitionParentNode=enclosingFunctionDefinitionNode.getParentNode();        
        baseDocument=jpNode.getOwnerDocument();

        /*
         * 0) bepaal naam CRP van caller_proxy en CEP van callee_proxy
         */
        Node oldFunctionNameNode=cGramXMLFactory.getFunctionNameNodeFromCallNode(jpNode);
        
        String functionName=cGramXMLFactory.getStringValueOf(oldFunctionNameNode);
        String callerProxy=functionName+jp.getID()+"_caller_proxy"+"_"+System.currentTimeMillis();/*uniqueness across different invocations of weaver!*/
        String calleeProxy=functionName+jp.getID()+"_callee_proxy"+"_"+System.currentTimeMillis();/*uniqueness across different invocations of weaver!*/
        
        /* 1) vervang oproep naar doel door oproep naar CRP
         */
        //Node oldFunctionNameNode=(Node)XPathUtilities.selectSingleNode(functionNameNode, "string");
        Node newFunctionNameNode=createLiteral(baseDocument,callerProxy);
        oldFunctionNameNode.getParentNode().replaceChild(newFunctionNameNode,oldFunctionNameNode);
        
        /* 2) creatie van prototype van CRP [base program]: clone van doel(), evenals van CEP (COMMENT-node)
         */
        /*Node functionDeclarationNode=(Node)XPathUtilities.selectSingleNode(baseDocument,"//declaration[.//function_declarator//identifier[1]/string='"+functionName+"']");*/
        Node functionDeclarationNode=cGramXMLFactory.getFunctionDeclarationNode(baseDocument, functionName);

        Node crpPrototypeNode=null;
        Node cepPrototypeNode=null;
        if(functionDeclarationNode!=null){ /*prototype found*/
        		/*Why making things so hard? int f(int a),g(double c);*/
        		Node declaration_specifiersNode=cGramXMLFactory.getFunctionDeclaratorsDeclarationSpecifiersNode(functionDeclarationNode);
        		//if(declaration_specifiersNode==null) XPathUtilities.walk(functionDeclarationNode);
        		Node clonedDeclaration_specifiersNode=((declaration_specifiersNode==null)?baseDocument.createComment (" "):declaration_specifiersNode.cloneNode(true));
        	
        		/*remove extern*/
        		cGramXMLFactory.removeExternStorageClassSpecifierNode(clonedDeclaration_specifiersNode);
        	
        		/*Node init_declaratorNode=(Node)XPathUtilities.selectSingleNode(functionDeclarationNode, ".//init_declarator[declarator/direct_declarator/function_declarator//identifier[1]/string='"+functionName+"']");
        		Node clonedInit_declaratorNode=init_declaratorNode.cloneNode(true);*/
        		Node clonedFunctionDeclarationNode=functionDeclarationNode.cloneNode(true);
        		
            	/*BUG in Kava*/
            	int nrArgs=cGramXMLFactory.getNumberOfArgs(clonedFunctionDeclarationNode);
            	if(nrArgs==0){
                    Node functionDefinitionNode=cGramXMLFactory.getFunctionDefinitionNode(baseDocument, functionName);
        			if(functionDefinitionNode!=null){ /*no-arg prototype found, but there is a definition provided which has EXACT types of args!*/
        				declaration_specifiersNode=cGramXMLFactory.getFunctionDefinitionsDeclarationSpecifiersNode(functionDefinitionNode);
        	        		clonedDeclaration_specifiersNode=((declaration_specifiersNode==null)?baseDocument.createComment (" "):declaration_specifiersNode.cloneNode(true));
        	        	
        	        		/*remove extern*/
        	        		cGramXMLFactory.removeExternStorageClassSpecifierNode(clonedDeclaration_specifiersNode);
        	        			        	
        	        		Node declaratorNode=cGramXMLFactory.getFunctionDefinitionsDeclaratorNode(functionDefinitionNode);
        	        		Node clonedDeclaratorNode=declaratorNode.cloneNode(true);
        	        	
        	        		/*check for ellipsis*/
        	        		boolean hasEllipsis=cGramXMLFactory.hasEllipsis(clonedDeclaratorNode);
        	        		if(hasEllipsis){
        	        			try{
        	        				resolveEllipsis(jpNode,clonedDeclaratorNode,functionName);
        	        			}catch(Exception ex){
        	        				//ex.printStackTrace();
        						System.err.println("%%% I will exclude joinpoint "+callerProxy+" from the list! %%%");
        						//error correction
        						nrSkipped++;
        				        newFunctionNameNode.getParentNode().replaceChild(oldFunctionNameNode,newFunctionNameNode);
        				        invalidateBindings(adviceAndBindings);
        					continue;
        	        			}
        	        		}
        	        		
        	        		clonedDeclaration_specifiersNode=transfer(clonedDeclaration_specifiersNode,"NDeclarationSpecifiers");
        	        		clonedFunctionDeclarationNode=clonedDeclaratorNode;

        	        		/*Node newDeclarationSpecifiersNode=transfer(clonedDeclaration_specifiersNode,"NDeclarationSpecifiers");
        	        		
        	        		Node declaration = baseDocument.createElement("NDeclaration");
                     declaration.appendChild(newDeclarationSpecifiersNode);
                     Node daj_n1 = baseDocument.createElement("NInitDecl");
                     declaration.appendChild(daj_n1);
                       daj_n1.appendChild(clonedDeclaratorNode);
                     Node daj_n2 = createLiteral(baseDocument, ";\n");
                     declaration.appendChild(daj_n2);
                     Node daj_n3 = baseDocument.createComment("   ");
                     declaration.appendChild(daj_n3);
        				
        				crpPrototypeNode=declaration;
        	        		System.out.println("TEST:");
        	        		XPathUtilities.walk(crpPrototypeNode);*/
        	        		/*if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpPrototypeNode);*/
        	        		/*Node oldNameNode=(Node)XPathUtilities.selectSingleNode(crpPrototypeNode, ".//identifier[1]/string");*/
        	        		/*Node oldNameNode=(Node)XPathUtilities.selectSingleNode(crpPrototypeNode, ".//init_declarator_list/init_declarator//direct_declarator//identifier[1]/string");
        	        		oldNameNode.getParentNode().replaceChild(newFunctionNameNode.cloneNode(true),oldNameNode);
        	        		
        	        		/*Node functionDefinitionParentNode=functionDefinitionNode.getParentNode();
        	        		functionDefinitionParentNode.insertBefore(crpPrototypeNode,functionDefinitionNode);*/
        	        		/*enclosingFunctionDefinitionParentNode.insertBefore(crpPrototypeNode,enclosingFunctionDefinitionNode);
        	        		cepPrototypeNode=createAdvicePrototype(baseDocument,calleeProxy);
        	        		/*functionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
        	        		/*enclosingFunctionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
        			}else{ //guess arg-types from context
            	    Node insertPositionNode=cGramXMLFactory.removeEllipsisNodes(clonedFunctionDeclarationNode);
            	    try{
            	        gatherTypesFromContext(functionName,jpNode,insertPositionNode,nrArgs);
    	        		/*XPathUtilities.walk(clonedDeclaration_specifiersNode);
    	        		XPathUtilities.walk(clonedFunctionDeclarationNode);*/
            	        /*BUG in Kava*/
        	        }catch(Exception ex){
        	            //ex.printStackTrace();
        	            System.err.println("%%% UNRESOLVABLE pre-ANSI code:\tI will exclude joinpoint "+callerProxy+" from the list! %%%");
        	            //error correction
        	            nrSkipped++;
        	            newFunctionNameNode.getParentNode().replaceChild(oldFunctionNameNode,newFunctionNameNode);
        	            invalidateBindings(adviceAndBindings);
        	            continue;
        	        }
        			}
            	}else{ //more than zero args
            	    /*check for ellipsis*/
            	    /*NodeList parTypeListNodeList=(Node)XPathUtilities.selectNodes(clonedFunctionDeclarationNode, "*[pos()>pos(../string[string(.)='('][1]) and pos()<pos(../string[string(.)=')'][1])]");
            	     if(parTypeListNode!=null){*/
            	    boolean hasEllipsis=cGramXMLFactory.hasEllipsis(clonedFunctionDeclarationNode);
            	    if(hasEllipsis){
            	        try{
            	            resolveEllipsis(jpNode,clonedFunctionDeclarationNode,functionName);
            	        }catch(Exception ex){
            	            //ex.printStackTrace();
            	            System.err.println("%%% I will exclude joinpoint "+callerProxy+" from the list! %%%");
					//error correction
            	            nrSkipped++;
            	            newFunctionNameNode.getParentNode().replaceChild(oldFunctionNameNode,newFunctionNameNode);
            	            invalidateBindings(adviceAndBindings);
            	            continue;
            	        }
            	    }
        		}
        		/*}*/
        	
        		Node declaration = baseDocument.createElement("NDeclaration");
            declaration.appendChild(clonedDeclaration_specifiersNode);
            Node daj_n4 = baseDocument.createElement("NInitDecl");
            declaration.appendChild(daj_n4);
              daj_n4.appendChild(clonedFunctionDeclarationNode);
            Node daj_n5 = createLiteral(baseDocument, ";\n");
            declaration.appendChild(daj_n5);
            Node daj_n6 = baseDocument.createComment("   ");
            declaration.appendChild(daj_n6);
       	  	crpPrototypeNode=declaration;
        		/*System.out.println("1:");
        		 if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpPrototypeNode);*/
            /*Node oldNameNode=(Node)XPathUtilities.selectSingleNode(crpPrototypeNode, "NInitDecl/NDeclarator/NIdentifier[1]/string");
            oldNameNode.getParentNode().replaceChild(newFunctionNameNode.cloneNode(true),oldNameNode);
        		/*System.out.println("2:");
        		 if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpPrototypeNode);*/

       	  	/*Node functionDeclarationParentNode=functionDeclarationNode.getParentNode();
       	  	functionDeclarationParentNode.insertBefore(crpPrototypeNode,functionDeclarationNode);*/
            /*enclosingFunctionDefinitionParentNode.insertBefore(crpPrototypeNode,enclosingFunctionDefinitionNode);
       	  	cepPrototypeNode=createAdvicePrototype(baseDocument,calleeProxy);
       	  	/*functionDeclarationParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
       	  	/*enclosingFunctionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
        }else{
            Node functionDefinitionNode=cGramXMLFactory.getFunctionDefinitionNode(baseDocument, functionName);
			if(functionDefinitionNode!=null){ /*no prototype found, but there is a definition provided!*/
				Node declaration_specifiersNode=cGramXMLFactory.getFunctionDefinitionsDeclarationSpecifiersNode(functionDefinitionNode);
	        		Node clonedDeclaration_specifiersNode=((declaration_specifiersNode==null)?baseDocument.createComment (" "):declaration_specifiersNode.cloneNode(true));
	        	
	        		/*remove extern*/
	        		cGramXMLFactory.removeExternStorageClassSpecifierNode(clonedDeclaration_specifiersNode);
	        			        	
	        		Node declaratorNode=cGramXMLFactory.getFunctionDefinitionsDeclaratorNode(functionDefinitionNode);
	        		Node clonedDeclaratorNode=declaratorNode.cloneNode(true);
	        	
	        		/*check for ellipsis*/
	        		boolean hasEllipsis=cGramXMLFactory.hasEllipsis(clonedDeclaratorNode);
	        		if(hasEllipsis){
	        			try{
	        				resolveEllipsis(jpNode,clonedDeclaratorNode,functionName);
	        			}catch(Exception ex){
	        				//ex.printStackTrace();
						System.err.println("%%% I will exclude joinpoint "+callerProxy+" from the list! %%%");
						//error correction
						nrSkipped++;
				        newFunctionNameNode.getParentNode().replaceChild(oldFunctionNameNode,newFunctionNameNode);
				        invalidateBindings(adviceAndBindings);
					continue;
	        			}
	        		}

	        		Node newDeclarationSpecifiersNode=transfer(clonedDeclaration_specifiersNode,"NDeclarationSpecifiers");
	        		
	        		Node declaration = baseDocument.createElement("NDeclaration");
             declaration.appendChild(newDeclarationSpecifiersNode);
             Node daj_n7 = baseDocument.createElement("NInitDecl");
             declaration.appendChild(daj_n7);
               daj_n7.appendChild(clonedDeclaratorNode);
             Node daj_n8 = createLiteral(baseDocument, ";\n");
             declaration.appendChild(daj_n8);
             Node daj_n9 = baseDocument.createComment("   ");
             declaration.appendChild(daj_n9);
				
				crpPrototypeNode=declaration;
	        		/*if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpPrototypeNode);*/
	        		/*Node oldNameNode=(Node)XPathUtilities.selectSingleNode(crpPrototypeNode, ".//identifier[1]/string");*/
	        		/*Node oldNameNode=(Node)XPathUtilities.selectSingleNode(crpPrototypeNode, ".//init_declarator_list/init_declarator//direct_declarator//identifier[1]/string");
	        		oldNameNode.getParentNode().replaceChild(newFunctionNameNode.cloneNode(true),oldNameNode);
	        		
	        		/*Node functionDefinitionParentNode=functionDefinitionNode.getParentNode();
	        		functionDefinitionParentNode.insertBefore(crpPrototypeNode,functionDefinitionNode);*/
	        		/*enclosingFunctionDefinitionParentNode.insertBefore(crpPrototypeNode,enclosingFunctionDefinitionNode);
	        		cepPrototypeNode=createAdvicePrototype(baseDocument,calleeProxy);
	        		/*functionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
	        		/*enclosingFunctionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);*/
			}else{
			    //throw new AspicereException("There is NO function prototype for method <"+functionName+">, nor does a definition exist. I quit!");
	            System.err.println("%%% There is NO function prototype for method <"+functionName+">, nor does a definition exist: I will exclude joinpoint "+callerProxy+" from the list! %%%");
	            //error correction
	            nrSkipped++;
	            newFunctionNameNode.getParentNode().replaceChild(oldFunctionNameNode,newFunctionNameNode);
	            invalidateBindings(adviceAndBindings);
	            continue;
			}
        }
       
        /*insert crp- and cep- prototypes*/
        Node oldNameNode=cGramXMLFactory.getFunctionNameStringNodeFromDeclarationNode(crpPrototypeNode);
        oldNameNode.getParentNode().replaceChild(newFunctionNameNode.cloneNode(true),oldNameNode);

        enclosingFunctionDefinitionParentNode.insertBefore(crpPrototypeNode,enclosingFunctionDefinitionNode);

        cepPrototypeNode=createAdvicePrototype(baseDocument,calleeProxy,"jp");
   	  	enclosingFunctionDefinitionParentNode.insertBefore(cepPrototypeNode,crpPrototypeNode);
   	 
        /*System.out.println("NA2:");
	    XPathUtilities.walk(crpPrototypeNode);*/
        List argumentTypes=getArgumentTypes(crpPrototypeNode,globalToken);
        String returnType=getReturnType(crpPrototypeNode);
        boolean isVoid=returnType.trim().equals("void");
        //List adviceAndBindings=(List)joinPointToAdviceAndBinding.get(jp);
        /*System.out.println("JOINPOINT:\t"+jp.toString());*/

        /*adviceAndBindings=sortAdvice(adviceAndBindings,aspectNamesOrderedList,aspectNamesToOrderedListOfAdviceNames);/*currently unnecessary*/

        /* 6) vervang functie-argument bindings door C-code: (*((int*)(jp->args[0])))
         * 	  Automatisch zal wijziging percoleren naar de List in newAdviceToBindings. Nadien via Set ...=new HashSet(...) opnieuw herstellen van Sets in newAdviceToBindings.*/
        Iterator applicableAdviceAndBindingsIterator=adviceAndBindings.iterator();
        while(applicableAdviceAndBindingsIterator.hasNext()){
            List tmp=(List)applicableAdviceAndBindingsIterator.next();
            String advName=(String)tmp.get(0);
            Binding advBinding=(Binding)tmp.get(1);
            Map bindings=advBinding.getBindings();
            Iterator singleBindingsIterator=bindings.keySet().iterator();
            while(singleBindingsIterator.hasNext()){
                String varName=(String)singleBindingsIterator.next();
                Object value=bindings.get(varName);
                //System.out.println("BEFORE ARG-CHECK");
                if(value instanceof Node){ 
                    Node valueNode=(Node)value;
                    //System.out.println("BEFORE ARG-CHECK-IF:\t"+valueNode.getNodeName());
                    if(cGramXMLFactory.isActualFunctionArgumentNode(valueNode)){ /*it is a function call argument*/
                        /*Determine index of argument in call signature*/
                        //System.out.println("BEFORE ARG-CHECK-OPS");
                        int index=cGramXMLFactory.getIndexOfArgumentExpressionNode(valueNode);
                        String type=(String)argumentTypes.get(index);
                        String code="";
                        if(isPrimitiveOrUnreferencedTypedef(type)){
                        		code="(*(("+pointerToArgumentType(type)+")("+adviceToJpName.get(advName)+"->args["+index+"])))";
                        }else{
                        		code="(("+generateArgumentType(type)+")("+adviceToJpName.get(advName)+"->args["+index+"]))";
                        }
                        //System.out.println("ARGUMENT "+varName+" for ADVICE "+advName+" REPLACED BY "+code);
                        //String code="(*(("+generateArgumentType(type,"*")+")(jp->args["+index+"])))";
                        bindings.put(varName,code);/*replace XML node by C code*/
                    }
                }
            }
            if(!isVoid) bindings.put(PROCEEDTOKEN,"(call_next("+adviceToJpName.get(advName)+"),*(("+returnType+"*)("+adviceToJpName.get(advName)+"->returnValue)))");/*replacement code for proceed()*/
            else bindings.put(PROCEEDTOKEN,"call_next("+adviceToJpName.get(advName)+")");/*replacement code for proceed()*/
            bindings.put(RETURNTOKEN,"*(("+returnType+"*)("+adviceToJpName.get(advName)+"->returnValue))");/* return statement will be replaced by assignment of this code to return expression */
        }
        
        
        /* 3) creatie van body van CRP [base program]
         */        
        Node crpBodyNode=createCallerProxyBody(baseDocument,crpPrototypeNode,adviceAndBindings,argumentTypes,returnType,calleeProxy,fileName,functionName);
        enclosingFunctionDefinitionParentNode.insertBefore(crpBodyNode,enclosingFunctionDefinitionNode);
        /*System.out.println("3:");
    	if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpPrototypeNode);
        System.out.println("4:");
    	if(functionName.equals("_iqcprep")) XPathUtilities.walk(crpBodyNode);*/
        
        /*
         * 5) creatie van body van CEP [base program]
         */
        Node cepBodyNode=createCalleeProxyBody(baseDocument,functionName,argumentTypes,returnType,calleeProxy);        
        enclosingFunctionDefinitionParentNode.insertBefore(cepBodyNode,enclosingFunctionDefinitionNode);
        

    }
    
    /*Make newAdviceToBindings consistent again (aka filter duplicate Bindings: List -> Set)*/
    /*System.out.println("VOOR:\t"+newAdviceToBindings);*/
    Iterator newAdviceToBindingsIterator=newAdviceToBindings.keySet().iterator();
    while(newAdviceToBindingsIterator.hasNext()){
        String advName=(String)newAdviceToBindingsIterator.next();
        newAdviceToBindings.put(advName,new HashSet((List)newAdviceToBindings.get(advName)));/*filtering*/
    }
    /*System.out.println("NA:\t"+newAdviceToBindings);*/
    
    /*Managing bindings file*/
    Map adviceToBindings=null;
    File bindingsFile=null;
    if(nolegacy){
        bindingsFile=new File(System.getProperty("user.dir")+File.separator+"bindings.xml");
        boolean firstWeave=false;
        if(bindingsFile.exists()){
            XMLDecoder d;
            try {
                d = new XMLDecoder(new BufferedInputStream(new FileInputStream(bindingsFile)));
            } catch (FileNotFoundException e) {
                System.err.println("Problem with multi-file weaving: cannot find binding file. Aborting ...");
                e.printStackTrace();
                return null;
            }
            Map oldAdviceToBindings = (Map)d.readObject();
            d.close();
    		
            adviceToBindings=splitOldBindingsFromNewOnes(oldAdviceToBindings,newAdviceToBindings);
        }else{
            firstWeave=true;
    		try {
                bindingsFile.createNewFile();
            } catch (IOException e) {
                System.err.println("Problem with multi-file weaving: cannot create new binding file. Aborting ...");
                e.printStackTrace();
                return null;
            }
    		adviceToBindings=newAdviceToBindings;
        }
    }else adviceToBindings=newAdviceToBindings;

    /*make bodies for transformed advice*/
    /*XPathUtilities.walk(jpNode);*/
    Node baseTopNode=cGramXMLFactory.getTopNode(baseDocument);	
    	
    int advIndex=0;
    int advTotal=adviceToBindings.size()-((adviceToBindings.get(ASPECTFILEINCLUDESTOKEN)!=null)?1:0);
    Iterator adviceIterator=adviceToBindings.keySet().iterator();
    while(adviceIterator.hasNext()){
        String advName=(String)adviceIterator.next();
	if(advName.equals(ASPECTFILEINCLUDESTOKEN)) continue;
    	System.out.println("$$$ advice "+(++advIndex)+"/"+advTotal+" ("+advName+") $$$");
        Set bindings=(Set)adviceToBindings.get(advName);
        Advice advice=(Advice)allAdvice.get(advName);
        Node adviceNode=advice.getNode();
        Document adviceDocument=adviceNode.getOwnerDocument();
        Node topNode=cGramXMLFactory.getTopNode(adviceDocument);//(Node)XPathUtilities.selectSingleNode(adviceDocument,"//aspectc_application/*[node()][1]");/*first real child node of current aspect*/        
        
        Iterator bindingsIterator=bindings.iterator();
        while(bindingsIterator.hasNext()){
            Binding binding=(Binding)bindingsIterator.next();
            if(!binding.isValid()){
                System.err.println("Binding "+binding.getName()+" INVALID!");
                continue;
            }/*else System.err.println("Binding "+binding.getName()+" CORRECT!");*/
            String bindingName=binding.getName();            
            Map currentBindingMap=binding.getBindings();

            /*
             * 	6) creatie prototypes advice [base program][getransformeerd aspect]
             */
            /*System.out.println("NAME:\t"+(String)(adviceToJpName.get(advName)));*/
            Node advicePrototypeNode=createAdvicePrototype(baseDocument,bindingName,(String)(adviceToJpName.get(advName)));
            baseTopNode.getParentNode().insertBefore(advicePrototypeNode,baseTopNode);            
			if(nolegacy){
				Node advicePrototypeNodeAspectSide=adviceDocument.importNode(advicePrototypeNode,true);
	            topNode.getParentNode().insertBefore(advicePrototypeNodeAspectSide,topNode);
			}
            
            /*Node advicePrototypeCallerSideNode=baseDocument.importNode(advicePrototypeNode,true);
            baseTopNode.getParentNode().insertBefore(advicePrototypeCallerSideNode,baseTopNode);*/

            Node declaration_specifiers=cGramXMLFactory.getFunctionPrototypesDeclarationSpecifiersNode(advicePrototypeNode).cloneNode(true);
            Node function_declaration_specifiers=(!nolegacy)?transfer(declaration_specifiers,"NFunctionDeclarationSpecifiers"):adviceDocument.importNode(transfer(declaration_specifiers,"NFunctionDeclarationSpecifiers"),true);
            Node declarator=(!nolegacy)?cGramXMLFactory.getFunctionPrototypesDeclaratorNode(advicePrototypeNode).cloneNode(true):adviceDocument.importNode(cGramXMLFactory.getFunctionPrototypesDeclaratorNode(advicePrototypeNode),true);
            Node function_definitionNode=null;
            
            if(!nolegacy){
				Node compound=baseDocument.importNode(advice.getBody(),true);
    	        Node tmp_function_definitionNode = baseDocument.createElement("NFunctionDef");
               tmp_function_definitionNode.appendChild(function_declaration_specifiers);
               tmp_function_definitionNode.appendChild(declarator);
               tmp_function_definitionNode.appendChild(compound);
		       	function_definitionNode=tmp_function_definitionNode;
			}else{
	            Node compound=advice.getBody().cloneNode(true);
    	        Node tmp_function_definitionNode = adviceDocument.createElement("NFunctionDef");
               tmp_function_definitionNode.appendChild(function_declaration_specifiers);
               tmp_function_definitionNode.appendChild(declarator);
               tmp_function_definitionNode.appendChild(compound);
				function_definitionNode=tmp_function_definitionNode;
			}            
	            
            
            /* 7) detecteer static locale variabelen van niet-template type in advice: creëer "globale" static variabele, een prototype voor getter en setter
             * als template: voor alle zelfde waarden zelfde static variabele? of geen templates ondersteunen?
             */
            
            
            /* 8) creatie bodies advice [getransformeerd aspect]
             */
            /* replace template parameters */
            List possibleTemplateNodes=cGramXMLFactory.getIdentifierNodes(function_definitionNode);
            Iterator possibleTemplateNodesIterator=possibleTemplateNodes.iterator();
            while(possibleTemplateNodesIterator.hasNext()){
                Node possibleTemplateNode=(Node)possibleTemplateNodesIterator.next();
                String templateName=cGramXMLFactory.getStringValueOf(possibleTemplateNode);
                /*System.out.print("TEMPLATE:\t"+templateName);*/
                Object possibleValue=currentBindingMap.get(templateName);
                if(possibleValue!=null){ /*found template!*/
                	/*System.out.println(" ... detected!");*/
                    Node newNode=(!nolegacy)?baseDocument.createComment(" "+possibleValue.toString()+"\t "):adviceDocument.createComment(" "+possibleValue.toString()+"\t ");
                    /*Node possibleTemplateNodeParent=possibleTemplateNode.getParentNode();*/
                    possibleTemplateNode.getParentNode().replaceChild(newNode,possibleTemplateNode);
                    /*System.out.println("PER PARENT");
                    XPathUtilities.walk(possibleTemplateNodeParent);*/
                }/*else if(templateName.equals(FILENAMETOKEN)){
                		Node newNode=baseDocument.createComment(" \""+fileName+"\" ");
                		possibleTemplateNode.getParentNode().replaceChild(newNode,possibleTemplateNode);
                }*/
                /*System.out.println(" ... NOT detected");*/
            }
            /* replace proceed calls */
            List possibleProceedNodes=cGramXMLFactory.getProceedCallNodes(function_definitionNode);
            Iterator possibleProceedNodesIterator=possibleProceedNodes.iterator();
            while(possibleProceedNodesIterator.hasNext()){
                Node possibleProceedNode=(Node)possibleProceedNodesIterator.next();
                Node proceedCodeNode=(!nolegacy)?baseDocument.createComment (" "+currentBindingMap.get(PROCEEDTOKEN)+" "):adviceDocument.createComment (" "+currentBindingMap.get(PROCEEDTOKEN)+" ");
                possibleProceedNode.getParentNode().replaceChild(proceedCodeNode,possibleProceedNode);
            }
            /* replace non-void return calls */
            List possibleReturnNodes=cGramXMLFactory.getReturnNodes(function_definitionNode);
            Iterator possibleReturnNodesIterator=possibleReturnNodes.iterator();
            while(possibleReturnNodesIterator.hasNext()){
                Node possibleReturnNode=((Node)possibleReturnNodesIterator.next());
                Node possibleReturnNodeExpression=cGramXMLFactory.getReturnNodeExpression(possibleReturnNode);
                if(possibleReturnNodeExpression==null){ //just remove the return;
                		possibleReturnNode.getParentNode().removeChild(possibleReturnNode);	
                }else{ //create assignment: return i; => ((...)(jp->...))=i;
					if(!nolegacy){
                		Node returnCodeNode=baseDocument.createComment (" "+currentBindingMap.get(RETURNTOKEN)+" ");
	                    Node expr_statementNode = baseDocument.createElement("NStatementExpression");
                       Node daj_n10 = baseDocument.createElement("NExpression");
                       expr_statementNode.appendChild(daj_n10);
                         Node daj_n11 = baseDocument.createElement("NAssignExpression");
                         daj_n10.appendChild(daj_n11);
                           daj_n11.appendChild(returnCodeNode);
                           Node daj_n12 = createLiteral(baseDocument, "=");
                           daj_n11.appendChild(daj_n12);
                           daj_n11.appendChild(possibleReturnNodeExpression);
                       Node daj_n13 = createLiteral(baseDocument, ";\n");
                       expr_statementNode.appendChild(daj_n13);
						possibleReturnNode.getParentNode().replaceChild(expr_statementNode,possibleReturnNode);
					}else{
						Node returnCodeNode=adviceDocument.createComment (" "+currentBindingMap.get(RETURNTOKEN)+" ");
	                    Node expr_statementNode = adviceDocument.createElement("NStatementExpression");
                       Node daj_n14 = adviceDocument.createElement("NExpression");
                       expr_statementNode.appendChild(daj_n14);
                         Node daj_n15 = adviceDocument.createElement("NAssignExpression");
                         daj_n14.appendChild(daj_n15);
                           daj_n15.appendChild(returnCodeNode);
                           Node daj_n16 = createLiteral(adviceDocument, "=");
                           daj_n15.appendChild(daj_n16);
                           daj_n15.appendChild(possibleReturnNodeExpression);
                       Node daj_n17 = createLiteral(adviceDocument, ";\n");
                       expr_statementNode.appendChild(daj_n17);
						possibleReturnNode.getParentNode().replaceChild(expr_statementNode,possibleReturnNode);
					}					
                }
            }
            
            /*plakken bodyNode in goeie document*/
            /*AANGEPAST*/
            /*baseTopNode.getParentNode().insertBefore(function_definitionNode,baseTopNode);*/
			if(!nolegacy) baseTopNode.getParentNode().appendChild(function_definitionNode);
			else adviceNode.getParentNode().insertBefore(function_definitionNode,adviceNode);
            /*AANGEPAST*/
            /*System.out.println("ALLES");
            XPathUtilities.walk(function_definitionNode);*/
        }        
    }
    
    /*_aspicere.h includeren bovenaan base program!*/
    /*Node _aspicereIncludeNode=baseDocument.createComment (" #include \"_aspicere.h\" @n ");
    baseDocument.insertBefore(_aspicereIncludeNode,baseDocument.getFirstChild());*/

    /*We want an ordered list of unique file names*/
    	Set allHeaderFileNamesSet=new HashSet();    
    
	    List allHeaderFileNamesList=new ArrayList();    
    	/*Set allBaseProgramHeaderFileNames=new HashSet();
	    allBaseProgramHeaderFileNames.add("#include \"_aspicere.h\"");
    
    	Collection allHeaderSets=fileNameToHeaderFiles.values();
	    Iterator allHeaderSetsIterator=allHeaderSets.iterator();
    	while(allHeaderSetsIterator.hasNext()){
	        allBaseProgramHeaderFileNames.addAll((Set)allHeaderSetsIterator.next());
    	}*/
	    //DEBUG
    	//System.out.println("ASPECTS:\t"+aspectNamesToBody);
    
	    List allBaseProgramHeaderFileNames=cGramXMLFactory.getHeaderFileNames(baseDocument);
    	Iterator allBaseProgramHeaderFileNamesIterator=allBaseProgramHeaderFileNames.iterator();
	    while(allBaseProgramHeaderFileNamesIterator.hasNext()){
	        String tmpHeader=(String)allBaseProgramHeaderFileNamesIterator.next();
    	    if(allHeaderFileNamesSet.add(tmpHeader)) allHeaderFileNamesList.add(tmpHeader); /*not present already*/
	    }
    
    	Iterator aspectNamesToBodyIterator=aspectNamesToBody.values().iterator();
	    while(aspectNamesToBodyIterator.hasNext()){
    	    Document doc=(Document)aspectNamesToBodyIterator.next();
        	List tmp=cGramXMLFactory.getHeaderFileNames(doc);
        
	        Iterator tmpIterator=tmp.iterator();
    	    while(tmpIterator.hasNext()){
        	    String tmpHeader=(String)tmpIterator.next();
            	if(allHeaderFileNamesSet.add(tmpHeader)) allHeaderFileNamesList.add(tmpHeader); /*not present already*/
	        }
    	    //System.out.println("TEMP:\t"+tmp);
        	//allHeaderFileNames.addAll(tmp);
	    }
    
    	if(allHeaderFileNamesSet.add("\"_aspicere.h\"")) allHeaderFileNamesList.add("\"_aspicere.h\"");
    
	if(nolegacy){
	    Map aspectNamesToAggregatedIncludeFiles=null;
	    Object obj=adviceToBindings.get(ASPECTFILEINCLUDESTOKEN);
	    if(obj==null) aspectNamesToAggregatedIncludeFiles=new HashMap();
	    else{
		//System.out.println(obj+"\nTYPE:\t"+obj.getClass().getName());
		aspectNamesToAggregatedIncludeFiles=(Map)obj;
	    }
	    


	    /* 9) bovenaan elk ASPECT #include van _aspicere.h (duplicaat OK)
	     * */
	    aspectNamesToBodyIterator=aspectNamesToBody.keySet().iterator();
	    while(aspectNamesToBodyIterator.hasNext()){
		String aspectName=(String)aspectNamesToBodyIterator.next();
	        Document doc=(Document)aspectNamesToBody.get(aspectName);

		List aggregatedIncludeFiles=(List)aspectNamesToAggregatedIncludeFiles.get(aspectName);
		if(aggregatedIncludeFiles==null){
		    aggregatedIncludeFiles=new ArrayList(allHeaderFileNamesList);
		}else{
		    Set avoidDuplicates=new HashSet(aggregatedIncludeFiles);
		    Iterator allHeaderFileNamesListIterator=allHeaderFileNamesList.iterator();
		    while(allHeaderFileNamesListIterator.hasNext()){
			String tmp=(String)allHeaderFileNamesListIterator.next();
			if(avoidDuplicates.add(tmp)) aggregatedIncludeFiles.add(tmp);
		    }
		}
		aspectNamesToAggregatedIncludeFiles.put(aspectName,aggregatedIncludeFiles);

		/*We gather all base program header files <--> 
		  1) too coarse grained
		  2) problems if no #ifndef ... #define ... #endif
		  3) idem if duplicate names in header files

		  => ideal solution: select just the types bound in advices on a per-advice basis and include only its header file or (even better) its declaration (look if there is a single XML-element containing ultimate type bound in binding); this approach already supported by following loop and structure of bindings.xml*/

		Iterator aggregatedIncludeFilesIterator=aggregatedIncludeFiles.iterator();
		while(aggregatedIncludeFilesIterator.hasNext()){
		    String include=(String)aggregatedIncludeFilesIterator.next();
		    Node includeNode=doc.createComment (" #include "+include+" @n ");
		    /*Right order or reverse?*/
		    doc.insertBefore(includeNode,doc.getFirstChild());        
		}

		cGramXMLFactory.removeAllPreprocessingOutput(doc);
	    }
	    adviceToBindings.put(ASPECTFILEINCLUDESTOKEN,aspectNamesToAggregatedIncludeFiles);
	    
	    /* 9) bovenaan base program #include van _aspicere.h (duplicaat OK)
	     * */
		Node _aspicereIncludeNode=baseDocument.createComment (" #include \"_aspicere.h\" @n ");
	    baseDocument.insertBefore(_aspicereIncludeNode,baseDocument.getFirstChild());

	    XMLEncoder e;
        try {
            e = new XMLEncoder(
                new BufferedOutputStream(
                    new FileOutputStream(bindingsFile)));
        } catch (FileNotFoundException e1) {
            System.err.println("Problem with multi-file weaving: cannot write to binding file. Aborting ...");
            e1.printStackTrace();
            return null;
        }
            e.writeObject(adviceToBindings);
	    	e.close();
    
    	/*XMLDecoder d;
        try {
            d = new XMLDecoder(
                new BufferedInputStream(
            	    new FileInputStream(new File(System.getProperty("user.dir")+File.separator+"bindings.xml"))));
        } catch (FileNotFoundException e2) {
            System.err.println("Problem with multi-file weaving: cannot find binding file. Aborting ...");
            e2.printStackTrace();
            return null;
        }
            adviceToBindings = (Map)d.readObject();
            d.close();*/
	}else{

	    /*include necessary header files in base program*/

    
    
	    //DEBUG
    	//System.out.println("BASE:\t"+allBaseProgramHeaderFileNames);
	    //System.out.println("ALL-BEFORE:\t"+allHeaderFileNames);
    	//allBaseProgramHeaderFileNames.addAll(allHeaderFileNames);
	    //System.out.println("BASE-AFTER:\t"+allBaseProgramHeaderFileNames);

    	/*try{
	    	java.io.PrintStream str=new java.io.PrintStream(new java.io.FileOutputStream("__debug_before_erase.xml"));
    		XPathUtilities.walk(baseDocument,str);
    		str.close();
	    }catch(Exception ex){
    		System.err.println("Logging to XML-file did NOT work!");
    		ex.printStackTrace();
	    }*/
    
    	/*REMOVE all preprocessing-output*/
	    cGramXMLFactory.removeAllPreprocessingOutput(baseDocument);
    
    	System.out.println("Adding following #include-files:\t"+allHeaderFileNamesList);
	    //DEBUG
    	Collections.reverse(allHeaderFileNamesList);
	    Iterator allHeaderFileNamesListIterator=allHeaderFileNamesList.iterator();
    	while(allHeaderFileNamesListIterator.hasNext()){
	        String headerFileName=(String)allHeaderFileNamesListIterator.next();
    	    /*EXTRA check/hack: As ANTLR does not guarantee that getSystemHeader() only works on system headers*/
        	//if(headerFileName.matches("</usr/include/.*\\.h\\s*>")) headerFileName=headerFileName.substring(14,headerFileName.length()-1).trim();
	        Node tmpIncludeNode=baseDocument.createComment (" #include "+headerFileName+" @n ");
    	    //Node tmpIncludeNode=baseDocument.createComment (" "+headerFileName+" @n ");
        	baseDocument.insertBefore(tmpIncludeNode,baseDocument.getFirstChild());
	        //System.out.println("HEADER:\t"+headerFileName);
    	}


    
	    /*if(!allBaseProgramHeaderFileNames.contains("</usr/include/stdio.h>")){
    	    Node tmpIncludeNode=baseDocument.createComment (" #include </usr/include/stdio.h> @n ");
        	baseDocument.insertBefore(tmpIncludeNode,baseDocument.getFirstChild());
	    }
    	if(!allBaseProgramHeaderFileNames.contains("</usr/include/stdlib.h>")){
        	Node tmpIncludeNode=baseDocument.createComment (" #include </usr/include/stdlib.h> @n ");
	        baseDocument.insertBefore(tmpIncludeNode,baseDocument.getFirstChild());
    	}
	    if(!allBaseProgramHeaderFileNames.contains("</usr/include/string.h>")){
    	    Node tmpIncludeNode=baseDocument.createComment (" #include </usr/include/string.h> @n ");
        	baseDocument.insertBefore(tmpIncludeNode,baseDocument.getFirstChild());
	    }*/
    }
    
    /*stdlib.h includeren bovenaan base program! <--> NO: trouble with sys/types.h*/
    /*Node stdlibIncludeNode=baseDocument.createComment (" #include <stdlib.h> @n ");
    baseDocument.insertBefore(stdlibIncludeNode,baseDocument.getFirstChild());*/

    System.out.println("Number of skipped joinpoints:\t"+nrSkipped);
    
    return null;
}

Node createLiteral(Document document, String literal) {
	  Text text = document.createTextNode(literal);
	  Node node = document.createElement("string");
	  node.appendChild(text);
	  return node;
}

Node createAdvicePrototype(Document document,String name,String jpName) {
	/*return document.createComment (" void "+name+"(thisJoinPoint* jp); @n ");*/
    Node nameNode=createLiteral(document,name);
    Node jpNameNode=createLiteral(document,jpName);
    Node resNode = document.createElement("NDeclaration");
      Node daj_n18 = document.createElement("NDeclarationSpecifiers");
      resNode.appendChild(daj_n18);
        Node daj_n19 = document.createElement("NTypeSpecifier");
        daj_n18.appendChild(daj_n19);
          Node daj_n20 = createLiteral(document, "void");
          daj_n19.appendChild(daj_n20);
          Node daj_n21 = document.createComment("   ");
          daj_n19.appendChild(daj_n21);
      Node daj_n22 = document.createElement("NInitDecl");
      resNode.appendChild(daj_n22);
        Node daj_n23 = document.createElement("NDeclarator");
        daj_n22.appendChild(daj_n23);
          Node daj_n24 = document.createElement("NIdentifier");
          daj_n23.appendChild(daj_n24);
            daj_n24.appendChild(nameNode);
          Node daj_n25 = createLiteral(document, "(");
          daj_n23.appendChild(daj_n25);
          Node daj_n26 = document.createElement("NParameterDeclaration");
          daj_n23.appendChild(daj_n26);
            Node daj_n27 = document.createElement("NDeclarationSpecifiers");
            daj_n26.appendChild(daj_n27);
              Node daj_n28 = document.createElement("NTypeSpecifier");
              daj_n27.appendChild(daj_n28);
                Node daj_n29 = createLiteral(document, "thisJoinPoint");
                daj_n28.appendChild(daj_n29);
            Node daj_n30 = document.createElement("NDeclarator");
            daj_n26.appendChild(daj_n30);
              Node daj_n31 = document.createElement("NPointerGroup");
              daj_n30.appendChild(daj_n31);
                Node daj_n32 = createLiteral(document, "*");
                daj_n31.appendChild(daj_n32);
                Node daj_n33 = document.createComment("   ");
                daj_n31.appendChild(daj_n33);
              Node daj_n34 = document.createElement("NIdentifier");
              daj_n30.appendChild(daj_n34);
                daj_n34.appendChild(jpNameNode);
          Node daj_n35 = createLiteral(document, ")");
          daj_n23.appendChild(daj_n35);
      Node daj_n36 = createLiteral(document, ";\n");
      resNode.appendChild(daj_n36);
      Node daj_n37 = document.createComment("  ");
      resNode.appendChild(daj_n37);
      Node daj_n38 = document.createComment("  ");
      resNode.appendChild(daj_n38);
    return resNode;     
}

void gatherTypesFromContext(String functionName,Node jpNode,Node insertPositionNode,int nrFixedArgs) throws AgentException{
    Document doc=jpNode.getOwnerDocument();
    Node insertPositionParentNode=insertPositionNode.getParentNode();
    List actualArgs=cGramXMLFactory.getActualArgumentNodes(jpNode);
    Iterator actualArgsIterator=actualArgs.iterator();
    int index=0;
    while(actualArgsIterator.hasNext()){
        Node actualArgNode=(Node)actualArgsIterator.next();
        if(index>=nrFixedArgs){
            if(index>0){
                Node commaNode=createLiteral(doc,",");
                insertPositionParentNode.insertBefore(commaNode,insertPositionNode);
            }
            
            Node assignExprNode=cGramXMLFactory.getSupportedEllipsisArgumentNode(actualArgNode);
            /*XPathUtilities.walk(actualArgNode);
    		XPathUtilities.walk(assignExprNode);*/
            if(assignExprNode==null) throw new AspicereException("You made a call to "+functionName+", a method with an ellipsis in its prototype, using arguments other than constants, variables and/or function calls. We currently do NOT support this behaviour!");
            if(!cGramXMLFactory.isFunctionCallNode(assignExprNode)){ /*geen call: kijk of constant of string_literal of identifier, anders exceptie*/
                if(cGramXMLFactory.isNonStringConstantNode(assignExprNode)){
                    String value=debracketize(cGramXMLFactory.getStringValueOf(assignExprNode));
                    if(value.matches(".*\\..*")){
                        System.out.println("\targument of type <double>");
                        Node parDecNode = doc.createElement("NParameterDeclaration");
                          Node daj_n39 = doc.createElement("NDeclarationSpecifiers");
                          parDecNode.appendChild(daj_n39);
                            Node daj_n40 = doc.createElement("NTypeSpecifier");
                            daj_n39.appendChild(daj_n40);
                              Node daj_n41 = createLiteral(doc, "double");
                              daj_n40.appendChild(daj_n41);
                        insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
                    }else if(value.matches("'.*'")){
                        System.out.println("\targument of type <char>");
                        Node parDecNode = doc.createElement("NParameterDeclaration");
                          Node daj_n42 = doc.createElement("NDeclarationSpecifiers");
                          parDecNode.appendChild(daj_n42);
                            Node daj_n43 = doc.createElement("NTypeSpecifier");
                            daj_n42.appendChild(daj_n43);
                              Node daj_n44 = createLiteral(doc, "char");
                              daj_n43.appendChild(daj_n44);
                        insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
                    }else{
                        System.out.println("\targument of type <int>");
                        Node parDecNode = doc.createElement("NParameterDeclaration");
                          Node daj_n45 = doc.createElement("NDeclarationSpecifiers");
                          parDecNode.appendChild(daj_n45);
                            Node daj_n46 = doc.createElement("NTypeSpecifier");
                            daj_n45.appendChild(daj_n46);
                              Node daj_n47 = createLiteral(doc, "int");
                              daj_n46.appendChild(daj_n47);
                        insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
                    }
                }else{
                    if(cGramXMLFactory.isStringConstantNode(assignExprNode)){
                        System.out.println("\targument of type <char*>");
                        Node parDecNode = doc.createElement("NParameterDeclaration");
                          Node daj_n48 = doc.createElement("NDeclarationSpecifiers");
                          parDecNode.appendChild(daj_n48);
                            Node daj_n49 = doc.createElement("NTypeSpecifier");
                            daj_n48.appendChild(daj_n49);
                              Node daj_n50 = createLiteral(doc, "char");
                              daj_n49.appendChild(daj_n50);
                          Node daj_n51 = doc.createElement("NDeclarator");
                          parDecNode.appendChild(daj_n51);
                            Node daj_n52 = doc.createElement("NPointerGroup");
                            daj_n51.appendChild(daj_n52);
                              Node daj_n53 = createLiteral(doc, "*");
                              daj_n52.appendChild(daj_n53);
                        insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
  	              }else{
  	              		int referenced=cGramXMLFactory.isReferencedIdentifierNode(assignExprNode)-cGramXMLFactory.isDeReferencedIdentifierNode(assignExprNode);
  	                    if(cGramXMLFactory.isIdentifierNode(assignExprNode)|(referenced!=0)){	                        
  	                        String varName=debracketize(cGramXMLFactory.getStringValueOf(assignExprNode));
  	                        System.out.println("\t"+(referenced!=0?"Pointer to ":"")+"argument of type <IDENTIFIER> named "+varName);
  	                        String returnType=null;
  	                        /*locals: check first because of scoping in inner blocks*/
  	                        Node localNode=cGramXMLFactory.getLocalVariableDeclarationNode(assignExprNode,varName);
  	                        if(localNode!=null){
  	                            /*XPathUtilities.walk(localNode);*/
  	                        		returnType=getLocalVarType(localNode,varName).trim();//getReturnType(localNode);
  	  	                            System.out.println("\t\tdeclared as local var with type: "+returnType);  	                        		
  	                        }else{ /*args*/
  	                        		/*zoek eerste parent-parameterlijst*/	                            
  	                            Node enclosingParDecNode=cGramXMLFactory.getEnclosingParameterDeclarationNode(assignExprNode,varName);
  	                            
  	                            if(enclosingParDecNode!=null){
  		                            Node enclosingDefinitionNode=cGramXMLFactory.getEnclosingFunctionDefinitionNode(enclosingParDecNode);
  	                                int index2=cGramXMLFactory.getIndexOfParameterDeclarationNode(enclosingParDecNode);  	                                
  	                                returnType=((String)getArgumentTypes(enclosingDefinitionNode).get(index2)).trim();
  	                                System.out.println("\t\tdeclared as argument "+index2+", named "+varName+" and typed: "+returnType);
  	                            }else{
  	                                /*global (static)*/	                                
  	                                Node globalDeclarationNode=cGramXMLFactory.getGlobalDeclarationNode(doc,varName);
  	                                if(globalDeclarationNode!=null){  	                                    
  	                                    returnType=getLocalVarType(globalDeclarationNode,varName).trim();//getReturnType(globalDeclarationNode);
  	                                    System.out.println("\t\tdeclared as global (static) variable named "+varName+" and typed: "+returnType);
  	                                }else throw new AspicereException("You made a call to "+functionName+", a method with an ellipsis in its prototype, using arguments other than constants, variables and/or function calls. We currently do NOT support this behaviour!");
  	                            }
  	                        }
  	                        if(referenced>0){
  	                        		//System.out.println("REFERENCED:\tVOOR:\t"+returnType);
  	                        		for(int i=0;i<referenced;i++) returnType+="*";
  	                        		//System.out.println("REFERENCED:\tNA:\t"+returnType);
  	                        }else if(referenced<0){
  	                        		//System.out.println("DEREFERENCED:\tVOOR:\t"+returnType);
  	                        		for(int i=0;i>referenced;i--) returnType=returnType.substring(0,returnType.lastIndexOf('*')).trim();
	                        		//System.out.println("DEREFERENCED:\tNA:\t"+returnType);
  	                        } 
  	                        
  	                        int pos=returnType.indexOf('*');
  	                        if(pos<0) pos=returnType.length();
  	                        String type=returnType.substring(0,pos);
  	                        String pointer=returnType.substring(pos).trim();
  	                        /*System.out.println("type:\t<"+type+">");
  	                        System.out.println("pointer:\t<"+pointer+">");*/
  	                        
  	                        if(pointer.length()>0){
  		                        Node typeNode=createLiteral(doc,type);		                        
  		                        Node pointerGroupNode=doc.createElement("NPointerGroup");
  		                        
  								for(int i=0;i<pointer.length();i++){
  									pointerGroupNode.appendChild(createLiteral(doc,"*"));
  								}
  								
  		                        Node parDecNode = doc.createElement("NParameterDeclaration");
                              Node daj_n54 = doc.createElement("NDeclarationSpecifiers");
                              parDecNode.appendChild(daj_n54);
                                Node daj_n55 = doc.createElement("NTypeSpecifier");
                                daj_n54.appendChild(daj_n55);
                                  daj_n55.appendChild(typeNode);
                              Node daj_n56 = doc.createElement("NonEmptyAbstractDeclarator");
                              parDecNode.appendChild(daj_n56);
                                daj_n56.appendChild(pointerGroupNode);
  								
  								insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);  		                      
  	                        }else{
  		                        Node typeNode=createLiteral(doc,type);
  		                        Node parDecNode = doc.createElement("NParameterDeclaration");
                              Node daj_n57 = doc.createElement("NDeclarationSpecifiers");
                              parDecNode.appendChild(daj_n57);
                                Node daj_n58 = doc.createElement("NTypeSpecifier");
                                daj_n57.appendChild(daj_n58);
                                  daj_n58.appendChild(typeNode);
  								insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);  		                      
  	                        }

  	                    }else throw new AspicereException("You made a call to "+functionName+", a method with an ellipsis in its prototype, using arguments other than constants, variables and/or function calls. We currently do NOT support this behaviour!");
  	                }
                }
            }else{ /*call: zoek return type*/
                    String functionName2=cGramXMLFactory.getFunctionNameFromCallNode(assignExprNode);
                    System.out.println("\targument of type <CALL> to function named "+functionName2);
                    /*zoek parameterlist: 2 mogelijke manieren, zie boven (decl. en def.)*/
                                
                    Node functionDeclarationNode=cGramXMLFactory.getFunctionDeclarationNode(doc,functionName2);
                    Node declaration_specifiersNode=null;
                    Node declarator_node=null;

                    /*ENKEL returntype nodig, dus NIET kijken naar lege argumentenlijst!!!*/
                    if(functionDeclarationNode!=null){ /*prototype found*/
                    		/*Why making things so hard? int f(int a),g(double c);*/                      
                    		declaration_specifiersNode=cGramXMLFactory.getFunctionDeclaratorsDeclarationSpecifiersNode(functionDeclarationNode);
                    		declarator_node=functionDeclarationNode;
                    }else{
                        	Node functionDefinitionNode=cGramXMLFactory.getFunctionDefinitionNode(doc, functionName2);
            				if(functionDefinitionNode!=null){ /*no prototype found, but there is a definition provided!*/
            				    declaration_specifiersNode=cGramXMLFactory.getFunctionDefinitionsDeclarationSpecifiersNode(functionDefinitionNode);
            				    declarator_node=cGramXMLFactory.getFunctionDefinitionsDeclaratorNode(functionDefinitionNode);
            				}else throw new AspicereException("There is NO function prototype for method <"+functionName2+">, nor does a definition exist. I quit!");
                      }
                    String returnType=cGramXMLFactory.getFunctionReturnType(declaration_specifiersNode,declarator_node);
                    
      				int pos=returnType.indexOf('*');
        				if(pos<0) pos=returnType.length();
        				String type=returnType.substring(0,pos);
        				String pointer=returnType.substring(pos);
        				System.out.println("type:\t"+type);
        				System.out.println("pointer:\t"+pointer);
        			
        				if(pointer.length()>0){
                          Node typeNode=createLiteral(doc,type);
                          Node pointerGroupNode=doc.createElement("NPointerGroup");
                          
  						for(int i=0;i<pointer.length();i++){
  							pointerGroupNode.appendChild(createLiteral(doc,"*"));
  						}
  						
                          Node parDecNode = doc.createElement("NParameterDeclaration");
                            Node daj_n59 = doc.createElement("NDeclarationSpecifiers");
                            parDecNode.appendChild(daj_n59);
                              Node daj_n60 = doc.createElement("NTypeSpecifier");
                              daj_n59.appendChild(daj_n60);
                                daj_n60.appendChild(typeNode);
                            Node daj_n61 = doc.createElement("NonEmptyAbstractDeclarator");
                            parDecNode.appendChild(daj_n61);
                              daj_n61.appendChild(pointerGroupNode);
  						
  						insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
        				}else{
        				    Node typeNode=createLiteral(doc,type);
        				    Node parDecNode = doc.createElement("NParameterDeclaration");
                  Node daj_n62 = doc.createElement("NDeclarationSpecifiers");
                  parDecNode.appendChild(daj_n62);
                    Node daj_n63 = doc.createElement("NTypeSpecifier");
                    daj_n62.appendChild(daj_n63);
                      daj_n63.appendChild(typeNode);	
  					    insertPositionParentNode.insertBefore(parDecNode,insertPositionNode);
        				}                 
            }
            
        }
        index++;
    }    
}

void resolveEllipsis(Node jpNode,Node declaratorNode,String functionName) throws AgentException{
    /*instantiate the ellipsis, i.e. fill in the exact function args and discover their types (char*, int, double, function_calls and identifiers)
    <--> NO expressions*/
  System.out.println("There is an ellipsis in "+functionName+".");
  Node insertPositionNode=cGramXMLFactory.removeEllipsisNodes(declaratorNode);
  
  int nrFixedArgs=cGramXMLFactory.getNumberOfArgs(declaratorNode);
  /*Node parListNode=(Node)XPathUtilities.selectSingleNode(parTypeListNode, "parameter_list");*/
  /*Document doc=declaratorNode.getOwnerDocument();*/
  
  gatherTypesFromContext(functionName,jpNode,insertPositionNode,nrFixedArgs);
}

List getArgumentTypes(Node prototypeNode){
	return getArgumentTypes(prototypeNode," ");
}

List getArgumentTypes(Node prototypeNode,String tempToken){
    List res=new ArrayList();
    /*List argumentTypes=XPathUtilities.evaluate(prototypeNode, ".//parameter_type_list//type_specifier");*/
    
    /*String name=XPathUtilities.stringValueOf(prototypeNode, "string(.//init_declarator_list/init_declarator//direct_declarator//identifier[1]/string)");
    if(name.matches(".*printf18.*")){
        System.out.println("DEBUG:");
        XPathUtilities.walk(prototypeNode);
    } */   
    List argumentTypes=cGramXMLFactory.getFunctionArgumentsDeclarationSpecifiersNodes(prototypeNode);
    List argumentNodes=cGramXMLFactory.getFunctionArgumentsParameterDeclarationNodes(prototypeNode);
    /*List pointerArguments=new ArrayList();/*lookup pointer info*/
    Iterator itTypes=argumentTypes.iterator();
    Iterator itArguments=argumentNodes.iterator();
    while((itTypes.hasNext())&&(itArguments.hasNext())){
    		/*HACK!!!*/
    		String type=cGramXMLFactory.getFunctionArgumentType((Node)itTypes.next(),(Node)itArguments.next(),tempToken);
    		
        /*int nrStars=Integer.parseInt(XPathUtilities.stringValueOf((Node)itArguments.next(),"count(.//pointer)"));
        String stars="";
        for(int i=0;i<nrStars;i++) stars+="*";        
        String type=XPathUtilities.stringValueOf((Node)itTypes.next(),"concat(string(./type_qualifier),' ',string(./type_specifier))").trim()+stars;*/
        /*if(name.matches(".*printf18.*")){
            System.out.println("DEBUG("+nrStars+"):\t"+type);
        }*/
        if(!type.trim().equals("void")) res.add(type);
    }
    /*System.out.println("ARGS:\t"+res);*/
    return res;
}

String getLocalVarType(Node declarationNode,String varName){    
	Node declarationSpecifiersNode=cGramXMLFactory.getLocalVariableDeclarationSpecifiersNode(declarationNode);
	Node declaratorNode=cGramXMLFactory.getLocalVariableDeclaratorNode(declarationNode,varName);
    /*System.out.println("RETURN:");
    XPathUtilities.walk(prototypeNode);*/
	
    return cGramXMLFactory.getFunctionReturnType(declarationSpecifiersNode,declaratorNode);
}

String getReturnType(Node prototypeNode){
	Node declarationSpecifiersNode=cGramXMLFactory.getFunctionPrototypesDeclarationSpecifiersNode(prototypeNode);
	Node declaratorNode=cGramXMLFactory.getFunctionPrototypesDeclaratorNode(prototypeNode);
    /*System.out.println("RETURN:");
    XPathUtilities.walk(prototypeNode);*/
	
    return cGramXMLFactory.getFunctionReturnType(declarationSpecifiersNode,declaratorNode);
}

Node createCallerProxyBody(Document document,Node crpPrototypeNode,List adviceAndBindings,List argumentTypes, String returnType, String calleeProxy,String fileName,String functionName) {
    String proxyName=cGramXMLFactory.getFunctionNameFromDeclarationNode(crpPrototypeNode);
    /*String proxyName=XPathUtilities.stringValueOf(crpPrototypeNode,"string(.//identifier[1]/string)").trim();*/
    boolean isVoid=returnType.trim().equals("void");
    
    /*int doel_caller_proxy(int a,int b){*/
    String code=" "+returnType+" "+proxyName+"(";
    Iterator it=argumentTypes.iterator();
    int counter=0;
    boolean notLast=it.hasNext();
    List stmts=new ArrayList();    
    while(notLast){
        String argumentType=(String)it.next();
        if(!argumentType.equals("void")){ /*else: 0 args*/
        		String argumentName="a"+counter;
        		code+=generateArgumentType(argumentType,argumentName);//argumentType+" "+argumentName;
        		notLast=it.hasNext();

        		if(notLast) code+=",";
        		if(isPrimitiveOrUnreferencedTypedef(argumentType)){
        			stmts.add("jp.args["+(counter++)+"]=(void*)&"+argumentName+";\n");
        		}else{
        			stmts.add("jp.args["+(counter++)+"]=(void*)"+argumentName+";\n");
        		}
        }else notLast=it.hasNext();
    }
    boolean zeroArgs=(counter==0);
    
    /*	int res=0; //return value 

    //1) aanmaken van thisJoinPoint
     	thisJoinPoint jp;  
     	jp.nrArgs=2;//van doel()=>gekend!
     	jp.args=(void**)malloc(2*sizeof(void*));*/    
    code+="){\n";
    if(!isVoid) code+=returnType+" res;\n";
    code+="thisJoinPoint jp;\n" +
    				"jp.nrArgs="+counter+";\n";
    if(!zeroArgs)code+=	"jp.args=(void**)malloc("+counter+"*sizeof(void*));\n";
    
    /*	jp.args[0]=(void*)&a;
     	jp.args[1]=(void*)&b;//van doel()=>gekend*/    
    it=stmts.iterator();
    while(it.hasNext()){
        code+=(String)it.next();
    }

	/*	//PROBLEEM 3:assigneren van jp.returnValue: reden is dat later geen pointer naar resultaat op stack kan genomen worden <--> nu memory OVERHEAD
	 	jp.returnValue=malloc(sizeof(int));//to be determined in doel() of één van de advices*/
    if(!isVoid) code+="\n" +
    		"jp.returnValue=(void*)malloc(sizeof("+returnType+"));\n";
    								
    /*	jp.closureList=(closure*)malloc(3*sizeof(closure));
     	jp.closureList[0]=&advice_one;
     	jp.closureList[1]=&advice_two;//chain van adviezen=>letterlijk te initialiseren door weaver
     	jp.closureList[2]=&doel_callee_proxy;
     	jp.adviceIndex=-1;//index in chain <--> nog niet begonnen!*/    
    it=adviceAndBindings.iterator();
    counter=0;
    stmts=new ArrayList();
    while(it.hasNext()){
        List adviceAndBinding=(List)it.next();
        Binding tmp=(Binding)adviceAndBinding.get(1);
        stmts.add("jp.closureList["+(counter++)+"]=&"+tmp.getName()+";\n");
    }
    stmts.add("jp.closureList["+(counter++)+"]=&"+calleeProxy+";\n");

    code+="jp.closureList=(closure*)malloc("+counter+"*sizeof(closure));\n";
    it=stmts.iterator();
    while(it.hasNext()){
        code+=(String)it.next();
    }
    code+="jp.adviceIndex=-1;\n";
    
    /*jp.fileName="name";
     * jp.functionName="name";*/
    code+="jp.fileName=\""+fileName+"\";\n" +
    		"jp.functionName=\""+functionName+"\";\n";

    /*	//2) oproepen juiste advice (zie thisJoinPoint)
     	call_next(&jp);

    	//3) tijdelijk bijhouden return value
    	 res=*((int*)jp.returnValue);//want free => tijdelijk bijhouden

    	//4) opruimen heap-allocated memory
    	 free(jp.returnValue);
    	 free(jp.args);
    	 free(jp.closureList);

    	//5) return value
    	 return res;
       }*/    
    code+="call_next(&jp);\n";
    if(!isVoid) code+="res=*(("+returnType+"*)jp.returnValue);\n" +
    				"free(jp.returnValue);\n";
    if(!zeroArgs) code+="free(jp.args);\n";
    code+="free(jp.closureList);\n";
    if(!isVoid) code+="return res;\n";
    code+="}\n";
    
    return document.createComment (code+" @n ");
}

Node createCalleeProxyBody(Document document,String functionName,List argumentTypes, String returnType, String calleeProxy) {
    boolean isVoid=returnType.trim().equals("void");
    Iterator it=argumentTypes.iterator();
    int counter=0;
    boolean notLast=it.hasNext();
    String codeCallee="";
    String tmp="";
    
    while(notLast){
        String argumentType=(String)it.next();
        if(!argumentType.equals("void")){ /*else: 0 args*/
        		notLast=it.hasNext();
        		//tmp+="*(("+argumentType+"*)jp->args["+(counter++)+"])";
        		if(isPrimitiveOrUnreferencedTypedef(argumentType)){
        			tmp+="*(("+pointerToArgumentType(argumentType)+")jp->args["+(counter++)+"])";
        		}else{
        			tmp+="jp->args["+(counter++)+"]";
        		}
        		//tmp+="*(("+generateArgumentType(argumentType,"*")+")jp->args["+(counter++)+"])";
        		if(notLast) tmp+=",";
        }else notLast=it.hasNext();
    }
    
    /*void doel_callee_proxy(thisJoinPoint* jp){
 		*((int*)(jp->returnValue))=doel(*((int*)jp->args[0]),*((int*)jp->args[1]));

		jp->adviceIndex-=1;//manual cleanup (no call_next(...) here)<--> a simple decrement is illegal in <!-- ... -->
		return;
	}*/
    codeCallee=" void "+calleeProxy+"(thisJoinPoint* jp){\n";
    if(!isVoid) codeCallee+="*(("+returnType+"*)(jp->returnValue))=";
    codeCallee+=functionName+"("+tmp+");\n" +
		"jp->adviceIndex-=1;\n" +
		"return;\n" +
		"}\n";
    return document.createComment (codeCallee+" @n ");
}

/*List sortAdvice(adviceAndBindings,aspectNamesOrderedList,aspectNamesToOrderedListOfAdviceNames){
    /*List res=new ArrayList();
    Iterator aspectsIterator=aspectNamesOrderedList.iterator();
    while(aspectsIterator.hasNext()){
        String aspectName=(String)aspectsIterator.next();
        List advices=aspectNamesToOrderedListOfAdviceNames.get(aspectName);
        Iterator adviceIterator=advices.iterator();
        while(adviceIterator.hasNext()){
            String adviceName=(String)adviceIterator.next();
            Iterator advAndBindIterator=adviceAndBindings.iterator();
            while(advAndBindIterator.hasNext()){
                List entry=(List)advAndBindIterator.next();
                if(adviceName.equals((String)entry.get(0))) res.add(entry);
            }
        }
    }
    System.out.println("VOOR:\t"+adviceAndBindings);
    System.out.println("NA:\t"+res);
    return res;*/
    /*ORDERING*/
    /*apparently, the advice remains in the exact same order as has been decided by the judge
     * => using declarative ordering specifications in a module should result in the judge matching in a different ORDER and matched advices percolating here in the exact SAME order*/
    /*ORDERING*/
  /*  return adviceAndBindings;
}*/

/**
 * Only leave new Bindings in newAdviceToBindings and collect everything in resulting Map.
 */
Map splitOldBindingsFromNewOnes(Map oldAdviceToBindings,Map newAdviceToBindings){
	/*DEBUG*/
	/*System.out.println("OLD:");
	System.out.println(oldAdviceToBindings);
	System.out.println("NEW:");
	System.out.println(newAdviceToBindings);*/
	/*DEBUG*/
	/*old or new can lack some advice because there are no matches*/
	Set adviceSet=new HashSet(oldAdviceToBindings.keySet());
	adviceSet.addAll(newAdviceToBindings.keySet());
	
	/*filter*/
	Map adviceToBindings=new HashMap();
	Iterator adviceSetIterator=adviceSet.iterator();
	while(adviceSetIterator.hasNext()){
		String adviceName=(String)adviceSetIterator.next();
		Object obj=newAdviceToBindings.get(adviceName);
		Set bindings=new HashSet();
		if(obj!=null){
		    Set newBindings=(Set)obj;
		    Set oldBindings=(Set)oldAdviceToBindings.get(adviceName);
		    if(oldBindings!=null){
			newBindings.removeAll(oldBindings);
			if(newBindings.isEmpty()) newAdviceToBindings.remove(adviceName);
			bindings.addAll(oldBindings);
		    }
		    bindings.addAll(newBindings);
		    adviceToBindings.put(adviceName,bindings);
		}else if(adviceName.equals(ASPECTFILEINCLUDESTOKEN)) adviceToBindings.put(adviceName,obj);		
	}

	/*DEBUG*/
	/*System.out.println("RES:");
	System.out.println(adviceToBindings);*/
	/*DEBUG*/

	return adviceToBindings;
}

Node transfer(Node node,String elementName){
	Document doc=node.getOwnerDocument();
	Node res=doc.createElement(elementName);
	NodeList children=node.getChildNodes();
	for(int i=0;i<children.getLength();i++){
		Node child=children.item(i);
		res.appendChild(child.cloneNode(true));
	}
	return res;
}

String pointerToArgumentType(String type){
	return pointerToArgumentType(type,"*");
}

String pointerToArgumentType(String type,String tempToken){
       int tokenPos=type.indexOf(tempToken);
       int parenthesisPos=type.indexOf(")",tokenPos);
       if(parenthesisPos!=-1){ //parenthesis available
       	  return generateArgumentType(type,"*");
       }else{ //no parenthesis
           	int bracketPos=type.indexOf("[",tokenPos);
       	  	if(bracketPos!=-1) return generateArgumentType(type,"(*)");
       	  	else return generateArgumentType(type,"*");
       }
	/*if(type.matches(".*\\)\\s*\\(.*")){ //function pointer
		System.err.println("TEST: "+type);
		int pos=type.indexOf(globalToken);
		int starPos=type.lastIndexOf("*",pos);
		int haakjePos=type.lastIndexOf("(",pos);
		if(starPos>haakjePos){
			String sub1=type.substring(0,starPos);
			String sub2=generateArgumentType(type.substring(starPos,type.length()),tempToken);
			return sub1+"*"+sub2;
		}else{
			String sub1=type.substring(0,haakjePos);
			String sub2=generateArgumentType(type.substring(haakjePos,type.length()),tempToken);
			return sub1+"*"+sub2;			
		}
	}else{ //normal
		return generateArgumentType(type,tempToken)+"*";
	}*/
}

String generateArgumentType(String type){
	return generateArgumentType(type," ");
}

String generateArgumentType(String type,String tempToken){
	if(type.indexOf(globalToken)==-1) return type+" "+tempToken;//not correct in all cases
	else return type.replaceAll(globalToken,tempToken);
}

void invalidateBindings(List adviceAndBindings){
    Iterator applicableAdviceAndBindingsIterator=adviceAndBindings.iterator();
    while(applicableAdviceAndBindingsIterator.hasNext()){
        List tmp=(List)applicableAdviceAndBindingsIterator.next();        
        Binding advBinding=(Binding)tmp.get(1);
        //System.err.println("Invalidating binding "+advBinding.getName()+"..."+advBinding.isValid());
        advBinding.setValid(false);
    }
}

String debracketize(String s){
	String res=s.trim();
	while(res.matches("\\(.*\\)")) res=res.substring(1,res.length()-1).trim();
	return res;
}

boolean isPrimitiveOrUnreferencedTypedef(String type){
	String tmp=debracketize(type);
	if((tmp.indexOf('(')!=-1)||(tmp.indexOf('[')!=-1)||(tmp.indexOf('*')!=-1)) return false;
	else return true;
}

}