/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 22-nov-2004
 *
 */
package be.ugent.ftw.intec.sel.aspicere;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Var;
import be.ugent.ftw.intec.sel.lillambi.agents.TUPrologDynamicMapping;

/**
 * @author bram
 * 
 * 22-nov-2004
 */
public class TUPrologDOMXPathLibrary extends Library {

    /**
     *  
     */
    public TUPrologDOMXPathLibrary() {
        super();
    }

    /**
     * xpath_query(@Query,@Root,-NodeList): returns list of Node, NodeSet (both descendants of Root), Boolean, String or Number fulfilling XPath-query Query
     * 
     * @param query
     * @param root
     * @param nodeList
     * @return
     */
    public boolean xpath_query_3(Struct query, Struct root, Var nodeList) {
        if (query.isAtom() && root.isAtom()) {
            Object xpathQueryObj = TUPrologDynamicMapping.mapToJava(query, getEngine());
            if (!(xpathQueryObj instanceof String))
                return false;
            String xpathQuery = (String) xpathQueryObj;
            Object rootObj = TUPrologDynamicMapping.mapToJava(root, getEngine());
            /*DEBUG*/
            /*System.out.println("QUERY INSIDE: "+xpathQuery);/*
            if(root instanceof Node){
                System.out.println(root.getClass().getName()+" with value: ");
                XPathUtilities.walk((Node)root);
            }*/
            /*DEBUG*/
            List res = XPathUtilities.evaluate(rootObj,xpathQuery);            
            //List res = XPathUtilities.selectNodes(rootObj,xpathQuery);

            if (res != null) {
                /*Object[] row = new Object[res.size()];
                Iterator it=res.iterator();
                int i=0;
                while(it.hasNext()){
                    Node node=(Node)it.next();
                    System.out.println("$$$FOUND:");
                    XPathUtilities.walk(node);
                    row[i++]=node;
                }*/
                /*DEBUG*/
                /*System.out.println("NOT NULL");*/
                /*System.out.println("Size:\t"+res.size());
                Iterator it=res.iterator();
                int i=0;
                while(it.hasNext()){
                    Object obj=it.next();
                    System.out.println("[xpath_query_3]:\t");
                    if(obj instanceof Number){
                        System.out.println(obj.getClass().getName()+" with value: "+(Number)obj);
                    }else if(obj instanceof String){
                        System.out.println(obj.getClass().getName()+" with value: "+(String)obj);
                    }else if(obj instanceof Boolean){
                        System.out.println(obj.getClass().getName()+" with value: "+(Boolean)obj);
                    }else if(obj instanceof Node){
                        System.out.println(obj.getClass().getName()+" with value: ");
                        XPathUtilities.walk((Node)obj);
                    }else if(obj instanceof NodeList){
                        System.out.println(obj.getClass().getName()+" with following values: ");
                        NodeList list=(NodeList)obj;
                        for(int j=0;j<list.getLength();j++){
                            System.out.println("% Item "+j+" %");
                            XPathUtilities.walk(list.item(j));
                        }
                    }
                }
                /*DEBUG*/
                return unify(nodeList, TUPrologDynamicMapping.mapToTuProlog(
                        res.toArray(), getEngine()));
            } else{
                return unify(nodeList, TUPrologDynamicMapping.mapToTuProlog(
                        null, getEngine()));
            }                
        } else
            return false;
    }

    /**
     * xpath_create_joinpoints_2(@NodeOrNodeListList, -JpList): generates JoinPoints for the provided Node(List)s, WITHOUT their type or name specified. This is the responsibility of primitive predicates like call, ...
     * 
     * @param query
     * @param root
     * @param nodeList
     * @return
     */
    public boolean xpath_create_joinpoints_3(Struct name,Struct nodeOrNodeListList, Var jpList){
        //System.out.println("HELA");
        if (nodeOrNodeListList.isList()&&name.isAtom()){
            /*DEBUG*/
            /*System.out.println("[xpath_create_joinpoints_3]:\t");
            /*DEBUG*/
            Object tmpNodeOrNodeListList = TUPrologDynamicMapping.mapToJava(nodeOrNodeListList, getEngine());
            if (!(tmpNodeOrNodeListList instanceof Object[]))
                return false;
            Object[] nodeOrNodeListArray = (Object[]) tmpNodeOrNodeListList;
            
            Object nameObj = TUPrologDynamicMapping.mapToJava(name, getEngine());
            if (!(nameObj instanceof String))
                return false;
            String jpName = (String) nameObj;
            
            ArrayList jps=new ArrayList();
            for(int i=0;i<nodeOrNodeListArray.length;i++){
                Object tmp=nodeOrNodeListArray[i];
                JoinPoint jp=null;
                if(tmp instanceof Node){                    
                    jp=JoinPoint.createNewJoinPoint((Node)tmp);
                    //System.out.println("ONE");
                }else if(tmp instanceof NodeList){
                    //System.out.println("TWO");
                    NodeList list=(NodeList)tmp;
                    ArrayList res=new ArrayList();
                    for(int j=0;j<list.getLength();j++){
                        res.add(list.item(j));
                    }
                    jp=JoinPoint.createNewJoinPoint(res);
                }else{
                    //System.out.println("THREE");
                    return false;
                }
                jp.setName(jpName);
                jps.add(jp);
            }
            //System.out.println("FOUR");
            return unify(jpList, TUPrologDynamicMapping.mapToTuProlog(jps.toArray(), getEngine()));
        }else{
            return false;
        }
    }
}
