/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lillambi.
 *
 * The Initial Developer of the Original Code is
 * the Software Engineering Lab, INTEC, University Ghent.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Bram Adams <bram.adams@ugent.be>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
 * Created on 17-apr-2005
 *
 */
package be.ugent.ftw.intec.sel.aspicere;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import alice.tuprolog.Library;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import be.ugent.ftw.intec.sel.lillambi.agents.TUPrologDynamicMapping;

/**
 * @author bram
 *
 * 17-apr-2005
 */
public class TUPrologPrimitiveLibrary extends Library {
	static CGramXMLFactory cGramXMLFactory=new CGramXMLFactory();

	/**
	 * 
	 */
	public TUPrologPrimitiveLibrary() {
		super();
	}
	
    /**
     * primitive_returntype(@Jp, ?ReturnType): get ReturnType of function call Jp
     * 
     * @param jp
     * @param returnType
     * @return
     */
    public boolean primitive_returntype_2(Struct jp, Term returnType) {
    	if(!jp.isAtom()) return false;
    	
    	Object jpObj = TUPrologDynamicMapping.mapToJava(jp, getEngine());
        if (!(jpObj instanceof JoinPoint))
            return false;
        JoinPoint joinPoint = (JoinPoint) jpObj;

        if(!joinPoint.getName().equals("call")) return false;
        /* function call node */
        Node callNode=(Node)joinPoint.getNodes().get(0);
        Document doc=callNode.getOwnerDocument();
        /* String functionName=XPathUtilities.stringValueOf(callNode,"string(postfix_expression//identifier)").trim(); */
        String functionName=cGramXMLFactory.getFunctionNameFromCallNode(callNode);
//System.err.println ("++++++ FUNCNAME = " + functionName);
        Node declaration_specifiersNode=null;/*bevat basisreturntype, d.i. ZONDER pointerinfo*/
        //Node declaratorNode=null;
        Node declaratorNode = null;/*nodig voor pointerinfo van returntype*/
        
        /*1*/
        /* Node functionDeclarationNode=(Node)XPathUtilities.selectSingleNode(doc, "//declaration[.//identifier[1]/string='"+functionName+"' and .//identifier[1]/../../parameter_type_list]"); */
        Node functionDeclarationNode=cGramXMLFactory.getFunctionDeclarationNode(doc,functionName);
//System.err.println ("++++++ DECLARNODE = " + functionDeclarationNode);
        if(functionDeclarationNode!=null){
            /* declaration_specifiersNode=(Node)XPathUtilities.selectSingleNode(
             *   functionDeclarationNode,
             *   ".//declaration_specifiers"); */
            declaration_specifiersNode=cGramXMLFactory.getFunctionDeclaratorsDeclarationSpecifiersNode(functionDeclarationNode);
//System.err.println ("++++++++++ DECLARSPECNODE = " + declaration_specifiersNode);
			//XPathUtilities.walk(declaration_specifiersNode);

            //declaratorNode=(Node)XPathUtilities.selectSingleNode(
            //  functionDeclarationNode,
            //  ".//init_declarator/declarator[.//identifier[1]/string='"+functionName+"' and .//identifier[1]/../../parameter_type_list]");
            
            declaratorNode = functionDeclarationNode;

        }else{
        	//Node functionDefinitionNode=(Node)XPathUtilities.selectSingleNode(doc, "//function_definition[.//identifier[1]/string='"+functionName+"']");
        	Node functionDefinitionNode=cGramXMLFactory.getFunctionDefinitionNode(doc,functionName);

            if(functionDefinitionNode!=null){
//System.err.println ("++++++++++ FUNCDEFNODE = " + functionDefinitionNode);
            	//declaration_specifiersNode=(Node)XPathUtilities.selectSingleNode(functionDefinitionNode, "declaration_specifiers");
            	declaration_specifiersNode=cGramXMLFactory.getFunctionDefinitionsDeclarationSpecifiersNode(functionDefinitionNode);
//System.err.println ("++++++++++ FUNCDEFSPECNODE = " + declaration_specifiersNode);
            	//declaratorNode=(Node)XPathUtilities.selectSingleNode(functionDefinitionNode, "declarator"); 
declaratorNode=cGramXMLFactory.getFunctionDefinitionsDeclaratorNode(functionDefinitionNode);
                

        	}else{
        		return false;//error in C-program (no prototype or definition found!)!
        	}
        }

		String res=cGramXMLFactory.getFunctionReturnType(declaration_specifiersNode,declaratorNode);
		//System.out.println("OUT:\t"+res);
    
        return unify(returnType, TUPrologDynamicMapping.mapToTuProlog(
                res, getEngine()));
    }
    
    /**
     * primitive_method_node_name_2(@MethodNode, ?Name): get Name of MethodNode
     * 
     * @param methodeNode
     * @param name
     * @return
     */
    public boolean primitive_method_node_name_2(Struct methodNode, Term name) {
    	if(!methodNode.isAtom()) return false;
    	
    	Object methodNodeObj = TUPrologDynamicMapping.mapToJava(methodNode, getEngine());
        if (!(methodNodeObj instanceof Node))
            return false;
        Node methNode = (Node) methodNodeObj;
        
        //boolean isFunctionDef=(XPathUtilities.selectSingleNode(methNode, "self::function_definition")!=null);
        
        if(!cGramXMLFactory.isFunctionDefinitionNode(methNode)) return false;
        //String functionName=XPathUtilities.stringValueOf(methNode,"string(declarator/direct_declarator/direct_declarator/identifier/string)").trim();
        String functionName=cGramXMLFactory.getFunctionNameFromDefinitionNode(methNode);
        
        if(name.isAtom()){
            Object nameObj = TUPrologDynamicMapping.mapToJava(name, getEngine());
            if (!(nameObj instanceof String)) return false;
            String nameStr = (String) nameObj;
            return functionName.equals(nameStr);
        }else{
            return unify(name, TUPrologDynamicMapping.mapToTuProlog(functionName, getEngine()));            
        }
        
    }
    
    /**
     * primitive_enclosing_method_node(@Jp, ?MethodNode): get Node corresponding to function definition enclosing Jp
     * 
     * @param jp
     * @param methodNode
     * @return
     */
    public boolean primitive_enclosing_method_node_2(Struct jp, Term methodNode) {
    	if(!jp.isAtom()) return false;
    	
    	Object jpObj = TUPrologDynamicMapping.mapToJava(jp, getEngine());
        if (!(jpObj instanceof JoinPoint))
            return false;
        JoinPoint joinPoint = (JoinPoint) jpObj;

        if(!joinPoint.getName().equals("call")) return false;
        Node callNode=(Node)joinPoint.getNodes().get(0);
        Document doc=callNode.getOwnerDocument();
        // Node defNode=(Node)XPathUtilities.selectSingleNode(callNode, "ancestor::function_definition");
        Node defNode=cGramXMLFactory.getEnclosingFunctionDefinitionNode(callNode);

        if(defNode==null) return false;
        if(methodNode.isAtom()){
            Object methodNodeObj = TUPrologDynamicMapping.mapToJava(methodNode, getEngine());
            if (!(methodNodeObj instanceof Node)) return false;
            Node methNode = (Node) methodNodeObj;
            return defNode.equals(methNode);
        }else{
            return unify(methodNode, TUPrologDynamicMapping.mapToTuProlog(defNode, getEngine()));            
        }
    

    }
}
